#define XORWOW_DIM 5
#define XORWOW_BITS 32
#define XORWOW_PRECALC_MATRICES_SZ (XORWOW_BITS * XORWOW_DIM * XORWOW_DIM)
#define XORWOW_PRECALC_MATRICES_NUM 32
#define XORWOW_JUMP_LOG2 2
#define XORWOW_JUMP_LOG2_MASK ((1 << XORWOW_JUMP_LOG2) - 1)
#define XORWOW_SEQUENCE_JUMP_LOG2 67

static const unsigned int
    precalc_xorwow_skipahead_matrices[XORWOW_PRECALC_MATRICES_NUM][XORWOW_PRECALC_MATRICES_SZ] = {
        {
            0,          0,          0,          0,          3,          0,          0,
            0,          0,          6,          0,          0,          0,          0,
            15,         0,          0,          0,          0,          30,         0,
            0,          0,          0,          60,         0,          0,          0,
            0,          120,        0,          0,          0,          0,          240,
            0,          0,          0,          0,          480,        0,          0,
            0,          0,          960,        0,          0,          0,          0,
            1920,       0,          0,          0,          0,          3840,       0,
            0,          0,          0,          7680,       0,          0,          0,
            0,          15360,      0,          0,          0,          0,          30720,
            0,          0,          0,          0,          61440,      0,          0,
            0,          0,          122880,     0,          0,          0,          0,
            245760,     0,          0,          0,          0,          491520,     0,
            0,          0,          0,          983040,     0,          0,          0,
            0,          1966080,    0,          0,          0,          0,          3932160,
            0,          0,          0,          0,          7864320,    0,          0,
            0,          0,          15728640,   0,          0,          0,          0,
            31457280,   0,          0,          0,          0,          62914560,   0,
            0,          0,          0,          125829120,  0,          0,          0,
            0,          251658240,  0,          0,          0,          0,          503316480,
            0,          0,          0,          0,          1006632960, 0,          0,
            0,          0,          2013265920, 0,          0,          0,          0,
            4026531840, 0,          0,          0,          0,          3758096384, 1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            17,         0,          0,          0,          2,          34,         0,
            0,          0,          4,          68,         0,          0,          0,
            8,          136,        0,          0,          0,          16,         272,
            0,          0,          0,          32,         544,        0,          0,
            0,          64,         1088,       0,          0,          0,          128,
            2176,       0,          0,          0,          256,        4352,       0,
            0,          0,          512,        8704,       0,          0,          0,
            1024,       17408,      0,          0,          0,          2048,       34816,
            0,          0,          0,          4096,       69632,      0,          0,
            0,          8192,       139264,     0,          0,          0,          16384,
            278528,     0,          0,          0,          32768,      557056,     0,
            0,          0,          65536,      1114112,    0,          0,          0,
            131072,     2228224,    0,          0,          0,          262144,     4456448,
            0,          0,          0,          524288,     8912896,    0,          0,
            0,          1048576,    17825792,   0,          0,          0,          2097152,
            35651584,   0,          0,          0,          4194304,    71303168,   0,
            0,          0,          8388608,    142606336,  0,          0,          0,
            16777216,   285212672,  0,          0,          0,          33554432,   570425344,
            0,          0,          0,          67108864,   1140850688, 0,          0,
            0,          134217728,  2281701376, 0,          0,          0,          268435456,
            268435456,  0,          0,          0,          536870912,  536870912,  0,
            0,          0,          1073741824, 1073741824, 0,          0,          0,
            2147483648, 2147483648,
        },
        {
            0,          3,          51,         771,        13107,      0,          6,
            102,        1542,       26214,      0,          15,         255,        3855,
            65535,      0,          30,         510,        7710,       131070,     0,
            60,         1020,       15420,      262140,     0,          120,        2040,
            30840,      524280,     0,          240,        4080,       61680,      1048560,
            0,          480,        8160,       123360,     2097120,    0,          960,
            16320,      246720,     4194240,    0,          1920,       32640,      493440,
            8388480,    0,          3840,       65280,      986880,     16776960,   0,
            7680,       130560,     1973760,    33553920,   0,          15360,      261120,
            3947520,    67107840,   0,          30720,      522240,     7895040,    134215680,
            0,          61440,      1044480,    15790080,   268431360,  0,          122880,
            2088960,    31580160,   536862720,  0,          245760,     4177920,    63160320,
            1073725440, 0,          491520,     8355840,    126320640,  2147450880, 0,
            983040,     16711680,   252641280,  4294901760, 0,          1966080,    33423360,
            505282560,  4294836224, 0,          3932160,    66846720,   1010565120, 4294705152,
            0,          7864320,    133693440,  2021130240, 4294443008, 0,          15728640,
            267386880,  4042260480, 4293918720, 0,          31457280,   534773760,  3789553664,
            4292870144, 0,          62914560,   1069547520, 3284140032, 4290772992, 0,
            125829120,  2139095040, 2273312768, 4286578688, 0,          251658240,  4278190080,
            251658240,  4278190080, 0,          503316480,  4261412864, 503316480,  4261412864,
            0,          1006632960, 4227858432, 1006632960, 4227858432, 0,          2013265920,
            4160749568, 2013265920, 4160749568, 0,          4026531840, 4026531840, 4026531840,
            4026531840, 0,          3758096384, 3758096384, 3758096384, 3758096384, 0,
            0,          3,          51,         771,        0,          0,          6,
            102,        1542,       0,          0,          15,         255,        3855,
            0,          0,          30,         510,        7710,       0,          0,
            60,         1020,       15420,      0,          0,          120,        2040,
            30840,      0,          0,          240,        4080,       61680,      0,
            0,          480,        8160,       123360,     0,          0,          960,
            16320,      246720,     0,          0,          1920,       32640,      493440,
            0,          0,          3840,       65280,      986880,     0,          0,
            7680,       130560,     1973760,    0,          0,          15360,      261120,
            3947520,    0,          0,          30720,      522240,     7895040,    0,
            0,          61440,      1044480,    15790080,   0,          0,          122880,
            2088960,    31580160,   0,          0,          245760,     4177920,    63160320,
            0,          0,          491520,     8355840,    126320640,  0,          0,
            983040,     16711680,   252641280,  0,          0,          1966080,    33423360,
            505282560,  0,          0,          3932160,    66846720,   1010565120, 0,
            0,          7864320,    133693440,  2021130240, 0,          0,          15728640,
            267386880,  4042260480, 0,          0,          31457280,   534773760,  3789553664,
            0,          0,          62914560,   1069547520, 3284140032, 0,          0,
            125829120,  2139095040, 2273312768, 0,          0,          251658240,  4278190080,
            251658240,  0,          0,          503316480,  4261412864, 503316480,  0,
            0,          1006632960, 4227858432, 1006632960, 0,          0,          2013265920,
            4160749568, 2013265920, 0,          0,          4026531840, 4026531840, 4026531840,
            0,          0,          3758096384, 3758096384, 3758096384, 0,          0,
            0,          3,          51,         0,          0,          0,          6,
            102,        0,          0,          0,          15,         255,        0,
            0,          0,          30,         510,        0,          0,          0,
            60,         1020,       0,          0,          0,          120,        2040,
            0,          0,          0,          240,        4080,       0,          0,
            0,          480,        8160,       0,          0,          0,          960,
            16320,      0,          0,          0,          1920,       32640,      0,
            0,          0,          3840,       65280,      0,          0,          0,
            7680,       130560,     0,          0,          0,          15360,      261120,
            0,          0,          0,          30720,      522240,     0,          0,
            0,          61440,      1044480,    0,          0,          0,          122880,
            2088960,    0,          0,          0,          245760,     4177920,    0,
            0,          0,          491520,     8355840,    0,          0,          0,
            983040,     16711680,   0,          0,          0,          1966080,    33423360,
            0,          0,          0,          3932160,    66846720,   0,          0,
            0,          7864320,    133693440,  0,          0,          0,          15728640,
            267386880,  0,          0,          0,          31457280,   534773760,  0,
            0,          0,          62914560,   1069547520, 0,          0,          0,
            125829120,  2139095040, 0,          0,          0,          251658240,  4278190080,
            0,          0,          0,          503316480,  4261412864, 0,          0,
            0,          1006632960, 4227858432, 0,          0,          0,          2013265920,
            4160749568, 0,          0,          0,          4026531840, 4026531840, 0,
            0,          0,          3758096384, 3758096384, 0,          0,          0,
            0,          3,          0,          0,          0,          0,          6,
            0,          0,          0,          0,          15,         0,          0,
            0,          0,          30,         0,          0,          0,          0,
            60,         0,          0,          0,          0,          120,        0,
            0,          0,          0,          240,        0,          0,          0,
            0,          480,        0,          0,          0,          0,          960,
            0,          0,          0,          0,          1920,       0,          0,
            0,          0,          3840,       0,          0,          0,          0,
            7680,       0,          0,          0,          0,          15360,      0,
            0,          0,          0,          30720,      0,          0,          0,
            0,          61440,      0,          0,          0,          0,          122880,
            0,          0,          0,          0,          245760,     0,          0,
            0,          0,          491520,     0,          0,          0,          0,
            983040,     0,          0,          0,          0,          1966080,    0,
            0,          0,          0,          3932160,    0,          0,          0,
            0,          7864320,    0,          0,          0,          0,          15728640,
            0,          0,          0,          0,          31457280,   0,          0,
            0,          0,          62914560,   0,          0,          0,          0,
            125829120,  0,          0,          0,          0,          251658240,  0,
            0,          0,          0,          503316480,  0,          0,          0,
            0,          1006632960, 0,          0,          0,          0,          2013265920,
            0,          0,          0,          0,          4026531840, 0,          0,
            0,          0,          3758096384, 1,          17,         257,        4369,
            65537,      2,          34,         514,        8738,       131074,     4,
            68,         1028,       17476,      262148,     8,          136,        2056,
            34952,      524296,     16,         272,        4112,       69904,      1048592,
            32,         544,        8224,       139808,     2097184,    64,         1088,
            16448,      279616,     4194368,    128,        2176,       32896,      559232,
            8388736,    256,        4352,       65792,      1118464,    16777472,   512,
            8704,       131584,     2236928,    33554944,   1024,       17408,      263168,
            4473856,    67109888,   2048,       34816,      526336,     8947712,    134219776,
            4096,       69632,      1052672,    17895424,   268439552,  8192,       139264,
            2105344,    35790848,   536879104,  16384,      278528,     4210688,    71581696,
            1073758208, 32768,      557056,     8421376,    143163392,  2147516416, 65536,
            1114112,    16842752,   286326784,  65536,      131072,     2228224,    33685504,
            572653568,  131072,     262144,     4456448,    67371008,   1145307136, 262144,
            524288,     8912896,    134742016,  2290614272, 524288,     1048576,    17825792,
            269484032,  286261248,  1048576,    2097152,    35651584,   538968064,  572522496,
            2097152,    4194304,    71303168,   1077936128, 1145044992, 4194304,    8388608,
            142606336,  2155872256, 2290089984, 8388608,    16777216,   285212672,  16777216,
            285212672,  16777216,   33554432,   570425344,  33554432,   570425344,  33554432,
            67108864,   1140850688, 67108864,   1140850688, 67108864,   134217728,  2281701376,
            134217728,  2281701376, 134217728,  268435456,  268435456,  268435456,  268435456,
            268435456,  536870912,  536870912,  536870912,  536870912,  536870912,  1073741824,
            1073741824, 1073741824, 1073741824, 1073741824, 2147483648, 2147483648, 2147483648,
            2147483648, 2147483648,
        },
        {
            85009117,   335741939,  1412632518, 386859243,  1741437244, 152139416,  403047142,
            2556825231, 505087203,  4287193174, 335609039,  336528191,  1425998811, 456920088,
            2832198590, 724748988,  3625845630, 1509824181, 3330088197, 2710488401, 1431742057,
            1077674236, 1140592489, 2096905276, 3007294393, 2863484114, 1081606648, 1207443154,
            972585080,  2793363314, 1432000919, 1089470704, 1341132452, 3019109363, 2362285522,
            1790260014, 2178941408, 2682264904, 1743251430, 429603751,  359294556,  62915520,
            1069562512, 3486502860, 859207501,  3939814584, 125831040,  2139125024, 2678038424,
            1718415002, 363436400,  251662080,  4278250048, 1061109552, 3436830004, 3948098272,
            503324160,  4261532800, 2122219104, 2310257256, 380003776,  1006648320, 4228098304,
            4244438208, 3278337232, 3981233024, 2013296640, 4161229312, 4193909120, 2530142624,
            446273280,  4026593280, 4027491328, 871625472,  4254978880, 4113772032, 3758219264,
            3760015360, 2011686400, 3946555008, 711351296,  3221471232, 3225063424, 4291808256,
            108481792,  2496444416, 2147975168, 2155159552, 4020213760, 485399040,  3919147008,
            983040,     15351808,   255799296,  3923588096, 322101248,  1966080,    299139072,
            511598592,  3283773440, 3865427968, 3932160,    4087939072, 1023197184, 1467273216,
            214663168,  7864320,    4149346304, 2046394368, 3202981888, 3650551808, 3236954112,
            1050935296, 871563264,  2916302848, 1932394496, 2447376384, 1833435136, 2011561984,
            2342944768, 643563520,  868220928,  177209344,  4291559424, 122486784,  2360868864,
            2004877312, 85983232,   4019716096, 3734634496, 3647995904, 1056964608, 3661627392,
            254803968,  2905866240, 1658847232, 2113929216, 3028287488, 3730833408, 2322071552,
            3586129920, 4227858432, 1761607680, 2092957696, 80740352,   2071986176, 4160749568,
            3523215360, 964689920,  429916160,  3875536896, 4026531840, 2751463424, 1929379840,
            4081057792, 503316480,  3758096384, 2281701376, 4127195136, 3397386240, 1316635,
            85009117,   335741939,  1412632518, 386859243,  1580547,    152139416,  403047142,
            2556825231, 505087203,  1317672,    335609039,  336528191,  1425998811, 456920088,
            1574501,    724748988,  3625845630, 1509824181, 3330088197, 15612,      1431742057,
            1077674236, 1140592489, 2096905276, 31224,      2863484114, 1081606648, 1207443154,
            972585080,  62451,      1432000919, 1089470704, 1341132452, 3019109363, 124902,
            1790260014, 2178941408, 2682264904, 1743251430, 249804,     359294556,  62915520,
            1069562512, 3486502860, 499608,     3939814584, 125831040,  2139125024, 2678038424,
            999216,     363436400,  251662080,  4278250048, 1061109552, 3223223904, 3948098272,
            503324160,  4261532800, 2122219104, 1077738688, 380003776,  1006648320, 4228098304,
            4244438208, 1081735552, 3981233024, 2013296640, 4161229312, 4193909120, 1089729280,
            446273280,  4026593280, 4027491328, 871625472,  2179458560, 4113772032, 3758219264,
            3760015360, 2011686400, 63949824,   711351296,  3221471232, 3225063424, 4291808256,
            127899648,  2496444416, 2147975168, 2155159552, 4020213760, 255799296,  3919147008,
            983040,     15351808,   255799296,  3732824064, 322101248,  1966080,    299139072,
            511598592,  2096939008, 3865427968, 3932160,    4087939072, 1023197184, 972652544,
            214663168,  7864320,    4149346304, 2046394368, 3019046912, 3650551808, 3236954112,
            1050935296, 871563264,  1743126528, 1932394496, 2447376384, 1833435136, 2011561984,
            3486253056, 643563520,  868220928,  177209344,  4291559424, 2677538816, 2360868864,
            2004877312, 85983232,   4019716096, 1060110336, 3647995904, 1056964608, 3661627392,
            254803968,  3193962496, 1658847232, 2113929216, 3028287488, 3730833408, 3166699520,
            3586129920, 4227858432, 1761607680, 2092957696, 3112173568, 2071986176, 4160749568,
            3523215360, 964689920,  1929379840, 3875536896, 4026531840, 2751463424, 1929379840,
            4127195136, 503316480,  3758096384, 2281701376, 4127195136, 332854,     1316635,
            85009117,   335741939,  1412632518, 596079,     1580547,    152139416,  403047142,
            2556825231, 1316075,    1317672,    335609039,  336528191,  1425998811, 2824661,
            1574501,    724748988,  3625845630, 1509824181, 5571497,    15612,      1431742057,
            1077674236, 1140592489, 11142994,   31224,      2863484114, 1081606648, 1207443154,
            22285988,   62451,      1432000919, 1089470704, 1341132452, 44571976,   124902,
            1790260014, 2178941408, 2682264904, 89143952,   249804,     359294556,  62915520,
            1069562512, 178287904,  499608,     3939814584, 125831040,  2139125024, 356575808,
            999216,     363436400,  251662080,  4278250048, 713151616,  3223223904, 3948098272,
            503324160,  4261532800, 1426303232, 1077738688, 380003776,  1006648320, 4228098304,
            2852606464, 1081735552, 3981233024, 2013296640, 4161229312, 1410245632, 1089729280,
            446273280,  4026593280, 4027491328, 1746749440, 2179458560, 4113772032, 3758219264,
            3760015360, 272273408,  63949824,   711351296,  3221471232, 3225063424, 3765772288,
            127899648,  2496444416, 2147975168, 2155159552, 15351808,   255799296,  3919147008,
            983040,     15351808,   3251929088, 3732824064, 322101248,  1966080,    299139072,
            1135149056, 2096939008, 3865427968, 3932160,    4087939072, 1196556288, 972652544,
            214663168,  7864320,    4149346304, 1319370752, 3019046912, 3650551808, 3236954112,
            1050935296, 2638741504, 1743126528, 1932394496, 2447376384, 1833435136, 982515712,
            3486253056, 643563520,  868220928,  177209344,  1965031424, 2677538816, 2360868864,
            2004877312, 85983232,   3930062848, 1060110336, 3647995904, 1056964608, 3661627392,
            3565158400, 3193962496, 1658847232, 2113929216, 3028287488, 2835349504, 3166699520,
            3586129920, 4227858432, 1761607680, 1375731712, 3112173568, 2071986176, 4160749568,
            3523215360, 2751463424, 1929379840, 3875536896, 4026531840, 2751463424, 2281701376,
            4127195136, 503316480,  3758096384, 2281701376, 5123,       332854,     1316635,
            85009117,   335741939,  6150,       596079,     1580547,    152139416,  403047142,
            5135,       1316075,    1317672,    335609039,  336528191,  6174,       2824661,
            1574501,    724748988,  3625845630, 60,         5571497,    15612,      1431742057,
            1077674236, 120,        11142994,   31224,      2863484114, 1081606648, 240,
            22285988,   62451,      1432000919, 1089470704, 480,        44571976,   124902,
            1790260014, 2178941408, 960,        89143952,   249804,     359294556,  62915520,
            1920,       178287904,  499608,     3939814584, 125831040,  3840,       356575808,
            999216,     363436400,  251662080,  7680,       713151616,  3223223904, 3948098272,
            503324160,  15360,      1426303232, 1077738688, 380003776,  1006648320, 30720,
            2852606464, 1081735552, 3981233024, 2013296640, 61440,      1410245632, 1089729280,
            446273280,  4026593280, 122880,     1746749440, 2179458560, 4113772032, 3758219264,
            245760,     272273408,  63949824,   711351296,  3221471232, 491520,     3765772288,
            127899648,  2496444416, 2147975168, 983040,     15351808,   255799296,  3919147008,
            983040,     3223191552, 3251929088, 3732824064, 322101248,  1966080,    1077673984,
            1135149056, 2096939008, 3865427968, 3932160,    1081606144, 1196556288, 972652544,
            214663168,  7864320,    1089470464, 1319370752, 3019046912, 3650551808, 3236954112,
            2178940928, 2638741504, 1743126528, 1932394496, 2447376384, 62914560,   982515712,
            3486253056, 643563520,  868220928,  125829120,  1965031424, 2677538816, 2360868864,
            2004877312, 251658240,  3930062848, 1060110336, 3647995904, 1056964608, 503316480,
            3565158400, 3193962496, 1658847232, 2113929216, 1006632960, 2835349504, 3166699520,
            3586129920, 4227858432, 2013265920, 1375731712, 3112173568, 2071986176, 4160749568,
            4026531840, 2751463424, 1929379840, 3875536896, 4026531840, 3758096384, 2281701376,
            4127195136, 503316480,  3758096384, 201392209,  3423671362, 218366296,  3713336838,
            206572594,  402785186,  2552372100, 436928947,  3130605370, 463476848,  262468,
            4461835,    68158800,   1158700908, 20971524,   524680,     8919318,    136513955,
            2316537326, 25165852,   3222274064, 3239051564, 3494187077, 3558090985, 3221225500,
            2149580832, 2183135832, 2693406858, 2821214674, 2147483704, 4194368,    71304368,
            1091846420, 1347462055, 64,         8388736,    142608736,  2183692840, 2694924110,
            3221225600, 16777472,   285217472,  72418384,   1094880924, 1342177536, 33554944,
            570434944,  144836768,  2189761848, 2684355072, 67109888,   1140869888, 289673536,
            84556400,   1073742848, 134219776,  2281739776, 579347072,  169112800,  2147485696,
            268439552,  268512256,  1158694144, 69790144,   4096,       536879104,  537024512,
            2317388288, 3360805760, 8192,       1073758208, 1074049024, 339809280,  1352902400,
            16384,      2147516416, 2148098048, 3900844032, 1632062976, 32768,      65536,
            1228800,    17059840,   311335936,  65536,      131072,     2457600,    34119680,
            622671872,  131072,     262144,     4915200,    68239360,   1245343744, 262144,
            524288,     9830400,    136478720,  2490687488, 524288,     1048576,    288096256,
            272957440,  954843136,  3222274048, 2097152,    3797417984, 545914880,  2983428096,
            2149580800, 4194304,    78643200,   1091829760, 2745630720, 4194304,    3229614080,
            3378511872, 1109917696, 2270035968, 8388608,    1358954496, 1119879168, 1414529024,
            513540096,  16777216,   2717908992, 2239758336, 2829058048, 1027080192, 33554432,
            1140850688, 184549376,  1363148800, 2054160384, 3288334336, 2281701376, 369098752,
            2726297600, 4108320768, 2281701376, 268435456,  738197504,  2231369728, 968884224,
            3959422976, 536870912,  1476395008, 167772160,  3011510272, 3355443200, 1073741824,
            2952790016, 335544320,  1728053248, 2147483648, 2147483648, 1610612736, 3892314112,
            503316480,  0,
        },
        {
            1939838472, 1412147404, 166205219,  1757484276, 2905930693, 2345662040, 2845657161,
            253454719,  2661974169, 303781080,  4075331504, 31014156,   244538930,  3752264221,
            992575155,  219309525,  246620060,  215640989,  4125020723, 2016731730, 3236558869,
            297169276,  3293566751, 1867504216, 210423272,  2531663658, 499723753,  1730625896,
            189236880,  3388575408, 2433358422, 1368961148, 3134096848, 2827836415, 3888822753,
            4172043647, 3379360748, 2651760955, 1345081091, 627692776,  189423917,  1927379456,
            4004336944, 2995932065, 1882016234, 2551113616, 1576396048, 1299792730, 2151240795,
            2154814108, 4292139924, 3555849728, 943986992,  3169912733, 2631635779, 3478094562,
            1285558544, 3716074330, 2780749859, 3911106510, 4175656994, 1731832828, 1275401375,
            937322456,  3802094750, 1145506936, 1008905193, 1718801768, 645739137,  1356219146,
            827886816,  1722154800, 2242776733, 754630810,  772070504,  249481170,  2608123425,
            2087201889, 3200968096, 3292110026, 841433255,  477543427,  1878882709, 705347364,
            4003860146, 3194913138, 2616490007, 357561212,  2446098297, 2955680594, 2512991743,
            637464579,  1209132455, 1341312804, 612108672,  2455017713, 1749147666, 4020226825,
            2873924220, 499405095,  1837614076, 1227604028, 714577577,  165950208,  442290261,
            489077752,  216760440,  42151250,   426862080,  2810242474, 4112075489, 3514761468,
            4101921371, 982512636,  500792667,  4286077681, 198050301,  1858712743, 2913642493,
            3547545255, 3981929169, 2944140287, 2286578015, 3422343167, 1239123295, 2026367394,
            3269986302, 3028402878, 2709637886, 1096011710, 294584132,  3086749695, 3324400975,
            1164394495, 4290155855, 543687304,  4008517630, 836370334,  1876426750, 2362048414,
            3578325264, 3221487612, 2671154748, 3395518460, 2018383420, 2131029536, 2165829624,
            697661816,  1336049656, 3309365624, 4259639360, 3423548400, 2416417776, 1633698800,
            1630071792, 41950336,   3423478496, 2885608160, 3943744224, 677380832,  4179285363,
            1939838472, 1412147404, 166205219,  1757484276, 3838244595, 2345662040, 2845657161,
            253454719,  2661974169, 138737288,  4075331504, 31014156,   244538930,  3752264221,
            1503392345, 219309525,  246620060,  215640989,  4125020723, 1759481152, 3236558869,
            297169276,  3293566751, 1867504216, 3898070400, 2531663658, 499723753,  1730625896,
            189236880,  2610231010, 2433358422, 1368961148, 3134096848, 2827836415, 3903474593,
            4172043647, 3379360748, 2651760955, 1345081091, 1267864331, 189423917,  1927379456,
            4004336944, 2995932065, 3452816347, 2551113616, 1576396048, 1299792730, 2151240795,
            1222520631, 4292139924, 3555849728, 943986992,  3169912733, 3260130211, 3478094562,
            1285558544, 3716074330, 2780749859, 3039362306, 4175656994, 1731832828, 1275401375,
            937322456,  3236754932, 1145506936, 1008905193, 1718801768, 645739137,  1358079399,
            827886816,  1722154800, 2242776733, 754630810,  1748663943, 249481170,  2608123425,
            2087201889, 3200968096, 698076610,  841433255,  477543427,  1878882709, 705347364,
            3692794996, 3194913138, 2616490007, 357561212,  2446098297, 2771068186, 2512991743,
            637464579,  1209132455, 1341312804, 27937268,   2455017713, 1749147666, 4020226825,
            2873924220, 1673040956, 1837614076, 1227604028, 714577577,  165950208,  528340088,
            489077752,  216760440,  42151250,   426862080,  1646215396, 4112075489, 3514761468,
            4101921371, 982512636,  2095821304, 4286077681, 198050301,  1858712743, 2913642493,
            277300160,  3981929169, 2944140287, 2286578015, 3422343167, 1178044288, 2026367394,
            3269986302, 3028402878, 2709637886, 2234191616, 294584132,  3086749695, 3324400975,
            1164394495, 136978944,  543687304,  4008517630, 836370334,  1876426750, 3275253760,
            3578325264, 3221487612, 2671154748, 3395518460, 3942394880, 2131029536, 2165829624,
            697661816,  1336049656, 3265045504, 4259639360, 3423548400, 2416417776, 1633698800,
            3943712768, 41950336,   3423478496, 2885608160, 3943744224, 2293593009, 4179285363,
            1939838472, 1412147404, 166205219,  715714152,  3838244595, 2345662040, 2845657161,
            253454719,  3758048260, 138737288,  4075331504, 31014156,   244538930,  370671650,
            1503392345, 219309525,  246620060,  215640989,  2219162331, 1759481152, 3236558869,
            297169276,  3293566751, 135243402,  3898070400, 2531663658, 499723753,  1730625896,
            3142293713, 2610231010, 2433358422, 1368961148, 3134096848, 486949791,  3903474593,
            4172043647, 3379360748, 2651760955, 3172880550, 1267864331, 189423917,  1927379456,
            4004336944, 191463910,  3452816347, 2551113616, 1576396048, 1299792730, 4411574,
            1222520631, 4292139924, 3555849728, 943986992,  3073348038, 3260130211, 3478094562,
            1285558544, 3716074330, 3098363790, 3039362306, 4175656994, 1731832828, 1275401375,
            468159532,  3236754932, 1145506936, 1008905193, 1718801768, 1092964081, 1358079399,
            827886816,  1722154800, 2242776733, 53128947,   1748663943, 249481170,  2608123425,
            2087201889, 1960144614, 698076610,  841433255,  477543427,  1878882709, 1505419004,
            3692794996, 3194913138, 2616490007, 357561212,  2823143358, 2771068186, 2512991743,
            637464579,  1209132455, 1991737212, 27937268,   2455017713, 1749147666, 4020226825,
            2907896812, 1673040956, 1837614076, 1227604028, 714577577,  3633969112, 528340088,
            489077752,  216760440,  42151250,   2886728356, 1646215396, 4112075489, 3514761468,
            4101921371, 3507686008, 2095821304, 4286077681, 198050301,  1858712743, 1463806912,
            277300160,  3981929169, 2944140287, 2286578015, 4137888640, 1178044288, 2026367394,
            3269986302, 3028402878, 1276820224, 2234191616, 294584132,  3086749695, 3324400975,
            4274031104, 136978944,  543687304,  4008517630, 836370334,  2978609152, 3275253760,
            3578325264, 3221487612, 2671154748, 2296777728, 3942394880, 2131029536, 2165829624,
            697661816,  1086645248, 3265045504, 4259639360, 3423548400, 2416417776, 2295121920,
            3943712768, 41950336,   3423478496, 2885608160, 3290486993, 2293593009, 4179285363,
            1939838472, 1412147404, 3718742914, 715714152,  3838244595, 2345662040, 2845657161,
            3251034248, 3758048260, 138737288,  4075331504, 31014156,   2257801369, 370671650,
            1503392345, 219309525,  246620060,  1375177854, 2219162331, 1759481152, 3236558869,
            297169276,  2981812236, 135243402,  3898070400, 2531663658, 499723753,  1103465850,
            3142293713, 2610231010, 2433358422, 1368961148, 2570001060, 486949791,  3903474593,
            4172043647, 3379360748, 1922171925, 3172880550, 1267864331, 189423917,  1927379456,
            1359812359, 191463910,  3452816347, 2551113616, 1576396048, 2518549525, 4411574,
            1222520631, 4292139924, 3555849728, 949028615,  3073348038, 3260130211, 3478094562,
            1285558544, 4113039486, 3098363790, 3039362306, 4175656994, 1731832828, 1827471372,
            468159532,  3236754932, 1145506936, 1008905193, 1626341859, 1092964081, 1358079399,
            827886816,  1722154800, 1069547583, 53128947,   1748663943, 249481170,  2608123425,
            3162506114, 1960144614, 698076610,  841433255,  477543427,  3641706484, 1505419004,
            3692794996, 3194913138, 2616490007, 3623882586, 2823143358, 2771068186, 2512991743,
            637464579,  16785012,   1991737212, 27937268,   2455017713, 1749147666, 2348825660,
            2907896812, 1673040956, 1837614076, 1227604028, 2579527800, 3633969112, 528340088,
            489077752,  216760440,  3628134628, 2886728356, 1646215396, 4112075489, 3514761468,
            1602085368, 3507686008, 2095821304, 4286077681, 198050301,  2501362624, 1463806912,
            277300160,  3981929169, 2944140287, 4112467840, 4137888640, 1178044288, 2026367394,
            3269986302, 3356184320, 1276820224, 2234191616, 294584132,  3086749695, 366387712,
            4274031104, 136978944,  543687304,  4008517630, 1006135296, 2978609152, 3275253760,
            3578325264, 3221487612, 3104844800, 2296777728, 3942394880, 2131029536, 2165829624,
            1874371584, 1086645248, 3265045504, 4259639360, 3423548400, 2975352832, 2295121920,
            3943712768, 41950336,   3423478496, 989898496,  3410688577, 2331788830, 3546482013,
            813828841,  1865093068, 3265457506, 3795669738, 2119696024, 4285651426, 3333834629,
            3451487261, 2090324595, 1816963648, 932961512,  2470761029, 3401764108, 3421619354,
            4199624502, 589386372,  879396240,  3372470254, 2693109296, 2424215996, 38442268,
            1882087724, 171397600,  2024561281, 183095586,  3282207272, 3402177296, 1859195498,
            413109947,  2839537944, 1632143648, 3742715856, 388696500,  1748703733, 3563198567,
            3826785440, 2896086528, 3989037829, 1478787788, 1390277813, 2123320736, 3416516800,
            2056564203, 2584895011, 1605192736, 2475623616, 3856499712, 3439657984, 708088129,
            1501395566, 1302184960, 1360092352, 1645630430, 1425230387, 3369488824, 2979863936,
            869212432,  150548847,  1097557362, 655939640,  316553344,  3761918508, 3958338094,
            141744600,  1412214640, 1859689984, 3200680981, 3883058679, 999801880,  3946079738,
            1876072704, 194381849,  2177533995, 1584707624, 3053768410, 2593051904, 3458076673,
            4047442835, 3545972808, 3441793178, 194975744,  1731731470, 4168755162, 2628944732,
            2125675784, 3119906816, 960774145,  2646626078, 2152793157, 3049156634, 672464896,
            3046932493, 3700727536, 2152335477, 575986696,  671940608,  2208366608, 1454456125,
            937760016,  4103979069, 2737668096, 1179779104, 1030912634, 1041902112, 2032909434,
            2274230272, 2089025605, 3050632421, 2428784965, 140658149,  4254138368, 1745354889,
            711584249,  2746523017, 2551006457, 1100808192, 1494221073, 3422999489, 2696954129,
            976716737,  2653421568, 3806331426, 3690047362, 1481392674, 3817015170, 2353004544,
            286262340,  2300534532, 4206449732, 15339268,   2894069760, 488376456,  1489927688,
            1196583048, 652746248,  2214592512, 69904,      1006205200, 2322628880, 1229515024,
            2617245696, 3423527456, 1964953120, 4260938272, 386199072,  1744830464, 1342444608,
            1069330496, 2138592320, 3185897536, 1073741824, 1342493824, 3780942976, 1771066496,
            2189433984, 2147483648,
        },
        {
            1804684571, 2106089606, 1533056158, 2870216110, 3618155659, 3789871366, 4246691682,
            3667072763, 1212241769, 3152390668, 2973497449, 2958641966, 2088805328, 717518631,
            2401090860, 3606967204, 952637656,  59827581,   1291486682, 1499453515, 2053994857,
            563998083,  4094000396, 1163546899, 1003843565, 654565639,  1070907026, 4217851863,
            426034251,  1721352737, 278404469,  3899800390, 1063362170, 1162348262, 3153545093,
            3249996223, 186674553,  2616406148, 3137968354, 1282784965, 1495068058, 3033760361,
            2278144523, 3192245769, 719586342,  2602548287, 3386583150, 355354345,  3252815848,
            2178056037, 2283016801, 3005955037, 3340254490, 802791670,  251122316,  3705188626,
            1252262272, 3989036796, 3527490452, 2047131255, 1447170583, 3373930285, 2895037457,
            209341805,  1820357643, 3712392731, 685796521,  1322920440, 814388470,  1357857147,
            434430265,  2650681935, 1371566728, 58783716,   2273435933, 3498513198, 792571900,
            1447808772, 3513385860, 99175889,   1105434360, 1484146625, 3327194068, 242672513,
            3552105593, 1425844616, 2871928454, 1124633561, 607610433,  2130018608, 1610235673,
            2844230432, 2748082340, 994392866,  450823250,  2912535126, 2574390988, 3974009252,
            78696582,   649682891,  3980917176, 3221419689, 960695436,  729221508,  358358845,
            3392407691, 472711005,  295914899,  3005191796, 3078521977, 3370011868, 509135340,
            1965939519, 2086465877, 2457949822, 1324152522, 762289386,  3618693997, 233730715,
            2873984650, 31168606,   3367142977, 2851851305, 3251660053, 4209768406, 3298190175,
            901235185,  1564391510, 2352686527, 1008150482, 578573310,  3462447127, 2482873876,
            1790221257, 2255375608, 2335345651, 1381450613, 2866805101, 1495073163, 519905259,
            3184556473, 1076378339, 2692926127, 970097715,  4013407916, 4014350363, 2476927059,
            1989070516, 2640060069, 1987784589, 1880989003, 3861138803, 451743296,  1987067871,
            1975657871, 3397816882, 2309900530, 4108425851, 4063867233, 3319482186, 2621772886,
            1804684571, 2106089606, 1533056158, 2870216110, 611557097,  3789871366, 4246691682,
            3667072763, 1212241769, 3389551988, 2973497449, 2958641966, 2088805328, 717518631,
            2460955430, 3606967204, 952637656,  59827581,   1291486682, 3531087304, 2053994857,
            563998083,  4094000396, 1163546899, 1242934125, 654565639,  1070907026, 4217851863,
            426034251,  3034416129, 278404469,  3899800390, 1063362170, 1162348262, 4258714417,
            3249996223, 186674553,  2616406148, 3137968354, 639885806,  1495068058, 3033760361,
            2278144523, 3192245769, 4159910300, 2602548287, 3386583150, 355354345,  3252815848,
            1555885880, 2283016801, 3005955037, 3340254490, 802791670,  2948774612, 3705188626,
            1252262272, 3989036796, 3527490452, 2107826711, 1447170583, 3373930285, 2895037457,
            209341805,  3763367196, 3712392731, 685796521,  1322920440, 814388470,  1986168339,
            434430265,  2650681935, 1371566728, 58783716,   1423189187, 3498513198, 792571900,
            1447808772, 3513385860, 315969823,  1105434360, 1484146625, 3327194068, 242672513,
            3336228275, 1425844616, 2871928454, 1124633561, 607610433,  1762052458, 1610235673,
            2844230432, 2748082340, 994392866,  3771702243, 2912535126, 2574390988, 3974009252,
            78696582,   1626628844, 3980917176, 3221419689, 960695436,  729221508,  382092233,
            3392407691, 472711005,  295914899,  3005191796, 514297204,  3370011868, 509135340,
            1965939519, 2086465877, 3975975091, 1324152522, 762289386,  3618693997, 233730715,
            455322516,  31168606,   3367142977, 2851851305, 3251660053, 3952189603, 3298190175,
            901235185,  1564391510, 2352686527, 826181452,  578573310,  3462447127, 2482873876,
            1790221257, 1529242773, 2335345651, 1381450613, 2866805101, 1495073163, 877718651,
            3184556473, 1076378339, 2692926127, 970097715,  299344245,  4014350363, 2476927059,
            1989070516, 2640060069, 3844531327, 1880989003, 3861138803, 451743296,  1987067871,
            3272848161, 3397816882, 2309900530, 4108425851, 4063867233, 834288064,  2621772886,
            1804684571, 2106089606, 1533056158, 304865970,  611557097,  3789871366, 4246691682,
            3667072763, 2728206193, 3389551988, 2973497449, 2958641966, 2088805328, 3895037582,
            2460955430, 3606967204, 952637656,  59827581,   2349212526, 3531087304, 2053994857,
            563998083,  4094000396, 4028900485, 1242934125, 654565639,  1070907026, 4217851863,
            1663452176, 3034416129, 278404469,  3899800390, 1063362170, 2721441405, 4258714417,
            3249996223, 186674553,  2616406148, 4228837490, 639885806,  1495068058, 3033760361,
            2278144523, 2820661772, 4159910300, 2602548287, 3386583150, 355354345,  1815256314,
            1555885880, 2283016801, 3005955037, 3340254490, 2166514144, 2948774612, 3705188626,
            1252262272, 3989036796, 751187322,  2107826711, 1447170583, 3373930285, 2895037457,
            2809311944, 3763367196, 3712392731, 685796521,  1322920440, 936300677,  1986168339,
            434430265,  2650681935, 1371566728, 1308015359, 1423189187, 3498513198, 792571900,
            1447808772, 3065349526, 315969823,  1105434360, 1484146625, 3327194068, 1038676789,
            3336228275, 1425844616, 2871928454, 1124633561, 2956422231, 1762052458, 1610235673,
            2844230432, 2748082340, 3603862093, 3771702243, 2912535126, 2574390988, 3974009252,
            1691332448, 1626628844, 3980917176, 3221419689, 960695436,  3120142427, 382092233,
            3392407691, 472711005,  295914899,  4101686983, 514297204,  3370011868, 509135340,
            1965939519, 3015736706, 3975975091, 1324152522, 762289386,  3618693997, 2395097989,
            455322516,  31168606,   3367142977, 2851851305, 30511955,   3952189603, 3298190175,
            901235185,  1564391510, 2606298633, 826181452,  578573310,  3462447127, 2482873876,
            4159642946, 1529242773, 2335345651, 1381450613, 2866805101, 1782913669, 877718651,
            3184556473, 1076378339, 2692926127, 1730328819, 299344245,  4014350363, 2476927059,
            1989070516, 1425685614, 3844531327, 1880989003, 3861138803, 451743296,  889237383,
            3272848161, 3397816882, 2309900530, 4108425851, 1155723231, 834288064,  2621772886,
            1804684571, 2106089606, 2387009004, 304865970,  611557097,  3789871366, 4246691682,
            1405709661, 2728206193, 3389551988, 2973497449, 2958641966, 3183906006, 3895037582,
            2460955430, 3606967204, 952637656,  1345432763, 2349212526, 3531087304, 2053994857,
            563998083,  3749011414, 4028900485, 1242934125, 654565639,  1070907026, 1072342672,
            1663452176, 3034416129, 278404469,  3899800390, 3566652188, 2721441405, 4258714417,
            3249996223, 186674553,  4001263143, 4228837490, 639885806,  1495068058, 3033760361,
            4278332644, 2820661772, 4159910300, 2602548287, 3386583150, 838831089,  1815256314,
            1555885880, 2283016801, 3005955037, 3377397178, 2166514144, 2948774612, 3705188626,
            1252262272, 2414422575, 751187322,  2107826711, 1447170583, 3373930285, 1253755033,
            2809311944, 3763367196, 3712392731, 685796521,  3238624475, 936300677,  1986168339,
            434430265,  2650681935, 1642290570, 1308015359, 1423189187, 3498513198, 792571900,
            173318140,  3065349526, 315969823,  1105434360, 1484146625, 4103797777, 1038676789,
            3336228275, 1425844616, 2871928454, 1797745765, 2956422231, 1762052458, 1610235673,
            2844230432, 2180656608, 3603862093, 3771702243, 2912535126, 2574390988, 1183098390,
            1691332448, 1626628844, 3980917176, 3221419689, 2645203959, 3120142427, 382092233,
            3392407691, 472711005,  1659659070, 4101686983, 514297204,  3370011868, 509135340,
            483888155,  3015736706, 3975975091, 1324152522, 762289386,  1259948064, 2395097989,
            455322516,  31168606,   3367142977, 339990414,  30511955,   3952189603, 3298190175,
            901235185,  3097920065, 2606298633, 826181452,  578573310,  3462447127, 1548039839,
            4159642946, 1529242773, 2335345651, 1381450613, 2173079994, 1782913669, 877718651,
            3184556473, 1076378339, 1570275057, 1730328819, 299344245,  4014350363, 2476927059,
            1845882881, 1425685614, 3844531327, 1880989003, 3861138803, 1322409081, 889237383,
            3272848161, 3397816882, 2309900530, 3505447982, 3430136873, 1319796589, 4202423979,
            3184732284, 2910356648, 2534615223, 3854465731, 768821792,  2205052576, 1348983754,
            1300250188, 2919181738, 2520178732, 3967243685, 2646012002, 1784678658, 741302051,
            3464753547, 194213376,  1482799064, 3009673860, 680824208,  741966796,  2381283369,
            3022877171, 1619439814, 3961433610, 1331297670, 1100110820, 1311672539, 1122110615,
            4056004850, 3413790176, 3148768822, 1242592694, 2925975727, 1879285134, 334328879,
            1318235222, 3140739559, 401691770,  3604288404, 3686496908, 770670945,  199139043,
            2092710473, 3914528993, 700991333,  2375775811, 858137308,  3490050165, 2389078291,
            1615607459, 3027969809, 820012549,  2085659484, 2654485136, 2630408646, 196481396,
            1119673274, 1026209692, 726501622,  2940737143, 3559571163, 2288027726, 1039212708,
            929664536,  1061981465, 186058675,  3537656152, 844176796,  2996217992, 1545798611,
            3031020656, 2248030435, 1665857580, 2905758082, 1269201312, 3031275084, 4034872841,
            983632400,  4188503190, 757119675,  2105920865, 4281032819, 2917801076, 3900010013,
            3910997169, 1729751422, 562313247,  3070846353, 2564238664, 4050540186, 4258833501,
            2270666053, 2207128401, 2990540001, 797768898,  2288390225, 3230323685, 1974727440,
            3327301426, 289857826,  3565889868, 2791014422, 2021097820, 3350378271, 3673707591,
            2610067927, 4255789547, 2682856590, 12563128,   1397542366, 237149400,  2233707508,
            3875573245, 2097374144, 175320773,  4103445984, 4089284323, 3610168130, 3084915964,
            680145366,  2571684685, 1132894909, 104640024,  193765521,  2338202907, 895271448,
            11499099,   1798066417, 1297412626, 2511347162, 3140535007, 2129963538, 700683199,
            2609700278, 2953463279, 2290844145, 1871316353, 3993801787, 2219413182, 2954453701,
            231283580,  1375331115, 207723994,  1799562537, 2056553564, 2513609799, 3542459627,
            3173012714, 3923404932, 217877755,  2095124912, 192024370,  1168134987, 1889598668,
            3014873069, 2033573343,
        },
        {
            3465348660, 3623545008, 3505902593, 838034830,  1338018789, 2595329276, 3367746385,
            3197935201, 1439351946, 3585085571, 4165798087, 3634792639, 2359485974, 2772582925,
            1110186203, 3771562484, 1508694157, 1564641206, 2801985736, 2446107936, 3849126897,
            1842973671, 944408104,  2624631280, 2729080685, 3737368614, 858809173,  2289802345,
            2428186575, 3114742765, 716011303,  3443810690, 814132610,  517432787,  614445393,
            2930433345, 291178098,  2117644502, 2749446703, 311745701,  365684723,  1705418876,
            2213749318, 4011417220, 1842575651, 988348831,  94258998,   2771150272, 498058526,
            1344827813, 2961955291, 262703473,  1404034822, 1566595865, 2522381203, 1706522206,
            1203054806, 1273801539, 2070583465, 3913449936, 3231505231, 619636751,  3746997351,
            4103027837, 1205468203, 3355878253, 3433356888, 107785753,  2779092609, 1869691566,
            2555219983, 903319808,  3273374169, 2538926990, 979533870,  1356500860, 1661983738,
            1380761625, 2919458459, 1041142798, 1430817627, 517007606,  1421570516, 2371447300,
            2985632691, 3684889351, 3873926653, 788770697,  1854750277, 209332297,  1137299679,
            848527832,  3850486924, 4179307312, 2764470693, 1353191605, 4166891919, 2074703841,
            3373997532, 2013528640, 701389744,  841917592,  2065742268, 2721848192, 2566956680,
            3122896007, 1090761479, 921859028,  4086736376, 1837462309, 2579826431, 2436217134,
            839037727,  1072086642, 614518622,  3764758228, 1501128342, 3669108708, 1601407381,
            2899014005, 3268308948, 3337564231, 1986911578, 3379194930, 1950365753, 2098537451,
            51515980,   1176526086, 3213391582, 1059745735, 2273586703, 376085505,  1493749800,
            3970342143, 1620925244, 2165301314, 2332030190, 1864098798, 276747442,  2776569227,
            2992780663, 3027279789, 1074555384, 3481518659, 2499703783, 661805703,  3782305562,
            9186074,    2357407210, 2355922343, 2024733363, 485434612,  862379913,  1029706268,
            1512726310, 3834948354, 1435892840, 3297980694, 2831553800, 2111416471, 711321697,
            3465348660, 3623545008, 3505902593, 838034830,  1553436793, 2595329276, 3367746385,
            3197935201, 1439351946, 3198044157, 4165798087, 3634792639, 2359485974, 2772582925,
            836042976,  3771562484, 1508694157, 1564641206, 2801985736, 1190371491, 3849126897,
            1842973671, 944408104,  2624631280, 410746791,  3737368614, 858809173,  2289802345,
            2428186575, 1542325976, 716011303,  3443810690, 814132610,  517432787,  1649301063,
            2930433345, 291178098,  2117644502, 2749446703, 3955511579, 365684723,  1705418876,
            2213749318, 4011417220, 2753632862, 988348831,  94258998,   2771150272, 498058526,
            3314106168, 2961955291, 262703473,  1404034822, 1566595865, 3590367097, 1706522206,
            1203054806, 1273801539, 2070583465, 2340683261, 3231505231, 619636751,  3746997351,
            4103027837, 2785398766, 3355878253, 3433356888, 107785753,  2779092609, 1608451840,
            2555219983, 903319808,  3273374169, 2538926990, 645164419,  1356500860, 1661983738,
            1380761625, 2919458459, 2260224548, 1430817627, 517007606,  1421570516, 2371447300,
            1636004496, 3684889351, 3873926653, 788770697,  1854750277, 1345251011, 1137299679,
            848527832,  3850486924, 4179307312, 3576574608, 1353191605, 4166891919, 2074703841,
            3373997532, 183447754,  701389744,  841917592,  2065742268, 2721848192, 2109289891,
            3122896007, 1090761479, 921859028,  4086736376, 2212730874, 2579826431, 2436217134,
            839037727,  1072086642, 55934784,   3764758228, 1501128342, 3669108708, 1601407381,
            516550987,  3268308948, 3337564231, 1986911578, 3379194930, 3973484473, 2098537451,
            51515980,   1176526086, 3213391582, 4251661633, 2273586703, 376085505,  1493749800,
            3970342143, 3190791788, 2165301314, 2332030190, 1864098798, 276747442,  2991976613,
            2992780663, 3027279789, 1074555384, 3481518659, 1399789494, 661805703,  3782305562,
            9186074,    2357407210, 1942736967, 2024733363, 485434612,  862379913,  1029706268,
            4122704494, 3834948354, 1435892840, 3297980694, 2831553800, 1210092654, 711321697,
            3465348660, 3623545008, 3505902593, 3443231198, 1553436793, 2595329276, 3367746385,
            3197935201, 1304974987, 3198044157, 4165798087, 3634792639, 2359485974, 3518323362,
            836042976,  3771562484, 1508694157, 1564641206, 3577633375, 1190371491, 3849126897,
            1842973671, 944408104,  1854555112, 410746791,  3737368614, 858809173,  2289802345,
            3622671731, 1542325976, 716011303,  3443810690, 814132610,  296197011,  1649301063,
            2930433345, 291178098,  2117644502, 1056271538, 3955511579, 365684723,  1705418876,
            2213749318, 1258535671, 2753632862, 988348831,  94258998,   2771150272, 3669902097,
            3314106168, 2961955291, 262703473,  1404034822, 1654433938, 3590367097, 1706522206,
            1203054806, 1273801539, 2448138887, 2340683261, 3231505231, 619636751,  3746997351,
            1454088394, 2785398766, 3355878253, 3433356888, 107785753,  689323470,  1608451840,
            2555219983, 903319808,  3273374169, 1603842392, 645164419,  1356500860, 1661983738,
            1380761625, 2814639423, 2260224548, 1430817627, 517007606,  1421570516, 1938805701,
            1636004496, 3684889351, 3873926653, 788770697,  4238900666, 1345251011, 1137299679,
            848527832,  3850486924, 108793827,  3576574608, 1353191605, 4166891919, 2074703841,
            3780897861, 183447754,  701389744,  841917592,  2065742268, 3036602746, 2109289891,
            3122896007, 1090761479, 921859028,  3499985398, 2212730874, 2579826431, 2436217134,
            839037727,  3520354700, 55934784,   3764758228, 1501128342, 3669108708, 1601010847,
            516550987,  3268308948, 3337564231, 1986911578, 2704241781, 3973484473, 2098537451,
            51515980,   1176526086, 3602010532, 4251661633, 2273586703, 376085505,  1493749800,
            2922957328, 3190791788, 2165301314, 2332030190, 1864098798, 1649666443, 2991976613,
            2992780663, 3027279789, 1074555384, 2848531519, 1399789494, 661805703,  3782305562,
            9186074,    320781315,  1942736967, 2024733363, 485434612,  862379913,  3598892066,
            4122704494, 3834948354, 1435892840, 3297980694, 545184652,  1210092654, 711321697,
            3465348660, 3623545008, 1173753045, 3443231198, 1553436793, 2595329276, 3367746385,
            2444634476, 1304974987, 3198044157, 4165798087, 3634792639, 1837035806, 3518323362,
            836042976,  3771562484, 1508694157, 2899021294, 3577633375, 1190371491, 3849126897,
            1842973671, 1614215215, 1854555112, 410746791,  3737368614, 858809173,  525745365,
            3622671731, 1542325976, 716011303,  3443810690, 566299749,  296197011,  1649301063,
            2930433345, 291178098,  1987532525, 1056271538, 3955511579, 365684723,  1705418876,
            2321222760, 1258535671, 2753632862, 988348831,  94258998,   2986060366, 3669902097,
            3314106168, 2961955291, 262703473,  604452796,  1654433938, 3590367097, 1706522206,
            1203054806, 1894894069, 2448138887, 2340683261, 3231505231, 619636751,  6680729,
            1454088394, 2785398766, 3355878253, 3433356888, 2025591660, 689323470,  1608451840,
            2555219983, 903319808,  3430384385, 1603842392, 645164419,  1356500860, 1661983738,
            2108736152, 2814639423, 2260224548, 1430817627, 517007606,  2973658959, 1938805701,
            1636004496, 3684889351, 3873926653, 2283691941, 4238900666, 1345251011, 1137299679,
            848527832,  45551112,   108793827,  3576574608, 1353191605, 4166891919, 3776615962,
            3780897861, 183447754,  701389744,  841917592,  3830639316, 3036602746, 2109289891,
            3122896007, 1090761479, 1931255897, 3499985398, 2212730874, 2579826431, 2436217134,
            3272166055, 3520354700, 55934784,   3764758228, 1501128342, 1567864246, 1601010847,
            516550987,  3268308948, 3337564231, 3918802424, 2704241781, 3973484473, 2098537451,
            51515980,   3551394489, 3602010532, 4251661633, 2273586703, 376085505,  885459498,
            2922957328, 3190791788, 2165301314, 2332030190, 3197056515, 1649666443, 2991976613,
            2992780663, 3027279789, 2385348906, 2848531519, 1399789494, 661805703,  3782305562,
            2163075465, 320781315,  1942736967, 2024733363, 485434612,  2680597981, 3598892066,
            4122704494, 3834948354, 1435892840, 2499644163, 2704575422, 2579557838, 673530532,
            493730767,  1124557747, 1908629439, 2821949504, 1743112513, 2849457841, 2344409314,
            3479159262, 4260973770, 2991970754, 3812641863, 2229319917, 2466968521, 1766353737,
            3216591612, 2113272648, 364370737,  1893001758, 2608875275, 4224057183, 3546705413,
            1999778009, 348872225,  2470564216, 1417878284, 2709790112, 3579129936, 2137971615,
            4046639861, 2841156930, 391544737,  2056567354, 737657378,  3877904725, 578930752,
            1759172471, 3383278785, 1047197514, 649468151,  3452867243, 1792089520, 63936215,
            3909143729, 3753489875, 734314122,  2490530916, 3043874586, 1504812057, 59001199,
            2493748676, 2552438622, 1889694845, 3715397860, 2817245010, 3841049206, 816106718,
            2176130406, 640254735,  12376903,   3000264936, 3304116079, 1620334094, 2109391765,
            1348210951, 2237645681, 1207768272, 1562894669, 2156631655, 1387193235, 3154858817,
            633510901,  2312190757, 402878244,  2501565021, 2984409334, 4167491216, 3614267292,
            3078552271, 971722322,  3065543880, 2307584190, 491480322,  2068673112, 1929780632,
            178549964,  983979983,  2769314886, 4214442042, 2977609682, 25450683,   3075212658,
            1571149568, 3531670561, 42782504,   425601306,  428715214,  497250251,  693520802,
            166426814,  1786382125, 2712003995, 3610802197, 2076490757, 404822980,  3953184772,
            1655231947, 3594351577, 3068232274, 3771730346, 4110519574, 3534704897, 2375277865,
            3597780202, 3472676002, 1350276449, 3218248239, 3589255283, 3253132633, 1769885529,
            3792812294, 120332643,  1219374788, 3608889019, 2386099811, 858495304,  1284785543,
            331370962,  2259419662, 2519864134, 3194739432, 2669074511, 2565559140, 3378072004,
            2647801475, 265068954,  1464416963, 1232787612, 4160089759, 2510685972, 670300081,
            2509357766, 1981891975, 4161588397, 1371924626, 44760868,   634955171,  1187096933,
            3324788972, 3576888559, 2801347752, 3730298395, 1702170762, 4206083415, 741409141,
            3649731355, 1025429529,
        },
        {
            91444490,   628576944,  4069219862, 2253058925, 492354082,  1191182242, 1565180119,
            2257613723, 456055162,  605712223,  953365104,  3104638527, 1133984729, 2662828416,
            2134948274, 1921384447, 843719355,  588432962,  1734575434, 2924140067, 483396548,
            3848838894, 3155476556, 1760928304, 4168059840, 3279827269, 2644461735, 4168565656,
            3951563569, 1276805504, 1708974143, 1878547888, 3465220024, 3062086782, 2801401651,
            1510428126, 716404149,  1646021208, 3534932385, 1186585561, 651997355,  282914223,
            352224857,  3764407517, 1059868753, 1971798134, 978904005,  976413661,  4039544152,
            498989693,  2565125471, 2782642813, 3537961025, 1194967362, 169217024,  3491609,
            1319592872, 1630206561, 2497130840, 1685008996, 2828944016, 3301346775, 2893072371,
            2606559798, 4026138031, 2664450619, 691091062,  1079640113, 1417637732, 4081852209,
            2197910648, 2310382370, 1000957047, 959936499,  2844551811, 2272766890, 31122394,
            2742925483, 1121884686, 57929089,   2468361281, 2982007782, 2371576893, 177782593,
            3603584577, 672057044,  2108452841, 1671338057, 3386908223, 1243029765, 805157552,
            1271858417, 1621249501, 1804851492, 1321010403, 751773221,  1517221627, 822709871,
            104533154,  3578182264, 640541709,  421086624,  4233576392, 3729339369, 197460644,
            773140636,  2158026018, 1756785611, 4011575991, 3569445500, 736117181,  2456162322,
            1168189787, 3651312675, 1070291988, 268231205,  541474497,  3316168972, 3546990856,
            830417208,  725960194,  2044207227, 3188997938, 2383298579, 3350316374, 3575011225,
            1553111865, 1285013027, 749371711,  766611716,  598195098,  2139882719, 2062405428,
            3634702446, 3015263295, 223311969,  2622859522, 3888492701, 2955257225, 582625650,
            3563756446, 2886083960, 1907546514, 454650902,  3287277541, 625828138,  2991888140,
            1935326370, 4031152256, 702881509,  1427632724, 1345475301, 2577560804, 2858595147,
            2533191188, 185662179,  536505093,  3747894147, 111551030,  370373207,  2293908590,
            91444490,   628576944,  4069219862, 2253058925, 1671484924, 1191182242, 1565180119,
            2257613723, 456055162,  3411094744, 953365104,  3104638527, 1133984729, 2662828416,
            2000630022, 1921384447, 843719355,  588432962,  1734575434, 3293926122, 483396548,
            3848838894, 3155476556, 1760928304, 146876953,  3279827269, 2644461735, 4168565656,
            3951563569, 3976156700, 1708974143, 1878547888, 3465220024, 3062086782, 1999154400,
            1510428126, 716404149,  1646021208, 3534932385, 2479551429, 651997355,  282914223,
            352224857,  3764407517, 1275979651, 1971798134, 978904005,  976413661,  4039544152,
            300654823,  2565125471, 2782642813, 3537961025, 1194967362, 3123973648, 3491609,
            1319592872, 1630206561, 2497130840, 1437913158, 2828944016, 3301346775, 2893072371,
            2606559798, 2153172585, 2664450619, 691091062,  1079640113, 1417637732, 17137237,
            2197910648, 2310382370, 1000957047, 959936499,  802137134,  2272766890, 31122394,
            2742925483, 1121884686, 3909775167, 2468361281, 2982007782, 2371576893, 177782593,
            3319492525, 672057044,  2108452841, 1671338057, 3386908223, 1878151473, 805157552,
            1271858417, 1621249501, 1804851492, 3215921223, 751773221,  1517221627, 822709871,
            104533154,  361845001,  640541709,  421086624,  4233576392, 3729339369, 2655936801,
            773140636,  2158026018, 1756785611, 4011575991, 587202971,  736117181,  2456162322,
            1168189787, 3651312675, 2517883370, 268231205,  541474497,  3316168972, 3546990856,
            2037251305, 725960194,  2044207227, 3188997938, 2383298579, 2665008587, 3575011225,
            1553111865, 1285013027, 749371711,  2163964019, 598195098,  2139882719, 2062405428,
            3634702446, 2788202059, 223311969,  2622859522, 3888492701, 2955257225, 740986174,
            3563756446, 2886083960, 1907546514, 454650902,  2426323587, 625828138,  2991888140,
            1935326370, 4031152256, 1831149435, 1427632724, 1345475301, 2577560804, 2858595147,
            3977153945, 185662179,  536505093,  3747894147, 111551030,  4131587422, 2293908590,
            91444490,   628576944,  4069219862, 2408189350, 1671484924, 1191182242, 1565180119,
            2257613723, 1338069254, 3411094744, 953365104,  3104638527, 1133984729, 631497759,
            2000630022, 1921384447, 843719355,  588432962,  3280318959, 3293926122, 483396548,
            3848838894, 3155476556, 1777918163, 146876953,  3279827269, 2644461735, 4168565656,
            2786264663, 3976156700, 1708974143, 1878547888, 3465220024, 2793923820, 1999154400,
            1510428126, 716404149,  1646021208, 3102243824, 2479551429, 651997355,  282914223,
            352224857,  3767702588, 1275979651, 1971798134, 978904005,  976413661,  1951622548,
            300654823,  2565125471, 2782642813, 3537961025, 2186817324, 3123973648, 3491609,
            1319592872, 1630206561, 1075424534, 1437913158, 2828944016, 3301346775, 2893072371,
            207992406,  2153172585, 2664450619, 691091062,  1079640113, 3114255216, 17137237,
            2197910648, 2310382370, 1000957047, 2548008553, 802137134,  2272766890, 31122394,
            2742925483, 4069482373, 3909775167, 2468361281, 2982007782, 2371576893, 2807823912,
            3319492525, 672057044,  2108452841, 1671338057, 12831353,   1878151473, 805157552,
            1271858417, 1621249501, 461887094,  3215921223, 751773221,  1517221627, 822709871,
            1317394918, 361845001,  640541709,  421086624,  4233576392, 3385587450, 2655936801,
            773140636,  2158026018, 1756785611, 1475601973, 587202971,  736117181,  2456162322,
            1168189787, 911455077,  2517883370, 268231205,  541474497,  3316168972, 1500275507,
            2037251305, 725960194,  2044207227, 3188997938, 2036633808, 2665008587, 3575011225,
            1553111865, 1285013027, 87868216,   2163964019, 598195098,  2139882719, 2062405428,
            517907301,  2788202059, 223311969,  2622859522, 3888492701, 3926046234, 740986174,
            3563756446, 2886083960, 1907546514, 1911066215, 2426323587, 625828138,  2991888140,
            1935326370, 2031853435, 1831149435, 1427632724, 1345475301, 2577560804, 3509674153,
            3977153945, 185662179,  536505093,  3747894147, 1711714600, 4131587422, 2293908590,
            91444490,   628576944,  3370678255, 2408189350, 1671484924, 1191182242, 1565180119,
            3786239592, 1338069254, 3411094744, 953365104,  3104638527, 3659647225, 631497759,
            2000630022, 1921384447, 843719355,  3364831282, 3280318959, 3293926122, 483396548,
            3848838894, 3131266478, 1777918163, 146876953,  3279827269, 2644461735, 4156372383,
            2786264663, 3976156700, 1708974143, 1878547888, 2168041590, 2793923820, 1999154400,
            1510428126, 716404149,  3392113666, 3102243824, 2479551429, 651997355,  282914223,
            2085613514, 3767702588, 1275979651, 1971798134, 978904005,  503506384,  1951622548,
            300654823,  2565125471, 2782642813, 1458431750, 2186817324, 3123973648, 3491609,
            1319592872, 452433679,  1075424534, 1437913158, 2828944016, 3301346775, 2333281307,
            207992406,  2153172585, 2664450619, 691091062,  3553502652, 3114255216, 17137237,
            2197910648, 2310382370, 3153689868, 2548008553, 802137134,  2272766890, 31122394,
            468580641,  4069482373, 3909775167, 2468361281, 2982007782, 1445286890, 2807823912,
            3319492525, 672057044,  2108452841, 1755577669, 12831353,   1878151473, 805157552,
            1271858417, 2623540912, 461887094,  3215921223, 751773221,  1517221627, 3922191946,
            1317394918, 361845001,  640541709,  421086624,  2173849516, 3385587450, 2655936801,
            773140636,  2158026018, 1085377158, 1475601973, 587202971,  736117181,  2456162322,
            2158960374, 911455077,  2517883370, 268231205,  541474497,  943191315,  1500275507,
            2037251305, 725960194,  2044207227, 2481150802, 2036633808, 2665008587, 3575011225,
            1553111865, 2301231777, 87868216,   2163964019, 598195098,  2139882719, 2007840238,
            517907301,  2788202059, 223311969,  2622859522, 151920263,  3926046234, 740986174,
            3563756446, 2886083960, 1338937928, 1911066215, 2426323587, 625828138,  2991888140,
            2652286195, 2031853435, 1831149435, 1427632724, 1345475301, 289801789,  3509674153,
            3977153945, 185662179,  536505093,  2727322952, 3980498348, 2529622213, 1903052964,
            3564714651, 2281240568, 533384122,  277613480,  1815540358, 282763841,  3669112623,
            2572859425, 195220178,  1210883545, 2359703600, 1187537824, 675732974,  325036095,
            708091465,  2556854604, 701006284,  2378459191, 1863513103, 2690918197, 4237307694,
            1356483501, 2160905652, 521809106,  974368613,  3136010957, 2722488678, 3711515637,
            2296341459, 4233729945, 1196247571, 3031398071, 515543502,  1314129776, 3235373306,
            1303165859, 1820568009, 559099351,  186876368,  1076102111, 1218809551, 1790301111,
            4130210229, 768125358,  1132864749, 4262563773, 2294411020, 4092943985, 2558108246,
            3737664949, 2219923393, 724326159,  4134105682, 4188752746, 3615233671, 1526018731,
            2281637916, 2459490295, 3637342666, 777862587,  39962002,   3772005832, 997473319,
            574843584,  3356551974, 1265234427, 1698059437, 534747571,  1465532164, 3263029035,
            534512444,  2343092827, 2375685652, 2497926141, 2377933621, 2212335180, 261114084,
            172755755,  2737085495, 2225257145, 148605658,  1353911796, 357753009,  1778732943,
            497635558,  4136467976, 2837964962, 4045039047, 2485296762, 1587587183, 4042904168,
            3184240963, 2393293696, 915444966,  2299938515, 3351580749, 506575598,  1541916825,
            3465300401, 525927458,  681152801,  331660975,  3624685846, 2994172100, 3274369082,
            3638287602, 815689760,  1710961092, 2775607076, 2175058103, 3252688367, 2936890483,
            2746319120, 2736754,    1646031035, 2448701214, 2886833213, 3689830606, 3292798106,
            300773646,  3125160783, 1247453205, 2746275624, 4011063775, 904135764,  876847374,
            366267234,  2541269205, 131376648,  1805948133, 3383589530, 2350119829, 2513170439,
            4096158499, 4229211520, 2992048272, 1338522080, 1187391335, 2898563453, 2163088451,
            1417971677, 2047421551, 902282791,  1143943232, 3568431811, 4059861993, 193362198,
            2509297125, 3968551582, 2175686117, 3568936881, 1853177468, 2134063169, 2919389416,
            1124914545, 1209806738,
        },
        {
            1199972651, 1035834631, 3177798370, 860834162,  3741677748, 3780327829, 1693730265,
            1643429511, 559568669,  2758650294, 647308222,  3901603996, 1778653821, 3618523672,
            2154201067, 4261179460, 3285764480, 3334002738, 3215795953, 91368462,   1883994950,
            1506873376, 1527780962, 4046354597, 4081676034, 2389066602, 1574939945, 427845396,
            2714836263, 1259019491, 2493238133, 2584034689, 3151382431, 2171033919, 176883719,
            2031844862, 1272380790, 1298975901, 4087222847, 1524000054, 311436877,  3627785554,
            1889491722, 2938069193, 2771940687, 2756955968, 4289348777, 263514583,  887207028,
            3522902525, 2273246349, 835377715,  2897243319, 204645450,  1775911983, 639470242,
            2856296318, 3032942383, 2845501282, 1979082575, 202834023,  1876303820, 1434703409,
            4240524132, 848853780,  4188621628, 928095314,  876412914,  3446576392, 3235688990,
            4021419931, 2483628986, 3155781890, 399997246,  1642535200, 3872575068, 1577956550,
            3606228634, 609914462,  653194726,  4048067248, 2500767965, 1125167825, 3707628088,
            1819135158, 1875618971, 3865851141, 328215079,  1695889194, 2040280471, 3384684457,
            2540504961, 293050253,  525570078,  2655676443, 1392199429, 3370444585, 1937915855,
            2229636250, 247937142,  2534538765, 365841057,  2449431033, 2456532429, 101910696,
            1247069485, 1523958293, 2473285670, 473709728,  3026667113, 2071968844, 324025193,
            423064436,  3870800061, 3977393138, 3632553233, 352757977,  1584833348, 3173248650,
            1159857686, 1501841977, 1751860798, 617281070,  1958012761, 4031667102, 3232142321,
            3087428595, 2380824676, 1194087757, 1542961747, 4163350364, 1721646249, 1672791861,
            2900511710, 24973500,   1705444176, 713642505,  3017719513, 2090715200, 3521434070,
            37117223,   1948295454, 3055840561, 3476120789, 3994249388, 527899063,  4285770666,
            1075524023, 2594223535, 392943522,  171012646,  3515750082, 3414659054, 3501852926,
            1493283737, 2662104279, 2033464928, 90134967,   363058647,  3289266998, 2470752727,
            1199972651, 1035834631, 3177798370, 860834162,  1791097822, 3780327829, 1693730265,
            1643429511, 559568669,  3503319486, 647308222,  3901603996, 1778653821, 3618523672,
            4294594427, 4261179460, 3285764480, 3334002738, 3215795953, 212518363,  1883994950,
            1506873376, 1527780962, 4046354597, 2398655600, 2389066602, 1574939945, 427845396,
            2714836263, 2744363872, 2493238133, 2584034689, 3151382431, 2171033919, 2787053497,
            2031844862, 1272380790, 1298975901, 4087222847, 2342953154, 311436877,  3627785554,
            1889491722, 2938069193, 2026656505, 2756955968, 4289348777, 263514583,  887207028,
            2097276163, 2273246349, 835377715,  2897243319, 204645450,  4233399907, 639470242,
            2856296318, 3032942383, 2845501282, 28260330,   202834023,  1876303820, 1434703409,
            4240524132, 2455670466, 4188621628, 928095314,  876412914,  3446576392, 117581687,
            4021419931, 2483628986, 3155781890, 399997246,  4254101087, 3872575068, 1577956550,
            3606228634, 609914462,  4003279048, 4048067248, 2500767965, 1125167825, 3707628088,
            922020515,  1875618971, 3865851141, 328215079,  1695889194, 625773097,  3384684457,
            2540504961, 293050253,  525570078,  2592805114, 1392199429, 3370444585, 1937915855,
            2229636250, 3190958614, 2534538765, 365841057,  2449431033, 2456532429, 3778669305,
            1247069485, 1523958293, 2473285670, 473709728,  720895889,  2071968844, 324025193,
            423064436,  3870800061, 3535536111, 3632553233, 352757977,  1584833348, 3173248650,
            2649344603, 1501841977, 1751860798, 617281070,  1958012761, 778965559,  3232142321,
            3087428595, 2380824676, 1194087757, 3880222002, 4163350364, 1721646249, 1672791861,
            2900511710, 702936770,  1705444176, 713642505,  3017719513, 2090715200, 1477858694,
            37117223,   1948295454, 3055840561, 3476120789, 464173532,  527899063,  4285770666,
            1075524023, 2594223535, 2872629966, 171012646,  3515750082, 3414659054, 3501852926,
            1631555059, 2662104279, 2033464928, 90134967,   363058647,  4112991722, 2470752727,
            1199972651, 1035834631, 3177798370, 4152098951, 1791097822, 3780327829, 1693730265,
            1643429511, 153020604,  3503319486, 647308222,  3901603996, 1778653821, 221887019,
            4294594427, 4261179460, 3285764480, 3334002738, 3340918862, 212518363,  1883994950,
            1506873376, 1527780962, 430180116,  2398655600, 2389066602, 1574939945, 427845396,
            1683639957, 2744363872, 2493238133, 2584034689, 3151382431, 752704472,  2787053497,
            2031844862, 1272380790, 1298975901, 1528220628, 2342953154, 311436877,  3627785554,
            1889491722, 2576495467, 2026656505, 2756955968, 4289348777, 263514583,  3778019638,
            2097276163, 2273246349, 835377715,  2897243319, 1060067446, 4233399907, 639470242,
            2856296318, 3032942383, 2351047932, 28260330,   202834023,  1876303820, 1434703409,
            3094305336, 2455670466, 4188621628, 928095314,  876412914,  3785385583, 117581687,
            4021419931, 2483628986, 3155781890, 1867816730, 4254101087, 3872575068, 1577956550,
            3606228634, 3081878598, 4003279048, 4048067248, 2500767965, 1125167825, 928465955,
            922020515,  1875618971, 3865851141, 328215079,  173810260,  625773097,  3384684457,
            2540504961, 293050253,  2645143254, 2592805114, 1392199429, 3370444585, 1937915855,
            162781360,  3190958614, 2534538765, 365841057,  2449431033, 3105377832, 3778669305,
            1247069485, 1523958293, 2473285670, 800971948,  720895889,  2071968844, 324025193,
            423064436,  52577992,   3535536111, 3632553233, 352757977,  1584833348, 3305908059,
            2649344603, 1501841977, 1751860798, 617281070,  264880505,  778965559,  3232142321,
            3087428595, 2380824676, 1127761012, 3880222002, 4163350364, 1721646249, 1672791861,
            2368512339, 702936770,  1705444176, 713642505,  3017719513, 197200752,  1477858694,
            37117223,   1948295454, 3055840561, 1588372042, 464173532,  527899063,  4285770666,
            1075524023, 2124039914, 2872629966, 171012646,  3515750082, 3414659054, 818571456,
            1631555059, 2662104279, 2033464928, 90134967,   952712086,  4112991722, 2470752727,
            1199972651, 1035834631, 888975816,  4152098951, 1791097822, 3780327829, 1693730265,
            3406785510, 153020604,  3503319486, 647308222,  3901603996, 3753248472, 221887019,
            4294594427, 4261179460, 3285764480, 1861431346, 3340918862, 212518363,  1883994950,
            1506873376, 2695939612, 430180116,  2398655600, 2389066602, 1574939945, 2852159074,
            1683639957, 2744363872, 2493238133, 2584034689, 1952065633, 752704472,  2787053497,
            2031844862, 1272380790, 3530505866, 1528220628, 2342953154, 311436877,  3627785554,
            3410473245, 2576495467, 2026656505, 2756955968, 4289348777, 2856163034, 3778019638,
            2097276163, 2273246349, 835377715,  3127280755, 1060067446, 4233399907, 639470242,
            2856296318, 2615775011, 2351047932, 28260330,   202834023,  1876303820, 619308202,
            3094305336, 2455670466, 4188621628, 928095314,  3764894047, 3785385583, 117581687,
            4021419931, 2483628986, 3759839215, 1867816730, 4254101087, 3872575068, 1577956550,
            1687107439, 3081878598, 4003279048, 4048067248, 2500767965, 2804044146, 928465955,
            922020515,  1875618971, 3865851141, 2359176389, 173810260,  625773097,  3384684457,
            2540504961, 3665420733, 2645143254, 2592805114, 1392199429, 3370444585, 1604709429,
            162781360,  3190958614, 2534538765, 365841057,  3843585067, 3105377832, 3778669305,
            1247069485, 1523958293, 293374051,  800971948,  720895889,  2071968844, 324025193,
            3342361801, 52577992,   3535536111, 3632553233, 352757977,  1386594581, 3305908059,
            2649344603, 1501841977, 1751860798, 3160423601, 264880505,  778965559,  3232142321,
            3087428595, 3814775120, 1127761012, 3880222002, 4163350364, 1721646249, 3640773034,
            2368512339, 702936770,  1705444176, 713642505,  1717761787, 197200752,  1477858694,
            37117223,   1948295454, 896215772,  1588372042, 464173532,  527899063,  4285770666,
            3441409029, 2124039914, 2872629966, 171012646,  3515750082, 2216687886, 818571456,
            1631555059, 2662104279, 2033464928, 369438400,  329003658,  1503365029, 4215790910,
            3264377550, 733526983,  2935318632, 1792331479, 608347530,  392723097,  1330445854,
            3473004271, 1267636682, 2150566972, 2664910943, 2591861637, 409769584,  2943326880,
            3746302819, 3162268832, 1028663260, 3206607045, 832105292,  2119405275, 538318455,
            2981192295, 861775416,  609718403,  3531204230, 1904759571, 1262633751, 2375133081,
            460454984,  946700253,  3763898311, 1571175213, 3124410107, 2413420216, 2664177543,
            3241803820, 3968067371, 1234860999, 1130471500, 772727786,  247203117,  576455235,
            246297007,  2027348597, 764933887,  3812479771, 1825807084, 4072281412, 2156865781,
            1286484847, 1966749063, 2479269303, 423506843,  3070938758, 653091413,  2267423132,
            2004263526, 1374490719, 3871990628, 841138314,  1260317857, 3887432433, 4025147569,
            764233331,  1794763428, 3005903468, 877926770,  2466593927, 2971729561, 3203070565,
            4198500026, 815665759,  2434508139, 1840456368, 2279000427, 17077200,   3178380570,
            990304199,  3578008580, 1965763660, 1640352477, 750159594,  2047409402, 3576308245,
            544920564,  1730124869, 1194761386, 3280315505, 147334027,  2870674244, 2076860776,
            1100947675, 2482772161, 401966468,  1610650855, 193868446,  3808157106, 1509130117,
            1324484736, 3852893217, 1059179497, 4053543778, 2557844172, 3282312002, 682550058,
            4281899173, 137171998,  3239159214, 2258610918, 426724741,  3502660993, 135977383,
            429929363,  3984458137, 964026748,  2182019070, 3836562946, 515026869,  359030455,
            1301694917, 2300414803, 2364654981, 3804876710, 171119249,  2646785698, 4283509387,
            3628087763, 1748227044, 3037141234, 3000413256, 23007314,   3598880509, 4160517314,
            112205578,  1677675411, 734881643,  2830770338, 3470317145, 3306806569, 2635040943,
            2671367560, 3528996498, 3878886478, 3114253828, 2721384408, 3175226991, 1393767271,
            2651623266, 3767978376, 1269699398, 1100964192, 4169085845, 2086718107, 1286251099,
            764751784,  3006878591,
        },
        {
            2565473087, 1149521056, 3529037691, 630435548,  73598765,   1467331930, 3988027050,
            2771962200, 91261543,   980989218,  2227515435, 236831608,  2872772569, 2330469327,
            1654035853, 2883791516, 4170143763, 126418114,  127789935,  2114249438, 2933346767,
            639483386,  1532399845, 2182422151, 741069317,  2376371063, 3398508789, 3828295651,
            3963199356, 4156483769, 4206759111, 1266176088, 3210273687, 432131993,  667709537,
            874477513,  2304714957, 629309008,  116453438,  3051811727, 3490241985, 3355968243,
            2304043871, 2724990029, 1095724699, 2408437363, 1433161037, 3245468546, 2494529842,
            4204170637, 1966342448, 3092333073, 1861880941, 3990012367, 3710334908, 2526395471,
            1884691351, 2145882162, 2561288457, 2253122309, 1154858044, 1643256991, 3172857504,
            1096492713, 2848827103, 799826424,  3094672168, 3535834360, 4213256737, 1131757994,
            520495112,  575315345,  3823364867, 2424349582, 3604795017, 310789314,  4207205257,
            553462404,  2918228443, 2568360580, 3863565851, 874197736,  3329267685, 1186352580,
            3928193054, 1780200631, 4088289456, 3323217870, 2758854947, 3111637417, 990374143,
            2080149357, 4047813631, 2019887940, 578660736,  2145680301, 2328411541, 1572704242,
            405739686,  1869350271, 2046317220, 4021497634, 1385163990, 1935250885, 1132987169,
            581690993,  3172043012, 628071512,  2851125739, 2735324847, 2847267504, 3408334906,
            3352976111, 706277272,  2971786942, 2811957324, 3578703606, 1126685543, 2671169997,
            31952251,   2802110464, 2391618856, 3031260674, 1165714541, 2411388800, 2825634835,
            101928462,  477629709,  4257022506, 3281706767, 2576087732, 736533968,  2543083137,
            3430523686, 3272172013, 3056925798, 341993500,  406782950,  1770032304, 125786076,
            1321359723, 2901696227, 1890958265, 3610842776, 1772227311, 1564088598, 914173231,
            3734092059, 1652333721, 2386645282, 329706426,  1022239203, 1832393502, 4064995802,
            3497852986, 1046436763, 366391010,  2237068647, 2887356463, 304718827,  3969799795,
            2565473087, 1149521056, 3529037691, 630435548,  3758124054, 1467331930, 3988027050,
            2771962200, 91261543,   836545831,  2227515435, 236831608,  2872772569, 2330469327,
            3439193753, 2883791516, 4170143763, 126418114,  127789935,  1648940583, 2933346767,
            639483386,  1532399845, 2182422151, 2470139222, 2376371063, 3398508789, 3828295651,
            3963199356, 2997263135, 4206759111, 1266176088, 3210273687, 432131993,  2416600665,
            874477513,  2304714957, 629309008,  116453438,  2586542760, 3490241985, 3355968243,
            2304043871, 2724990029, 452934545,  2408437363, 1433161037, 3245468546, 2494529842,
            2244403710, 1966342448, 3092333073, 1861880941, 3990012367, 2774994234, 2526395471,
            1884691351, 2145882162, 2561288457, 2303702146, 1154858044, 1643256991, 3172857504,
            1096492713, 130979316,  799826424,  3094672168, 3535834360, 4213256737, 935499492,
            520495112,  575315345,  3823364867, 2424349582, 2272973265, 310789314,  4207205257,
            553462404,  2918228443, 2613016888, 3863565851, 874197736,  3329267685, 1186352580,
            4106984978, 1780200631, 4088289456, 3323217870, 2758854947, 1559861146, 990374143,
            2080149357, 4047813631, 2019887940, 1133329900, 2145680301, 2328411541, 1572704242,
            405739686,  63633520,   2046317220, 4021497634, 1385163990, 1935250885, 1762959503,
            581690993,  3172043012, 628071512,  2851125739, 3726073981, 2847267504, 3408334906,
            3352976111, 706277272,  3817450114, 2811957324, 3578703606, 1126685543, 2671169997,
            2749086326, 2802110464, 2391618856, 3031260674, 1165714541, 2210258428, 2825634835,
            101928462,  477629709,  4257022506, 2679409844, 2576087732, 736533968,  2543083137,
            3430523686, 1122549807, 3056925798, 341993500,  406782950,  1770032304, 2617760292,
            1321359723, 2901696227, 1890958265, 3610842776, 2666109620, 1564088598, 914173231,
            3734092059, 1652333721, 3456779008, 329706426,  1022239203, 1832393502, 4064995802,
            4006865520, 1046436763, 366391010,  2237068647, 2887356463, 1479646555, 3969799795,
            2565473087, 1149521056, 3529037691, 2379195579, 3758124054, 1467331930, 3988027050,
            2771962200, 1796797949, 836545831,  2227515435, 236831608,  2872772569, 544017308,
            3439193753, 2883791516, 4170143763, 126418114,  3811390247, 1648940583, 2933346767,
            639483386,  1532399845, 4165970043, 2470139222, 2376371063, 3398508789, 3828295651,
            4066952157, 2997263135, 4206759111, 1266176088, 3210273687, 560560354,  2416600665,
            874477513,  2304714957, 629309008,  2010844440, 2586542760, 3490241985, 3355968243,
            2304043871, 855615381,  452934545,  2408437363, 1433161037, 3245468546, 3813880871,
            2244403710, 1966342448, 3092333073, 1861880941, 3334256651, 2774994234, 2526395471,
            1884691351, 2145882162, 3500193798, 2303702146, 1154858044, 1643256991, 3172857504,
            3480843206, 130979316,  799826424,  3094672168, 3535834360, 915442396,  935499492,
            520495112,  575315345,  3823364867, 2876158574, 2272973265, 310789314,  4207205257,
            553462404,  2184663001, 2613016888, 3863565851, 874197736,  3329267685, 3447734684,
            4106984978, 1780200631, 4088289456, 3323217870, 2748493470, 1559861146, 990374143,
            2080149357, 4047813631, 2728282767, 1133329900, 2145680301, 2328411541, 1572704242,
            3396987326, 63633520,   2046317220, 4021497634, 1385163990, 1582181054, 1762959503,
            581690993,  3172043012, 628071512,  2790170929, 3726073981, 2847267504, 3408334906,
            3352976111, 1211075015, 3817450114, 2811957324, 3578703606, 1126685543, 1946225412,
            2749086326, 2802110464, 2391618856, 3031260674, 453222948,  2210258428, 2825634835,
            101928462,  477629709,  410621659,  2679409844, 2576087732, 736533968,  2543083137,
            1101977922, 1122549807, 3056925798, 341993500,  406782950,  3057489804, 2617760292,
            1321359723, 2901696227, 1890958265, 4035843698, 2666109620, 1564088598, 914173231,
            3734092059, 908525903,  3456779008, 329706426,  1022239203, 1832393502, 4024857205,
            4006865520, 1046436763, 366391010,  2237068647, 1564059380, 1479646555, 3969799795,
            2565473087, 1149521056, 2808155917, 2379195579, 3758124054, 1467331930, 3988027050,
            810008243,  1796797949, 836545831,  2227515435, 236831608,  608273331,  544017308,
            3439193753, 2883791516, 4170143763, 3309288977, 3811390247, 1648940583, 2933346767,
            639483386,  1685761277, 4165970043, 2470139222, 2376371063, 3398508789, 4275493636,
            4066952157, 2997263135, 4206759111, 1266176088, 333592630,  560560354,  2416600665,
            874477513,  2304714957, 1438974661, 2010844440, 2586542760, 3490241985, 3355968243,
            2556368068, 855615381,  452934545,  2408437363, 1433161037, 4061232080, 3813880871,
            2244403710, 1966342448, 3092333073, 3412770364, 3334256651, 2774994234, 2526395471,
            1884691351, 1414627588, 3500193798, 2303702146, 1154858044, 1643256991, 2245958719,
            3480843206, 130979316,  799826424,  3094672168, 2214560871, 915442396,  935499492,
            520495112,  575315345,  3894763683, 2876158574, 2272973265, 310789314,  4207205257,
            3203740771, 2184663001, 2613016888, 3863565851, 874197736,  3371653768, 3447734684,
            4106984978, 1780200631, 4088289456, 378312754,  2748493470, 1559861146, 990374143,
            2080149357, 554816113,  2728282767, 1133329900, 2145680301, 2328411541, 4249979994,
            3396987326, 63633520,   2046317220, 4021497634, 4185731269, 1582181054, 1762959503,
            581690993,  3172043012, 3142596028, 2790170929, 3726073981, 2847267504, 3408334906,
            2556911142, 1211075015, 3817450114, 2811957324, 3578703606, 1480672978, 1946225412,
            2749086326, 2802110464, 2391618856, 3986823297, 453222948,  2210258428, 2825634835,
            101928462,  26373721,   410621659,  2679409844, 2576087732, 736533968,  888001208,
            1101977922, 1122549807, 3056925798, 341993500,  3243663736, 3057489804, 2617760292,
            1321359723, 2901696227, 1652018736, 4035843698, 2666109620, 1564088598, 914173231,
            1857869366, 908525903,  3456779008, 329706426,  1022239203, 2622178179, 4024857205,
            4006865520, 1046436763, 366391010,  3722250905, 2880126367, 4102186560, 1642831571,
            2222486636, 2572764729, 2046028516, 3507603612, 1703451134, 89818497,   1961701523,
            3704300476, 3563143931, 1609575644, 1599081111, 1047838539, 2779312926, 2065354728,
            956677756,  2073145924, 726634994,  119064196,  2046275296, 2105141632, 1023267361,
            1204528080, 623740611,  1419328884, 933734693,  2030900835, 2556538268, 1672647866,
            3125658368, 2221217376, 1097330641, 3214790630, 4276041578, 2397216525, 3916900004,
            330223096,  3915966823, 2646760259, 1724289351, 4015221358, 2338587000, 110922222,
            2314933196, 4026908935, 3272487985, 2685115305, 84271650,   731354215,  2358136447,
            1069348214, 2676811333, 1386266810, 1364512901, 4154449904, 3469122709, 54276972,
            560967905,  2363475740, 331250049,  3024074455, 186605617,  389582566,  1258386782,
            703909543,  3968367083, 1553533794, 3699576213, 1145761343, 921983735,  3573813763,
            1280477631, 3365842435, 1618458494, 2621328991, 1534006198, 2307669227, 4192335609,
            1338050203, 785284052,  4227164890, 2874735332, 3655821191, 2911684671, 3266454200,
            2679968625, 1191162601, 456550349,  1143881236, 3560103440, 2253437876, 3683014001,
            1087142366, 1462192975, 1076595768, 3227872159, 1842092988, 148227073,  3812110998,
            1317300278, 3068446245, 3376284001, 3164402992, 2730404635, 2848239579, 3008959791,
            2901849226, 1234485739, 869158554,  245101118,  1724974650, 3851803199, 922411232,
            3046280696, 3284392523, 3528264590, 2802364078, 381450957,  1741009694, 4222244451,
            102929888,  1668474417, 3881791214, 1429483134, 1938365051, 1023690708, 3333855520,
            3238705869, 2602245525, 3059586169, 720438965,  2120786297, 453980990,  1048501876,
            4060576583, 3537810796, 3892882814, 691572481,  3899584121, 1582529013, 3260326865,
            2358704826, 1607030801, 1035900449, 3442507859, 1406737127, 249758705,  1535363329,
            893329207,  51912312,   3440532856, 3736385218, 295452658,  2379709553, 1647382020,
            2363679860, 2998779887,
        },
        {
            4209102573, 2387104994, 1221484586, 1726143957, 3263877318, 3362559187, 282442925,
            2418524976, 3196072648, 3174695999, 2072047145, 2985823503, 2132951745, 2298545297,
            2495977670, 1397656146, 2086257884, 3834366725, 3862532368, 3583329522, 1543996818,
            2192688115, 3081427696, 2656520743, 8772004,    2476324234, 3600148050, 1168683794,
            3219143568, 108768238,  1339513738, 447593731,  2742877256, 2488536667, 4189834432,
            808657962,  2422880287, 390864786,  3381554683, 760628048,  353395922,  3577556262,
            2482413928, 507756643,  839344953,  3505184848, 3945044582, 2414915836, 2313624497,
            1832728088, 2036999647, 1369090013, 3264575895, 1096327239, 3483440128, 3999302048,
            2761563885, 2882627112, 3126073009, 1749658776, 3152482044, 3040022505, 3249451214,
            2933713956, 2861715096, 1314806730, 932941454,  4276317539, 343449784,  1913556027,
            1493892363, 2539517630, 2046391233, 3046108187, 28742917,   4009448584, 530945117,
            3165875131, 1018448712, 110256395,  3550192264, 1279873435, 2276349621, 517650895,
            1957973772, 619869608,  4260458157, 2281748739, 2489253174, 2220997989, 3787481606,
            508630251,  3761850170, 3992979014, 2298047038, 3506428315, 1279341556, 3293496518,
            1313470495, 1021100687, 3113171268, 798494760,  2981622008, 4152623583, 576409629,
            2312811213, 992326282,  261645450,  1818084365, 3357150904, 144093,     1937589359,
            2016990596, 4273422066, 588267732,  3592151118, 3846596932, 1198111464, 944363907,
            1288613766, 1707163456, 4020906747, 1161127694, 2303844076, 2632591611, 3877442490,
            2453788473, 1725876694, 1193989740, 2650581453, 1937459187, 361099994,  3566745727,
            3658112707, 3612317412, 2684702277, 2880928862, 2044313931, 1866044828, 3528429465,
            130421713,  2658878825, 1566180833, 1572228417, 531947625,  3774861000, 1894712110,
            1319199233, 865634052,  2602102379, 3389730171, 3878969250, 107983959,  1601930856,
            2511728925, 2146946013, 497511195,  720616881,  699892123,  2404505137, 2656498433,
            4209102573, 2387104994, 1221484586, 1726143957, 1267363185, 3362559187, 282442925,
            2418524976, 3196072648, 2942944206, 2072047145, 2985823503, 2132951745, 2298545297,
            4079341490, 1397656146, 2086257884, 3834366725, 3862532368, 3991197972, 1543996818,
            2192688115, 3081427696, 2656520743, 825853576,  2476324234, 3600148050, 1168683794,
            3219143568, 528751585,  1339513738, 447593731,  2742877256, 2488536667, 4025362081,
            808657962,  2422880287, 390864786,  3381554683, 2682225618, 353395922,  3577556262,
            2482413928, 507756643,  3979211244, 3505184848, 3945044582, 2414915836, 2313624497,
            1841224078, 2036999647, 1369090013, 3264575895, 1096327239, 607843308,  3999302048,
            2761563885, 2882627112, 3126073009, 1241524975, 3152482044, 3040022505, 3249451214,
            2933713956, 420486142,  1314806730, 932941454,  4276317539, 343449784,  2231505736,
            1493892363, 2539517630, 2046391233, 3046108187, 2351652097, 4009448584, 530945117,
            3165875131, 1018448712, 1683392491, 3550192264, 1279873435, 2276349621, 517650895,
            4036312766, 619869608,  4260458157, 2281748739, 2489253174, 1686790154, 3787481606,
            508630251,  3761850170, 3992979014, 1745325013, 3506428315, 1279341556, 3293496518,
            1313470495, 3066312306, 3113171268, 798494760,  2981622008, 4152623583, 3871822467,
            2312811213, 992326282,  261645450,  1818084365, 3681154045, 144093,     1937589359,
            2016990596, 4273422066, 2361898985, 3592151118, 3846596932, 1198111464, 944363907,
            2866279694, 1707163456, 4020906747, 1161127694, 2303844076, 3044280908, 3877442490,
            2453788473, 1725876694, 1193989740, 2049617934, 1937459187, 361099994,  3566745727,
            3658112707, 934740227,  2684702277, 2880928862, 2044313931, 1866044828, 1814569183,
            130421713,  2658878825, 1566180833, 1572228417, 1784679035, 3774861000, 1894712110,
            1319199233, 865634052,  283642947,  3389730171, 3878969250, 107983959,  1601930856,
            3698217362, 2146946013, 497511195,  720616881,  699892123,  2117385156, 2656498433,
            4209102573, 2387104994, 1221484586, 3495886368, 1267363185, 3362559187, 282442925,
            2418524976, 3489510655, 2942944206, 2072047145, 2985823503, 2132951745, 885541635,
            4079341490, 1397656146, 2086257884, 3834366725, 1049969755, 3991197972, 1543996818,
            2192688115, 3081427696, 2141948440, 825853576,  2476324234, 3600148050, 1168683794,
            5160254,    528751585,  1339513738, 447593731,  2742877256, 3033397497, 4025362081,
            808657962,  2422880287, 390864786,  3191593886, 2682225618, 353395922,  3577556262,
            2482413928, 1185107868, 3979211244, 3505184848, 3945044582, 2414915836, 3030493909,
            1841224078, 2036999647, 1369090013, 3264575895, 3054343366, 607843308,  3999302048,
            2761563885, 2882627112, 3912854189, 1241524975, 3152482044, 3040022505, 3249451214,
            55140065,   420486142,  1314806730, 932941454,  4276317539, 1055315026, 2231505736,
            1493892363, 2539517630, 2046391233, 4174985470, 2351652097, 4009448584, 530945117,
            3165875131, 2168411768, 1683392491, 3550192264, 1279873435, 2276349621, 1875092822,
            4036312766, 619869608,  4260458157, 2281748739, 98823023,   1686790154, 3787481606,
            508630251,  3761850170, 2636025017, 1745325013, 3506428315, 1279341556, 3293496518,
            978338993,  3066312306, 3113171268, 798494760,  2981622008, 2712384846, 3871822467,
            2312811213, 992326282,  261645450,  66982935,   3681154045, 144093,     1937589359,
            2016990596, 3390191329, 2361898985, 3592151118, 3846596932, 1198111464, 1857959320,
            2866279694, 1707163456, 4020906747, 1161127694, 913091437,  3044280908, 3877442490,
            2453788473, 1725876694, 4254455215, 2049617934, 1937459187, 361099994,  3566745727,
            2914687409, 934740227,  2684702277, 2880928862, 2044313931, 1515195925, 1814569183,
            130421713,  2658878825, 1566180833, 2753417020, 1784679035, 3774861000, 1894712110,
            1319199233, 287161774,  283642947,  3389730171, 3878969250, 107983959,  3057929912,
            3698217362, 2146946013, 497511195,  720616881,  3570251850, 2117385156, 2656498433,
            4209102573, 2387104994, 2940868252, 3495886368, 1267363185, 3362559187, 282442925,
            2510419746, 3489510655, 2942944206, 2072047145, 2985823503, 978430777,  885541635,
            4079341490, 1397656146, 2086257884, 134380865,  1049969755, 3991197972, 1543996818,
            2192688115, 1205081471, 2141948440, 825853576,  2476324234, 3600148050, 228461601,
            5160254,    528751585,  1339513738, 447593731,  2852356745, 3033397497, 4025362081,
            808657962,  2422880287, 3287655095, 3191593886, 2682225618, 353395922,  3577556262,
            2542841784, 1185107868, 3979211244, 3505184848, 3945044582, 2905156498, 3030493909,
            1841224078, 2036999647, 1369090013, 4246605417, 3054343366, 607843308,  3999302048,
            2761563885, 3611911899, 3912854189, 1241524975, 3152482044, 3040022505, 3215633820,
            55140065,   420486142,  1314806730, 932941454,  2708752494, 1055315026, 2231505736,
            1493892363, 2539517630, 962728637,  4174985470, 2351652097, 4009448584, 530945117,
            3370859357, 2168411768, 1683392491, 3550192264, 1279873435, 3028448904, 1875092822,
            4036312766, 619869608,  4260458157, 199178828,  98823023,   1686790154, 3787481606,
            508630251,  4205010983, 2636025017, 1745325013, 3506428315, 1279341556, 683127445,
            978338993,  3066312306, 3113171268, 798494760,  2823693013, 2712384846, 3871822467,
            2312811213, 992326282,  3701928286, 66982935,   3681154045, 144093,     1937589359,
            1117717039, 3390191329, 2361898985, 3592151118, 3846596932, 1072660054, 1857959320,
            2866279694, 1707163456, 4020906747, 2503116219, 913091437,  3044280908, 3877442490,
            2453788473, 1815274499, 4254455215, 2049617934, 1937459187, 361099994,  3771108073,
            2914687409, 934740227,  2684702277, 2880928862, 3591322975, 1515195925, 1814569183,
            130421713,  2658878825, 354587729,  2753417020, 1784679035, 3774861000, 1894712110,
            1799044969, 287161774,  283642947,  3389730171, 3878969250, 1229815186, 3057929912,
            3698217362, 2146946013, 497511195,  3121882901, 426537369,  3852284416, 4050544256,
            3148944089, 878474231,  1369575859, 2206199765, 870626886,  494668165,  613011290,
            3246772867, 1040178461, 2396959353, 2105449571, 456758967,  4134137960, 3525051481,
            3633445497, 2895048060, 2008411846, 2194012253, 2326112129, 2956901044, 2297039362,
            3400824024, 42139718,   4212208866, 3874761488, 2361955811, 1890446075, 864533345,
            474524842,  2283847731, 283971243,  3607219686, 280870706,  4188549522, 659660119,
            2460943922, 4252134362, 922033031,  3615474721, 1691563300, 3002653770, 2414043617,
            2251931324, 752654714,  4188343161, 305594960,  1320443323, 797027061,  2347530104,
            3608843538, 2717312892, 1841295453, 1574467161, 823626340,  2244853583, 2648217758,
            141742826,  1605436472, 745763543,  3275460028, 3166960370, 2655678693, 3964037210,
            945054703,  998173049,  1014527437, 3424443612, 281835352,  826817508,  260462513,
            2849967970, 3447294061, 3670173947, 2430650055, 4134905457, 3798172627, 2156572681,
            2600148034, 2773013892, 3290397106, 1740507705, 3450254627, 3613087060, 440045928,
            1230555006, 980805434,  2107958250, 526555374,  3150741277, 4283672024, 193019043,
            786035243,  3002832578, 3938336183, 4209865002, 1005950967, 3533346582, 3196886974,
            83962845,   1882902787, 3595687446, 2927597311, 2728550762, 2750900392, 1474254316,
            1509832112, 1763262792, 2706181276, 538294991,  353565565,  18133995,   1719731406,
            3311085516, 2018821960, 300367686,  2628312935, 1151449661, 2178805970, 3288321196,
            535051857,  1623270973, 2761151808, 2701048972, 317681607,  2281427601, 719748170,
            351452298,  2191958596, 4000232015, 335837771,  4158081521, 3779404077, 1998444133,
            3849605095, 1532231791, 2930266419, 4203951289, 748423654,  1993082867, 451159852,
            488781053,  2438982775, 2222815270, 543209242,  1241562465, 2868868009, 4201052877,
            2438841764, 2151708682, 2426958921, 1520654642, 1990098337, 1070792755, 2308394635,
            1442389785, 705615044,
        },
        {
            973368008,  1221885324, 2086331970, 2323744198, 280145759,  1795442656, 2984366093,
            3532172763, 323888669,  851950179,  4198638255, 899943985,  4087912561, 2935341503,
            1443752852, 3991058999, 3547259355, 35779889,   1076308344, 4075444807, 186174448,
            3542284780, 660388677,  2777400132, 1092226205, 2418702276, 1307933032, 1940510003,
            1932005362, 4016036211, 387339882,  2969593895, 3453134349, 1382709098, 1795814140,
            1588159469, 1216733801, 2227378121, 2063027627, 582454582,  3364657275, 3466973302,
            484564303,  1489261596, 2270291560, 2008178784, 2284268924, 2229317366, 644797709,
            1213921542, 99331403,   3027640949, 1137722852, 2991506109, 1432805987, 931795812,
            1075567424, 28963219,   1462245461, 3781444706, 521233400,  1891915904, 3774338085,
            1635359313, 2356111795, 4121073768, 1045110727, 2822507066, 1087914587, 3744509525,
            911370656,  181884066,  1944539735, 290356444,  3598887471, 4236934380, 3224468239,
            457546246,  4119337570, 37700432,   655783844,  1423101410, 1693002969, 3287768267,
            928748421,  4074128009, 3081088543, 2882833790, 3180154875, 1094657682, 2388253717,
            4173455215, 794709427,  3363292346, 67786868,   3786597763, 380587236,  2345941620,
            560232318,  2137123833, 619747082,  1050293267, 2537845069, 1407302835, 433399526,
            1083185007, 1893842085, 3711748584, 4225838280, 3863317129, 2043467942, 2799650657,
            3590486611, 1231938950, 215905995,  155811669,  806806587,  2732631168, 1621659281,
            632403616,  401165422,  2661074778, 4156963191, 3691812937, 3767271627, 2834948318,
            2877210497, 2420260153, 733172233,  1771708940, 3102718549, 2468707423, 1857088312,
            3176535032, 1908570295, 3966666208, 605079895,  2982506620, 3721694730, 1640691570,
            3764975545, 3257514114, 1826578604, 1358557411, 4049610348, 615820785,  3355718142,
            1734641780, 2958744617, 274522187,  3198436002, 4077346785, 2890101344, 4012464346,
            1288365365, 96583076,   2656389382, 1858181040, 2717010340, 2032153178, 349324012,
            973368008,  1221885324, 2086331970, 2323744198, 253685576,  1795442656, 2984366093,
            3532172763, 323888669,  248935329,  4198638255, 899943985,  4087912561, 2935341503,
            3213394756, 3991058999, 3547259355, 35779889,   1076308344, 1987715385, 186174448,
            3542284780, 660388677,  2777400132, 2071022105, 2418702276, 1307933032, 1940510003,
            1932005362, 144370664,  387339882,  2969593895, 3453134349, 1382709098, 2394736611,
            1588159469, 1216733801, 2227378121, 2063027627, 4064263898, 3364657275, 3466973302,
            484564303,  1489261596, 3405101812, 2008178784, 2284268924, 2229317366, 644797709,
            2560273821, 99331403,   3027640949, 1137722852, 2991506109, 1446442417, 931795812,
            1075567424, 28963219,   1462245461, 1201513613, 521233400,  1891915904, 3774338085,
            1635359313, 2815447944, 4121073768, 1045110727, 2822507066, 1087914587, 2485035329,
            911370656,  181884066,  1944539735, 290356444,  2078819341, 4236934380, 3224468239,
            457546246,  4119337570, 2666895496, 655783844,  1423101410, 1693002969, 3287768267,
            3595439673, 4074128009, 3081088543, 2882833790, 3180154875, 872453917,  2388253717,
            4173455215, 794709427,  3363292346, 4188764388, 3786597763, 380587236,  2345941620,
            560232318,  625538006,  619747082,  1050293267, 2537845069, 1407302835, 2128289331,
            1083185007, 1893842085, 3711748584, 4225838280, 2486133065, 2043467942, 2799650657,
            3590486611, 1231938950, 928582681,  155811669,  806806587,  2732631168, 1621659281,
            1163969880, 401165422,  2661074778, 4156963191, 3691812937, 2322579561, 2834948318,
            2877210497, 2420260153, 733172233,  170239236,  3102718549, 2468707423, 1857088312,
            3176535032, 3868693408, 3966666208, 605079895,  2982506620, 3721694730, 2066859537,
            3764975545, 3257514114, 1826578604, 1358557411, 2964604045, 615820785,  3355718142,
            1734641780, 2958744617, 4091225681, 3198436002, 4077346785, 2890101344, 4012464346,
            2612861218, 96583076,   2656389382, 1858181040, 2717010340, 3639170895, 349324012,
            973368008,  1221885324, 2086331970, 2258432445, 253685576,  1795442656, 2984366093,
            3532172763, 3831166882, 248935329,  4198638255, 899943985,  4087912561, 715173523,
            3213394756, 3991058999, 3547259355, 35779889,   2393072396, 1987715385, 186174448,
            3542284780, 660388677,  3731857267, 2071022105, 2418702276, 1307933032, 1940510003,
            4262274779, 144370664,  387339882,  2969593895, 3453134349, 1923698215, 2394736611,
            1588159469, 1216733801, 2227378121, 2907069566, 4064263898, 3364657275, 3466973302,
            484564303,  2234542580, 3405101812, 2008178784, 2284268924, 2229317366, 1349323372,
            2560273821, 99331403,   3027640949, 1137722852, 4200786664, 1446442417, 931795812,
            1075567424, 28963219,   1659632304, 1201513613, 521233400,  1891915904, 3774338085,
            763590809,  2815447944, 4121073768, 1045110727, 2822507066, 4131040734, 2485035329,
            911370656,  181884066,  1944539735, 4104473807, 2078819341, 4236934380, 3224468239,
            457546246,  1241850776, 2666895496, 655783844,  1423101410, 1693002969, 2025898966,
            3595439673, 4074128009, 3081088543, 2882833790, 218474476,  872453917,  2388253717,
            4173455215, 794709427,  250328312,  4188764388, 3786597763, 380587236,  2345941620,
            1937652040, 625538006,  619747082,  1050293267, 2537845069, 1140055765, 2128289331,
            1083185007, 1893842085, 3711748584, 2298055548, 2486133065, 2043467942, 2799650657,
            3590486611, 1235949580, 928582681,  155811669,  806806587,  2732631168, 4046198728,
            1163969880, 401165422,  2661074778, 4156963191, 2003518762, 2322579561, 2834948318,
            2877210497, 2420260153, 326741418,  170239236,  3102718549, 2468707423, 1857088312,
            3936056808, 3868693408, 3966666208, 605079895,  2982506620, 2354705582, 2066859537,
            3764975545, 3257514114, 1826578604, 3017501686, 2964604045, 615820785,  3355718142,
            1734641780, 1681548103, 4091225681, 3198436002, 4077346785, 2890101344, 416470693,
            2612861218, 96583076,   2656389382, 1858181040, 3104217288, 3639170895, 349324012,
            973368008,  1221885324, 601524567,  2258432445, 253685576,  1795442656, 2984366093,
            1875491903, 3831166882, 248935329,  4198638255, 899943985,  2182697927, 715173523,
            3213394756, 3991058999, 3547259355, 1472237612, 2393072396, 1987715385, 186174448,
            3542284780, 2160848139, 3731857267, 2071022105, 2418702276, 1307933032, 3815354311,
            4262274779, 144370664,  387339882,  2969593895, 4240850623, 1923698215, 2394736611,
            1588159469, 1216733801, 322523795,  2907069566, 4064263898, 3364657275, 3466973302,
            2920715858, 2234542580, 3405101812, 2008178784, 2284268924, 1936025139, 1349323372,
            2560273821, 99331403,   3027640949, 859541953,  4200786664, 1446442417, 931795812,
            1075567424, 1876635772, 1659632304, 1201513613, 521233400,  1891915904, 3949233865,
            763590809,  2815447944, 4121073768, 1045110727, 2522258582, 4131040734, 2485035329,
            911370656,  181884066,  2467886009, 4104473807, 2078819341, 4236934380, 3224468239,
            603014155,  1241850776, 2666895496, 655783844,  1423101410, 673119756,  2025898966,
            3595439673, 4074128009, 3081088543, 4100445818, 218474476,  872453917,  2388253717,
            4173455215, 2395519424, 250328312,  4188764388, 3786597763, 380587236,  4292608797,
            1937652040, 625538006,  619747082,  1050293267, 2989616803, 1140055765, 2128289331,
            1083185007, 1893842085, 3313934002, 2298055548, 2486133065, 2043467942, 2799650657,
            1804808801, 1235949580, 928582681,  155811669,  806806587,  2864892828, 4046198728,
            1163969880, 401165422,  2661074778, 2946769376, 2003518762, 2322579561, 2834948318,
            2877210497, 2647485275, 326741418,  170239236,  3102718549, 2468707423, 2520336801,
            3936056808, 3868693408, 3966666208, 605079895,  2949706551, 2354705582, 2066859537,
            3764975545, 3257514114, 495003693,  3017501686, 2964604045, 615820785,  3355718142,
            3799230297, 1681548103, 4091225681, 3198436002, 4077346785, 258363842,  416470693,
            2612861218, 96583076,   2656389382, 2198085634, 1607235362, 694172175,  4194347563,
            2665732891, 3419430286, 597070176,  2749480905, 3937535348, 3639873850, 2050067843,
            4045290683, 2964298196, 3631595287, 1409808193, 121765438,  2129412744, 2497437101,
            2664102876, 1773441464, 1708052456, 2923764322, 3350385352, 1592204280, 1118221370,
            3416016313, 116121364,  1179473397, 1497519022, 902569114,  3840281863, 2783662797,
            1712084322, 1982884601, 3625797892, 4222938993, 3231134134, 3046745397, 446484563,
            1133869192, 2622178726, 3881085862, 4012894217, 391734322,  2089696890, 1304197030,
            2663978386, 1685998658, 4238620912, 448351665,  2724524045, 1038754164, 413586547,
            3107681687, 1454664365, 3353731192, 128440996,  565817989,  127978294,  1043863326,
            1747369107, 2772246481, 172569313,  2740699699, 3417082503, 2103702630, 2139566116,
            1378864710, 2444170529, 3234220221, 3974870858, 1965162347, 956763257,  3932467825,
            1077337271, 4084837149, 3699147465, 1882164226, 236113740,  3116302858, 2730529598,
            3449804672, 4002370655, 2011573068, 1551746089, 3917496971, 2852603,    1682999535,
            2764817908, 2489487254, 261936311,  3122421452, 1199382345, 2617247590, 1909026938,
            3156073069, 1492533764, 97847107,   1260892586, 187242945,  1286471861, 1763024967,
            127723419,  210606273,  228546401,  3249879676, 482069954,  383075106,  3263105259,
            2242748676, 1105681409, 4033144425, 4017983282, 1670425353, 4040882785, 1780687273,
            1405678015, 3076115981, 2713472488, 286336494,  3664225263, 502759060,  777620620,
            635590826,  132236203,  1866406173, 1235046453, 2859554298, 121814656,  944976320,
            1946494170, 2548097575, 415384946,  3934685646, 1507032178, 1383654007, 2906269630,
            566005756,  3118733139, 2969075870, 1834096359, 3263358416, 1322979710, 904583023,
            3582075094, 2298898632, 2491891941, 660351763,  2548592542, 3009200751, 2116595110,
            2623212287, 4167133624, 196759529,  3038645579, 1769704552, 1713233322, 2127497999,
            3849458221, 3769872265,
        },
        {
            51082211,   3347503176, 3221768777, 2986163981, 3937460013, 1716372908, 4132024211,
            3035957293, 1791036224, 4214815056, 1645540011, 2629793790, 3185505897, 1855718954,
            495459467,  1728339314, 2318396341, 3396602050, 3273624616, 2625973148, 1762905939,
            1706358553, 1088424264, 2764318930, 1026127380, 1128004134, 2724553694, 41981087,
            2304966004, 1342745986, 3425554050, 3537673465, 752263676,  280905885,  929399589,
            4090689526, 2141254732, 1469491656, 2593100469, 1096008340, 3316809312, 1698245188,
            1656427920, 3081873338, 1750515301, 3850483440, 4081834419, 1225164947, 1244139942,
            1972663124, 116832506,  3097397897, 961156503,  1899056660, 1659173175, 1890464921,
            1891872926, 191259956,  1735304734, 4246751855, 4285601625, 1495519933, 3398829761,
            997567482,  2277782972, 1286922996, 3120709698, 15569196,   191501283,  3916619528,
            1552075789, 4259725643, 2837166910, 2231584792, 1912204495, 2597304083, 4147585653,
            1021482843, 2003417305, 186794491,  3608172979, 1991038123, 97515853,   34341352,
            4163491231, 1046079304, 4105813389, 3589099183, 3970004064, 3899560802, 4148331147,
            2267137817, 85024486,   3019925981, 3069231953, 1563669137, 314080592,  2943111861,
            2838243982, 726216848,  2621853102, 2355885175, 3359668856, 1111296541, 2330283124,
            3626558972, 4290084148, 1632078,    1047440803, 1350377197, 2490578842, 2366345698,
            1628128899, 860259543,  1937956234, 2833820527, 329818923,  648489148,  1791961202,
            1652322723, 1513419073, 149629345,  2468961221, 3711837973, 2377333831, 1434755773,
            3808719305, 2513270108, 2701064683, 3097011724, 303393137,  1346302239, 1852307302,
            850106025,  2473124483, 2853497268, 3786573704, 2604101162, 1446573486, 506925220,
            3138967488, 2973528682, 2752811123, 2890321579, 1037196362, 1335670403, 1560253777,
            1437495434, 2700525242, 4259933972, 3870707795, 4141538580, 3375331039, 3081538601,
            3129978494, 3689191993, 1933431212, 2196145886, 87814045,   878611347,  812542698,
            51082211,   3347503176, 3221768777, 2986163981, 277257023,  1716372908, 4132024211,
            3035957293, 1791036224, 2713916211, 1645540011, 2629793790, 3185505897, 1855718954,
            3800150234, 1728339314, 2318396341, 3396602050, 3273624616, 2530282967, 1762905939,
            1706358553, 1088424264, 2764318930, 4224669506, 1128004134, 2724553694, 41981087,
            2304966004, 484289311,  3425554050, 3537673465, 752263676,  280905885,  657028134,
            4090689526, 2141254732, 1469491656, 2593100469, 2089385540, 3316809312, 1698245188,
            1656427920, 3081873338, 2750354264, 3850483440, 4081834419, 1225164947, 1244139942,
            3432605739, 116832506,  3097397897, 961156503,  1899056660, 2234120716, 1890464921,
            1891872926, 191259956,  1735304734, 125359575,  4285601625, 1495519933, 3398829761,
            997567482,  4034254942, 1286922996, 3120709698, 15569196,   191501283,  2090684174,
            1552075789, 4259725643, 2837166910, 2231584792, 3412758413, 2597304083, 4147585653,
            1021482843, 2003417305, 2464533361, 3608172979, 1991038123, 97515853,   34341352,
            2634732952, 1046079304, 4105813389, 3589099183, 3970004064, 4263828421, 4148331147,
            2267137817, 85024486,   3019925981, 3229477751, 1563669137, 314080592,  2943111861,
            2838243982, 1274664774, 2621853102, 2355885175, 3359668856, 1111296541, 1615234696,
            3626558972, 4290084148, 1632078,    1047440803, 623898652,  2490578842, 2366345698,
            1628128899, 860259543,  2097114662, 2833820527, 329818923,  648489148,  1791961202,
            1730000077, 1513419073, 149629345,  2468961221, 3711837973, 3255238414, 1434755773,
            3808719305, 2513270108, 2701064683, 1635042488, 303393137,  1346302239, 1852307302,
            850106025,  3523245944, 2853497268, 3786573704, 2604101162, 1446573486, 1011238489,
            3138967488, 2973528682, 2752811123, 2890321579, 1044586909, 1335670403, 1560253777,
            1437495434, 2700525242, 608940900,  3870707795, 4141538580, 3375331039, 3081538601,
            728626935,  3689191993, 1933431212, 2196145886, 87814045,   646732047,  812542698,
            51082211,   3347503176, 3221768777, 1783601443, 277257023,  1716372908, 4132024211,
            3035957293, 3363442238, 2713916211, 1645540011, 2629793790, 3185505897, 2066587565,
            3800150234, 1728339314, 2318396341, 3396602050, 2279941522, 2530282967, 1762905939,
            1706358553, 1088424264, 2989326347, 4224669506, 1128004134, 2724553694, 41981087,
            2348931916, 484289311,  3425554050, 3537673465, 752263676,  3169550883, 657028134,
            4090689526, 2141254732, 1469491656, 1152943917, 2089385540, 3316809312, 1698245188,
            1656427920, 1808689833, 2750354264, 3850483440, 4081834419, 1225164947, 2422106046,
            3432605739, 116832506,  3097397897, 961156503,  1581804167, 2234120716, 1890464921,
            1891872926, 191259956,  4113708001, 125359575,  4285601625, 1495519933, 3398829761,
            3473435310, 4034254942, 1286922996, 3120709698, 15569196,   3122200488, 2090684174,
            1552075789, 4259725643, 2837166910, 2838170407, 3412758413, 2597304083, 4147585653,
            1021482843, 954000150,  2464533361, 3608172979, 1991038123, 97515853,   3832321348,
            2634732952, 1046079304, 4105813389, 3589099183, 1288675572, 4263828421, 4148331147,
            2267137817, 85024486,   1080403742, 3229477751, 1563669137, 314080592,  2943111861,
            3357655593, 1274664774, 2621853102, 2355885175, 3359668856, 3722440291, 1615234696,
            3626558972, 4290084148, 1632078,    4263556325, 623898652,  2490578842, 2366345698,
            1628128899, 3623136669, 2097114662, 2833820527, 329818923,  648489148,  592747007,
            1730000077, 1513419073, 149629345,  2468961221, 3766709284, 3255238414, 1434755773,
            3808719305, 2513270108, 1958651003, 1635042488, 303393137,  1346302239, 1852307302,
            579487408,  3523245944, 2853497268, 3786573704, 2604101162, 4183724981, 1011238489,
            3138967488, 2973528682, 2752811123, 3074709397, 1044586909, 1335670403, 1560253777,
            1437495434, 1237099522, 608940900,  3870707795, 4141538580, 3375331039, 2032507604,
            728626935,  3689191993, 1933431212, 2196145886, 4008131891, 646732047,  812542698,
            51082211,   3347503176, 3622107037, 1783601443, 277257023,  1716372908, 4132024211,
            1264285659, 3363442238, 2713916211, 1645540011, 2629793790, 2179309595, 2066587565,
            3800150234, 1728339314, 2318396341, 580990822,  2279941522, 2530282967, 1762905939,
            1706358553, 2826056883, 2989326347, 4224669506, 1128004134, 2724553694, 1486392636,
            2348931916, 484289311,  3425554050, 3537673465, 2497657189, 3169550883, 657028134,
            4090689526, 2141254732, 1019244016, 1152943917, 2089385540, 3316809312, 1698245188,
            2921739456, 1808689833, 2750354264, 3850483440, 4081834419, 108425527,  2422106046,
            3432605739, 116832506,  3097397897, 3902994002, 1581804167, 2234120716, 1890464921,
            1891872926, 3428861050, 4113708001, 125359575,  4285601625, 1495519933, 3350053832,
            3473435310, 4034254942, 1286922996, 3120709698, 2906201347, 3122200488, 2090684174,
            1552075789, 4259725643, 1965598685, 2838170407, 3412758413, 2597304083, 4147585653,
            3335631208, 954000150,  2464533361, 3608172979, 1991038123, 3788034599, 3832321348,
            2634732952, 1046079304, 4105813389, 2362460804, 1288675572, 4263828421, 4148331147,
            2267137817, 2767331798, 1080403742, 3229477751, 1563669137, 314080592,  1737897403,
            3357655593, 1274664774, 2621853102, 2355885175, 57997639,   3722440291, 1615234696,
            3626558972, 4290084148, 3703113369, 4263556325, 623898652,  2490578842, 2366345698,
            73788443,   3623136669, 2097114662, 2833820527, 329818923,  253042650,  592747007,
            1730000077, 1513419073, 149629345,  4248302934, 3766709284, 3255238414, 1434755773,
            3808719305, 3698431827, 1958651003, 1635042488, 303393137,  1346302239, 3872433842,
            579487408,  3523245944, 2853497268, 3786573704, 3459185849, 4183724981, 1011238489,
            3138967488, 2973528682, 2605373899, 3074709397, 1044586909, 1335670403, 1560253777,
            4069724875, 1237099522, 608940900,  3870707795, 4141538580, 2550307954, 2032507604,
            728626935,  3689191993, 1933431212, 1177640824, 4168589688, 1361487780, 2649612520,
            2181448948, 2176288560, 947907377,  3772487849, 2002599877, 3353450532, 2013145251,
            2357912348, 2316997609, 2355480213, 255142205,  751273749,  4049362748, 1434168014,
            2069693747, 6910933,    1352778547, 2413649875, 4238683558, 484497407,  522555106,
            1848417180, 3001805499, 2264939603, 3606143565, 1782482647, 2955918436, 3471474379,
            2814133839, 3779337475, 3522102195, 1551792178, 3742001759, 3433504551, 472918932,
            3835854229, 4259163014, 4103952359, 1989474190, 1792448078, 1517735224, 1958036884,
            2277922531, 2856192348, 4294188732, 2674247971, 643649427,  3847742408, 1512435795,
            4236693554, 1749045838, 397093640,  2940663643, 4156440725, 188785143,  3894740830,
            897618321,  3333498692, 1623924612, 4111607062, 2242558573, 1565861815, 1177957654,
            4129621176, 2232443247, 3216995984, 3313294700, 791442469,  1782204490, 2452634246,
            1288014576, 1347365377, 112254281,  2044140398, 2479591984, 3293701920, 1062335151,
            1397230369, 2460086085, 2412349474, 1252633202, 3704541545, 2132499200, 2202058121,
            1981543691, 2683673516, 1198109770, 4279157703, 2224504258, 2188868731, 769314834,
            601313429,  3595357440, 561383123,  3444949507, 2127327734, 2865252582, 4181002098,
            2408426518, 309361635,  2377703815, 1109219406, 406287309,  1750179098, 3619129839,
            937928728,  884423945,  928407281,  4173634172, 1492070114, 2706943441, 1365883971,
            3076484301, 744370087,  4004118884, 2199449568, 879458863,  3197725005, 3590586547,
            59693002,   3614114662, 1499386564, 2914582708, 3751842429, 947438603,  1986129491,
            3747112289, 833777768,  2231649410, 1841607849, 3526253103, 3797105813, 1291185911,
            3188408549, 3311027691, 3983681758, 2246511800, 1271525377, 2996265908, 2396071405,
            902427181,  164636454,  2459631341, 635349368,  463309029,  1409367654, 849052250,
            3221786769, 2310288531, 2919204855, 1263130532, 1215722704, 3497322658, 2840687222,
            2185004161, 1507335864,
        },
        {
            2052557448, 2879065999, 22933757,   2160014758, 3736092460, 3556641619, 1350613766,
            2107757927, 309323868,  3452852627, 3424626316, 545651740,  1935764720, 2349926457,
            3546577033, 862046434,  167198649,  338290297,  1145807303, 1571276102, 883549156,
            907871968,  638566313,  678764227,  3795356864, 3306095271, 1452688488, 621126888,
            1838613968, 2054107827, 1785040579, 454879400,  1952849106, 1907701866, 1639495252,
            1623968604, 2997422000, 2633878652, 1036670775, 2191465943, 3053533585, 1654709920,
            1950620393, 4177745509, 1742007818, 2888573892, 2825965566, 1399790365, 1307674482,
            310692416,  384880529,  3497622676, 1024664651, 1541456182, 1904670217, 1008618602,
            2816673160, 684112698,  3332034744, 3646613828, 962627614,  3072103948, 3713153075,
            476323310,  3243124597, 126319837,  2155412848, 228580793,  2142696490, 3442722759,
            2689599232, 426191419,  3157759186, 100239709,  494534049,  1259677734, 2889209278,
            1754641396, 1057778427, 2133253617, 1298500018, 3340348062, 3967049659, 2927469144,
            1503854147, 2271956463, 3004309866, 260248338,  2570702480, 2067671015, 3168497089,
            361311552,  2123195373, 2825457193, 2599488181, 507483626,  1201669979, 910763802,
            4158584821, 3116016424, 3375736126, 2857697336, 3112473104, 2683465481, 1495348009,
            681020485,  4044713962, 2443109893, 129994063,  1710251126, 820410567,  601527649,
            1007603132, 2096580480, 1942768885, 1984297765, 1888157243, 960265104,  527990410,
            1572910026, 1106822080, 1472807331, 2465011897, 3139401215, 3705452371, 393081842,
            3826516196, 2576499701, 4130037087, 4155028170, 2188282304, 2949056849, 1138928618,
            858751984,  3735375571, 496972334,  830265621,  1355757111, 909444416,  1337622259,
            2616327935, 2337227347, 2139876075, 4269663356, 796316592,  1893005585, 3958551664,
            1746456069, 2430709714, 4025417573, 3333292799, 1833607331, 3864559081, 3415700826,
            3291421244, 1987321873, 1792851165, 505718946,  3755903648, 3351468604, 4035552813,
            2052557448, 2879065999, 22933757,   2160014758, 2321387515, 3556641619, 1350613766,
            2107757927, 309323868,  1850700415, 3424626316, 545651740,  1935764720, 2349926457,
            979047283,  862046434,  167198649,  338290297,  1145807303, 4201635137, 883549156,
            907871968,  638566313,  678764227,  2637527083, 3306095271, 1452688488, 621126888,
            1838613968, 117966344,  1785040579, 454879400,  1952849106, 1907701866, 733998186,
            1623968604, 2997422000, 2633878652, 1036670775, 3360491537, 3053533585, 1654709920,
            1950620393, 4177745509, 1716078578, 2888573892, 2825965566, 1399790365, 1307674482,
            2776111761, 384880529,  3497622676, 1024664651, 1541456182, 618916624,  1008618602,
            2816673160, 684112698,  3332034744, 3340690804, 962627614,  3072103948, 3713153075,
            476323310,  902990902,  126319837,  2155412848, 228580793,  2142696490, 4254301999,
            2689599232, 426191419,  3157759186, 100239709,  3216403640, 1259677734, 2889209278,
            1754641396, 1057778427, 3221479262, 1298500018, 3340348062, 3967049659, 2927469144,
            3926654939, 2271956463, 3004309866, 260248338,  2570702480, 1879451653, 3168497089,
            361311552,  2123195373, 2825457193, 341920668,  507483626,  1201669979, 910763802,
            4158584821, 3748705813, 3375736126, 2857697336, 3112473104, 2683465481, 3336305747,
            681020485,  4044713962, 2443109893, 129994063,  2578353596, 820410567,  601527649,
            1007603132, 2096580480, 3155251071, 1984297765, 1888157243, 960265104,  527990410,
            2548692624, 1106822080, 1472807331, 2465011897, 3139401215, 736629379,  393081842,
            3826516196, 2576499701, 4130037087, 2440227627, 2188282304, 2949056849, 1138928618,
            858751984,  191805249,  496972334,  830265621,  1355757111, 909444416,  396738554,
            2616327935, 2337227347, 2139876075, 4269663356, 3932761947, 1893005585, 3958551664,
            1746456069, 2430709714, 3171160829, 3333292799, 1833607331, 3864559081, 3415700826,
            1332800826, 1987321873, 1792851165, 505718946,  3755903648, 1770588062, 4035552813,
            2052557448, 2879065999, 22933757,   3159941473, 2321387515, 3556641619, 1350613766,
            2107757927, 2669366188, 1850700415, 3424626316, 545651740,  1935764720, 3252475208,
            979047283,  862046434,  167198649,  338290297,  771814471,  4201635137, 883549156,
            907871968,  638566313,  184144160,  2637527083, 3306095271, 1452688488, 621126888,
            4275587594, 117966344,  1785040579, 454879400,  1952849106, 3806424990, 733998186,
            1623968604, 2997422000, 2633878652, 2670843077, 3360491537, 3053533585, 1654709920,
            1950620393, 3541927406, 1716078578, 2888573892, 2825965566, 1399790365, 3184295779,
            2776111761, 384880529,  3497622676, 1024664651, 723804135,  618916624,  1008618602,
            2816673160, 684112698,  3275521308, 3340690804, 962627614,  3072103948, 3713153075,
            2023106558, 902990902,  126319837,  2155412848, 228580793,  3978575748, 4254301999,
            2689599232, 426191419,  3157759186, 2446138116, 3216403640, 1259677734, 2889209278,
            1754641396, 1706032491, 3221479262, 1298500018, 3340348062, 3967049659, 3805001240,
            3926654939, 2271956463, 3004309866, 260248338,  294480880,  1879451653, 3168497089,
            361311552,  2123195373, 2080604411, 341920668,  507483626,  1201669979, 910763802,
            2012149356, 3748705813, 3375736126, 2857697336, 3112473104, 2935748807, 3336305747,
            681020485,  4044713962, 2443109893, 2862982895, 2578353596, 820410567,  601527649,
            1007603132, 1890290066, 3155251071, 1984297765, 1888157243, 960265104,  41870487,
            2548692624, 1106822080, 1472807331, 2465011897, 2382974023, 736629379,  393081842,
            3826516196, 2576499701, 4219335149, 2440227627, 2188282304, 2949056849, 1138928618,
            3785297102, 191805249,  496972334,  830265621,  1355757111, 3962907313, 396738554,
            2616327935, 2337227347, 2139876075, 552154011,  3932761947, 1893005585, 3958551664,
            1746456069, 895507243,  3171160829, 3333292799, 1833607331, 3864559081, 3564325554,
            1332800826, 1987321873, 1792851165, 505718946,  3245448088, 1770588062, 4035552813,
            2052557448, 2879065999, 3602157977, 3159941473, 2321387515, 3556641619, 1350613766,
            4101259055, 2669366188, 1850700415, 3424626316, 545651740,  2873707882, 3252475208,
            979047283,  862046434,  167198649,  654196140,  771814471,  4201635137, 883549156,
            907871968,  191965184,  184144160,  2637527083, 3306095271, 1452688488, 1562736568,
            4275587594, 117966344,  1785040579, 454879400,  3484019450, 3806424990, 733998186,
            1623968604, 2997422000, 273316614,  2670843077, 3360491537, 3053533585, 1654709920,
            591311873,  3541927406, 1716078578, 2888573892, 2825965566, 2277117038, 3184295779,
            2776111761, 384880529,  3497622676, 1086566797, 723804135,  618916624,  1008618602,
            2816673160, 3344392942, 3275521308, 3340690804, 962627614,  3072103948, 2910444460,
            2023106558, 902990902,  126319837,  2155412848, 337119596,  3978575748, 4254301999,
            2689599232, 426191419,  3471778695, 2446138116, 3216403640, 1259677734, 2889209278,
            4102983766, 1706032491, 3221479262, 1298500018, 3340348062, 2940293024, 3805001240,
            3926654939, 2271956463, 3004309866, 3634668003, 294480880,  1879451653, 3168497089,
            361311552,  3417679321, 2080604411, 341920668,  507483626,  1201669979, 3174274528,
            2012149356, 3748705813, 3375736126, 2857697336, 3929686609, 2935748807, 3336305747,
            681020485,  4044713962, 405011299,  2862982895, 2578353596, 820410567,  601527649,
            4281957726, 1890290066, 3155251071, 1984297765, 1888157243, 1978308818, 41870487,
            2548692624, 1106822080, 1472807331, 3701147046, 2382974023, 736629379,  393081842,
            3826516196, 3225163595, 4219335149, 2440227627, 2188282304, 2949056849, 3894577191,
            3785297102, 191805249,  496972334,  830265621,  4293577013, 3962907313, 396738554,
            2616327935, 2337227347, 3701032380, 552154011,  3932761947, 1893005585, 3958551664,
            4148575672, 895507243,  3171160829, 3333292799, 1833607331, 1596419195, 3564325554,
            1332800826, 1987321873, 1792851165, 3663406943, 3892533309, 247565591,  953356243,
            4103354183, 1908418768, 3915294912, 2390669489, 3865260287, 1818313429, 557880278,
            2499771815, 2618380525, 732785004,  1414011135, 2858311749, 3871596970, 2428464498,
            645476041,  683035653,  4079609082, 2404111028, 3332056297, 3054547484, 3616426087,
            1311379849, 3682136336, 3795847093, 1509718393, 541389178,  1103876446, 2549442278,
            3656600574, 3019560735, 523610761,  3889482885, 3080739216, 2359120072, 1034857006,
            63567637,   1520176098, 1741685274, 2330217396, 1429674399, 517809884,  2653145241,
            868296581,  646514407,  3166145188, 3023629813, 2333851648, 2967365394, 1828821737,
            3333092181, 445460259,  2682093551, 3655100102, 2592872076, 1588368999, 3964958220,
            755397374,  1912970603, 396253754,  4260038354, 1530898510, 2396805917, 3327501452,
            4235709361, 2762163349, 553869167,  3162483580, 1611891352, 248738605,  3403092967,
            2194464420, 113420452,  1752444845, 3770903547, 2397481985, 2866414964, 2555678075,
            2796010061, 762034588,  2679383682, 1848516655, 3857720381, 1119111363, 1829110546,
            2183620391, 1743838702, 3363053704, 2212810289, 966205413,  3897281091, 2148139678,
            2690229390, 427450194,  3516115778, 1864991059, 134448489,  3397232480, 3999530682,
            1927036992, 3170864927, 3879295489, 134554462,  3447324105, 86678510,   1656551206,
            2844494044, 2469678938, 2885597732, 2715483555, 3566904604, 462585182,  1922457093,
            3035264235, 2866504077, 2031456720, 1598555964, 2569915450, 3947972758, 290683210,
            2465427488, 3504862176, 793156806,  1722326752, 2706215067, 3818976191, 2007064241,
            552144413,  2692866408, 3975075075, 4293828741, 1123460373, 960845744,  1855626484,
            1876934434, 1343778249, 912185207,  127278206,  4168930635, 340393978,  65814528,
            2552086271, 2507474816, 1240220220, 1761964455, 2204917500, 4088965101, 1079310398,
            3071460742, 2188549805, 1064733776, 4191719087, 3221046115, 3772395288, 883516842,
            2077853840, 229484673,
        },
        {
            448889887,  3508620909, 4164289950, 155254859,  298319697,  980080883,  3500794888,
            3974907245, 682778656,  382798811,  1500342771, 3942535492, 1039809505, 2126581011,
            561192171,  4046277638, 840733718,  1694555864, 241216466,  4182349979, 2525929010,
            386794637,  349755829,  2959959729, 686974318,  3243688353, 3911051908, 3917458620,
            441833800,  3164548257, 584185450,  450132281,  3528356519, 4275666503, 1317069624,
            817077137,  2945430988, 1532878265, 2542155552, 3348614029, 1419611574, 1245233100,
            1981161828, 1161647342, 2781439556, 3896025436, 2349200248, 1213899699, 860301545,
            1590934964, 3371591516, 2850926464, 2774569126, 907316453,  3541736952, 3572719697,
            278602945,  4257620354, 3396349537, 3144949411, 191271983,  2974056951, 2743594803,
            1119054633, 815666748,  920991498,  187861899,  2008325469, 1548504646, 3749744762,
            993523345,  1171349070, 4105576982, 1559471848, 2656434170, 2795453957, 3357293755,
            4260164297, 2211998873, 1783238785, 2831224398, 1704939914, 2626903427, 1148581053,
            849777796,  4219173763, 694869701,  1297370017, 3573985711, 1739242781, 3680794431,
            400850360,  909653264,  1496585542, 460982606,  828640603,  3993062500, 2145047281,
            1587836828, 912583500,  1234319994, 4276951314, 485282908,  1903750880, 1667769214,
            3950976882, 3711912938, 3626058764, 627857875,  436470402,  1753727232, 50241405,
            206782941,  612110492,  954016857,  2567547031, 3360482779, 820704062,  412722485,
            2044763466, 1915626743, 2703000434, 2755090057, 53587450,   2457122208, 1397065983,
            2822294224, 3024827428, 2201149820, 699377793,  157099022,  2792298089, 3927835437,
            1095494739, 1230723791, 2740420278, 2518077381, 3674832547, 2375246835, 923451748,
            3665432731, 1577970518, 2643388181, 4050379756, 1145072065, 1632232822, 2365350332,
            1126185680, 930842061,  3816331201, 1624573114, 3809118349, 1187817320, 945407897,
            63630679,   1852369563, 971772965,  2229069035, 2320405193, 3474864049, 1666937976,
            448889887,  3508620909, 4164289950, 155254859,  3157319819, 980080883,  3500794888,
            3974907245, 682778656,  3201604042, 1500342771, 3942535492, 1039809505, 2126581011,
            3235144326, 4046277638, 840733718,  1694555864, 241216466,  2728337326, 2525929010,
            386794637,  349755829,  2959959729, 20820947,   3243688353, 3911051908, 3917458620,
            441833800,  4143649787, 584185450,  450132281,  3528356519, 4275666503, 3541347868,
            817077137,  2945430988, 1532878265, 2542155552, 3199458552, 1419611574, 1245233100,
            1981161828, 1161647342, 958085276,  3896025436, 2349200248, 1213899699, 860301545,
            1701089635, 3371591516, 2850926464, 2774569126, 907316453,  1529987826, 3572719697,
            278602945,  4257620354, 3396349537, 4120000342, 191271983,  2974056951, 2743594803,
            1119054633, 4255116655, 920991498,  187861899,  2008325469, 1548504646, 100038488,
            993523345,  1171349070, 4105576982, 1559471848, 2523523381, 2795453957, 3357293755,
            4260164297, 2211998873, 3644225670, 2831224398, 1704939914, 2626903427, 1148581053,
            1292003378, 4219173763, 694869701,  1297370017, 3573985711, 2510138592, 3680794431,
            400850360,  909653264,  1496585542, 1738256576, 828640603,  3993062500, 2145047281,
            1587836828, 3478998519, 1234319994, 4276951314, 485282908,  1903750880, 746205619,
            3950976882, 3711912938, 3626058764, 627857875,  954627753,  1753727232, 50241405,
            206782941,  612110492,  2251018875, 2567547031, 3360482779, 820704062,  412722485,
            2120077037, 1915626743, 2703000434, 2755090057, 53587450,   2696843657, 1397065983,
            2822294224, 3024827428, 2201149820, 3308142895, 157099022,  2792298089, 3927835437,
            1095494739, 730099534,  2740420278, 2518077381, 3674832547, 2375246835, 2126745526,
            3665432731, 1577970518, 2643388181, 4050379756, 2987545029, 1632232822, 2365350332,
            1126185680, 930842061,  3140947362, 1624573114, 3809118349, 1187817320, 945407897,
            1282799903, 1852369563, 971772965,  2229069035, 2320405193, 670134249,  1666937976,
            448889887,  3508620909, 4164289950, 127045110,  3157319819, 980080883,  3500794888,
            3974907245, 2740953010, 3201604042, 1500342771, 3942535492, 1039809505, 306788856,
            3235144326, 4046277638, 840733718,  1694555864, 2260304655, 2728337326, 2525929010,
            386794637,  349755829,  3842816805, 20820947,   3243688353, 3911051908, 3917458620,
            3398227861, 4143649787, 584185450,  450132281,  3528356519, 550401017,  3541347868,
            817077137,  2945430988, 1532878265, 1045681234, 3199458552, 1419611574, 1245233100,
            1981161828, 1153297031, 958085276,  3896025436, 2349200248, 1213899699, 1451842347,
            1701089635, 3371591516, 2850926464, 2774569126, 1269128107, 1529987826, 3572719697,
            278602945,  4257620354, 2479560493, 4120000342, 191271983,  2974056951, 2743594803,
            4081110580, 4255116655, 920991498,  187861899,  2008325469, 1300371976, 100038488,
            993523345,  1171349070, 4105576982, 3010753279, 2523523381, 2795453957, 3357293755,
            4260164297, 207153762,  3644225670, 2831224398, 1704939914, 2626903427, 916783095,
            1292003378, 4219173763, 694869701,  1297370017, 3388725608, 2510138592, 3680794431,
            400850360,  909653264,  2421730678, 1738256576, 828640603,  3993062500, 2145047281,
            2123619770, 3478998519, 1234319994, 4276951314, 485282908,  4002661777, 746205619,
            3950976882, 3711912938, 3626058764, 1230937254, 954627753,  1753727232, 50241405,
            206782941,  460314337,  2251018875, 2567547031, 3360482779, 820704062,  1339598718,
            2120077037, 1915626743, 2703000434, 2755090057, 660730207,  2696843657, 1397065983,
            2822294224, 3024827428, 126840648,  3308142895, 157099022,  2792298089, 3927835437,
            2192535935, 730099534,  2740420278, 2518077381, 3674832547, 1879512787, 2126745526,
            3665432731, 1577970518, 2643388181, 832572764,  2987545029, 1632232822, 2365350332,
            1126185680, 3248646182, 3140947362, 1624573114, 3809118349, 1187817320, 4270855000,
            1282799903, 1852369563, 971772965,  2229069035, 3735782785, 670134249,  1666937976,
            448889887,  3508620909, 3681408470, 127045110,  3157319819, 980080883,  3500794888,
            3967872553, 2740953010, 3201604042, 1500342771, 3942535492, 613854690,  306788856,
            3235144326, 4046277638, 840733718,  3957877023, 2260304655, 2728337326, 2525929010,
            386794637,  1779451936, 3842816805, 20820947,   3243688353, 3911051908, 688470429,
            3398227861, 4143649787, 584185450,  450132281,  3381050556, 550401017,  3541347868,
            817077137,  2945430988, 1859551669, 1045681234, 3199458552, 1419611574, 1245233100,
            53681099,   1153297031, 958085276,  3896025436, 2349200248, 1796144514, 1451842347,
            1701089635, 3371591516, 2850926464, 1337394836, 1269128107, 1529987826, 3572719697,
            278602945,  46913829,   2479560493, 4120000342, 191271983,  2974056951, 1361976701,
            4081110580, 4255116655, 920991498,  187861899,  1237191391, 1300371976, 100038488,
            993523345,  1171349070, 3168325479, 3010753279, 2523523381, 2795453957, 3357293755,
            2142853843, 207153762,  3644225670, 2831224398, 1704939914, 2369686128, 916783095,
            1292003378, 4219173763, 694869701,  4150182218, 3388725608, 2510138592, 3680794431,
            400850360,  654034492,  2421730678, 1738256576, 828640603,  3993062500, 84735560,
            2123619770, 3478998519, 1234319994, 4276951314, 2545204994, 4002661777, 746205619,
            3950976882, 3711912938, 426068544,  1230937254, 954627753,  1753727232, 50241405,
            589286339,  460314337,  2251018875, 2567547031, 3360482779, 3279873953, 1339598718,
            2120077037, 1915626743, 2703000434, 2720159887, 660730207,  2696843657, 1397065983,
            2822294224, 3536645029, 126840648,  3308142895, 157099022,  2792298089, 485214530,
            2192535935, 730099534,  2740420278, 2518077381, 418832171,  1879512787, 2126745526,
            3665432731, 1577970518, 721018,     832572764,  2987545029, 1632232822, 2365350332,
            1769688764, 3248646182, 3140947362, 1624573114, 3809118349, 3561012744, 4270855000,
            1282799903, 1852369563, 971772965,  2160782957, 105464019,  2131462864, 335205049,
            3271229551, 1374396416, 4269753677, 1984596635, 37563880,   3956352262, 2168603656,
            311623712,  1593371323, 351020595,  3439337532, 3130874657, 3613343327, 695789539,
            609797513,  53642143,   1479027519, 1588831722, 262810641,  3418379977, 530167431,
            1962487963, 2410103328, 3360114680, 3548827677, 2735238248, 2136058369, 4013192489,
            4106245442, 2155966460, 3653971354, 1230293148, 3966689348, 3455336684, 3594979856,
            3178937309, 3983796170, 3617590004, 1727358326, 1121418876, 1022562029, 2437823131,
            2733424381, 452731958,  2983755220, 1674750403, 3110921909, 3514365950, 2193238341,
            2073801740, 669573402,  1824298084, 22336337,   3366446304, 1536043612, 2502297553,
            1409641611, 2399583184, 2593245170, 716832039,  4286149460, 814849965,  4239224908,
            2453627262, 976385355,  1846129423, 52096201,   88835472,   2621770794, 2491757130,
            1849417480, 576668065,  2186701850, 3357019214, 442191324,  3662645846, 3653766782,
            2254203663, 1169821059, 3735427676, 2246044748, 2635264668, 2647842566, 1435695450,
            1658777934, 2927080369, 1341088646, 3565982642, 221661496,  3246988243, 2718455491,
            483517148,  4181332651, 1143646375, 1720449423, 331164544,  539836322,  3485371630,
            1110077273, 4088985694, 145720169,  2382276586, 4276410795, 2051956774, 936524156,
            15415192,   1815949694, 272696290,  1495465483, 3102030383, 3546078241, 3272619595,
            759699322,  1161486824, 1146281812, 4194130649, 3936306436, 4077338125, 2127551216,
            2995077453, 209698652,  3836657987, 1782152220, 1642490089, 3695579542, 537862234,
            1696168156, 4022607,    3642864269, 54404878,   2925910542, 3444042482, 1931288691,
            2269375687, 614870298,  1139082272, 3672546472, 3255845763, 2987873616, 3436501734,
            380553853,  750118352,  750708138,  488564982,  2936846643, 3460652101, 3085496886,
            3734224010, 523359404,  2751912206, 3302219188, 2729509827, 1995554251, 2288103059,
            3289667468, 2860301591,
        },
        {
            3481653941, 2111903071, 3569014882, 1149634763, 4206972571, 2948781360, 2576820949,
            2587099571, 3987042644, 4255777336, 2829594348, 3832744490, 3554499754, 787920018,
            695635693,  2746034685, 2078139227, 1144320548, 4020978225, 449503505,  3004993826,
            2045843139, 1604631401, 148449881,  457819243,  4089112489, 1713441237, 1790909556,
            3334464951, 3070008305, 811825474,  4089105370, 708239097,  1494832299, 2074902973,
            468898217,  1722559700, 2499754488, 2267939270, 650114709,  549502184,  4040463514,
            4228169080, 4094284819, 1599334548, 2992525399, 2107053637, 197348940,  1669884894,
            3982326753, 4259099320, 1862793542, 1751219817, 2701271514, 2507353222, 1488339939,
            4246544316, 3978321870, 132720476,  3020305599, 154822619,  2595474066, 1654579304,
            1997335204, 891320674,  3153502700, 601607977,  2695457160, 4137981809, 37584248,
            1674050253, 1805619463, 676369068,  2294902904, 658143166,  141452045,  2383327493,
            1222336195, 2628962123, 2378299402, 2724274090, 1783957650, 453206569,  3190116972,
            1480368955, 1145768764, 3628222572, 3108689607, 182547022,  360165920,  3378423016,
            1443723222, 2843274258, 1597581683, 664283285,  258077235,  3071875976, 240688930,
            988895736,  2965351284, 91332032,   941306162,  2464278288, 3493666272, 2437043750,
            2356658919, 24726067,   3025656863, 1343636659, 2408295270, 3097408183, 461428710,
            2449005423, 3220070834, 1418517867, 907095008,  428073188,  1938061314, 2094361729,
            2570445990, 346999411,  990247709,  1630488660, 2574142591, 1466590284, 1906935236,
            1592544037, 4168163186, 2773942807, 939392801,  1610069434, 1935303983, 2962954128,
            2490925509, 4103025390, 3614258069, 174125899,  4113855120, 2449365101, 3384244363,
            4115219971, 3187664453, 4021992190, 2959372973, 2946571025, 2144945539, 388172915,
            1125615727, 881693338,  3313110562, 859388069,  177786360,  4134747901, 616417204,
            2104495620, 783302897,  512784708,  1295821322, 3810209448, 2966899912, 2390608767,
            3481653941, 2111903071, 3569014882, 1149634763, 1385372463, 2948781360, 2576820949,
            2587099571, 3987042644, 2251144849, 2829594348, 3832744490, 3554499754, 787920018,
            73007125,   2746034685, 2078139227, 1144320548, 4020978225, 2729117517, 3004993826,
            2045843139, 1604631401, 148449881,  3343221736, 4089112489, 1713441237, 1790909556,
            3334464951, 1920962856, 811825474,  4089105370, 708239097,  1494832299, 2485576001,
            468898217,  1722559700, 2499754488, 2267939270, 2271486862, 549502184,  4040463514,
            4228169080, 4094284819, 3177940420, 2992525399, 2107053637, 197348940,  1669884894,
            3596140613, 4259099320, 1862793542, 1751219817, 2701271514, 1357847339, 1488339939,
            4246544316, 3978321870, 132720476,  344033794,  154822619,  2595474066, 1654579304,
            1997335204, 1849659590, 3153502700, 601607977,  2695457160, 4137981809, 3559496104,
            1674050253, 1805619463, 676369068,  2294902904, 1583197657, 141452045,  2383327493,
            1222336195, 2628962123, 3486106126, 2724274090, 1783957650, 453206569,  3190116972,
            1939413704, 1145768764, 3628222572, 3108689607, 182547022,  2911760834, 3378423016,
            1443723222, 2843274258, 1597581683, 3599911248, 258077235,  3071875976, 240688930,
            988895736,  4263328855, 91332032,   941306162,  2464278288, 3493666272, 1561559932,
            2356658919, 24726067,   3025656863, 1343636659, 257301433,  3097408183, 461428710,
            2449005423, 3220070834, 3544357262, 907095008,  428073188,  1938061314, 2094361729,
            4112109825, 346999411,  990247709,  1630488660, 2574142591, 1466763688, 1906935236,
            1592544037, 4168163186, 2773942807, 3608227467, 1610069434, 1935303983, 2962954128,
            2490925509, 825197245,  3614258069, 174125899,  4113855120, 2449365101, 167881680,
            4115219971, 3187664453, 4021992190, 2959372973, 1971633162, 2144945539, 388172915,
            1125615727, 881693338,  223946687,  859388069,  177786360,  4134747901, 616417204,
            722598357,  783302897,  512784708,  1295821322, 3810209448, 1589703161, 2390608767,
            3481653941, 2111903071, 3569014882, 2520719089, 1385372463, 2948781360, 2576820949,
            2587099571, 1427210741, 2251144849, 2829594348, 3832744490, 3554499754, 1257461820,
            73007125,   2746034685, 2078139227, 1144320548, 3065859797, 2729117517, 3004993826,
            2045843139, 1604631401, 36092756,   3343221736, 4089112489, 1713441237, 1790909556,
            1504385586, 1920962856, 811825474,  4089105370, 708239097,  4135459720, 2485576001,
            468898217,  1722559700, 2499754488, 1392696606, 2271486862, 549502184,  4040463514,
            4228169080, 2521060775, 3177940420, 2992525399, 2107053637, 197348940,  4225425195,
            3596140613, 4259099320, 1862793542, 1751219817, 3752827533, 1357847339, 1488339939,
            4246544316, 3978321870, 270743120,  344033794,  154822619,  2595474066, 1654579304,
            986127123,  1849659590, 3153502700, 601607977,  2695457160, 437034992,  3559496104,
            1674050253, 1805619463, 676369068,  956939381,  1583197657, 141452045,  2383327493,
            1222336195, 3287498300, 3486106126, 2724274090, 1783957650, 453206569,  3610364652,
            1939413704, 1145768764, 3628222572, 3108689607, 708259891,  2911760834, 3378423016,
            1443723222, 2843274258, 1498209005, 3599911248, 258077235,  3071875976, 240688930,
            3815218922, 4263328855, 91332032,   941306162,  2464278288, 3018835600, 1561559932,
            2356658919, 24726067,   3025656863, 368313673,  257301433,  3097408183, 461428710,
            2449005423, 3690066046, 3544357262, 907095008,  428073188,  1938061314, 2274317748,
            4112109825, 346999411,  990247709,  1630488660, 1584471638, 1466763688, 1906935236,
            1592544037, 4168163186, 473837206,  3608227467, 1610069434, 1935303983, 2962954128,
            391171548,  825197245,  3614258069, 174125899,  4113855120, 2095676907, 167881680,
            4115219971, 3187664453, 4021992190, 4246237180, 1971633162, 2144945539, 388172915,
            1125615727, 3158677395, 223946687,  859388069,  177786360,  4134747901, 4017781965,
            722598357,  783302897,  512784708,  1295821322, 3908594844, 1589703161, 2390608767,
            3481653941, 2111903071, 2713757719, 2520719089, 1385372463, 2948781360, 2576820949,
            638075690,  1427210741, 2251144849, 2829594348, 3832744490, 2871270139, 1257461820,
            73007125,   2746034685, 2078139227, 1974062189, 3065859797, 2729117517, 3004993826,
            2045843139, 772058252,  36092756,   3343221736, 4089112489, 1713441237, 2172680702,
            1504385586, 1920962856, 811825474,  4089105370, 1822881146, 4135459720, 2485576001,
            468898217,  1722559700, 3429640856, 1392696606, 2271486862, 549502184,  4040463514,
            3072935276, 2521060775, 3177940420, 2992525399, 2107053637, 1114377646, 4225425195,
            3596140613, 4259099320, 1862793542, 1439724658, 3752827533, 1357847339, 1488339939,
            4246544316, 1051119047, 270743120,  344033794,  154822619,  2595474066, 3143800435,
            986127123,  1849659590, 3153502700, 601607977,  2334441739, 437034992,  3559496104,
            1674050253, 1805619463, 455274178,  956939381,  1583197657, 141452045,  2383327493,
            1520979444, 3287498300, 3486106126, 2724274090, 1783957650, 2212706740, 3610364652,
            1939413704, 1145768764, 3628222572, 2719501850, 708259891,  2911760834, 3378423016,
            1443723222, 2678486648, 1498209005, 3599911248, 258077235,  3071875976, 513762712,
            3815218922, 4263328855, 91332032,   941306162,  3000922309, 3018835600, 1561559932,
            2356658919, 24726067,   3626352172, 368313673,  257301433,  3097408183, 461428710,
            2370224855, 3690066046, 3544357262, 907095008,  428073188,  2279237523, 2274317748,
            4112109825, 346999411,  990247709,  896290404,  1584471638, 1466763688, 1906935236,
            1592544037, 2387522308, 473837206,  3608227467, 1610069434, 1935303983, 4120978868,
            391171548,  825197245,  3614258069, 174125899,  2940674123, 2095676907, 167881680,
            4115219971, 3187664453, 456143482,  4246237180, 1971633162, 2144945539, 388172915,
            4041481385, 3158677395, 223946687,  859388069,  177786360,  3094936989, 4017781965,
            722598357,  783302897,  512784708,  4078350595, 2002159085, 3374931831, 1327513052,
            4231642441, 2398594140, 2750176655, 2377078716, 3051451207, 2923556938, 392203913,
            970480700,  1611278056, 1212903807, 85815670,   2398261756, 1052760308, 175807153,
            2617028873, 1862087601, 1824020594, 3770624867, 141863380,  2090619424, 3994019338,
            2363183556, 3095139522, 1792884692, 3026343485, 2320955816, 145789343,  214170401,
            2926373126, 3858640613, 2188241463, 459887603,  2117474937, 2514234285, 1454156613,
            1675396814, 4188979068, 1584843874, 3594779833, 563029256,  28681425,   446949770,
            3498545218, 435874305,  3448653884, 863509898,  2247299904, 4211345429, 971855563,
            1475394960, 3401692834, 167361776,  496249436,  1465278889, 780336162,  2108770597,
            1806981510, 3677875653, 1890122303, 16399665,   2747394159, 2098019492, 1597583332,
            1763649529, 1286079969, 1846278877, 1016796923, 959676917,  3091540766, 1626192266,
            780987350,  1102963422, 2507002232, 691766944,  193328868,  981596600,  2384820612,
            3149668778, 1691569420, 2852237957, 893819979,  2572584243, 216077070,  1267249886,
            2572508880, 1706489454, 2391561733, 2608477467, 209783612,  765896849,  3617020328,
            3488800100, 2237655981, 2095308189, 963275857,  3563488318, 1865487834, 480006810,
            18562439,   1025913188, 3368592397, 374648713,  2421713724, 2705651398, 3098059650,
            1109934605, 3085839620, 3184266772, 2359972463, 862934481,  3624479194, 3574284465,
            2700143837, 2468083868, 3798800988, 4116964911, 1832002264, 4276154871, 3256889524,
            4036954281, 697729046,  886223984,  2196986730, 1157617208, 1995907944, 398452318,
            3523714364, 613570866,  2962430983, 1408814780, 892117129,  4173164219, 3894076479,
            2721348430, 555734931,  1869034419, 336114876,  3142554871, 3349604636, 3450290892,
            955122895,  2202902910, 2558366468, 1701182712, 283197682,  1865942385, 2027648778,
            2285857699, 880475184,  958651279,  169534250,  3842420528, 1568559789, 2986618464,
            2568345525, 3081082692,
        },
        {
            575494427,  2773243709, 4009191487, 3877909663, 2252044261, 1328043370, 1407136778,
            3204434425, 3881653592, 1481049819, 2939203697, 889352935,  628666312,  165199023,
            2949092155, 1116804589, 998930334,  4144153491, 4191022348, 9022505,    4033326555,
            2329569601, 824756145,  3501916851, 1481410328, 1970954319, 4022176157, 2356841052,
            3783173734, 3649102345, 3205430658, 1460938436, 280282398,  3262135457, 4055383786,
            28522973,   1100901182, 4048609665, 994490185,  2888527367, 3591919750, 65093467,
            399797207,  3377740861, 3103183487, 3696509979, 866353724,  3847992271, 2821933890,
            1491144079, 1702442928, 1271285504, 636444475,  2465430290, 2440306765, 2651443172,
            2895101023, 43843628,   518479547,  3708355608, 2313400729, 3786408564, 2823763904,
            3267560272, 524168411,  2580824843, 2687886610, 785942949,  2624395631, 3713348903,
            4104123478, 2234056629, 2683158959, 1805382347, 1645702909, 382688861,  2843792951,
            39122499,   2765954033, 3033237617, 784228054,  1680611136, 2306036746, 892707919,
            3825738103, 1289362844, 3462989616, 484526950,  178560970,  1863413515, 71290794,
            1716785670, 3881310302, 2826977504, 2312744076, 1000001815, 1580868938, 3808984884,
            2521899773, 738699928,  2244576791, 1833964269, 1361345793, 2934763305, 2944705940,
            2334116476, 674208214,  587191877,  271361277,  1639419136, 2742744205, 2556530506,
            3764115510, 861410771,  3473658359, 2879790483, 1497452846, 1101855458, 2268199923,
            1766359872, 480532790,  2926891626, 1366888524, 2262816900, 620045088,  2279182738,
            2479688463, 427385986,  271096497,  1999040724, 1980388138, 3104550456, 2496325717,
            2941450111, 1784373495, 4020221165, 2567325850, 2636190539, 2764516078, 2285887821,
            2395930109, 1867061176, 665795763,  3869868300, 4033135159, 2589983679, 682593183,
            1254600537, 1701095863, 3738080583, 369734429,  2231641462, 1866531599, 1317004965,
            466053171,  2320346625, 485850108,  1279183025, 423884362,  1878291714, 228799661,
            575494427,  2773243709, 4009191487, 3877909663, 1392246100, 1328043370, 1407136778,
            3204434425, 3881653592, 303018213,  2939203697, 889352935,  628666312,  165199023,
            691563049,  1116804589, 998930334,  4144153491, 4191022348, 2882458100, 4033326555,
            2329569601, 824756145,  3501916851, 3512382126, 1970954319, 4022176157, 2356841052,
            3783173734, 3277915742, 3205430658, 1460938436, 280282398,  3262135457, 416160861,
            28522973,   1100901182, 4048609665, 994490185,  2206150488, 3591919750, 65093467,
            399797207,  3377740861, 3954301001, 3696509979, 866353724,  3847992271, 2821933890,
            482325742,  1702442928, 1271285504, 636444475,  2465430290, 476965483,  2651443172,
            2895101023, 43843628,   518479547,  2354104222, 2313400729, 3786408564, 2823763904,
            3267560272, 1682576095, 2580824843, 2687886610, 785942949,  2624395631, 3219885224,
            4104123478, 2234056629, 2683158959, 1805382347, 4143809855, 382688861,  2843792951,
            39122499,   2765954033, 2870716981, 784228054,  1680611136, 2306036746, 892707919,
            2648492467, 1289362844, 3462989616, 484526950,  178560970,  3047404165, 71290794,
            1716785670, 3881310302, 2826977504, 2439325884, 1000001815, 1580868938, 3808984884,
            2521899773, 2222792732, 2244576791, 1833964269, 1361345793, 2934763305, 655108124,
            2334116476, 674208214,  587191877,  271361277,  1403491312, 2742744205, 2556530506,
            3764115510, 861410771,  2748819627, 2879790483, 1497452846, 1101855458, 2268199923,
            2646753562, 480532790,  2926891626, 1366888524, 2262816900, 691077353,  2279182738,
            2479688463, 427385986,  271096497,  357444234,  1980388138, 3104550456, 2496325717,
            2941450111, 717953620,  4020221165, 2567325850, 2636190539, 2764516078, 588189150,
            2395930109, 1867061176, 665795763,  3869868300, 2245339306, 2589983679, 682593183,
            1254600537, 1701095863, 3193417815, 369734429,  2231641462, 1866531599, 1317004965,
            1295326133, 2320346625, 485850108,  1279183025, 423884362,  1310342080, 228799661,
            575494427,  2773243709, 4009191487, 3178129190, 1392246100, 1328043370, 1407136778,
            3204434425, 558594993,  303018213,  2939203697, 889352935,  628666312,  3995857198,
            691563049,  1116804589, 998930334,  4144153491, 2375099047, 2882458100, 4033326555,
            2329569601, 824756145,  3031828205, 3512382126, 1970954319, 4022176157, 2356841052,
            1599294097, 3277915742, 3205430658, 1460938436, 280282398,  2438973535, 416160861,
            28522973,   1100901182, 4048609665, 2989609671, 2206150488, 3591919750, 65093467,
            399797207,  183644195,  3954301001, 3696509979, 866353724,  3847992271, 1244421011,
            482325742,  1702442928, 1271285504, 636444475,  3659422961, 476965483,  2651443172,
            2895101023, 43843628,   2230230933, 2354104222, 2313400729, 3786408564, 2823763904,
            4146329709, 1682576095, 2580824843, 2687886610, 785942949,  126345381,  3219885224,
            4104123478, 2234056629, 2683158959, 1734650983, 4143809855, 382688861,  2843792951,
            39122499,   3527484969, 2870716981, 784228054,  1680611136, 2306036746, 1606477743,
            2648492467, 1289362844, 3462989616, 484526950,  3730796296, 3047404165, 71290794,
            1716785670, 3881310302, 4233965062, 2439325884, 1000001815, 1580868938, 3808984884,
            1228341642, 2222792732, 2244576791, 1833964269, 1361345793, 3313812192, 655108124,
            2334116476, 674208214,  587191877,  1531247446, 1403491312, 2742744205, 2556530506,
            3764115510, 2419989900, 2748819627, 2879790483, 1497452846, 1101855458, 1430402656,
            2646753562, 480532790,  2926891626, 1366888524, 1848714433, 691077353,  2279182738,
            2479688463, 427385986,  3906690631, 357444234,  1980388138, 3104550456, 2496325717,
            2272350403, 717953620,  4020221165, 2567325850, 2636190539, 1950604113, 588189150,
            2395930109, 1867061176, 665795763,  1735147895, 2245339306, 2589983679, 682593183,
            1254600537, 1518037357, 3193417815, 369734429,  2231641462, 1866531599, 1751783137,
            1295326133, 2320346625, 485850108,  1279183025, 149835864,  1310342080, 228799661,
            575494427,  2773243709, 1505829825, 3178129190, 1392246100, 1328043370, 1407136778,
            856233019,  558594993,  303018213,  2939203697, 889352935,  625515593,  3995857198,
            691563049,  1116804589, 998930334,  3264640128, 2375099047, 2882458100, 4033326555,
            2329569601, 1824812377, 3031828205, 3512382126, 1970954319, 4022176157, 3682468973,
            1599294097, 3277915742, 3205430658, 1460938436, 2034940270, 2438973535, 416160861,
            28522973,   1100901182, 3534874298, 2989609671, 2206150488, 3591919750, 65093467,
            2231373121, 183644195,  3954301001, 3696509979, 866353724,  1479968372, 1244421011,
            482325742,  1702442928, 1271285504, 3834022401, 3659422961, 476965483,  2651443172,
            2895101023, 1042443120, 2230230933, 2354104222, 2313400729, 3786408564, 2940290545,
            4146329709, 1682576095, 2580824843, 2687886610, 895602439,  126345381,  3219885224,
            4104123478, 2234056629, 3633565082, 1734650983, 4143809855, 382688861,  2843792951,
            3076342354, 3527484969, 2870716981, 784228054,  1680611136, 3667923304, 1606477743,
            2648492467, 1289362844, 3462989616, 1338592032, 3730796296, 3047404165, 71290794,
            1716785670, 995728648,  4233965062, 2439325884, 1000001815, 1580868938, 1245957136,
            1228341642, 2222792732, 2244576791, 1833964269, 2899552190, 3313812192, 655108124,
            2334116476, 674208214,  1154789946, 1531247446, 1403491312, 2742744205, 2556530506,
            1668620496, 2419989900, 2748819627, 2879790483, 1497452846, 177853954,  1430402656,
            2646753562, 480532790,  2926891626, 3179057526, 1848714433, 691077353,  2279182738,
            2479688463, 1988854710, 3906690631, 357444234,  1980388138, 3104550456, 1772857305,
            2272350403, 717953620,  4020221165, 2567325850, 3129906484, 1950604113, 588189150,
            2395930109, 1867061176, 2248975336, 1735147895, 2245339306, 2589983679, 682593183,
            3087155398, 1518037357, 3193417815, 369734429,  2231641462, 1858424931, 1751783137,
            1295326133, 2320346625, 485850108,  2471611230, 107369761,  2623559579, 4256589070,
            2365810185, 907910243,  3901832478, 2068079364, 2072842987, 401440347,  1707255913,
            1450112231, 2618898012, 600446000,  788321632,  4119629235, 2648781584, 1927659116,
            171372782,  1789511950, 2648296999, 3558619514, 1819608632, 1392007708, 2918513974,
            2270003900, 784021820,  1379044539, 591935962,  1638390839, 10832053,   3946625290,
            2916913801, 2718331169, 1595482738, 1294279402, 19889234,   1374364843, 571354125,
            3357938719, 2337506269, 905453029,  2504232400, 258673393,  2590342355, 3308443353,
            3359617898, 2686453711, 932545954,  509832408,  820508114,  431186194,  3434866166,
            1108455121, 2802986572, 893446102,  3248197798, 1797985531, 3952804303, 558601278,
            1813674114, 311050994,  425175161,  1125527204, 1597986581, 2282580210, 1659733126,
            2080660004, 4121079137, 3373787661, 1902252724, 2669993847, 2450915273, 2155525933,
            2139535914, 274595185,  1890506924, 2631794527, 1423530517, 4027031002, 1085427968,
            2402514206, 3591455043, 2513094696, 2338347202, 1168222597, 3922339535, 3991725466,
            2774598759, 3478721168, 3676766916, 179748891,  2911159372, 191101265,  3389843262,
            3093358663, 2333576084, 1056514165, 2987497874, 2502331872, 2027710028, 2338525812,
            3904906078, 806669884,  596300960,  1993055778, 1541809402, 3578865742, 652348267,
            3332532764, 2656602623, 2037214047, 323260312,  3310408133, 4037617529, 137297627,
            1236501991, 495817051,  481150309,  3067841968, 3120347176, 714354848,  1554632062,
            2522324107, 4274051212, 2180914534, 1261686356, 3569290041, 1801431819, 4286755560,
            2749452442, 829235089,  2243153325, 2525168177, 1486881882, 585653228,  3288336688,
            2734161045, 30430534,   714492313,  2582732426, 595577790,  1463554287, 1949506865,
            4210942156, 2008105540, 4055753132, 2530320603, 319064177,  2305067982, 3825716413,
            1543867515, 108979478,  3089716545, 2921391708, 2403595525, 3783697766, 2313991047,
            3302598706, 1318323763,
        },
        {
            1470380360, 3057428612, 2756676297, 1633786556, 4246459918, 2557524017, 1857180133,
            618903690,  2475611092, 2621430634, 2084292404, 1698607774, 1788956972, 3375072220,
            1499167056, 1218814632, 3699503479, 588281768,  3603925285, 1187721841, 1307962320,
            2562217840, 3882506958, 2387033730, 2097027049, 1593669125, 1899433035, 4039983902,
            1546854551, 1073191673, 3368453769, 3074694838, 534637095,  1860006723, 3416402670,
            802354899,  3998709605, 3944315555, 3454226397, 1648185195, 488532673,  3063734121,
            1318974867, 187087202,  200160693,  4170479404, 782764886,  4007973657, 1651636372,
            3084151528, 2085263921, 2424937940, 230704223,  3342587983, 1093085714, 683877298,
            3635026316, 3839461209, 2977567556, 3947448199, 3767172681, 1350679624, 3541409523,
            3975162472, 2459379316, 3287828387, 1565768431, 3149625429, 1328627497, 2156355750,
            112739894,  4052025045, 1396839113, 212349044,  110706825,  2185320852, 2540909191,
            2129623107, 3515174750, 2669147508, 1243549180, 3996575850, 149304348,  2755670869,
            930137412,  350687475,  1512442864, 3764389325, 3489308665, 276147411,  2268414314,
            30674096,   3202650841, 3446821592, 3341145621, 3749209259, 674361204,  1384681012,
            2716655878, 454169262,  289282175,  966029495,  3052791893, 3111969089, 1151599976,
            3620936019, 1877909034, 1953262994, 4240669039, 1857402256, 3337397349, 2392730459,
            1158928694, 1757447952, 2682284750, 2796982914, 1203210173, 797579212,  1645601877,
            3579805998, 797556690,  4106236617, 1379943929, 129105346,  3950170317, 723231430,
            88997404,   2591283275, 359831168,  306903531,  1987846974, 2654779951, 3724360049,
            1693615498, 1095306415, 3586751806, 2045807380, 2779363615, 2912940562, 1557518560,
            3620536996, 1723152132, 4087191232, 1042907094, 3210303305, 1536493323, 4094765090,
            575328723,  359319532,  2458971265, 3159207510, 387883436,  2521400838, 2359639886,
            261289463,  2094643916, 2269112547, 2387198764, 3619233779, 3019052785, 2910774311,
            1470380360, 3057428612, 2756676297, 1633786556, 386502519,  2557524017, 1857180133,
            618903690,  2475611092, 30080431,   2084292404, 1698607774, 1788956972, 3375072220,
            1158684464, 1218814632, 3699503479, 588281768,  3603925285, 238328161,  1307962320,
            2562217840, 3882506958, 2387033730, 3010587639, 1593669125, 1899433035, 4039983902,
            1546854551, 4192218972, 3368453769, 3074694838, 534637095,  1860006723, 652336168,
            802354899,  3998709605, 3944315555, 3454226397, 1926499185, 488532673,  3063734121,
            1318974867, 187087202,  1106075322, 4170479404, 782764886,  4007973657, 1651636372,
            2404132022, 2085263921, 2424937940, 230704223,  3342587983, 918664020,  683877298,
            3635026316, 3839461209, 2977567556, 1943458501, 3767172681, 1350679624, 3541409523,
            3975162472, 276593262,  3287828387, 1565768431, 3149625429, 1328627497, 1428675465,
            112739894,  4052025045, 1396839113, 212349044,  4056830215, 2185320852, 2540909191,
            2129623107, 3515174750, 1542171596, 1243549180, 3996575850, 149304348,  2755670869,
            3578672658, 350687475,  1512442864, 3764389325, 3489308665, 1546094236, 2268414314,
            30674096,   3202650841, 3446821592, 2954172575, 3749209259, 674361204,  1384681012,
            2716655878, 3784818668, 289282175,  966029495,  3052791893, 3111969089, 4157356036,
            3620936019, 1877909034, 1953262994, 4240669039, 558548232,  3337397349, 2392730459,
            1158928694, 1757447952, 2764253876, 2796982914, 1203210173, 797579212,  1645601877,
            1754284241, 797556690,  4106236617, 1379943929, 129105346,  1072954804, 723231430,
            88997404,   2591283275, 359831168,  3790749526, 1987846974, 2654779951, 3724360049,
            1693615498, 529478744,  3586751806, 2045807380, 2779363615, 2912940562, 3883779003,
            3620536996, 1723152132, 4087191232, 1042907094, 2510614710, 1536493323, 4094765090,
            575328723,  359319532,  4185709932, 3159207510, 387883436,  2521400838, 2359639886,
            143795416,  2094643916, 2269112547, 2387198764, 3619233779, 2856133500, 2910774311,
            1470380360, 3057428612, 2756676297, 1184346658, 386502519,  2557524017, 1857180133,
            618903690,  113530176,  30080431,   2084292404, 1698607774, 1788956972, 1446640841,
            1158684464, 1218814632, 3699503479, 588281768,  145530757,  238328161,  1307962320,
            2562217840, 3882506958, 2145494995, 3010587639, 1593669125, 1899433035, 4039983902,
            1668183055, 4192218972, 3368453769, 3074694838, 534637095,  1759744354, 652336168,
            802354899,  3998709605, 3944315555, 3058692249, 1926499185, 488532673,  3063734121,
            1318974867, 728549366,  1106075322, 4170479404, 782764886,  4007973657, 3270440405,
            2404132022, 2085263921, 2424937940, 230704223,  3329510499, 918664020,  683877298,
            3635026316, 3839461209, 79335966,   1943458501, 3767172681, 1350679624, 3541409523,
            925084463,  276593262,  3287828387, 1565768431, 3149625429, 3775346659, 1428675465,
            112739894,  4052025045, 1396839113, 865124022,  4056830215, 2185320852, 2540909191,
            2129623107, 408329043,  1542171596, 1243549180, 3996575850, 149304348,  3549625626,
            3578672658, 350687475,  1512442864, 3764389325, 2745315161, 1546094236, 2268414314,
            30674096,   3202650841, 1591955495, 2954172575, 3749209259, 674361204,  1384681012,
            4064148122, 3784818668, 289282175,  966029495,  3052791893, 1370867977, 4157356036,
            3620936019, 1877909034, 1953262994, 4021792514, 558548232,  3337397349, 2392730459,
            1158928694, 3155295174, 2764253876, 2796982914, 1203210173, 797579212,  3928348491,
            1754284241, 797556690,  4106236617, 1379943929, 535801204,  1072954804, 723231430,
            88997404,   2591283275, 3834650337, 3790749526, 1987846974, 2654779951, 3724360049,
            1042046499, 529478744,  3586751806, 2045807380, 2779363615, 1125934487, 3883779003,
            3620536996, 1723152132, 4087191232, 234512721,  2510614710, 1536493323, 4094765090,
            575328723,  3997395999, 4185709932, 3159207510, 387883436,  2521400838, 3125399953,
            143795416,  2094643916, 2269112547, 2387198764, 652167990,  2856133500, 2910774311,
            1470380360, 3057428612, 2132157457, 1184346658, 386502519,  2557524017, 1857180133,
            4131611047, 113530176,  30080431,   2084292404, 1698607774, 391246724,  1446640841,
            1158684464, 1218814632, 3699503479, 2411874184, 145530757,  238328161,  1307962320,
            2562217840, 2812151676, 2145494995, 3010587639, 1593669125, 1899433035, 2422208371,
            1668183055, 4192218972, 3368453769, 3074694838, 2148785858, 1759744354, 652336168,
            802354899,  3998709605, 1781938823, 3058692249, 1926499185, 488532673,  3063734121,
            3539633540, 728549366,  1106075322, 4170479404, 782764886,  2780824417, 3270440405,
            2404132022, 2085263921, 2424937940, 1908513596, 3329510499, 918664020,  683877298,
            3635026316, 2918953355, 79335966,   1943458501, 3767172681, 1350679624, 341369607,
            925084463,  276593262,  3287828387, 1565768431, 1957429498, 3775346659, 1428675465,
            112739894,  4052025045, 1847440090, 865124022,  4056830215, 2185320852, 2540909191,
            3477402775, 408329043,  1542171596, 1243549180, 3996575850, 179432054,  3549625626,
            3578672658, 350687475,  1512442864, 2118138924, 2745315161, 1546094236, 2268414314,
            30674096,   2317064191, 1591955495, 2954172575, 3749209259, 674361204,  3286542168,
            4064148122, 3784818668, 289282175,  966029495,  1327408800, 1370867977, 4157356036,
            3620936019, 1877909034, 405707683,  4021792514, 558548232,  3337397349, 2392730459,
            3244675609, 3155295174, 2764253876, 2796982914, 1203210173, 2274948223, 3928348491,
            1754284241, 797556690,  4106236617, 2665938417, 535801204,  1072954804, 723231430,
            88997404,   3006584290, 3834650337, 3790749526, 1987846974, 2654779951, 4271242910,
            1042046499, 529478744,  3586751806, 2045807380, 2283867237, 1125934487, 3883779003,
            3620536996, 1723152132, 1761178713, 234512721,  2510614710, 1536493323, 4094765090,
            2361030279, 3997395999, 4185709932, 3159207510, 387883436,  3979684113, 3125399953,
            143795416,  2094643916, 2269112547, 1499026790, 2673871071, 3817604600, 2996498142,
            1211396713, 4016438754, 992969238,  2196610884, 1333868752, 2722471337, 2178395143,
            533478044,  291720336,  3552502714, 1060260388, 1389737501, 3508724089, 3106493936,
            2013154532, 3169850047, 3773175439, 3604033115, 4234678017, 2903156223, 3832188501,
            2874956773, 4283805552, 3664062691, 1974738248, 925764827,  1750660924, 141239116,
            3273085573, 2427940522, 1962727892, 2493949152, 1043482688, 2345076260, 2209086707,
            3642865193, 3119873884, 571850463,  1599484831, 76923002,   3077572436, 4086821865,
            1523654720, 480304732,  476538774,  2169116383, 4033618691, 2819753414, 2856326003,
            747450871,  1851448547, 713503330,  3709263622, 781002495,  1968749577, 2933719965,
            4057398020, 3406593497, 689436820,  2935729647, 2030357428, 2075940397, 1830631914,
            1093330800, 1706624613, 1805612947, 4257097124, 3233604448, 159450674,  1050507045,
            566046625,  2253420120, 904902042,  1830037922, 4081490982, 1427186514, 2535536470,
            3869316947, 4097476542, 930420754,  2519255367, 49908928,   454325685,  888118139,
            3453892181, 1263601461, 1236190782, 674943665,  1648077470, 429399730,  2904879506,
            3718410520, 1802183310, 1872553091, 605480672,  774749173,  3200570514, 181210046,
            2560898144, 3947027625, 1535243167, 324801283,  4234744788, 746560316,  2456297875,
            3925756080, 533997731,  3919796086, 662975152,  864661066,  1070894403, 1020445801,
            1511298602, 4221508348, 3577952702, 4122306502, 2012051572, 1616168260, 2456901413,
            2717726537, 840264605,  2687215223, 2174960097, 1239122603, 2890231920, 3365350767,
            3998868598, 563137220,  893868530,  3400632172, 1538627830, 2812510298, 496662288,
            2317289974, 2252393722, 1221289032, 2418100559, 402670890,  1528570045, 3160531718,
            1806492066, 3211663975, 3617025598, 3664580463, 1338638297, 341637330,  2097019728,
            4031221207, 503636424,  3883416740, 1530237682, 1152125396, 2845384901, 332460372,
            457364876,  1738239808,
        },
        {
            1118787884, 1884590246, 1007052798, 3717680750, 1609263052, 2486654530, 2761168910,
            163554565,  3928803020, 2632714628, 1386788970, 2621928183, 2855206157, 2989018213,
            1836814260, 4197635108, 1030118238, 2789863793, 2063944689, 1647608366, 255485979,
            3657534664, 1317185871, 2410074449, 3971156607, 907575923,  4132859581, 416269582,
            877554291,  633895348,  2236014545, 992386759,  3971362318, 2173597771, 1673339632,
            1371742490, 2033574313, 3809530180, 319182848,  1562235776, 463522324,  1482338913,
            1816432405, 3278626272, 1335179249, 171265751,  2249118654, 1153849045, 3013179633,
            1450352108, 1267908572, 1138658121, 623675874,  3608469129, 978093004,  1283228910,
            1810859539, 1179125634, 2939039286, 3862213960, 1168357273, 376788629,  314507445,
            219039712,  463080619,  2994990779, 1035692306, 2228303916, 1280244913, 1965417315,
            1815095408, 939691799,  3080056566, 3741305118, 1495905100, 65327713,   3884301346,
            2536445014, 1503280354, 3398924419, 3678532805, 2616964783, 3168581019, 3553322118,
            3023259169, 480342712,  451634742,  3562778450, 1943708078, 660077747,  434714388,
            2369278293, 2894425895, 1919542250, 2469130567, 551196237,  4193980239, 2952382875,
            3311173667, 2856797012, 2845888917, 1669184098, 3928626091, 2491577076, 3719464032,
            2151963814, 3474431449, 3971510537, 3695841119, 2215238146, 3668152847, 1974578319,
            2328185090, 2096356935, 3973692455, 3954842437, 422675402,  477894725,  3398641827,
            1366451030, 1354642198, 3029840461, 35700837,   2937170986, 1336296570, 3508313874,
            587724229,  2051237478, 3539754304, 1946154432, 2463932452, 144772179,  353408424,
            3493806256, 3782958493, 1957797444, 228084488,  192277278,  3612092522, 2235069734,
            467407503,  3391861572, 847810786,  1838763654, 2272109211, 3018265496, 4249218445,
            1722760791, 3484353162, 3906437663, 4208966227, 2352549740, 714311566,  1346246305,
            2865157059, 2989587005, 3946819548, 3109244860, 3885124598, 3314346978, 952826829,
            1118787884, 1884590246, 1007052798, 3717680750, 1521451317, 2486654530, 2761168910,
            163554565,  3928803020, 2299046195, 1386788970, 2621928183, 2855206157, 2989018213,
            3048269905, 4197635108, 1030118238, 2789863793, 2063944689, 1814057352, 255485979,
            3657534664, 1317185871, 2410074449, 4041610788, 907575923,  4132859581, 416269582,
            877554291,  2338964683, 2236014545, 992386759,  3971362318, 2173597771, 579340117,
            1371742490, 2033574313, 3809530180, 319182848,  3090313228, 463522324,  1482338913,
            1816432405, 3278626272, 2418220643, 171265751,  2249118654, 1153849045, 3013179633,
            2738647190, 1267908572, 1138658121, 623675874,  3608469129, 3096087202, 1283228910,
            1810859539, 1179125634, 2939039286, 2601862091, 1168357273, 376788629,  314507445,
            219039712,  1174181426, 2994990779, 1035692306, 2228303916, 1280244913, 752017703,
            1815095408, 939691799,  3080056566, 3741305118, 126135654,  65327713,   3884301346,
            2536445014, 1503280354, 955981361,  3678532805, 2616964783, 3168581019, 3553322118,
            3772187171, 480342712,  451634742,  3562778450, 1943708078, 1466950454, 434714388,
            2369278293, 2894425895, 1919542250, 317862862,  551196237,  4193980239, 2952382875,
            3311173667, 12728591,   2845888917, 1669184098, 3928626091, 2491577076, 2742989641,
            2151963814, 3474431449, 3971510537, 3695841119, 1005662613, 3668152847, 1974578319,
            2328185090, 2096356935, 3629684995, 3954842437, 422675402,  477894725,  3398641827,
            209352768,  1354642198, 3029840461, 35700837,   2937170986, 1660777984, 3508313874,
            587724229,  2051237478, 3539754304, 3631430985, 2463932452, 144772179,  353408424,
            3493806256, 3616422021, 1957797444, 228084488,  192277278,  3612092522, 3638977910,
            467407503,  3391861572, 847810786,  1838763654, 2427237699, 3018265496, 4249218445,
            1722760791, 3484353162, 2322365400, 4208966227, 2352549740, 714311566,  1346246305,
            954101391,  2989587005, 3946819548, 3109244860, 3885124598, 420941376,  952826829,
            1118787884, 1884590246, 1007052798, 539759724,  1521451317, 2486654530, 2761168910,
            163554565,  1954997983, 2299046195, 1386788970, 2621928183, 2855206157, 3104695189,
            3048269905, 4197635108, 1030118238, 2789863793, 3556473570, 1814057352, 255485979,
            3657534664, 1317185871, 3004205219, 4041610788, 907575923,  4132859581, 416269582,
            2980178044, 2338964683, 2236014545, 992386759,  3971362318, 2573125018, 579340117,
            1371742490, 2033574313, 3809530180, 766585731,  3090313228, 463522324,  1482338913,
            1816432405, 3101578277, 2418220643, 171265751,  2249118654, 1153849045, 2143267892,
            2738647190, 1267908572, 1138658121, 623675874,  2944231951, 3096087202, 1283228910,
            1810859539, 1179125634, 374714364,  2601862091, 1168357273, 376788629,  314507445,
            1710922505, 1174181426, 2994990779, 1035692306, 2228303916, 3222680885, 752017703,
            1815095408, 939691799,  3080056566, 1985366287, 126135654,  65327713,   3884301346,
            2536445014, 3002467868, 955981361,  3678532805, 2616964783, 3168581019, 2173417616,
            3772187171, 480342712,  451634742,  3562778450, 236095606,  1466950454, 434714388,
            2369278293, 2894425895, 1766257461, 317862862,  551196237,  4193980239, 2952382875,
            2416349742, 12728591,   2845888917, 1669184098, 3928626091, 2346338391, 2742989641,
            2151963814, 3474431449, 3971510537, 942354812,  1005662613, 3668152847, 1974578319,
            2328185090, 3234982376, 3629684995, 3954842437, 422675402,  477894725,  2931444539,
            209352768,  1354642198, 3029840461, 35700837,   3388567298, 1660777984, 3508313874,
            587724229,  2051237478, 1770178720, 3631430985, 2463932452, 144772179,  353408424,
            3783114255, 3616422021, 1957797444, 228084488,  192277278,  611095909,  3638977910,
            467407503,  3391861572, 847810786,  1413548572, 2427237699, 3018265496, 4249218445,
            1722760791, 1487262638, 2322365400, 4208966227, 2352549740, 714311566,  1378213368,
            954101391,  2989587005, 3946819548, 3109244860, 4183748384, 420941376,  952826829,
            1118787884, 1884590246, 2199811809, 539759724,  1521451317, 2486654530, 2761168910,
            1100080647, 1954997983, 2299046195, 1386788970, 2621928183, 916352763,  3104695189,
            3048269905, 4197635108, 1030118238, 369866139,  3556473570, 1814057352, 255485979,
            3657534664, 2916985473, 3004205219, 4041610788, 907575923,  4132859581, 3856599532,
            2980178044, 2338964683, 2236014545, 992386759,  3393662326, 2573125018, 579340117,
            1371742490, 2033574313, 1938766053, 766585731,  3090313228, 463522324,  1482338913,
            2122086302, 3101578277, 2418220643, 171265751,  2249118654, 952602228,  2143267892,
            2738647190, 1267908572, 1138658121, 1808026803, 2944231951, 3096087202, 1283228910,
            1810859539, 3881666794, 374714364,  2601862091, 1168357273, 376788629,  728738466,
            1710922505, 1174181426, 2994990779, 1035692306, 74930675,   3222680885, 752017703,
            1815095408, 939691799,  3404352271, 1985366287, 126135654,  65327713,   3884301346,
            1822629733, 3002467868, 955981361,  3678532805, 2616964783, 3865359567, 2173417616,
            3772187171, 480342712,  451634742,  1099609112, 236095606,  1466950454, 434714388,
            2369278293, 2671873359, 1766257461, 317862862,  551196237,  4193980239, 2006763654,
            2416349742, 12728591,   2845888917, 1669184098, 2492983893, 2346338391, 2742989641,
            2151963814, 3474431449, 2095232649, 942354812,  1005662613, 3668152847, 1974578319,
            1748794756, 3234982376, 3629684995, 3954842437, 422675402,  2291986911, 2931444539,
            209352768,  1354642198, 3029840461, 3772709822, 3388567298, 1660777984, 3508313874,
            587724229,  2759789003, 1770178720, 3631430985, 2463932452, 144772179,  1572181309,
            3783114255, 3616422021, 1957797444, 228084488,  4106643586, 611095909,  3638977910,
            467407503,  3391861572, 927151111,  1413548572, 2427237699, 3018265496, 4249218445,
            692575565,  1487262638, 2322365400, 4208966227, 2352549740, 1281886506, 1378213368,
            954101391,  2989587005, 3946819548, 1861811740, 1484768905, 359662140,  4058479705,
            1306547382, 514617018,  1685692791, 3370601554, 2920029077, 447798803,  3124262580,
            1841693810, 583764638,  853545489,  2614348705, 1445696741, 4226719361, 1299450005,
            7404137,    3158806368, 3487160245, 1410910965, 3697116584, 4272452035, 832215403,
            4190877996, 2360539465, 1011144434, 546018244,  613443074,  2523894977, 998991923,
            2569220540, 4221264346, 2627827148, 2606458015, 261584257,  4172552877, 1174774061,
            1040006970, 2378868955, 1539192255, 1322624483, 3221782707, 3352886416, 3634686692,
            65447704,   3962131218, 839088053,  4154193716, 1211888926, 319402483,  3922826413,
            3799829447, 623726612,  1586183272, 1853729462, 2621029589, 708558605,  1618007233,
            2784732545, 953859039,  921654620,  477148727,  3592256598, 2772318818, 1460772911,
            1309227716, 3484274262, 3425161241, 1677052569, 2238155114, 2828087292, 2361598991,
            4283732706, 1530059373, 1564048492, 243829114,  104328994,  3080249237, 2054985396,
            408961407,  2978652320, 2412674552, 3794618070, 3644862703, 2095186402, 3294126752,
            2970218740, 1800713612, 3806665216, 3990918051, 142666452,  531078813,  1079142774,
            3437358350, 635943961,  255576894,  2991317718, 1208676456, 247449774,  454879171,
            113230697,  3064123371, 336269028,  1137083842, 959568850,  2508623991, 3338418112,
            2660268938, 1318010299, 3950178561, 1078499199, 1176289535, 3875152821, 1984420952,
            1134199826, 2944539174, 3667625203, 2034152216, 1648355307, 2376447620, 2967418253,
            185143450,  889002925,  3999315013, 661455858,  4026799358, 3626504428, 3544795311,
            3642718771, 2467387138, 1034249749, 2051371333, 4251353248, 1575036366, 751400924,
            2906720214, 1210002606, 916508568,  1728487600, 2478884914, 3081526615, 1867135009,
            1955998382, 701713417,  512784398,  1255240210, 3665676113, 1771754697, 4000392442,
            3342268855, 2677221913, 369054145,  4011912082, 748537647,  1626721797, 852497405,
            168721778,  3091138383,
        },
        {
            3781228998, 1787582256, 838267218,  2710632450, 690892139,  2484870604, 4151302318,
            1844787776, 727768263,  1075391038, 1842903369, 2927332301, 3246688068, 1234715005,
            2906526190, 3369636401, 3091858538, 3320767682, 920496809,  1406803705, 3163880457,
            1540551653, 2733620168, 2588558057, 147277542,  803170440,  821275940,  3897549272,
            151390608,  951639139,  904639695,  1106545578, 1514893712, 998760135,  2557458623,
            4109877399, 578824730,  2174064027, 3352513900, 3206168298, 911932439,  2030004973,
            3283902592, 3755877921, 250434692,  352122318,  977153640,  642640734,  2555395772,
            2307695537, 2593565626, 3738143618, 734614254,  3276420511, 2636087597, 4157371578,
            1082026387, 429736987,  3755125580, 1935957937, 3300547146, 3089498232, 4167244256,
            1619189426, 1094447351, 1061842570, 3666470174, 810916769,  2263633079, 3863543843,
            1804937521, 2774236887, 2858593613, 961498236,  1515309045, 1564424234, 2276602447,
            2540994858, 78621171,   3575132456, 2958793283, 387554009,  688827573,  3833764146,
            2611524056, 2296780370, 2411775612, 3790615886, 3399757437, 1385198595, 1005364336,
            2093159919, 2091827252, 1461775197, 4225171212, 1185831033, 12264437,   1313835999,
            556653278,  917105970,  1471530347, 2010243509, 3097827138, 1399987735, 273352191,
            2505795417, 1336824946, 3358720963, 2874295267, 2282349617, 3478581038, 4027859424,
            713597958,  4059691816, 2812811116, 2291324146, 932688463,  3001334051, 2028368589,
            830582457,  3964293916, 4276849132, 1828058403, 1351688755, 2113265048, 42517349,
            3100438883, 1137792178, 1479076106, 463377892,  3964913740, 2422362185, 436113863,
            2044139049, 4197323265, 3275185975, 2655265571, 1674107588, 1496360114, 3642050139,
            1739051417, 2393774399, 250035802,  10186306,   263338568,  3899157617, 3679157076,
            2258085991, 1407319575, 899008067,  3679828833, 711086272,  2952963707, 3373894808,
            445540851,  3405637490, 1343291195, 730888681,  507768703,  3473963321, 1779803564,
            3781228998, 1787582256, 838267218,  2710632450, 2431224659, 2484870604, 4151302318,
            1844787776, 727768263,  4012573268, 1842903369, 2927332301, 3246688068, 1234715005,
            3405161215, 3369636401, 3091858538, 3320767682, 920496809,  400609988,  3163880457,
            1540551653, 2733620168, 2588558057, 2137935937, 803170440,  821275940,  3897549272,
            151390608,  194431797,  904639695,  1106545578, 1514893712, 998760135,  62528087,
            4109877399, 578824730,  2174064027, 3352513900, 3495516649, 911932439,  2030004973,
            3283902592, 3755877921, 1774462108, 352122318,  977153640,  642640734,  2555395772,
            756528792,  2593565626, 3738143618, 734614254,  3276420511, 4086313763, 4157371578,
            1082026387, 429736987,  3755125580, 526056489,  3300547146, 3089498232, 4167244256,
            1619189426, 82235109,   1061842570, 3666470174, 810916769,  2263633079, 1110270726,
            1804937521, 2774236887, 2858593613, 961498236,  1840197918, 1564424234, 2276602447,
            2540994858, 78621171,   3690913528, 2958793283, 387554009,  688827573,  3833764146,
            3626285597, 2296780370, 2411775612, 3790615886, 3399757437, 1561545830, 1005364336,
            2093159919, 2091827252, 1461775197, 63358970,   1185831033, 12264437,   1313835999,
            556653278,  3918754976, 1471530347, 2010243509, 3097827138, 1399987735, 2767111911,
            2505795417, 1336824946, 3358720963, 2874295267, 902314853,  3478581038, 4027859424,
            713597958,  4059691816, 1462989647, 2291324146, 932688463,  3001334051, 2028368589,
            3594712587, 3964293916, 4276849132, 1828058403, 1351688755, 2571513800, 42517349,
            3100438883, 1137792178, 1479076106, 140519541,  3964913740, 2422362185, 436113863,
            2044139049, 226785542,  3275185975, 2655265571, 1674107588, 1496360114, 46428973,
            1739051417, 2393774399, 250035802,  10186306,   4118320101, 3899157617, 3679157076,
            2258085991, 1407319575, 4267866849, 3679828833, 711086272,  2952963707, 3373894808,
            3662249794, 3405637490, 1343291195, 730888681,  507768703,  2930510271, 1779803564,
            3781228998, 1787582256, 838267218,  1817693489, 2431224659, 2484870604, 4151302318,
            1844787776, 1788220652, 4012573268, 1842903369, 2927332301, 3246688068, 2050648011,
            3405161215, 3369636401, 3091858538, 3320767682, 241001958,  400609988,  3163880457,
            1540551653, 2733620168, 3857223520, 2137935937, 803170440,  821275940,  3897549272,
            1451986523, 194431797,  904639695,  1106545578, 1514893712, 4147878244, 62528087,
            4109877399, 578824730,  2174064027, 461571251,  3495516649, 911932439,  2030004973,
            3283902592, 1580354765, 1774462108, 352122318,  977153640,  642640734,  1019387737,
            756528792,  2593565626, 3738143618, 734614254,  999431451,  4086313763, 4157371578,
            1082026387, 429736987,  140091634,  526056489,  3300547146, 3089498232, 4167244256,
            3202763095, 82235109,   1061842570, 3666470174, 810916769,  3663992550, 1110270726,
            1804937521, 2774236887, 2858593613, 2203639366, 1840197918, 1564424234, 2276602447,
            2540994858, 978199281,  3690913528, 2958793283, 387554009,  688827573,  375113876,
            3626285597, 2296780370, 2411775612, 3790615886, 1277897939, 1561545830, 1005364336,
            2093159919, 2091827252, 1631078873, 63358970,   1185831033, 12264437,   1313835999,
            3872277948, 3918754976, 1471530347, 2010243509, 3097827138, 1291836608, 2767111911,
            2505795417, 1336824946, 3358720963, 3954754615, 902314853,  3478581038, 4027859424,
            713597958,  2198246306, 1462989647, 2291324146, 932688463,  3001334051, 2374736511,
            3594712587, 3964293916, 4276849132, 1828058403, 3619038368, 2571513800, 42517349,
            3100438883, 1137792178, 1146435746, 140519541,  3964913740, 2422362185, 436113863,
            3460540392, 226785542,  3275185975, 2655265571, 1674107588, 1288223861, 46428973,
            1739051417, 2393774399, 250035802,  1986226858, 4118320101, 3899157617, 3679157076,
            2258085991, 551117761,  4267866849, 3679828833, 711086272,  2952963707, 1667866621,
            3662249794, 3405637490, 1343291195, 730888681,  2381246695, 2930510271, 1779803564,
            3781228998, 1787582256, 1236367773, 1817693489, 2431224659, 2484870604, 4151302318,
            2902321811, 1788220652, 4012573268, 1842903369, 2927332301, 1185539274, 2050648011,
            3405161215, 3369636401, 3091858538, 4240555382, 241001958,  400609988,  3163880457,
            1540551653, 2539098607, 3857223520, 2137935937, 803170440,  821275940,  3485313735,
            1451986523, 194431797,  904639695,  1106545578, 1633417190, 4147878244, 62528087,
            4109877399, 578824730,  3671726812, 461571251,  3495516649, 911932439,  2030004973,
            2002341352, 1580354765, 1774462108, 352122318,  977153640,  170033402,  1019387737,
            756528792,  2593565626, 3738143618, 4160516213, 999431451,  4086313763, 4157371578,
            1082026387, 1423352480, 140091634,  526056489,  3300547146, 3089498232, 4266971502,
            3202763095, 82235109,   1061842570, 3666470174, 945994616,  3663992550, 1110270726,
            1804937521, 2774236887, 3776581315, 2203639366, 1840197918, 1564424234, 2276602447,
            928117829,  978199281,  3690913528, 2958793283, 387554009,  2817496615, 375113876,
            3626285597, 2296780370, 2411775612, 1346030561, 1277897939, 1561545830, 1005364336,
            2093159919, 821902776,  1631078873, 63358970,   1185831033, 12264437,   3192617499,
            3872277948, 3918754976, 1471530347, 2010243509, 4011062105, 1291836608, 2767111911,
            2505795417, 1336824946, 1593119272, 3954754615, 902314853,  3478581038, 4027859424,
            1163079365, 2198246306, 1462989647, 2291324146, 932688463,  4018333691, 2374736511,
            3594712587, 3964293916, 4276849132, 3902062310, 3619038368, 2571513800, 42517349,
            3100438883, 1645455709, 1146435746, 140519541,  3964913740, 2422362185, 3338363150,
            3460540392, 226785542,  3275185975, 2655265571, 3789582441, 1288223861, 46428973,
            1739051417, 2393774399, 2257001236, 1986226858, 4118320101, 3899157617, 3679157076,
            3707520907, 551117761,  4267866849, 3679828833, 711086272,  570153549,  1667866621,
            3662249794, 3405637490, 1343291195, 112368058,  2615115584, 2865130041, 357584504,
            528807633,  1816055434, 2854850066, 190222907,  1014915859, 3472967123, 2605782564,
            3353130066, 540430076,  2087143725, 1571283916, 1604766425, 934199876,  3359569795,
            4168578472, 1745876717, 277026333,  2679446726, 3582165485, 3954458991, 2615245404,
            2410035461, 3442004248, 2814474875, 1734556428, 2653422310, 4033890533, 2373774914,
            3011118469, 1276695464, 2995405818, 782363735,  2242531852, 4206829780, 1486885236,
            3764707851, 1945614253, 1147926733, 701960774,  3435251514, 3626050187, 3587799538,
            2399216643, 3217822006, 3600044386, 648239752,  2997947488, 1754097052, 4109638936,
            3413714077, 1038375790, 3394259389, 2284776380, 2711956471, 1278424040, 1272230764,
            3980809660, 1983901240, 894405781,  582621606,  1274260631, 763432985,  1862236664,
            10249416,   3838574116, 1912270458, 3491686662, 2696669149, 312119069,  1812714569,
            2729307370, 3045249652, 303684944,  503720764,  4029412414, 4101616421, 3484358948,
            1261027935, 145713434,  2918444923, 2099546237, 3173693583, 3498398823, 3769717769,
            2860220116, 2919562911, 1221047715, 1749384742, 1018968146, 2771587474, 2746107326,
            1182859751, 2403805226, 2206395932, 1500348209, 1762634532, 3017223998, 2043185588,
            2124568729, 1619852613, 3248258238, 3393223375, 644860154,  2465108160, 2358875673,
            3643741304, 1891106916, 416443047,  3298583974, 1030877276, 2839390034, 4181398645,
            1845333999, 3643365079, 1993116780, 1763857175, 1951718545, 3785659537, 4156412284,
            4138026128, 3480291142, 54280556,   4169041146, 3130638398, 3236816184, 3559898998,
            916420843,  938920758,  3425021599, 1528477728, 3597939783, 3516249439, 936528538,
            4174817780, 2541489033, 3962368135, 2054336507, 2610093970, 3613025255, 3583905994,
            2990129491, 332823408,  2505138276, 3811707598, 373987627,  4263703898, 1668946560,
            3213253899, 2673819338, 1631405099, 3127443274, 549232331,  21447814,   1647238011,
            3093799993, 1922712395,
        },
        {
            4224788259, 3569487556, 1080137041, 2788623569, 856160888,  2195536417, 3030463035,
            2906439247, 896055051,  1967105456, 2093562169, 2919742950, 546374698,  1372591815,
            3773616637, 349073007,  1331102855, 3035367896, 1222622311, 2266618592, 74466398,
            1140488004, 855606859,  3803728487, 3589743162, 2748402856, 1044387368, 1494850922,
            2242660891, 3111566003, 2013737074, 163276737,  1526772858, 3047139947, 3150695453,
            2583795468, 3628272447, 305282258,  2151108134, 2905708853, 1052800761, 3354632338,
            1017036861, 2453680791, 2673902555, 1622154585, 2893733051, 3888482522, 306284440,
            3245137245, 3480776670, 2865396581, 3571456526, 3284891766, 1393584874, 1057867320,
            2888126310, 3302325443, 4135187530, 1770789166, 1615533805, 1438727397, 2921922012,
            3156703516, 435047591,  2999350446, 575044884,  1001339111, 625824120,  2489346227,
            2104489492, 2494528446, 1141458836, 4048430074, 2599022749, 2438694106, 1443850072,
            3321658999, 87870515,   958195816,  380666771,  3062272732, 4178548642, 4274603044,
            888566831,  3386636024, 1636806704, 2400069397, 3003029365, 1953620944, 3278772216,
            1562778171, 2767090642, 14436957,   913966574,  1724553886, 2015261135, 4191296122,
            1688939147, 110865735,  2913800286, 4131469475, 315962755,  1531174227, 1226678476,
            3446400266, 3896297836, 539834883,  2871306264, 3333932675, 2229436010, 1928458456,
            464682640,  1786180352, 162599143,  817038005,  3146256537, 1676400403, 2484731087,
            702610427,  4005124049, 1691076958, 1268494739, 4093608833, 3757213737, 2627839929,
            2884764386, 1548110665, 3361745333, 3955318088, 3264527857, 3969225726, 968269281,
            2630991382, 2716444139, 1071781623, 3704437685, 1511193802, 843840414,  1277966236,
            4141095880, 715016637,  1255888181, 1321941951, 1180174408, 1021629824, 3395369301,
            3912221525, 2611782663, 4038117717, 2253029302, 974431991,  347200257,  886823557,
            2275848777, 3732452739, 3708953729, 2688020866, 4185175489, 99605353,   2387945286,
            4224788259, 3569487556, 1080137041, 2788623569, 238715294,  2195536417, 3030463035,
            2906439247, 896055051,  3061240402, 2093562169, 2919742950, 546374698,  1372591815,
            851057115,  349073007,  1331102855, 3035367896, 1222622311, 3305595574, 74466398,
            1140488004, 855606859,  3803728487, 3838112757, 2748402856, 1044387368, 1494850922,
            2242660891, 1038286760, 2013737074, 163276737,  1526772858, 3047139947, 3518918891,
            2583795468, 3628272447, 305282258,  2151108134, 3555155951, 1052800761, 3354632338,
            1017036861, 2453680791, 2394691836, 1622154585, 2893733051, 3888482522, 306284440,
            2055552069, 3480776670, 2865396581, 3571456526, 3284891766, 1179339312, 1057867320,
            2888126310, 3302325443, 4135187530, 683364318,  1615533805, 1438727397, 2921922012,
            3156703516, 1333086260, 2999350446, 575044884,  1001339111, 625824120,  576119652,
            2104489492, 2494528446, 1141458836, 4048430074, 786660788,  2438694106, 1443850072,
            3321658999, 87870515,   457955380,  380666771,  3062272732, 4178548642, 4274603044,
            2256710588, 3386636024, 1636806704, 2400069397, 3003029365, 3733049985, 3278772216,
            1562778171, 2767090642, 14436957,   530062778,  1724553886, 2015261135, 4191296122,
            1688939147, 2981240708, 2913800286, 4131469475, 315962755,  1531174227, 2433363617,
            3446400266, 3896297836, 539834883,  2871306264, 2597546929, 2229436010, 1928458456,
            464682640,  1786180352, 1165821797, 817038005,  3146256537, 1676400403, 2484731087,
            3239493343, 4005124049, 1691076958, 1268494739, 4093608833, 2088690204, 2627839929,
            2884764386, 1548110665, 3361745333, 1075350364, 3264527857, 3969225726, 968269281,
            2630991382, 4103280359, 1071781623, 3704437685, 1511193802, 843840414,  1340474980,
            4141095880, 715016637,  1255888181, 1321941951, 2512565938, 1021629824, 3395369301,
            3912221525, 2611782663, 2287272047, 2253029302, 974431991,  347200257,  886823557,
            3775715445, 3732452739, 3708953729, 2688020866, 4185175489, 2151114047, 2387945286,
            4224788259, 3569487556, 1080137041, 879682447,  238715294,  2195536417, 3030463035,
            2906439247, 3975397430, 3061240402, 2093562169, 2919742950, 546374698,  1928060945,
            851057115,  349073007,  1331102855, 3035367896, 1148668613, 3305595574, 74466398,
            1140488004, 855606859,  917923571,  3838112757, 2748402856, 1044387368, 1494850922,
            995791756,  1038286760, 2013737074, 163276737,  1526772858, 1944370085, 3518918891,
            2583795468, 3628272447, 305282258,  685261037,  3555155951, 1052800761, 3354632338,
            1017036861, 1620076466, 2394691836, 1622154585, 2893733051, 3888482522, 4119309151,
            2055552069, 3480776670, 2865396581, 3571456526, 4008552940, 1179339312, 1057867320,
            2888126310, 3302325443, 2359989247, 683364318,  1615533805, 1438727397, 2921922012,
            2092991022, 1333086260, 2999350446, 575044884,  1001339111, 2406217399, 576119652,
            2104489492, 2494528446, 1141458836, 1856565466, 786660788,  2438694106, 1443850072,
            3321658999, 2752588925, 457955380,  380666771,  3062272732, 4178548642, 1354877973,
            2256710588, 3386636024, 1636806704, 2400069397, 2275777233, 3733049985, 3278772216,
            1562778171, 2767090642, 3438624166, 530062778,  1724553886, 2015261135, 4191296122,
            3842215040, 2981240708, 2913800286, 4131469475, 315962755,  2891870900, 2433363617,
            3446400266, 3896297836, 539834883,  1390877376, 2597546929, 2229436010, 1928458456,
            464682640,  1405678725, 1165821797, 817038005,  3146256537, 1676400403, 9522151,
            3239493343, 4005124049, 1691076958, 1268494739, 4076978821, 2088690204, 2627839929,
            2884764386, 1548110665, 3713129550, 1075350364, 3264527857, 3969225726, 968269281,
            2669129178, 4103280359, 1071781623, 3704437685, 1511193802, 2032747975, 1340474980,
            4141095880, 715016637,  1255888181, 1290704077, 2512565938, 1021629824, 3395369301,
            3912221525, 767420943,  2287272047, 2253029302, 974431991,  347200257,  940587649,
            3775715445, 3732452739, 3708953729, 2688020866, 1603856534, 2151114047, 2387945286,
            4224788259, 3569487556, 4060395365, 879682447,  238715294,  2195536417, 3030463035,
            774839173,  3975397430, 3061240402, 2093562169, 2919742950, 77503099,   1928060945,
            851057115,  349073007,  1331102855, 4216140027, 1148668613, 3305595574, 74466398,
            1140488004, 1728766104, 917923571,  3838112757, 2748402856, 1044387368, 1408900577,
            995791756,  1038286760, 2013737074, 163276737,  936142172,  1944370085, 3518918891,
            2583795468, 3628272447, 1701372078, 685261037,  3555155951, 1052800761, 3354632338,
            2951922777, 1620076466, 2394691836, 1622154585, 2893733051, 2494523614, 4119309151,
            2055552069, 3480776670, 2865396581, 3031455484, 4008552940, 1179339312, 1057867320,
            2888126310, 2970791558, 2359989247, 683364318,  1615533805, 1438727397, 3697460033,
            2092991022, 1333086260, 2999350446, 575044884,  2712063736, 2406217399, 576119652,
            2104489492, 2494528446, 1096189230, 1856565466, 786660788,  2438694106, 1443850072,
            3615481975, 2752588925, 457955380,  380666771,  3062272732, 2387056252, 1354877973,
            2256710588, 3386636024, 1636806704, 517188972,  2275777233, 3733049985, 3278772216,
            1562778171, 3436331606, 3438624166, 530062778,  1724553886, 2015261135, 1711407722,
            3842215040, 2981240708, 2913800286, 4131469475, 878455086,  2891870900, 2433363617,
            3446400266, 3896297836, 4251949215, 1390877376, 2597546929, 2229436010, 1928458456,
            719826541,  1405678725, 1165821797, 817038005,  3146256537, 3883590627, 9522151,
            3239493343, 4005124049, 1691076958, 893183073,  4076978821, 2088690204, 2627839929,
            2884764386, 3312769297, 3713129550, 1075350364, 3264527857, 3969225726, 4161107579,
            2669129178, 4103280359, 1071781623, 3704437685, 1400940789, 2032747975, 1340474980,
            4141095880, 715016637,  1705234794, 1290704077, 2512565938, 1021629824, 3395369301,
            2934074199, 767420943,  2287272047, 2253029302, 974431991,  3060035390, 940587649,
            3775715445, 3732452739, 3708953729, 3489160434, 3200799223, 340420813,  2539294182,
            2619616318, 456806966,  4272538790, 2994564124, 2757588894, 3493053179, 2946195469,
            1402305257, 2266356503, 3512914478, 273195440,  3579761455, 862317458,  1894959361,
            42596779,   376641729,  782820755,  716528645,  222675565,  4038035195, 311038326,
            395780597,  2025474869, 404396572,  4138962756, 2441107014, 3525378401, 947085768,
            3758218091, 3185789607, 638283508,  3802505926, 830259842,  1086400881, 3444485,
            142418107,  4283468141, 1669846189, 955065888,  3864384467, 73139517,   136809048,
            1444329434, 174974637,  3303183786, 282216656,  3114827080, 3811060015, 1610640996,
            3824096289, 1123437514, 3826582808, 39407702,   2437666463, 2454206642, 830758422,
            4190092654, 1941090912, 224373276,  3704201239, 3284012568, 4056152539, 1022047941,
            1077111803, 3028336675, 3207391465, 3459202233, 1991240724, 4184491520, 1851863093,
            1038639595, 1392247730, 2113875749, 1162388509, 2629935260, 3545260772, 991928712,
            4064775043, 4180493781, 2134685922, 642853690,  290065503,  1629968,    3150373868,
            3110755428, 2254306163, 421928533,  11426979,   3042809169, 786868170,  1287942583,
            1851107769, 1444903906, 4150950197, 3737798306, 2848738554, 505924220,  2944131627,
            2639930627, 1339887691, 2382166850, 2668971315, 3944739049, 2217612340, 4142682607,
            997824216,  123465626,  844518179,  1161486362, 2706162053, 2966530827, 4103639053,
            1837121393, 909648429,  298619078,  2057042454, 3613272637, 3609349032, 1664428748,
            1871510359, 58508710,   1079418100, 3278870121, 3821562746, 16654909,   2530580589,
            3361874982, 629910009,  2124761646, 2508133604, 1954315500, 3019833617, 141617625,
            1653192078, 1541695589, 1223978475, 3875963510, 3028691587, 3450826564, 2185849120,
            1956475624, 3053842172, 3550887830, 2672339803, 176823785,  913229929,  681399502,
            2256486297, 2881672598, 597153273,  2782767695, 1133158067, 4126077325, 3456027404,
            754062201,  4069172986,
        },
        {
            2441935114, 3465447683, 2897229686, 3845380309, 1199633364, 495424232,  2490548037,
            581670528,  2467171733, 2200094863, 2163927790, 3895792830, 2097210789, 1606544633,
            1305562517, 4072525389, 3256142090, 349440478,  3920932491, 2462464051, 1075951496,
            2835763703, 1593198055, 2380945625, 543531323,  3182766507, 2927484354, 2877470578,
            4153923603, 2443156156, 1168544900, 888955615,  3605412824, 1336677864, 3256116974,
            2884036014, 4070749843, 2989661773, 1095584023, 1370834065, 3534389580, 312378113,
            3190819203, 1247574926, 2046019470, 3536918510, 1479030180, 847820646,  3992973956,
            3827223401, 4113429617, 3504933502, 295000614,  2238923504, 3485717254, 290246351,
            1064210816, 2848539559, 2617134888, 422213010,  2796674561, 3568250500, 2736237915,
            3950756060, 1527249993, 3603540278, 4115393386, 2851621193, 4230341156, 905168850,
            3916344126, 1496013046, 206343742,  2894205125, 1082918859, 2746480417, 3077328661,
            1209440053, 3258293856, 1032236533, 3043332566, 446879604,  587022214,  1614371566,
            3040899994, 3686422145, 937325128,  1968833679, 169086151,  4075432555, 1196046411,
            3101745581, 4228079966, 2942213563, 1195005323, 1673491641, 1762746534, 3641827252,
            694590905,  1828365460, 513716230,  3106485486, 2441593994, 4044462965, 3628121101,
            3957990629, 179764922,  579361186,  3474393871, 2474241006, 4031850878, 3120409532,
            4011587898, 3682942579, 3257272830, 3097029759, 2652540191, 1128762588, 1040256382,
            2743736716, 334893087,  1892049031, 2603159239, 3712772023, 2126593224, 3465793906,
            3180780589, 725740783,  3728108967, 573931936,  137996587,  110756053,  3984787930,
            3773232816, 3406981985, 1783088630, 2080089781, 195827466,  1409073281, 867635355,
            3049533211, 486687054,  2570137956, 527522011,  1084454084, 1019222771, 1415565066,
            650794786,  629618803,  1237709131, 1241899078, 2751644247, 2792313337, 649402117,
            275078659,  752459111,  2173220853, 3207031798, 821073585,  3005400729, 1085152012,
            2441935114, 3465447683, 2897229686, 3845380309, 3573898488, 495424232,  2490548037,
            581670528,  2467171733, 1208279791, 2163927790, 3895792830, 2097210789, 1606544633,
            2148733343, 4072525389, 3256142090, 349440478,  3920932491, 657289255,  1075951496,
            2835763703, 1593198055, 2380945625, 149487931,  3182766507, 2927484354, 2877470578,
            4153923603, 606130344,  1168544900, 888955615,  3605412824, 1336677864, 53448770,
            2884036014, 4070749843, 2989661773, 1095584023, 2766144383, 3534389580, 312378113,
            3190819203, 1247574926, 1530609481, 3536918510, 1479030180, 847820646,  3992973956,
            154171325,  4113429617, 3504933502, 295000614,  2238923504, 282708664,  290246351,
            1064210816, 2848539559, 2617134888, 36906646,   2796674561, 3568250500, 2736237915,
            3950756060, 3416260072, 3603540278, 4115393386, 2851621193, 4230341156, 448215287,
            3916344126, 1496013046, 206343742,  2894205125, 2420861244, 2746480417, 3077328661,
            1209440053, 3258293856, 2545287695, 3043332566, 446879604,  587022214,  1614371566,
            958587333,  3686422145, 937325128,  1968833679, 169086151,  154576725,  1196046411,
            3101745581, 4228079966, 2942213563, 2487464668, 1673491641, 1762746534, 3641827252,
            694590905,  3754606623, 513716230,  3106485486, 2441593994, 4044462965, 3064108377,
            3957990629, 179764922,  579361186,  3474393871, 2138270428, 4031850878, 3120409532,
            4011587898, 3682942579, 4015980199, 3097029759, 2652540191, 1128762588, 1040256382,
            3908621649, 334893087,  1892049031, 2603159239, 3712772023, 3291038350, 3465793906,
            3180780589, 725740783,  3728108967, 436976908,  137996587,  110756053,  3984787930,
            3773232816, 1000054791, 1783088630, 2080089781, 195827466,  1409073281, 3036813614,
            3049533211, 486687054,  2570137956, 527522011,  3669951690, 1019222771, 1415565066,
            650794786,  629618803,  4140569538, 1241899078, 2751644247, 2792313337, 649402117,
            2946582304, 752459111,  2173220853, 3207031798, 821073585,  1738142977, 1085152012,
            2441935114, 3465447683, 2897229686, 2707197334, 3573898488, 495424232,  2490548037,
            581670528,  2365865647, 1208279791, 2163927790, 3895792830, 2097210789, 3219551420,
            2148733343, 4072525389, 3256142090, 349440478,  3706519197, 657289255,  1075951496,
            2835763703, 1593198055, 2200084531, 149487931,  3182766507, 2927484354, 2877470578,
            2394288661, 606130344,  1168544900, 888955615,  3605412824, 1503975597, 53448770,
            2884036014, 4070749843, 2989661773, 243605110,  2766144383, 3534389580, 312378113,
            3190819203, 2398088088, 1530609481, 3536918510, 1479030180, 847820646,  2940281320,
            154171325,  4113429617, 3504933502, 295000614,  3078701806, 282708664,  290246351,
            1064210816, 2848539559, 3960345380, 36906646,   2796674561, 3568250500, 2736237915,
            2657034787, 3416260072, 3603540278, 4115393386, 2851621193, 3847740427, 448215287,
            3916344126, 1496013046, 206343742,  3419083433, 2420861244, 2746480417, 3077328661,
            1209440053, 3824237152, 2545287695, 3043332566, 446879604,  587022214,  506352928,
            958587333,  3686422145, 937325128,  1968833679, 1808935939, 154576725,  1196046411,
            3101745581, 4228079966, 709576348,  2487464668, 1673491641, 1762746534, 3641827252,
            3968332142, 3754606623, 513716230,  3106485486, 2441593994, 1453443785, 3064108377,
            3957990629, 179764922,  579361186,  1454621561, 2138270428, 4031850878, 3120409532,
            4011587898, 898119245,  4015980199, 3097029759, 2652540191, 1128762588, 1131456853,
            3908621649, 334893087,  1892049031, 2603159239, 4280222837, 3291038350, 3465793906,
            3180780589, 725740783,  1515867399, 436976908,  137996587,  110756053,  3984787930,
            1295994548, 1000054791, 1783088630, 2080089781, 195827466,  252558267,  3036813614,
            3049533211, 486687054,  2570137956, 786434419,  3669951690, 1019222771, 1415565066,
            650794786,  1316734597, 4140569538, 1241899078, 2751644247, 2792313337, 4014748337,
            2946582304, 752459111,  2173220853, 3207031798, 2903407363, 1738142977, 1085152012,
            2441935114, 3465447683, 1082984764, 2707197334, 3573898488, 495424232,  2490548037,
            240094068,  2365865647, 1208279791, 2163927790, 3895792830, 1107651215, 3219551420,
            2148733343, 4072525389, 3256142090, 681942656,  3706519197, 657289255,  1075951496,
            2835763703, 2172774506, 2200084531, 149487931,  3182766507, 2927484354, 3069592433,
            2394288661, 606130344,  1168544900, 888955615,  757163746,  1503975597, 53448770,
            2884036014, 4070749843, 1705538727, 243605110,  2766144383, 3534389580, 312378113,
            2256467250, 2398088088, 1530609481, 3536918510, 1479030180, 1360826079, 2940281320,
            154171325,  4113429617, 3504933502, 714934244,  3078701806, 282708664,  290246351,
            1064210816, 3694453051, 3960345380, 36906646,   2796674561, 3568250500, 3400481963,
            2657034787, 3416260072, 3603540278, 4115393386, 1466632735, 3847740427, 448215287,
            3916344126, 1496013046, 2893537514, 3419083433, 2420861244, 2746480417, 3077328661,
            2815979224, 3824237152, 2545287695, 3043332566, 446879604,  3719452721, 506352928,
            958587333,  3686422145, 937325128,  2653904510, 1808935939, 154576725,  1196046411,
            3101745581, 425411544,  709576348,  2487464668, 1673491641, 1762746534, 1960605594,
            3968332142, 3754606623, 513716230,  3106485486, 2881551071, 1453443785, 3064108377,
            3957990629, 179764922,  1408218536, 1454621561, 2138270428, 4031850878, 3120409532,
            3700386494, 898119245,  4015980199, 3097029759, 2652540191, 2181464767, 1131456853,
            3908621649, 334893087,  1892049031, 4220220071, 4280222837, 3291038350, 3465793906,
            3180780589, 1737123182, 1515867399, 436976908,  137996587,  110756053,  1360813614,
            1295994548, 1000054791, 1783088630, 2080089781, 1019367341, 252558267,  3036813614,
            3049533211, 486687054,  387915679,  786434419,  3669951690, 1019222771, 1415565066,
            4267042909, 1316734597, 4140569538, 1241899078, 2751644247, 3622120385, 4014748337,
            2946582304, 752459111,  2173220853, 1128460687, 2268047031, 239933818,  4141570430,
            1318816940, 2378987660, 731877825,  3950952879, 2975574698, 2938375136, 431933385,
            154404673,  2020658234, 846815781,  822137193,  1057315444, 3632584082, 3263363094,
            942201956,  2704683551, 1768107067, 4009446092, 3090701064, 701246680,  3548419575,
            3873366129, 1639833080, 2401253373, 66597794,   2515774132, 516246524,  4232115668,
            34426096,   2206423458, 3628832867, 2776950121, 2782943544, 2058958317, 1805852726,
            2151415233, 2940074103, 2318397273, 3067676663, 3127709351, 71509976,   115529187,
            1841252918, 2217805156, 733917373,  2432474677, 1416887641, 1895320369, 2779694586,
            510547269,  2614743018, 759552691,  2264773752, 305497497,  1082013785, 1681067734,
            1085957001, 846460632,  2824079919, 1820633139, 3686495295, 3978521319, 1734452426,
            4105472656, 1771256166, 1578071897, 1972844727, 2048372515, 3002132226, 1889169118,
            2932142799, 2166712623, 592016143,  1116895096, 889321536,  375621825,  2935845994,
            1982459859, 3336799370, 294519309,  2661638345, 1089335942, 227150969,  1454919198,
            3780503305, 1862290968, 1491836299, 766546986,  3638407467, 925906735,  208891816,
            236714698,  2853181150, 3889751556, 2161215392, 853579433,  2131555681, 1396396345,
            1088128136, 978252562,  2134024308, 2429920974, 1159468871, 2395949266, 1441791888,
            916521377,  3950270431, 2663319810, 3873120593, 2080989388, 2896532502, 3176181708,
            1736685126, 4081767288, 3515770288, 1371473598, 1491850178, 4284949727, 2774513541,
            1541596000, 3948112869, 2114538326, 2641532252, 1837244955, 2292505300, 3179787565,
            639953781,  785902378,  3852544833, 553508260,  23014564,   106722100,  2705412979,
            3449440367, 950636401,  870804158,  629831074,  424163855,  373653940,  2739378330,
            377730945,  418426029,  267367218,  554678849,  4222664331, 3346048120, 1870226737,
            2435616108, 3747040233, 698046507,  1671346285, 4127293033, 568612264,  3467142937,
            1627988025, 1305525598,
        },
        {
            2246605826, 215030128,  871645668,  3402612852, 423273439,  316965236,  47416561,
            1470716454, 2288582385, 2021890755, 2148091363, 167227868,  3085506034, 3365950545,
            1170282137, 1345986409, 197195155,  2644113318, 2491271090, 2597072003, 170335901,
            2540851884, 2584420407, 3609142920, 3052130502, 4018095157, 2850805299, 2777821400,
            110647395,  3262987676, 1447103309, 3632575579, 3243210595, 1892770504, 4214485953,
            38676169,   2431628817, 2836918800, 272023527,  2825888902, 2794421955, 2354379386,
            452404203,  584718212,  1915053836, 1455821656, 4264066935, 1150980581, 3792433350,
            3104909316, 441521402,  3807587668, 275969953,  3970844623, 3323695518, 3909107329,
            290225599,  957520066,  4048181850, 2623778463, 1957371891, 540091753,  3072448879,
            2386916346, 392549194,  1261391184, 4137605148, 314807135,  2916930821, 3168561018,
            2332027308, 1967082817, 1849256214, 1141134412, 1206824012, 2088102210, 4170914605,
            3399892824, 59190648,   1657183299, 1314626253, 500606287,  413229420,  1245395908,
            664681,     2726979120, 3408998445, 2318397638, 1882820077, 2073055266, 4262833629,
            1348801932, 229857331,  3086071450, 1327801028, 812015573,  2214355282, 2232635690,
            3162540418, 2049877621, 470752564,  2527480795, 1285499716, 220173566,  4239277569,
            788168494,  3748855859, 1360707769, 449512212,  1238219398, 2880205975, 2755133627,
            372409230,  411800575,  2455333195, 4080817864, 3556684908, 2857940866, 1969081563,
            2526852668, 1026062474, 1849785784, 3552290093, 4214448,    460332681,  30890894,
            1108618048, 272438799,  3339891045, 1512685591, 1310038443, 2431938882, 1478442144,
            2804640700, 3426381347, 861206186,  290322827,  2736623609, 327318125,  1922859957,
            1939922519, 3539608908, 3442377433, 3868710131, 2244493875, 47774461,   3858864626,
            3294523981, 1798515481, 565017248,  2633378137, 811307482,  1743357106, 419676111,
            1688841846, 1799884674, 1720546272, 3900863156, 3506303345, 1719438472, 576775454,
            2246605826, 215030128,  871645668,  3402612852, 619000856,  316965236,  47416561,
            1470716454, 2288582385, 3464704266, 2148091363, 167227868,  3085506034, 3365950545,
            901169164,  1345986409, 197195155,  2644113318, 2491271090, 3243741640, 170335901,
            2540851884, 2584420407, 3609142920, 2051834116, 4018095157, 2850805299, 2777821400,
            110647395,  2822981113, 1447103309, 3632575579, 3243210595, 1892770504, 1947501555,
            38676169,   2431628817, 2836918800, 272023527,  4010280501, 2794421955, 2354379386,
            452404203,  584718212,  3991257933, 1455821656, 4264066935, 1150980581, 3792433350,
            2151631692, 441521402,  3807587668, 275969953,  3970844623, 3965914153, 3909107329,
            290225599,  957520066,  4048181850, 4011285909, 1957371891, 540091753,  3072448879,
            2386916346, 1347453316, 1261391184, 4137605148, 314807135,  2916930821, 840822698,
            2332027308, 1967082817, 1849256214, 1141134412, 960593185,  2088102210, 4170914605,
            3399892824, 59190648,   2261593014, 1314626253, 500606287,  413229420,  1245395908,
            3401527918, 2726979120, 3408998445, 2318397638, 1882820077, 1683077666, 4262833629,
            1348801932, 229857331,  3086071450, 3363644507, 812015573,  2214355282, 2232635690,
            3162540418, 3579858747, 470752564,  2527480795, 1285499716, 220173566,  2294101261,
            788168494,  3748855859, 1360707769, 449512212,  28595866,   2880205975, 2755133627,
            372409230,  411800575,  1905311140, 4080817864, 3556684908, 2857940866, 1969081563,
            148561593,  1026062474, 1849785784, 3552290093, 4214448,    2237247821, 30890894,
            1108618048, 272438799,  3339891045, 169576507,  1310038443, 2431938882, 1478442144,
            2804640700, 4119485855, 861206186,  290322827,  2736623609, 327318125,  3408620608,
            1939922519, 3539608908, 3442377433, 3868710131, 1188056275, 47774461,   3858864626,
            3294523981, 1798515481, 1228896851, 2633378137, 811307482,  1743357106, 419676111,
            3111013241, 1799884674, 1720546272, 3900863156, 3506303345, 1474164586, 576775454,
            2246605826, 215030128,  871645668,  2968519387, 619000856,  316965236,  47416561,
            1470716454, 9648980,    3464704266, 2148091363, 167227868,  3085506034, 1505294373,
            901169164,  1345986409, 197195155,  2644113318, 1227359150, 3243741640, 170335901,
            2540851884, 2584420407, 1205921163, 2051834116, 4018095157, 2850805299, 2777821400,
            2967529310, 2822981113, 1447103309, 3632575579, 3243210595, 532996977,  1947501555,
            38676169,   2431628817, 2836918800, 1761031313, 4010280501, 2794421955, 2354379386,
            452404203,  1222630846, 3991257933, 1455821656, 4264066935, 1150980581, 2344548386,
            2151631692, 441521402,  3807587668, 275969953,  963889269,  3965914153, 3909107329,
            290225599,  957520066,  4176220201, 4011285909, 1957371891, 540091753,  3072448879,
            1810164615, 1347453316, 1261391184, 4137605148, 314807135,  2672526663, 840822698,
            2332027308, 1967082817, 1849256214, 734862208,  960593185,  2088102210, 4170914605,
            3399892824, 2471507530, 2261593014, 1314626253, 500606287,  413229420,  970185057,
            3401527918, 2726979120, 3408998445, 2318397638, 708987193,  1683077666, 4262833629,
            1348801932, 229857331,  749849397,  3363644507, 812015573,  2214355282, 2232635690,
            2901095495, 3579858747, 470752564,  2527480795, 1285499716, 941862108,  2294101261,
            788168494,  3748855859, 1360707769, 3818227212, 28595866,   2880205975, 2755133627,
            372409230,  570110534,  1905311140, 4080817864, 3556684908, 2857940866, 2253777974,
            148561593,  1026062474, 1849785784, 3552290093, 1525559608, 2237247821, 30890894,
            1108618048, 272438799,  3996203631, 169576507,  1310038443, 2431938882, 1478442144,
            2857841871, 4119485855, 861206186,  290322827,  2736623609, 1184217272, 3408620608,
            1939922519, 3539608908, 3442377433, 1263700272, 1188056275, 47774461,   3858864626,
            3294523981, 2611619,    1228896851, 2633378137, 811307482,  1743357106, 1930089302,
            3111013241, 1799884674, 1720546272, 3900863156, 2370003471, 1474164586, 576775454,
            2246605826, 215030128,  540197019,  2968519387, 619000856,  316965236,  47416561,
            3585128733, 9648980,    3464704266, 2148091363, 167227868,  509283324,  1505294373,
            901169164,  1345986409, 197195155,  3983525470, 1227359150, 3243741640, 170335901,
            2540851884, 2812935262, 1205921163, 2051834116, 4018095157, 2850805299, 2798430304,
            2967529310, 2822981113, 1447103309, 3632575579, 389184524,  532996977,  1947501555,
            38676169,   2431628817, 1055068556, 1761031313, 4010280501, 2794421955, 2354379386,
            965687576,  1222630846, 3991257933, 1455821656, 4264066935, 1551000086, 2344548386,
            2151631692, 441521402,  3807587668, 3701529910, 963889269,  3965914153, 3909107329,
            290225599,  1771599976, 4176220201, 4011285909, 1957371891, 540091753,  1670159873,
            1810164615, 1347453316, 1261391184, 4137605148, 4191698993, 2672526663, 840822698,
            2332027308, 1967082817, 3098515331, 734862208,  960593185,  2088102210, 4170914605,
            2470055060, 2471507530, 2261593014, 1314626253, 500606287,  1100764382, 970185057,
            3401527918, 2726979120, 3408998445, 4100198161, 708987193,  1683077666, 4262833629,
            1348801932, 3744209503, 749849397,  3363644507, 812015573,  2214355282, 3217409412,
            2901095495, 3579858747, 470752564,  2527480795, 552979949,  941862108,  2294101261,
            788168494,  3748855859, 2355231228, 3818227212, 28595866,   2880205975, 2755133627,
            833553378,  570110534,  1905311140, 4080817864, 3556684908, 4124102038, 2253777974,
            148561593,  1026062474, 1849785784, 656329297,  1525559608, 2237247821, 30890894,
            1108618048, 1464443032, 3996203631, 169576507,  1310038443, 2431938882, 2100788071,
            2857841871, 4119485855, 861206186,  290322827,  3653047356, 1184217272, 3408620608,
            1939922519, 3539608908, 4267170500, 1263700272, 1188056275, 47774461,   3858864626,
            1046565728, 2611619,    1228896851, 2633378137, 811307482,  1312393456, 1930089302,
            3111013241, 1799884674, 1720546272, 1199041144, 2406753856, 2108495166, 2126345981,
            1524975128, 1269232392, 3162531748, 3076707658, 1736955170, 1036221745, 1232435193,
            3945348482, 1057631163, 520376289,  4154435769, 1280565077, 1865705876, 1030078366,
            1140849319, 1769263412, 1161866807, 2768552980, 561022685,  2712685799, 1501252058,
            3608433719, 3138564149, 4093654128, 1218455911, 892700607,  2012017510, 3568315757,
            4002239824, 1754440379, 2641708101, 1027390781, 199831087,  1261208885, 2058433786,
            2101649235, 220966013,  3445375335, 1100438514, 4075559840, 4244062658, 3417249884,
            150102478,  3337395219, 2464869101, 3720375949, 93353579,   2329780067, 777826834,
            2745626035, 2984812746, 568848158,  1593919595, 1166619196, 96177504,   305329591,
            4271176854, 3829149188, 1551058535, 2828280993, 1367551996, 4208083082, 2260803683,
            3118708147, 434935608,  702805370,  3544156958, 792712531,  231019757,  136272259,
            4049968615, 2722527811, 603697698,  2891035509, 4270409302, 1220615076, 1932569338,
            1084454986, 468729683,  2377913518, 2068946556, 530579176,  1422294615, 4032799503,
            2065706770, 604700228,  98049660,   3182511353, 935830212,  1938107848, 1266035034,
            957505506,  2758220503, 1805223938, 3393041584, 3958541336, 2695487012, 3355668819,
            276889675,  3098939423, 415941187,  180737121,  2638873657, 1103150707, 4255168358,
            2736183195, 1275942292, 2687807236, 538129710,  3337005391, 3941968393, 1113153386,
            3813628384, 1775835369, 296314749,  1697642748, 3614403315, 1953056095, 2102878063,
            3161706344, 2207159580, 3078233525, 3836286614, 886914072,  1884037075, 4135819784,
            1616380780, 1672616998, 3879848699, 2277472209, 3933249848, 2428044648, 2876076879,
            165724720,  2277165385, 1984963196, 1456923194, 2406217222, 3388886718, 47522558,
            1903557801, 1959641458, 2325355446, 3251147398, 2266553941, 2243962024, 1420017618,
            1791159474, 1793406225, 601509698,  3207357979, 1189285184, 148538800,  2077251302,
            3267239327, 2851475997,
        },
        {
            2628162153, 3861478870, 2769884494, 3423483820, 1118276924, 536776894,  3742490940,
            550084334,  2441329856, 2604618499, 2308745810, 1178166365, 1345165241, 4039508109,
            1246601384, 3843182157, 2200144237, 91750284,   4290064840, 3363597477, 3243492274,
            4271100308, 4186328336, 2291901989, 1834723222, 372220743,  2190417067, 2624886324,
            3567647862, 1591175369, 2278087682, 2461678432, 232820452,  2714694382, 3070258434,
            2412655444, 2667664607, 249083056,  4166379751, 1360927521, 2247816079, 3253689753,
            1563674427, 1914999382, 2101454952, 1067816947, 1098201917, 4054175236, 1805828534,
            1815913104, 738357340,  2597170030, 1689737432, 2004663483, 1160995461, 1008175050,
            2004702919, 4258654415, 938972594,  2121583885, 2208729114, 276726877,  3973538591,
            2991069145, 2345655326, 2980162173, 1915611444, 2332104940, 2382102873, 2324437093,
            2640563452, 2680619359, 3413490949, 2140843463, 2424016743, 3735508133, 3421831326,
            4037977349, 3721506282, 510431975,  1014707294, 1378686477, 1939678832, 2223101760,
            2067687989, 309274614,  276596103,  3757624719, 1212251468, 2649271847, 4140361758,
            2634738350, 2029358730, 3205861896, 3090549771, 3775019657, 2018542036, 3675805680,
            3946144023, 331655838,  326568491,  1867863527, 1550945400, 3087000670, 2342003578,
            3949479453, 586483056,  147951307,  503062740,  3823927166, 2789767841, 3121654578,
            634238762,  4084629478, 3878778788, 435990088,  1724770389, 1403031256, 1334135626,
            1096780503, 3288769545, 2793293893, 80675548,   1637232257, 1856565474, 2675485635,
            1961165681, 1647512786, 4190102851, 4081320784, 2853183400, 3812341867, 278236392,
            1700614299, 2765246084, 3846866009, 1220806787, 3655684157, 1133921183, 2779125219,
            523552281,  703813725,  3110126767, 823843890,  290243102,  821297176,  364959993,
            3381862130, 2305271841, 356059263,  2558018765, 3235968999, 1070598970, 2444411636,
            3636221117, 4275517214, 4035198865, 3339014315, 2911872812, 4049586122, 4211583637,
            2628162153, 3861478870, 2769884494, 3423483820, 3254616321, 536776894,  3742490940,
            550084334,  2441329856, 1909596092, 2308745810, 1178166365, 1345165241, 4039508109,
            1349347043, 3843182157, 2200144237, 91750284,   4290064840, 803098068,  3243492274,
            4271100308, 4186328336, 2291901989, 2575673198, 372220743,  2190417067, 2624886324,
            3567647862, 132569424,  2278087682, 2461678432, 232820452,  2714694382, 3490648253,
            2412655444, 2667664607, 249083056,  4166379751, 3503294711, 2247816079, 3253689753,
            1563674427, 1914999382, 3121933565, 1067816947, 1098201917, 4054175236, 1805828534,
            816420552,  738357340,  2597170030, 1689737432, 2004663483, 397934907,  1008175050,
            2004702919, 4258654415, 938972594,  156733019,  2208729114, 276726877,  3973538591,
            2991069145, 2470446383, 2980162173, 1915611444, 2332104940, 2382102873, 3265195583,
            2640563452, 2680619359, 3413490949, 2140843463, 142464483,  3735508133, 3421831326,
            4037977349, 3721506282, 1898668265, 1014707294, 1378686477, 1939678832, 2223101760,
            4085776926, 309274614,  276596103,  3757624719, 1212251468, 1116423339, 4140361758,
            2634738350, 2029358730, 3205861896, 880658361,  3775019657, 2018542036, 3675805680,
            3946144023, 839516623,  326568491,  1867863527, 1550945400, 3087000670, 420309880,
            3949479453, 586483056,  147951307,  503062740,  416618471,  2789767841, 3121654578,
            634238762,  4084629478, 1120413065, 435990088,  1724770389, 1403031256, 1334135626,
            240966420,  3288769545, 2793293893, 80675548,   1637232257, 1785064235, 2675485635,
            1961165681, 1647512786, 4190102851, 2775407492, 2853183400, 3812341867, 278236392,
            1700614299, 2439624528, 3846866009, 1220806787, 3655684157, 1133921183, 366933679,
            523552281,  703813725,  3110126767, 823843890,  132468066,  821297176,  364959993,
            3381862130, 2305271841, 1048450041, 2558018765, 3235968999, 1070598970, 2444411636,
            1699430013, 4275517214, 4035198865, 3339014315, 2911872812, 324524850,  4211583637,
            2628162153, 3861478870, 2769884494, 1995585079, 3254616321, 536776894,  3742490940,
            550084334,  2121458511, 1909596092, 2308745810, 1178166365, 1345165241, 3067877274,
            1349347043, 3843182157, 2200144237, 91750284,   1246148630, 803098068,  3243492274,
            4271100308, 4186328336, 2932236493, 2575673198, 372220743,  2190417067, 2624886324,
            3945294599, 132569424,  2278087682, 2461678432, 232820452,  3341915918, 3490648253,
            2412655444, 2667664607, 249083056,  2307336284, 3503294711, 2247816079, 3253689753,
            1563674427, 1717494311, 3121933565, 1067816947, 1098201917, 4054175236, 971917867,
            816420552,  738357340,  2597170030, 1689737432, 243915062,  397934907,  1008175050,
            2004702919, 4258654415, 1807067458, 156733019,  2208729114, 276726877,  3973538591,
            1909483753, 2470446383, 2980162173, 1915611444, 2332104940, 3454651559, 3265195583,
            2640563452, 2680619359, 3413490949, 462852932,  142464483,  3735508133, 3421831326,
            4037977349, 1372088341, 1898668265, 1014707294, 1378686477, 1939678832, 752503486,
            4085776926, 309274614,  276596103,  3757624719, 4193030119, 1116423339, 4140361758,
            2634738350, 2029358730, 1725105892, 880658361,  3775019657, 2018542036, 3675805680,
            3496508290, 839516623,  326568491,  1867863527, 1550945400, 2685835387, 420309880,
            3949479453, 586483056,  147951307,  1639139280, 416618471,  2789767841, 3121654578,
            634238762,  3622035469, 1120413065, 435990088,  1724770389, 1403031256, 3548817929,
            240966420,  3288769545, 2793293893, 80675548,   3119506726, 1785064235, 2675485635,
            1961165681, 1647512786, 4019542081, 2775407492, 2853183400, 3812341867, 278236392,
            3487875111, 2439624528, 3846866009, 1220806787, 3655684157, 3303554633, 366933679,
            523552281,  703813725,  3110126767, 2477354049, 132468066,  821297176,  364959993,
            3381862130, 4065162466, 1048450041, 2558018765, 3235968999, 1070598970, 191819556,
            1699430013, 4275517214, 4035198865, 3339014315, 3588518026, 324524850,  4211583637,
            2628162153, 3861478870, 3361198093, 1995585079, 3254616321, 536776894,  3742490940,
            3912424229, 2121458511, 1909596092, 2308745810, 1178166365, 1882174246, 3067877274,
            1349347043, 3843182157, 2200144237, 1210030640, 1246148630, 803098068,  3243492274,
            4271100308, 402141998,  2932236493, 2575673198, 372220743,  2190417067, 1883679642,
            3945294599, 132569424,  2278087682, 2461678432, 708189294,  3341915918, 3490648253,
            2412655444, 2667664607, 2871800434, 2307336284, 3503294711, 2247816079, 3253689753,
            2113837945, 1717494311, 3121933565, 1067816947, 1098201917, 1041869160, 971917867,
            816420552,  738357340,  2597170030, 2306273930, 243915062,  397934907,  1008175050,
            2004702919, 2345434637, 1807067458, 156733019,  2208729114, 276726877,  2452083872,
            1909483753, 2470446383, 2980162173, 1915611444, 2043489400, 3454651559, 3265195583,
            2640563452, 2680619359, 2845757473, 462852932,  142464483,  3735508133, 3421831326,
            25103542,   1372088341, 1898668265, 1014707294, 1378686477, 2680788341, 752503486,
            4085776926, 309274614,  276596103,  3663266970, 4193030119, 1116423339, 4140361758,
            2634738350, 453005903,  1725105892, 880658361,  3775019657, 2018542036, 2601909713,
            3496508290, 839516623,  326568491,  1867863527, 3474340574, 2685835387, 420309880,
            3949479453, 586483056,  297934218,  1639139280, 416618471,  2789767841, 3121654578,
            958889718,  3622035469, 1120413065, 435990088,  1724770389, 2589603756, 3548817929,
            240966420,  3288769545, 2793293893, 972899860,  3119506726, 1785064235, 2675485635,
            1961165681, 2576799764, 4019542081, 2775407492, 2853183400, 3812341867, 159345352,
            3487875111, 2439624528, 3846866009, 1220806787, 3367080935, 3303554633, 366933679,
            523552281,  703813725,  1717395617, 2477354049, 132468066,  821297176,  364959993,
            1088290332, 4065162466, 1048450041, 2558018765, 3235968999, 285340039,  191819556,
            1699430013, 4275517214, 4035198865, 3544133220, 285121978,  1175302919, 4101282768,
            513236580,  890655666,  3051849972, 2315486379, 3067287276, 3134806925, 3926373006,
            2502825498, 461387883,  770459119,  3121636621, 1243065093, 1612354797, 659033930,
            621176955,  214256518,  371573588,  1168438671, 1233027650, 1984255965, 659404177,
            1218841419, 1226193512, 4247589702, 334814687,  980422670,  2518384561, 4041002302,
            1203659320, 509643440,  2528499450, 1512213710, 4052651069, 1378025938, 3436277168,
            2797728577, 463383787,  1184681947, 283482187,  2421891582, 3200080903, 373817869,
            452807139,  2002545143, 1068199574, 3390998240, 377559317,  1548403713, 1580741080,
            253591624,  759280679,  2174360733, 1687952097, 1325235423, 3856575909, 652218568,
            4130230594, 3757998028, 1349431618, 2870775414, 229741978,  1900794007, 201310771,
            4075023260, 3390078853, 3572716207, 1959949436, 1000128498, 1636575064, 241058867,
            2075461870, 1819342070, 619233032,  3164328001, 4280892071, 4219074185, 2719764611,
            3827656652, 4062556527, 621515766,  2542375627, 3901998596, 2295087430, 2880672054,
            2940372823, 2318642706, 914614262,  2549699597, 2907475284, 3901259809, 2663167002,
            3775306719, 2212887565, 1271873285, 3673659531, 3856609875, 1195785209, 1204338358,
            2785362544, 2398696803, 3038377816, 4288025143, 262511310,  4151907455, 924716723,
            3298769960, 2065938273, 3277412030, 122636766,  2164055077, 1000638739, 2044933533,
            2935604716, 2772787255, 3727331409, 1315627932, 2610657438, 832931652,  452359900,
            681035792,  3312648046, 1059435047, 1489639114, 3647631796, 417952902,  731020350,
            2847472725, 2779076784, 2674295324, 487600023,  2925909449, 3997011591, 3697231318,
            967300591,  2310856069, 684710043,  811911286,  4174732177, 1010656728, 702780279,
            920081774,  1578296057, 944734808,  2884038169, 2885919611, 2633474915, 2508946673,
            3579216621, 656143887,  426108406,  2166202683, 991797657,  706498590,  561168186,
            1144619335, 3136206425,
        },
        {
            3600072515, 651444872,  2348224675, 1684848433, 1913333701, 3413467790, 1567802204,
            2125206188, 2463158656, 2251055204, 4132590383, 3192977084, 3718261822, 3431519430,
            3506690867, 1313208797, 637811069,  12802085,   3456408080, 166617386,  1764224523,
            4016338923, 2225367442, 2461647273, 3137989854, 373730087,  3013524828, 242949418,
            3443491410, 3671816408, 2391000148, 3964107377, 716535366,  1884597979, 3917515811,
            3441985401, 2472173593, 4034695117, 2486526143, 1658764329, 1873516415, 884116165,
            814992460,  1069506245, 3797556389, 838088473,  2279863068, 1002637017, 4174541774,
            644478743,  4138151954, 4030442072, 297710349,  3507828614, 1403493362, 3132267322,
            227377796,  388148240,  2760904473, 352998924,  1603734504, 1528807885, 2283620218,
            737730350,  2761342715, 809367801,  1667936422, 1510238771, 3762862328, 1171532060,
            647580587,  1460988169, 3944640945, 2331043627, 1965076564, 2913596196, 2960957119,
            1316491503, 3086954934, 3471945989, 2485431762, 692294537,  3148362914, 3371415765,
            2990795967, 706771848,  3734467362, 2768750385, 2061275631, 3935582473, 1449841372,
            1239527551, 592595530,  1685341001, 3352323357, 4147988039, 4003871917, 4035869533,
            3022833195, 1266052547, 1429645393, 565106475,  327014810,  348739711,  3262918351,
            915509292,  397356303,  3248246752, 1122821778, 2373765260, 1795464380, 3485315196,
            1731529670, 86888382,   2789587372, 850847993,  1794523220, 577288126,  1996569530,
            909222664,  2601642298, 1469035973, 2727135938, 3467853736, 633292505,  756260381,
            41782389,   226724724,  3633968708, 1695315503, 1846857904, 3185630605, 823108172,
            3609336496, 3422558797, 2865413534, 564221408,  591845835,  2498463433, 3573926554,
            1336639597, 4180084026, 3195588503, 2822864841, 1916459886, 2073158796, 56968669,
            1234765864, 2456093821, 3500058416, 3146725645, 3295822468, 4135196531, 628000231,
            745509757,  4143543278, 1941480444, 3607603517, 2288239329, 1991437813, 4081693775,
            3600072515, 651444872,  2348224675, 1684848433, 3748890341, 3413467790, 1567802204,
            2125206188, 2463158656, 1516568259, 4132590383, 3192977084, 3718261822, 3431519430,
            461466951,  1313208797, 637811069,  12802085,   3456408080, 3444149988, 1764224523,
            4016338923, 2225367442, 2461647273, 2594402002, 373730087,  3013524828, 242949418,
            3443491410, 2740782133, 2391000148, 3964107377, 716535366,  1884597979, 3161911677,
            3441985401, 2472173593, 4034695117, 2486526143, 3623045141, 1873516415, 884116165,
            814992460,  1069506245, 1053106195, 838088473,  2279863068, 1002637017, 4174541774,
            1806935386, 4138151954, 4030442072, 297710349,  3507828614, 2328331779, 3132267322,
            227377796,  388148240,  2760904473, 3654577129, 1603734504, 1528807885, 2283620218,
            737730350,  2134741424, 809367801,  1667936422, 1510238771, 3762862328, 4084104273,
            647580587,  1460988169, 3944640945, 2331043627, 3458437694, 2913596196, 2960957119,
            1316491503, 3086954934, 2404530503, 2485431762, 692294537,  3148362914, 3371415765,
            3697728317, 706771848,  3734467362, 2768750385, 2061275631, 1337146928, 1449841372,
            1239527551, 592595530,  1685341001, 3121493408, 4147988039, 4003871917, 4035869533,
            3022833195, 2709537023, 1429645393, 565106475,  327014810,  348739711,  1278935671,
            915509292,  397356303,  3248246752, 1122821778, 1086107506, 1795464380, 3485315196,
            1731529670, 86888382,   3645735256, 850847993,  1794523220, 577288126,  1996569530,
            1126950,    2601642298, 1469035973, 2727135938, 3467853736, 3668777652, 756260381,
            41782389,   226724724,  3633968708, 738274780,  1846857904, 3185630605, 823108172,
            3609336496, 3371270228, 2865413534, 564221408,  591845835,  2498463433, 4157618574,
            1336639597, 4180084026, 3195588503, 2822864841, 3844986377, 2073158796, 56968669,
            1234765864, 2456093821, 1001761927, 3146725645, 3295822468, 4135196531, 628000231,
            541676954,  4143543278, 1941480444, 3607603517, 2288239329, 1068806322, 4081693775,
            3600072515, 651444872,  2348224675, 47991343,   3748890341, 3413467790, 1567802204,
            2125206188, 2662653600, 1516568259, 4132590383, 3192977084, 3718261822, 2554440323,
            461466951,  1313208797, 637811069,  12802085,   982676468,  3444149988, 1764224523,
            4016338923, 2225367442, 451503008,  2594402002, 373730087,  3013524828, 242949418,
            1086137206, 2740782133, 2391000148, 3964107377, 716535366,  731470002,  3161911677,
            3441985401, 2472173593, 4034695117, 44456710,   3623045141, 1873516415, 884116165,
            814992460,  4004771121, 1053106195, 838088473,  2279863068, 1002637017, 1587145121,
            1806935386, 4138151954, 4030442072, 297710349,  2570695340, 2328331779, 3132267322,
            227377796,  388148240,  3570998746, 3654577129, 1603734504, 1528807885, 2283620218,
            188017185,  2134741424, 809367801,  1667936422, 1510238771, 1503613101, 4084104273,
            647580587,  1460988169, 3944640945, 3301866374, 3458437694, 2913596196, 2960957119,
            1316491503, 2674694926, 2404530503, 2485431762, 692294537,  3148362914, 1645995464,
            3697728317, 706771848,  3734467362, 2768750385, 670964862,  1337146928, 1449841372,
            1239527551, 592595530,  4204421245, 3121493408, 4147988039, 4003871917, 4035869533,
            3652555523, 2709537023, 1429645393, 565106475,  327014810,  2716443687, 1278935671,
            915509292,  397356303,  3248246752, 204830047,  1086107506, 1795464380, 3485315196,
            1731529670, 662578255,  3645735256, 850847993,  1794523220, 577288126,  4237140216,
            1126950,    2601642298, 1469035973, 2727135938, 92392213,   3668777652, 756260381,
            41782389,   226724724,  1123105466, 738274780,  1846857904, 3185630605, 823108172,
            2880110296, 3371270228, 2865413534, 564221408,  591845835,  2356214088, 4157618574,
            1336639597, 4180084026, 3195588503, 4266261353, 3844986377, 2073158796, 56968669,
            1234765864, 3166457679, 1001761927, 3146725645, 3295822468, 4135196531, 496099322,
            541676954,  4143543278, 1941480444, 3607603517, 2578543796, 1068806322, 4081693775,
            3600072515, 651444872,  1131603264, 47991343,   3748890341, 3413467790, 1567802204,
            2823058381, 2662653600, 1516568259, 4132590383, 3192977084, 4247798474, 2554440323,
            461466951,  1313208797, 637811069,  2744898822, 982676468,  3444149988, 1764224523,
            4016338923, 2845667517, 451503008,  2594402002, 373730087,  3013524828, 3442521115,
            1086137206, 2740782133, 2391000148, 3964107377, 4060067791, 731470002,  3161911677,
            3441985401, 2472173593, 4227407417, 44456710,   3623045141, 1873516415, 884116165,
            2550700713, 4004771121, 1053106195, 838088473,  2279863068, 1296332348, 1587145121,
            1806935386, 4138151954, 4030442072, 2552496880, 2570695340, 2328331779, 3132267322,
            227377796,  3887816270, 3570998746, 3654577129, 1603734504, 1528807885, 3365552060,
            188017185,  2134741424, 809367801,  1667936422, 1358744245, 1503613101, 4084104273,
            647580587,  1460988169, 2318828416, 3301866374, 3458437694, 2913596196, 2960957119,
            49464436,   2674694926, 2404530503, 2485431762, 692294537,  1803418945, 1645995464,
            3697728317, 706771848,  3734467362, 2407932841, 670964862,  1337146928, 1449841372,
            1239527551, 1124552917, 4204421245, 3121493408, 4147988039, 4003871917, 3542256025,
            3652555523, 2709537023, 1429645393, 565106475,  2063548817, 2716443687, 1278935671,
            915509292,  397356303,  1049916999, 204830047,  1086107506, 1795464380, 3485315196,
            2183256184, 662578255,  3645735256, 850847993,  1794523220, 2943700388, 4237140216,
            1126950,    2601642298, 1469035973, 535075238,  92392213,   3668777652, 756260381,
            41782389,   1043025574, 1123105466, 738274780,  1846857904, 3185630605, 3324487649,
            2880110296, 3371270228, 2865413534, 564221408,  2528599862, 2356214088, 4157618574,
            1336639597, 4180084026, 592094844,  4266261353, 3844986377, 2073158796, 56968669,
            629503707,  3166457679, 1001761927, 3146725645, 3295822468, 2725304934, 496099322,
            541676954,  4143543278, 1941480444, 3557859116, 31832949,   3805791401, 4056283801,
            242812250,  4072988068, 2316479446, 2260433816, 2211372380, 2039672698, 2947948280,
            4106140026, 342600216,  98745656,   2541799209, 926067404,  2733213159, 3163537903,
            2800370126, 2099121446, 1279545581, 3699822446, 3764095615, 690503808,  3799637505,
            1000641330, 242588257,  3657834529, 824791208,  2529299371, 4081898575, 2120338882,
            1273883107, 1680877886, 1253060582, 1760259553, 2250763915, 31780198,   2511451445,
            3102141340, 861489797,  105854693,  70927387,   2725671050, 688282241,  2622257646,
            3466254816, 1905008219, 2980966436, 2154356718, 1075686806, 1966147415, 2357249256,
            2684600972, 400926709,  523449509,  2891602783, 673425710,  3766475216, 2319843954,
            3471794777, 13838840,   1908374660, 3839606132, 3829795513, 3403561639, 1369780874,
            4276407916, 3217619,    1284482371, 2020138237, 2804427294, 1194369854, 1094800747,
            2119081501, 726494474,  490750173,  1117517565, 3498786968, 2163060528, 696718831,
            2780121254, 1286646297, 1594539045, 411215116,  1407268753, 2759136967, 2179483407,
            2088977769, 2737453188, 2411478102, 3112688013, 4112484868, 429293789,  426390687,
            3158027863, 2601897382, 1546855515, 4258208908, 3691263847, 2394986813, 1986623921,
            2632462203, 3551311099, 3309482741, 2632571927, 1200010240, 554555739,  4119397989,
            622818813,  3116222066, 1801867255, 2738500841, 1452697246, 733457482,  1680421668,
            1035766144, 468847991,  3606474156, 2612692123, 730556693,  859096521,  4005878655,
            1138273887, 2182363629, 2710579590, 3345140092, 2562710857, 3859276724, 2318176233,
            3964665794, 3295219265, 3037789445, 371545704,  3434130670, 3686032092, 19964088,
            340386179,  2147090894, 1446742483, 3083526520, 561888846,  2903328518, 1524465288,
            360120037,  2031515996, 1516035872, 2752848969, 1094251072, 984159948,  369999653,
            864602622,  2402584241, 3028363830, 252580667,  480470405,  3201548259, 2739036185,
            2198549891, 1978812013,
        },
        {
            2546657140, 2771792972, 3371698159, 1137313111, 2399264952, 1204642544, 2090179262,
            2948712987, 2908027331, 498636511,  2292804841, 1480836858, 2826016727, 196495965,
            2168559184, 3910150715, 320076735,  3144753899, 3199094529, 1165806050, 728308199,
            2322528104, 2891334400, 561853019,  4161870615, 1348321971, 2461357166, 1216229488,
            1392766290, 3060494848, 3282469664, 1866493654, 2351421557, 4195620347, 1512242723,
            478174598,  1087303780, 471631659,  2599553643, 791527994,  563537164,  1238109907,
            3218421602, 133222502,  4182363220, 305688802,  2666439314, 2408520958, 787389550,
            4226450542, 4107143646, 4103547035, 1840887424, 2686247491, 334267386,  3772035402,
            3436827662, 1411515743, 2193739735, 1892746640, 4163192062, 2921191805, 1011310614,
            2178118214, 33647321,   1121452997, 507942677,  2542792587, 351339975,  1586639416,
            1918003826, 2513357034, 2747854573, 606238275,  1132105249, 574593993,  2655425816,
            1680556547, 1831942411, 2587194016, 90710116,   4291431098, 1899367028, 3251152898,
            3297078396, 2712235924, 1546135008, 897753268,  1619454780, 938130143,  1828916640,
            3620488958, 1822437033, 172584228,  1853048226, 3659288522, 3623450763, 1893292786,
            851522142,  3411705687, 4106341088, 4109830348, 1193339049, 878885723,  2964062476,
            2320209608, 1777678953, 2886897705, 3856938396, 252913914,  3648685154, 544382669,
            2631141468, 1524405364, 1848509666, 580646927,  2451560151, 181916967,  1426301928,
            1652422182, 2625099169, 176664750,  1582626255, 1675120608, 2571617898, 2096572277,
            2471745846, 419906507,  886861124,  1974832558, 3157060904, 216000225,  746978071,
            1424984058, 1457979883, 809822177,  3833178010, 3926414726, 1423462846, 3024443248,
            4067020014, 2881559869, 1376840097, 548130303,  1118013762, 1309103114, 2227304261,
            4205319357, 228947246,  2167410411, 620496852,  2724112116, 705259153,  3499686911,
            3085999115, 2447267299, 4190122199, 1091465954, 1233728238, 39711865,   1076751044,
            2546657140, 2771792972, 3371698159, 1137313111, 3857150586, 1204642544, 2090179262,
            2948712987, 2908027331, 368199414,  2292804841, 1480836858, 2826016727, 196495965,
            3235583934, 3910150715, 320076735,  3144753899, 3199094529, 1374597050, 728308199,
            2322528104, 2891334400, 561853019,  1515915224, 1348321971, 2461357166, 1216229488,
            1392766290, 15252704,   3282469664, 1866493654, 2351421557, 4195620347, 192355609,
            478174598,  1087303780, 471631659,  2599553643, 1725604263, 563537164,  1238109907,
            3218421602, 133222502,  305098282,  305688802,  2666439314, 2408520958, 787389550,
            3195522899, 4107143646, 4103547035, 1840887424, 2686247491, 1565529892, 3772035402,
            3436827662, 1411515743, 2193739735, 1848198417, 4163192062, 2921191805, 1011310614,
            2178118214, 3474206203, 1121452997, 507942677,  2542792587, 351339975,  3599278861,
            1918003826, 2513357034, 2747854573, 606238275,  446979745,  574593993,  2655425816,
            1680556547, 1831942411, 3338512802, 90710116,   4291431098, 1899367028, 3251152898,
            1006512939, 2712235924, 1546135008, 897753268,  1619454780, 1429190743, 1828916640,
            3620488958, 1822437033, 172584228,  2529855020, 3659288522, 3623450763, 1893292786,
            851522142,  1417935793, 4106341088, 4109830348, 1193339049, 878885723,  1886400637,
            2320209608, 1777678953, 2886897705, 3856938396, 1813134786, 3648685154, 544382669,
            2631141468, 1524405364, 687661410,  580646927,  2451560151, 181916967,  1426301928,
            1463347373, 2625099169, 176664750,  1582626255, 1675120608, 3387060344, 2096572277,
            2471745846, 419906507,  886861124,  4209699955, 3157060904, 216000225,  746978071,
            1424984058, 3063941448, 809822177,  3833178010, 3926414726, 1423462846, 750559587,
            4067020014, 2881559869, 1376840097, 548130303,  4056763004, 1309103114, 2227304261,
            4205319357, 228947246,  774411056,  620496852,  2724112116, 705259153,  3499686911,
            2486247387, 2447267299, 4190122199, 1091465954, 1233728238, 54639263,   1076751044,
            2546657140, 2771792972, 3371698159, 1152150303, 3857150586, 1204642544, 2090179262,
            2948712987, 452427847,  368199414,  2292804841, 1480836858, 2826016727, 1929008184,
            3235583934, 3910150715, 320076735,  3144753899, 895636897,  1374597050, 728308199,
            2322528104, 2891334400, 1871824871, 1515915224, 1348321971, 2461357166, 1216229488,
            3170568098, 15252704,   3282469664, 1866493654, 2351421557, 4253216490, 192355609,
            478174598,  1087303780, 471631659,  4230260400, 1725604263, 563537164,  1238109907,
            3218421602, 960481514,  305098282,  305688802,  2666439314, 2408520958, 242741163,
            3195522899, 4107143646, 4103547035, 1840887424, 2768321503, 1565529892, 3772035402,
            3436827662, 1411515743, 545362965,  1848198417, 4163192062, 2921191805, 1011310614,
            1196775493, 3474206203, 1121452997, 507942677,  2542792587, 1948892535, 3599278861,
            1918003826, 2513357034, 2747854573, 4172793632, 446979745,  574593993,  2655425816,
            1680556547, 2986869736, 3338512802, 90710116,   4291431098, 1899367028, 3376952160,
            1006512939, 2712235924, 1546135008, 897753268,  2061577225, 1429190743, 1828916640,
            3620488958, 1822437033, 4221327184, 2529855020, 3659288522, 3623450763, 1893292786,
            16446898,   1417935793, 4106341088, 4109830348, 1193339049, 2895194326, 1886400637,
            2320209608, 1777678953, 2886897705, 117861450,  1813134786, 3648685154, 544382669,
            2631141468, 1105253905, 687661410,  580646927,  2451560151, 181916967,  1605087684,
            1463347373, 2625099169, 176664750,  1582626255, 1993431057, 3387060344, 2096572277,
            2471745846, 419906507,  3219719670, 4209699955, 3157060904, 216000225,  746978071,
            3304126047, 3063941448, 809822177,  3833178010, 3926414726, 4061584738, 750559587,
            4067020014, 2881559869, 1376840097, 973425409,  4056763004, 1309103114, 2227304261,
            4205319357, 939664759,  774411056,  620496852,  2724112116, 705259153,  176172666,
            2486247387, 2447267299, 4190122199, 1091465954, 300145620,  54639263,   1076751044,
            2546657140, 2771792972, 188149161,  1152150303, 3857150586, 1204642544, 2090179262,
            626100323,  452427847,  368199414,  2292804841, 1480836858, 2700509669, 1929008184,
            3235583934, 3910150715, 320076735,  1715326239, 895636897,  1374597050, 728308199,
            2322528104, 2356051490, 1871824871, 1515915224, 1348321971, 2461357166, 243332180,
            3170568098, 15252704,   3282469664, 1866493654, 4079212881, 4253216490, 192355609,
            478174598,  1087303780, 3787911270, 4230260400, 1725604263, 563537164,  1238109907,
            1147223471, 960481514,  305098282,  305688802,  2666439314, 1503870433, 242741163,
            3195522899, 4107143646, 4103547035, 4041516761, 2768321503, 1565529892, 3772035402,
            3436827662, 3952861918, 545362965,  1848198417, 4163192062, 2921191805, 793561655,
            1196775493, 3474206203, 1121452997, 507942677,  3788690254, 1948892535, 3599278861,
            1918003826, 2513357034, 3301940062, 4172793632, 446979745,  574593993,  2655425816,
            667233719,  2986869736, 3338512802, 90710116,   4291431098, 2027122085, 3376952160,
            1006512939, 2712235924, 1546135008, 2609276017, 2061577225, 1429190743, 1828916640,
            3620488958, 1603195641, 4221327184, 2529855020, 3659288522, 3623450763, 2313432963,
            16446898,   1417935793, 4106341088, 4109830348, 4106013120, 2895194326, 1886400637,
            2320209608, 1777678953, 1952597964, 117861450,  1813134786, 3648685154, 544382669,
            3108229631, 1105253905, 687661410,  580646927,  2451560151, 1160575897, 1605087684,
            1463347373, 2625099169, 176664750,  1998534134, 1993431057, 3387060344, 2096572277,
            2471745846, 2246406696, 3219719670, 4209699955, 3157060904, 216000225,  902956869,
            3304126047, 3063941448, 809822177,  3833178010, 815366736,  4061584738, 750559587,
            4067020014, 2881559869, 350775477,  973425409,  4056763004, 1309103114, 2227304261,
            2047915817, 939664759,  774411056,  620496852,  2724112116, 3593903529, 176172666,
            2486247387, 2447267299, 4190122199, 1450746791, 1521739409, 272699299,  4113952664,
            1408743622, 4082014187, 2454446462, 1401621236, 2050232096, 4204834821, 2413497685,
            1032465253, 4276089655, 1737267711, 3335718398, 1924071395, 1560525661, 3064183869,
            1775038231, 89761304,   489201378,  1236489133, 2774076159, 822652970,  1583752702,
            1781766972, 2238480533, 3428349870, 3344555477, 2251934941, 2533404243, 3651295253,
            2359372862, 704049384,  3238382362, 2405156187, 2572833624, 531907732,  2240111412,
            4102445586, 849739856,  3649572083, 3317634415, 1141345331, 1118528358, 1664181643,
            648360156,  1364897187, 289264571,  1625825195, 1075970578, 3925373833, 2780782646,
            727038162,  2824687935, 3844230994, 2070739238, 2437298873, 1837327520, 4248571219,
            183041221,  3759390508, 3881974011, 658115161,  560642175,  32860408,   1321227669,
            1380454450, 1676524786, 476585241,  4034481274, 1110506516, 815601591,  2009522227,
            2168306897, 1856639149, 1328281664, 2710915389, 1886116025, 2074502324, 23109943,
            670045122,  2926671795, 4269143768, 2688621201, 1618605914, 1541217762, 4273045819,
            1029546542, 3663663567, 1402692384, 109336276,  2446546057, 2225682064, 3535545430,
            3847123891, 369718877,  3411726117, 703735748,  3139527634, 22388546,   998860697,
            2532911305, 1532808237, 4170332196, 1131906845, 1814343609, 4161931326, 1185668213,
            1903273604, 3466154373, 3988139604, 1079368270, 991305574,  898158502,  2898908951,
            651161128,  1952607949, 1221528540, 29979722,   3006846808, 2911550178, 2569412437,
            1460616937, 2127921978, 3689931108, 950505297,  3469337654, 3180457017, 2316433735,
            1464678429, 2867173456, 391248106,  3622065314, 2143251073, 860219584,  323835636,
            340886643,  1805485977, 109344001,  1537119779, 1795626099, 2568079633, 3048040562,
            1204069532, 2488753091, 2160014198, 3132782711, 1266102795, 91252225,   2018366053,
            39675212,   979320891,  343397131,  814470367,  366655857,  3287033048, 3379301026,
            1566381433, 3431153818,
        },
        {
            2234324389, 1682296894, 3526681456, 3988544681, 1315506584, 1754723911, 3607564438,
            3764062195, 3408328234, 2385116969, 3827569659, 4104590721, 2612634189, 1762747544,
            1676800931, 1814546108, 2684685172, 1659194343, 3381624140, 2286640580, 688245437,
            2593335056, 1657668516, 1161309746, 3390664973, 2460564382, 2811435329, 2169200311,
            2768093584, 4288309691, 1341061221, 1361417084, 3060155336, 2526021346, 1037055386,
            890124736,  2185462193, 765141735,  1841745804, 3562499272, 1437907207, 2127475991,
            2845453063, 4007976206, 4160093314, 2717704308, 4193767498, 1667876711, 3477753188,
            3150367681, 3224086539, 231347764,  2737121599, 1230656103, 4168131490, 1463860373,
            2760968409, 2579133178, 2309591728, 2958907244, 1041094855, 685134804,  3861095208,
            1088109135, 815655228,  2618003265, 3454840568, 1668276240, 1668403077, 663034899,
            4020374281, 1896863688, 677285319,  4047674693, 4098535894, 2038783953, 236635760,
            3641273565, 3568356824, 3405704765, 186484522,  3626346451, 3653227559, 281949942,
            1847600066, 4168753288, 1723123703, 3600798445, 4267802363, 2947454105, 468768748,
            2745777741, 26635454,   837186232,  206931043,  2601865569, 2021732453, 3171165636,
            786833002,  116631308,  1604778670, 437644814,  2437761489, 3573139998, 2637030522,
            972076738,  4075927397, 1427554739, 597414077,  559325169,  1774857312, 224593737,
            3697511293, 3905126277, 2446278950, 1847061846, 333176687,  2988562696, 3623938567,
            2389910304, 4273100167, 1673622334, 2163644598, 3666601063, 3971760462, 4176957983,
            565952761,  566996714,  103136762,  3648349163, 115456167,  3265051494, 2826313040,
            1898888678, 3921049266, 1276809956, 4051866478, 959265349,  851980436,  3105565302,
            2905096898, 342438530,  3428101638, 912389587,  2306839396, 3613297213, 200159550,
            3406974927, 832121231,  2998593393, 1242069873, 1464281204, 1828082526, 2620095350,
            3727900009, 986958825,  3332332947, 1610600284, 3193282615, 1873987353, 537698841,
            2234324389, 1682296894, 3526681456, 3988544681, 1112334635, 1754723911, 3607564438,
            3764062195, 3408328234, 2702680798, 3827569659, 4104590721, 2612634189, 1762747544,
            1596420149, 1814546108, 2684685172, 1659194343, 3381624140, 2424233156, 688245437,
            2593335056, 1657668516, 1161309746, 260803614,  2460564382, 2811435329, 2169200311,
            2768093584, 1426048416, 1341061221, 1361417084, 3060155336, 2526021346, 688976997,
            890124736,  2185462193, 765141735,  1841745804, 1113361455, 1437907207, 2127475991,
            2845453063, 4007976206, 1719248425, 2717704308, 4193767498, 1667876711, 3477753188,
            449353539,  3224086539, 231347764,  2737121599, 1230656103, 2122699205, 1463860373,
            2760968409, 2579133178, 2309591728, 4017154219, 1041094855, 685134804,  3861095208,
            1088109135, 3954527144, 2618003265, 3454840568, 1668276240, 1668403077, 3235241899,
            4020374281, 1896863688, 677285319,  4047674693, 4043186819, 2038783953, 236635760,
            3641273565, 3568356824, 3946220303, 186484522,  3626346451, 3653227559, 281949942,
            1896524045, 4168753288, 1723123703, 3600798445, 4267802363, 412498526,  468768748,
            2745777741, 26635454,   837186232,  1473941762, 2601865569, 2021732453, 3171165636,
            786833002,  3461566768, 1604778670, 437644814,  2437761489, 3573139998, 306196591,
            972076738,  4075927397, 1427554739, 597414077,  2401305323, 1774857312, 224593737,
            3697511293, 3905126277, 1527832817, 1847061846, 333176687,  2988562696, 3623938567,
            2731158470, 4273100167, 1673622334, 2163644598, 3666601063, 1991088422, 4176957983,
            565952761,  566996714,  103136762,  1639884175, 115456167,  3265051494, 2826313040,
            1898888678, 2976556877, 1276809956, 4051866478, 959265349,  851980436,  2482970929,
            2905096898, 342438530,  3428101638, 912389587,  2716490551, 3613297213, 200159550,
            3406974927, 832121231,  2865829307, 1242069873, 1464281204, 1828082526, 2620095350,
            3671861666, 986958825,  3332332947, 1610600284, 3193282615, 164496953,  537698841,
            2234324389, 1682296894, 3526681456, 486931321,  1112334635, 1754723911, 3607564438,
            3764062195, 898439171,  2702680798, 3827569659, 4104590721, 2612634189, 1703436382,
            1596420149, 1814546108, 2684685172, 1659194343, 3421607784, 2424233156, 688245437,
            2593335056, 1657668516, 362342820,  260803614,  2460564382, 2811435329, 2169200311,
            4248717010, 1426048416, 1341061221, 1361417084, 3060155336, 2693026827, 688976997,
            890124736,  2185462193, 765141735,  2445632748, 1113361455, 1437907207, 2127475991,
            2845453063, 1830953748, 1719248425, 2717704308, 4193767498, 1667876711, 2469362144,
            449353539,  3224086539, 231347764,  2737121599, 2917779591, 2122699205, 1463860373,
            2760968409, 2579133178, 2600345316, 4017154219, 1041094855, 685134804,  3861095208,
            3682591427, 3954527144, 2618003265, 3454840568, 1668276240, 988400088,  3235241899,
            4020374281, 1896863688, 677285319,  2749516227, 4043186819, 2038783953, 236635760,
            3641273565, 4073317913, 3946220303, 186484522,  3626346451, 3653227559, 872336642,
            1896524045, 4168753288, 1723123703, 3600798445, 524095357,  412498526,  468768748,
            2745777741, 26635454,   840544541,  1473941762, 2601865569, 2021732453, 3171165636,
            1058640324, 3461566768, 1604778670, 437644814,  2437761489, 3615438045, 306196591,
            972076738,  4075927397, 1427554739, 2369367008, 2401305323, 1774857312, 224593737,
            3697511293, 4186564433, 1527832817, 1847061846, 333176687,  2988562696, 4039340326,
            2731158470, 4273100167, 1673622334, 2163644598, 307949376,  1991088422, 4176957983,
            565952761,  566996714,  4159448552, 1639884175, 115456167,  3265051494, 2826313040,
            2698725478, 2976556877, 1276809956, 4051866478, 959265349,  293029699,  2482970929,
            2905096898, 342438530,  3428101638, 4172766741, 2716490551, 3613297213, 200159550,
            3406974927, 3723281866, 2865829307, 1242069873, 1464281204, 1828082526, 3304191156,
            3671861666, 986958825,  3332332947, 1610600284, 2370407607, 164496953,  537698841,
            2234324389, 1682296894, 826891606,  486931321,  1112334635, 1754723911, 3607564438,
            3598993552, 898439171,  2702680798, 3827569659, 4104590721, 1421852097, 1703436382,
            1596420149, 1814546108, 2684685172, 4090587429, 3421607784, 2424233156, 688245437,
            2593335056, 4151905751, 362342820,  260803614,  2460564382, 2811435329, 2402832015,
            4248717010, 1426048416, 1341061221, 1361417084, 1629089021, 2693026827, 688976997,
            890124736,  2185462193, 303105066,  2445632748, 1113361455, 1437907207, 2127475991,
            62024604,   1830953748, 1719248425, 2717704308, 4193767498, 667433630,  2469362144,
            449353539,  3224086539, 231347764,  3918249451, 2917779591, 2122699205, 1463860373,
            2760968409, 4274016442, 2600345316, 4017154219, 1041094855, 685134804,  643006688,
            3682591427, 3954527144, 2618003265, 3454840568, 4180665518, 988400088,  3235241899,
            4020374281, 1896863688, 3678687414, 2749516227, 4043186819, 2038783953, 236635760,
            2880089648, 4073317913, 3946220303, 186484522,  3626346451, 2454620114, 872336642,
            1896524045, 4168753288, 1723123703, 2692406059, 524095357,  412498526,  468768748,
            2745777741, 918726515,  840544541,  1473941762, 2601865569, 2021732453, 3534238020,
            1058640324, 3461566768, 1604778670, 437644814,  2894699005, 3615438045, 306196591,
            972076738,  4075927397, 3468671461, 2369367008, 2401305323, 1774857312, 224593737,
            2734827022, 4186564433, 1527832817, 1847061846, 333176687,  2437714719, 4039340326,
            2731158470, 4273100167, 1673622334, 196072958,  307949376,  1991088422, 4176957983,
            565952761,  847200194,  4159448552, 1639884175, 115456167,  3265051494, 2503079777,
            2698725478, 2976556877, 1276809956, 4051866478, 2731665893, 293029699,  2482970929,
            2905096898, 342438530,  581060953,  4172766741, 2716490551, 3613297213, 200159550,
            4222335623, 3723281866, 2865829307, 1242069873, 1464281204, 1080647953, 3304191156,
            3671861666, 986958825,  3332332947, 920422540,  3656094274, 4036161427, 2157099981,
            1855437762, 1385781426, 199192882,  489599802,  3472601685, 717544078,  2241742884,
            3951326913, 3590866192, 1087524220, 3517385549, 360484251,  2718513148, 1386577185,
            1833613127, 2926418589, 1652463225, 548895720,  1343026759, 1797789098, 3229783023,
            1745843414, 200554865,  2442780740, 2359926428, 2970332116, 3097392757, 134294482,
            936225458,  1968264650, 64868134,   3821668262, 2502175363, 1623767635, 2936073062,
            1991791011, 2971174068, 3142195911, 2874818345, 2192526584, 496586185,  2491564144,
            2415210641, 314307270,  2936737494, 557604388,  1067914024, 3270690738, 375601880,
            962749065,  3610467620, 402112984,  1432929499, 3872957776, 3971384069, 2223968592,
            407083609,  2178236674, 1806303230, 3397564470, 12158764,   415570813,  4033667395,
            3687406137, 801878150,  953500350,  3667783172, 1203668106, 902418194,  779786150,
            774683730,  2870261992, 509192460,  1961621392, 1064906432, 3665710891, 1733725153,
            1887608856, 1314631523, 4097239005, 29074501,   3472521950, 4040841657, 532128023,
            2333441401, 1671717886, 1678544416, 1218347584, 3680929567, 4025753853, 2810948711,
            1846100306, 3377469279, 3144481747, 2625781306, 730632118,  3162408393, 3423660386,
            1364968369, 4270900402, 1075484840, 2892932277, 3700635052, 3853022563, 281755151,
            1530909868, 2364069707, 2361723426, 738500028,  1401903990, 1543704261, 2442916222,
            1076190609, 1882477803, 740024557,  1591015439, 2730909167, 2723330839, 1637373491,
            3777799860, 2921269571, 3698591972, 3997463570, 3877862147, 1912888417, 3365137165,
            3465700492, 771243134,  4037723169, 1715894739, 1025821874, 1924958945, 3382242859,
            121591031,  483980724,  546523388,  2446882279, 856267778,  578739009,  2978085488,
            480884914,  966764808,  457039953,  3817520708, 1113646451, 2503896910, 3507840816,
            717151671,  4149352573, 1568869830, 395015863,  773165995,  1853682362, 2861368846,
            1884368812, 1250092101,
        },
        {
            916910638,  961623451,  1193013401, 1016438484, 4091279871, 287282633,  8590725,
            3575333670, 324340905,  3133751747, 2840894649, 2980503178, 1111215768, 2783846375,
            72516413,   4158424384, 2184094569, 2305724254, 4057093054, 1407652993, 3105191537,
            768505376,  298782270,  993926164,  2694730042, 1479658113, 2376490281, 2767906402,
            1619969256, 3256472015, 2563843533, 2974784738, 2529307107, 4289918826, 3105587575,
            3748950898, 2182744253, 431888679,  3780324902, 2525978209, 54545903,   1688749940,
            2394884334, 3477656171, 263834270,  1562965459, 804704330,  4185729868, 138898835,
            2113063150, 327612841,  1252226275, 935318076,  2956823075, 4095101181, 1510586062,
            156282440,  3386839706, 2294393752, 1306167091, 4005033667, 651716500,  4115192738,
            123027719,  3873547487, 2910637335, 2571924586, 3489608656, 956791985,  2467423726,
            3214531645, 2054232851, 49634692,   377192215,  1865068750, 2479252980, 3481787748,
            3243507737, 605491073,  4062466752, 988602517,  1539348794, 1555068617, 2657884010,
            460334294,  4240766479, 3639800790, 253377117,  3969136265, 488705329,  1722560286,
            2289159295, 1025876008, 2927117896, 767521707,  2047999999, 4260853571, 2079302241,
            2409677301, 1087552976, 2363907365, 2574464321, 2606273241, 3716086457, 26053603,
            3162779415, 14843078,   2614076143, 1157531920, 2773275636, 2338825066, 435472225,
            1399711137, 1224374788, 2154533280, 560135209,  935800607,  1940258814, 3826959530,
            3423217355, 3704934971, 3815248829, 3878175339, 1395508015, 3295101527, 177901558,
            4167531389, 1375148189, 3125377631, 557218961,  4088880299, 3478859071, 3687276754,
            2845114223, 1713171361, 1756507633, 3160807894, 2375334470, 843542578,  1907952570,
            1544844563, 2294372007, 3336681376, 734347193,  102566945,  2311037104, 4294750194,
            3572240326, 732958152,  263733314,  2087890678, 331542297,  3549110380, 2073894939,
            2104101380, 3670791368, 3122901693, 3799823891, 3783548253, 1102633864, 44327348,
            916910638,  961623451,  1193013401, 1016438484, 1873779640, 287282633,  8590725,
            3575333670, 324340905,  1144671533, 2840894649, 2980503178, 1111215768, 2783846375,
            2000673937, 4158424384, 2184094569, 2305724254, 4057093054, 533488413,  3105191537,
            768505376,  298782270,  993926164,  2015456740, 1479658113, 2376490281, 2767906402,
            1619969256, 3120736988, 2563843533, 2974784738, 2529307107, 4289918826, 729503771,
            3748950898, 2182744253, 431888679,  3780324902, 373638396,  54545903,   1688749940,
            2394884334, 3477656171, 1083764681, 1562965459, 804704330,  4185729868, 138898835,
            823405282,  327612841,  1252226275, 935318076,  2956823075, 899234846,  1510586062,
            156282440,  3386839706, 2294393752, 2769934879, 4005033667, 651716500,  4115192738,
            123027719,  3729538641, 2910637335, 2571924586, 3489608656, 956791985,  139360134,
            3214531645, 2054232851, 49634692,   377192215,  2754746969, 2479252980, 3481787748,
            3243507737, 605491073,  732155706,  988602517,  1539348794, 1555068617, 2657884010,
            3753733088, 4240766479, 3639800790, 253377117,  3969136265, 3848735787, 1722560286,
            2289159295, 1025876008, 2927117896, 3661948694, 2047999999, 4260853571, 2079302241,
            2409677301, 3421911122, 2363907365, 2574464321, 2606273241, 3716086457, 2064343322,
            3162779415, 14843078,   2614076143, 1157531920, 826449637,  2338825066, 435472225,
            1399711137, 1224374788, 3770340198, 560135209,  935800607,  1940258814, 3826959530,
            2963586762, 3704934971, 3815248829, 3878175339, 1395508015, 3721612680, 177901558,
            4167531389, 1375148189, 3125377631, 1023552290, 4088880299, 3478859071, 3687276754,
            2845114223, 3831557301, 1756507633, 3160807894, 2375334470, 843542578,  2798365898,
            1544844563, 2294372007, 3336681376, 734347193,  1856808621, 2311037104, 4294750194,
            3572240326, 732958152,  1999195012, 2087890678, 331542297,  3549110380, 2073894939,
            3115936764, 3670791368, 3122901693, 3799823891, 3783548253, 132796150,  44327348,
            916910638,  961623451,  1193013401, 1753944196, 1873779640, 287282633,  8590725,
            3575333670, 1447720209, 1144671533, 2840894649, 2980503178, 1111215768, 1211945983,
            2000673937, 4158424384, 2184094569, 2305724254, 402617261,  533488413,  3105191537,
            768505376,  298782270,  2915553159, 2015456740, 1479658113, 2376490281, 2767906402,
            3473761811, 3120736988, 2563843533, 2974784738, 2529307107, 737859212,  729503771,
            3748950898, 2182744253, 431888679,  2013420163, 373638396,  54545903,   1688749940,
            2394884334, 675998523,  1083764681, 1562965459, 804704330,  4185729868, 1165431355,
            823405282,  327612841,  1252226275, 935318076,  2420680216, 899234846,  1510586062,
            156282440,  3386839706, 2101339651, 2769934879, 4005033667, 651716500,  4115192738,
            112049740,  3729538641, 2910637335, 2571924586, 3489608656, 305695595,  139360134,
            3214531645, 2054232851, 49634692,   1073828255, 2754746969, 2479252980, 3481787748,
            3243507737, 3392719169, 732155706,  988602517,  1539348794, 1555068617, 3246776527,
            3753733088, 4240766479, 3639800790, 253377117,  872273450,  3848735787, 1722560286,
            2289159295, 1025876008, 4168154213, 3661948694, 2047999999, 4260853571, 2079302241,
            2380420842, 3421911122, 2363907365, 2574464321, 2606273241, 3881916078, 2064343322,
            3162779415, 14843078,   2614076143, 473288515,  826449637,  2338825066, 435472225,
            1399711137, 3068538992, 3770340198, 560135209,  935800607,  1940258814, 1469655183,
            2963586762, 3704934971, 3815248829, 3878175339, 2410602840, 3721612680, 177901558,
            4167531389, 1375148189, 1367577763, 1023552290, 4088880299, 3478859071, 3687276754,
            678224549,  3831557301, 1756507633, 3160807894, 2375334470, 2884561721, 2798365898,
            1544844563, 2294372007, 3336681376, 1938834658, 1856808621, 2311037104, 4294750194,
            3572240326, 2786764913, 1999195012, 2087890678, 331542297,  3549110380, 3597797341,
            3115936764, 3670791368, 3122901693, 3799823891, 1271317799, 132796150,  44327348,
            916910638,  961623451,  2427821332, 1753944196, 1873779640, 287282633,  8590725,
            1244012658, 1447720209, 1144671533, 2840894649, 2980503178, 3548902577, 1211945983,
            2000673937, 4158424384, 2184094569, 2152623453, 402617261,  533488413,  3105191537,
            768505376,  1095141108, 2915553159, 2015456740, 1479658113, 2376490281, 337998873,
            3473761811, 3120736988, 2563843533, 2974784738, 3087228498, 737859212,  729503771,
            3748950898, 2182744253, 2140410733, 2013420163, 373638396,  54545903,   1688749940,
            528290088,  675998523,  1083764681, 1562965459, 804704330,  2536362875, 1165431355,
            823405282,  327612841,  1252226275, 4037635314, 2420680216, 899234846,  1510586062,
            156282440,  2012335895, 2101339651, 2769934879, 4005033667, 651716500,  2552583570,
            112049740,  3729538641, 2910637335, 2571924586, 2436645403, 305695595,  139360134,
            3214531645, 2054232851, 2384286326, 1073828255, 2754746969, 2479252980, 3481787748,
            1948315585, 3392719169, 732155706,  988602517,  1539348794, 4110558494, 3246776527,
            3753733088, 4240766479, 3639800790, 3627363812, 872273450,  3848735787, 1722560286,
            2289159295, 4122430477, 4168154213, 3661948694, 2047999999, 4260853571, 1767882442,
            2380420842, 3421911122, 2363907365, 2574464321, 2778622726, 3881916078, 2064343322,
            3162779415, 14843078,   1513897109, 473288515,  826449637,  2338825066, 435472225,
            322954918,  3068538992, 3770340198, 560135209,  935800607,  345602050,  1469655183,
            2963586762, 3704934971, 3815248829, 3508249920, 2410602840, 3721612680, 177901558,
            4167531389, 2161244150, 1367577763, 1023552290, 4088880299, 3478859071, 1108183104,
            678224549,  3831557301, 1756507633, 3160807894, 2551630811, 2884561721, 2798365898,
            1544844563, 2294372007, 2520267760, 1938834658, 1856808621, 2311037104, 4294750194,
            2310096003, 2786764913, 1999195012, 2087890678, 331542297,  1205238749, 3597797341,
            3115936764, 3670791368, 3122901693, 2008141679, 2018425028, 3435073328, 1452813805,
            1628661138, 1323367156, 1062553693, 4029321700, 2772685842, 3798388850, 1315172209,
            3930983291, 3816791373, 529176017,  3419610188, 3331589216, 4016977274, 2047089790,
            3892571923, 2363414008, 1144631948, 3004954882, 2558739305, 19774033,   2525079911,
            3774885821, 2817837373, 986111566,  1446678953, 3238485630, 3993748600, 1601954599,
            3100591537, 2098009380, 3935971261, 4202546603, 3713465083, 3845664764, 2466365355,
            1452340065, 2003576531, 1013434822, 2254608933, 783902023,  3129770529, 129130612,
            821418228,  350036483,  3473671510, 4128495167, 2773832518, 683262085,  2143353417,
            256251732,  1719056536, 2670223618, 328467339,  1564657740, 451231672,  2788353006,
            882900088,  3255241056, 3198073758, 2541070985, 1941509325, 674933160,  207753676,
            2605303964, 1681335994, 1143520001, 448872632,  302917879,  1100138495, 2058770021,
            3116955098, 2081754747, 3734924767, 1916718058, 3873335960, 2740460398, 2171157007,
            27677949,   2364721928, 175851655,  1468083950, 3162369526, 2441504540, 556978295,
            2372096172, 3181101116, 2582850132, 1101292643, 862643740,  2095546242, 3261953801,
            748040658,  3970037674, 819116843,  3594523650, 1597423019, 4109336883, 1198282420,
            2905230517, 1729529596, 3230132814, 3640242164, 1899059108, 1944906555, 3426510495,
            3035188107, 6448083,    1093882965, 2867500469, 3626379157, 1849073068, 897616501,
            604221668,  1020676159, 4083635798, 1716022041, 3671877965, 1738820843, 30077467,
            729231767,  3413193248, 207000406,  3854363185, 3302747326, 3293643267, 2101250157,
            460131091,  4159442595, 1133391045, 1031215443, 4195487944, 45931575,   2922629291,
            789302543,  3024994662, 442525623,  2850119076, 838309503,  2585361734, 1020449164,
            1623631007, 955374631,  2932467671, 3713639221, 3019179416, 977970472,  1817244230,
            3856774853, 1140530868, 886199600,  1218509766, 4001537244, 2840913665, 2133254364,
            3332344608, 475291624,
        },
        {
            1854921599, 2655519695, 3124573588, 319882484,  603545603,  4175512633, 141286453,
            1183670252, 1789500145, 37351733,   3190829323, 2782782009, 493805446,  1228958246,
            2672482554, 2274981421, 2935438833, 3625733677, 3679506394, 687805550,  134516308,
            3576789728, 965007022,  1056542222, 2319405423, 3944221200, 950102624,  3848192810,
            3205299696, 82033760,   1241913280, 1360146137, 1675732327, 2164452797, 3920498715,
            2226452641, 3172047212, 1569171738, 2631589480, 2889660225, 2030783667, 2237381973,
            2706217212, 3143638386, 1733174225, 1166820137, 3818389960, 193959252,  2793509934,
            316291605,  2502743884, 1963136977, 3739017448, 25754513,   1590156485, 1856291967,
            4143674472, 2538785911, 2159135699, 1908446793, 3303325234, 2589568800, 1193586059,
            77481069,   789413194,  2556570543, 162987300,  1960844609, 2973799047, 4253906178,
            315868734,  2542622968, 3949539136, 1479106582, 4225431384, 1235059630, 1533374854,
            847792023,  4031286530, 4194276632, 164541100,  1010135841, 143302319,  1335585015,
            1237311692, 20896020,   344974153,  2576803233, 3430251730, 984163376,  2680612471,
            1276425436, 2400671554, 1628640140, 2161048926, 2109177634, 998215324,  3127793500,
            1759998050, 3105138908, 2583746384, 2126302368, 3258602104, 1262742375, 3565617377,
            3726060195, 157069329,  390662438,  3800994052, 2007694482, 377281730,  3251789121,
            236703173,  122782596,  775407411,  3394010206, 4232159202, 468321553,  2704615220,
            1332411375, 2978494251, 989230484,  3122841814, 2348872707, 731335994,  541354422,
            223117443,  2225009071, 4230058949, 1875162926, 3897048544, 3550177883, 2461273592,
            1046820583, 1333727817, 1378024753, 3686775275, 4230752590, 64834458,   1281467967,
            729116355,  3886390916, 65029451,   3478506446, 1387684482, 1172004841, 2525409243,
            1677678908, 1704646757, 930937262,  1088384271, 689357059,  1754542213, 702963842,
            2864311668, 1960202673, 1009675673, 3742350158, 3751269215, 3166659283, 9090161,
            1854921599, 2655519695, 3124573588, 319882484,  1422536794, 4175512633, 141286453,
            1183670252, 1789500145, 850391877,  3190829323, 2782782009, 493805446,  1228958246,
            837232655,  2274981421, 2935438833, 3625733677, 3679506394, 955772620,  134516308,
            3576789728, 965007022,  1056542222, 874117013,  3944221200, 950102624,  3848192810,
            3205299696, 543679720,  1241913280, 1360146137, 1675732327, 2164452797, 1169030022,
            2226452641, 3172047212, 1569171738, 2631589480, 3783543297, 2030783667, 2237381973,
            2706217212, 3143638386, 1560162209, 1166820137, 3818389960, 193959252,  2793509934,
            4258046618, 2502743884, 1963136977, 3739017448, 25754513,   1204846712, 1856291967,
            4143674472, 2538785911, 2159135699, 3889946075, 3303325234, 2589568800, 1193586059,
            77481069,   969912041,  2556570543, 162987300,  1960844609, 2973799047, 427583517,
            315868734,  2542622968, 3949539136, 1479106582, 92839917,   1235059630, 1533374854,
            847792023,  4031286530, 1147875681, 164541100,  1010135841, 143302319,  1335585015,
            368616909,  20896020,   344974153,  2576803233, 3430251730, 1078575783, 2680612471,
            1276425436, 2400671554, 1628640140, 4149623645, 2109177634, 998215324,  3127793500,
            1759998050, 3525419965, 2583746384, 2126302368, 3258602104, 1262742375, 1996113346,
            3726060195, 157069329,  390662438,  3800994052, 982000497,  377281730,  3251789121,
            236703173,  122782596,  2303768414, 3394010206, 4232159202, 468321553,  2704615220,
            681592492,  2978494251, 989230484,  3122841814, 2348872707, 4089094260, 541354422,
            223117443,  2225009071, 4230058949, 2754981128, 3897048544, 3550177883, 2461273592,
            1046820583, 668143612,  1378024753, 3686775275, 4230752590, 64834458,   3765910650,
            729116355,  3886390916, 65029451,   3478506446, 3419111947, 1172004841, 2525409243,
            1677678908, 1704646757, 155635560,  1088384271, 689357059,  1754542213, 702963842,
            2712009967, 1960202673, 1009675673, 3742350158, 3751269215, 129749802,  9090161,
            1854921599, 2655519695, 3124573588, 809557750,  1422536794, 4175512633, 141286453,
            1183670252, 1739311360, 850391877,  3190829323, 2782782009, 493805446,  1738527771,
            837232655,  2274981421, 2935438833, 3625733677, 1858071296, 955772620,  134516308,
            3576789728, 965007022,  3367712327, 874117013,  3944221200, 950102624,  3848192810,
            2420548306, 543679720,  1241913280, 1360146137, 1675732327, 176019367,  1169030022,
            2226452641, 3172047212, 1569171738, 76544055,   3783543297, 2030783667, 2237381973,
            2706217212, 3283985735, 1560162209, 1166820137, 3818389960, 193959252,  346134252,
            4258046618, 2502743884, 1963136977, 3739017448, 3887005605, 1204846712, 1856291967,
            4143674472, 2538785911, 366578749,  3889946075, 3303325234, 2589568800, 1193586059,
            2917569085, 969912041,  2556570543, 162987300,  1960844609, 61311938,   427583517,
            315868734,  2542622968, 3949539136, 2278526422, 92839917,   1235059630, 1533374854,
            847792023,  1361054176, 1147875681, 164541100,  1010135841, 143302319,  1348709332,
            368616909,  20896020,   344974153,  2576803233, 3290873783, 1078575783, 2680612471,
            1276425436, 2400671554, 628790408,  4149623645, 2109177634, 998215324,  3127793500,
            2019336900, 3525419965, 2583746384, 2126302368, 3258602104, 2858154034, 1996113346,
            3726060195, 157069329,  390662438,  2250549235, 982000497,  377281730,  3251789121,
            236703173,  3487415996, 2303768414, 3394010206, 4232159202, 468321553,  2773608982,
            681592492,  2978494251, 989230484,  3122841814, 3647638215, 4089094260, 541354422,
            223117443,  2225009071, 2829509947, 2754981128, 3897048544, 3550177883, 2461273592,
            282627696,  668143612,  1378024753, 3686775275, 4230752590, 1105868822, 3765910650,
            729116355,  3886390916, 65029451,   328554604,  3419111947, 1172004841, 2525409243,
            1677678908, 1395036942, 155635560,  1088384271, 689357059,  1754542213, 1076601715,
            2712009967, 1960202673, 1009675673, 3742350158, 2581225953, 129749802,  9090161,
            1854921599, 2655519695, 1393282220, 809557750,  1422536794, 4175512633, 141286453,
            2211497169, 1739311360, 850391877,  3190829323, 2782782009, 2694871802, 1738527771,
            837232655,  2274981421, 2935438833, 3145832503, 1858071296, 955772620,  134516308,
            3576789728, 4045354759, 3367712327, 874117013,  3944221200, 950102624,  3562634568,
            2420548306, 543679720,  1241913280, 1360146137, 3644280343, 176019367,  1169030022,
            2226452641, 3172047212, 3927720006, 76544055,   3783543297, 2030783667, 2237381973,
            1497233808, 3283985735, 1560162209, 1166820137, 3818389960, 2344066681, 346134252,
            4258046618, 2502743884, 1963136977, 79988846,   3887005605, 1204846712, 1856291967,
            4143674472, 3967952414, 366578749,  3889946075, 3303325234, 2589568800, 2193179011,
            2917569085, 969912041,  2556570543, 162987300,  52882655,   61311938,   427583517,
            315868734,  2542622968, 1575831590, 2278526422, 92839917,   1235059630, 1533374854,
            2397068791, 1361054176, 1147875681, 164541100,  1010135841, 2586368032, 1348709332,
            368616909,  20896020,   344974153,  3445652232, 3290873783, 1078575783, 2680612471,
            1276425436, 3682156544, 628790408,  4149623645, 2109177634, 998215324,  4049708298,
            2019336900, 3525419965, 2583746384, 2126302368, 1627944270, 2858154034, 1996113346,
            3726060195, 157069329,  1481222640, 2250549235, 982000497,  377281730,  3251789121,
            3564274539, 3487415996, 2303768414, 3394010206, 4232159202, 3509025997, 2773608982,
            681592492,  2978494251, 989230484,  980252048,  3647638215, 4089094260, 541354422,
            223117443,  543970497,  2829509947, 2754981128, 3897048544, 3550177883, 2736782140,
            282627696,  668143612,  1378024753, 3686775275, 2728601425, 1105868822, 3765910650,
            729116355,  3886390916, 1866378660, 328554604,  3419111947, 1172004841, 2525409243,
            1506924008, 1395036942, 155635560,  1088384271, 689357059,  3587092123, 1076601715,
            2712009967, 1960202673, 1009675673, 4292715891, 2465250857, 3267969665, 2459570573,
            3644463083, 1637197500, 684559293,  3520611957, 2976084366, 1512112440, 1778285193,
            1849742417, 3144801412, 3009052859, 820829188,  1382783871, 3373481539, 3777016406,
            266942530,  1792334422, 4109859515, 1468149634, 1356457853, 623893785,  1301686542,
            441704877,  3377795902, 879822753,  329462927,  543858304,  2221828617, 2996486613,
            981774202,  1032220084, 1066536452, 1004068806, 1336694798, 3744375323, 3802436665,
            3366526577, 418696462,  1776559103, 1291965608, 1623030339, 1443628607, 572114324,
            899621592,  332121275,  3637616671, 457287722,  3803043476, 408472701,  660940326,
            1209169008, 1202511620, 2906900959, 2600414642, 2015874468, 2931389161, 1760773669,
            2601299639, 543821664,  3426280682, 1337602255, 3334593650, 1320885980, 3857269540,
            2548321029, 2250001180, 673341051,  1900184720, 731675831,  2461790412, 2593291320,
            1640301250, 863529987,  91627443,   2437824309, 2834231475, 4093270720, 1474594761,
            4186662839, 1683556862, 1302286991, 806676270,  703274107,  3756759580, 674737904,
            912015048,  1823306025, 1509430520, 3128952761, 290841833,  3917789380, 1022040580,
            1810054038, 334998864,  1009274987, 310979037,  606749827,  546291081,  3438438313,
            1840081424, 1950680845, 4217236364, 1814584903, 2814353208, 194196981,  1540331253,
            3135937654, 773351497,  1878220007, 3097009802, 1252607159, 1378821846, 2741884614,
            178612659,  3656860395, 1259606652, 3942111545, 488406826,  3640897405, 3419000480,
            353909713,  2996208477, 2862593073, 108483327,  648472258,  1060249632, 1049865483,
            430087518,  1364157854, 3367631180, 251313827,  2374149836, 2109357086, 479172068,
            464775113,  1806677787, 3488082411, 356035738,  3080424395, 4134646749, 369528743,
            1031004516, 2525336414, 4189798138, 3928909462, 568714397,  1681832820, 1753328641,
            827357673,  1651960551, 1798317455, 737101952,  3257553606, 400882781,  1473208110,
            4134183873, 2193420912,
        },
        {
            2483976489, 2790651795, 3298324523, 3508205426, 2236819708, 917494217,  769620837,
            3411018785, 2391335000, 1627061280, 3356773416, 1288706527, 4178910717, 3636299534,
            4221874052, 3674654381, 537787012,  4271656840, 185820273,  1160533598, 1862365049,
            2550353307, 1392072847, 1870891365, 1517453821, 524666025,  3645751565, 2415020247,
            3691419894, 2580450642, 2130267479, 3636103610, 562446539,  750696587,  97137475,
            3894066051, 2239638596, 3256181120, 3981041836, 774947039,  451287677,  3618957054,
            4236303539, 1027744929, 1497195372, 498574915,  2164122779, 582902291,  3040883311,
            1626221455, 1853378,    2125490000, 3185055972, 1607660025, 432884530,  779476209,
            124284956,  2488937128, 2521389012, 107485781,  2873055013, 1171872946, 3130489952,
            4273333914, 646240524,  3970896645, 942009076,  4069926418, 3129385884, 3470469370,
            388702536,  450999415,  2995728716, 1687173264, 3049352827, 2648078738, 190663705,
            486809970,  424002670,  2421764946, 2941043524, 3841512738, 119077561,  1801381572,
            2208680167, 2502730219, 9899015,    2455199230, 3755314209, 3958460021, 3846398898,
            1405136244, 2870563334, 821846618,  2790899812, 863647562,  629585032,  958925512,
            1190540209, 57251233,   2109551995, 2294881622, 2603370255, 3839518646, 123838650,
            3436270690, 1637121394, 3761101432, 954001192,  759760236,  3268295908, 2313083096,
            630164216,  2367213191, 3992059381, 3292952769, 2040774258, 1420209005, 527547730,
            1222399440, 1515078401, 2005580991, 645585788,  2256370254, 3057235502, 2870727428,
            2785498804, 333440916,  1873686678, 2489794553, 3726728164, 3405629071, 3869328595,
            3081963448, 2122133003, 1428788181, 4141962679, 41030733,   183716455,  36316501,
            1430796327, 1884066707, 1216957106, 3455082673, 1092665987, 535070834,  3873372533,
            175757671,  3414803303, 791028991,  3436610906, 2950895946, 977680845,  4224715886,
            2809442211, 4044727083, 3035532020, 4253187882, 969203959,  2539482914, 813880136,
            2483976489, 2790651795, 3298324523, 3508205426, 49280479,   917494217,  769620837,
            3411018785, 2391335000, 3036738936, 3356773416, 1288706527, 4178910717, 3636299534,
            2294957038, 3674654381, 537787012,  4271656840, 185820273,  2622722506, 1862365049,
            2550353307, 1392072847, 1870891365, 2838104933, 524666025,  3645751565, 2415020247,
            3691419894, 1295777418, 2130267479, 3636103610, 562446539,  750696587,  249830932,
            3894066051, 2239638596, 3256181120, 3981041836, 3217398876, 451287677,  3618957054,
            4236303539, 1027744929, 1724964245, 498574915,  2164122779, 582902291,  3040883311,
            3101287841, 1853378,    2125490000, 3185055972, 1607660025, 1128474163, 779476209,
            124284956,  2488937128, 2521389012, 338597864,  2873055013, 1171872946, 3130489952,
            4273333914, 1557892392, 3970896645, 942009076,  4069926418, 3129385884, 2688433076,
            388702536,  450999415,  2995728716, 1687173264, 157685189,  2648078738, 190663705,
            486809970,  424002670,  979986388,  2941043524, 3841512738, 119077561,  1801381572,
            2668625968, 2502730219, 9899015,    2455199230, 3755314209, 2699515741, 3846398898,
            1405136244, 2870563334, 821846618,  505633792,  863647562,  629585032,  958925512,
            1190540209, 2067402799, 2109551995, 2294881622, 2603370255, 3839518646, 2688067120,
            3436270690, 1637121394, 3761101432, 954001192,  3206166733, 3268295908, 2313083096,
            630164216,  2367213191, 3007494680, 3292952769, 2040774258, 1420209005, 527547730,
            4047406592, 1515078401, 2005580991, 645585788,  2256370254, 13805572,   2870727428,
            2785498804, 333440916,  1873686678, 1928222740, 3726728164, 3405629071, 3869328595,
            3081963448, 2971423693, 1428788181, 4141962679, 41030733,   183716455,  4064095256,
            1430796327, 1884066707, 1216957106, 3455082673, 985592757,  535070834,  3873372533,
            175757671,  3414803303, 2159028553, 3436610906, 2950895946, 977680845,  4224715886,
            345462057,  4044727083, 3035532020, 4253187882, 969203959,  984166534,  813880136,
            2483976489, 2790651795, 3298324523, 1080001158, 49280479,   917494217,  769620837,
            3411018785, 3216598401, 3036738936, 3356773416, 1288706527, 4178910717, 3311472057,
            2294957038, 3674654381, 537787012,  4271656840, 220045511,  2622722506, 1862365049,
            2550353307, 1392072847, 3057632678, 2838104933, 524666025,  3645751565, 2415020247,
            252304106,  1295777418, 2130267479, 3636103610, 562446539,  80437039,   249830932,
            3894066051, 2239638596, 3256181120, 117173223,  3217398876, 451287677,  3618957054,
            4236303539, 1986849360, 1724964245, 498574915,  2164122779, 582902291,  288631030,
            3101287841, 1853378,    2125490000, 3185055972, 824635664,  1128474163, 779476209,
            124284956,  2488937128, 1231646648, 338597864,  2873055013, 1171872946, 3130489952,
            708957725,  1557892392, 3970896645, 942009076,  4069926418, 2286522565, 2688433076,
            388702536,  450999415,  2995728716, 2523361978, 157685189,  2648078738, 190663705,
            486809970,  151444406,  979986388,  2941043524, 3841512738, 119077561,  3762447035,
            2668625968, 2502730219, 9899015,    2455199230, 3532439568, 2699515741, 3846398898,
            1405136244, 2870563334, 2242036665, 505633792,  863647562,  629585032,  958925512,
            2618618630, 2067402799, 2109551995, 2294881622, 2603370255, 2461404010, 2688067120,
            3436270690, 1637121394, 3761101432, 1076814097, 3206166733, 3268295908, 2313083096,
            630164216,  12196305,   3007494680, 3292952769, 2040774258, 1420209005, 2609377752,
            4047406592, 1515078401, 2005580991, 645585788,  865985176,  13805572,   2870727428,
            2785498804, 333440916,  3735553268, 1928222740, 3726728164, 3405629071, 3869328595,
            501640466,  2971423693, 1428788181, 4141962679, 41030733,   97561214,   4064095256,
            1430796327, 1884066707, 1216957106, 3840122090, 985592757,  535070834,  3873372533,
            175757671,  3856277268, 2159028553, 3436610906, 2950895946, 977680845,  3313441827,
            345462057,  4044727083, 3035532020, 4253187882, 3468811573, 984166534,  813880136,
            2483976489, 2790651795, 3733649754, 1080001158, 49280479,   917494217,  769620837,
            3969566450, 3216598401, 3036738936, 3356773416, 1288706527, 2444128005, 3311472057,
            2294957038, 3674654381, 537787012,  4166109669, 220045511,  2622722506, 1862365049,
            2550353307, 2552992760, 3057632678, 2838104933, 524666025,  3645751565, 664164441,
            252304106,  1295777418, 2130267479, 3636103610, 3227561061, 80437039,   249830932,
            3894066051, 2239638596, 1071536668, 117173223,  3217398876, 451287677,  3618957054,
            3066415327, 1986849360, 1724964245, 498574915,  2164122779, 3541914330, 288631030,
            3101287841, 1853378,    2125490000, 2207189978, 824635664,  1128474163, 779476209,
            124284956,  2117633906, 1231646648, 338597864,  2873055013, 1171872946, 891038594,
            708957725,  1557892392, 3970896645, 942009076,  42952651,   2286522565, 2688433076,
            388702536,  450999415,  2986730356, 2523361978, 157685189,  2648078738, 190663705,
            3058267870, 151444406,  979986388,  2941043524, 3841512738, 1844101292, 3762447035,
            2668625968, 2502730219, 9899015,    2599582093, 3532439568, 2699515741, 3846398898,
            1405136244, 811001941,  2242036665, 505633792,  863647562,  629585032,  2722320710,
            2618618630, 2067402799, 2109551995, 2294881622, 1820862072, 2461404010, 2688067120,
            3436270690, 1637121394, 3642978005, 1076814097, 3206166733, 3268295908, 2313083096,
            1900318020, 12196305,   3007494680, 3292952769, 2040774258, 520848705,  2609377752,
            4047406592, 1515078401, 2005580991, 2530251392, 865985176,  13805572,   2870727428,
            2785498804, 2878984912, 3735553268, 1928222740, 3726728164, 3405629071, 2717736455,
            501640466,  2971423693, 1428788181, 4141962679, 3704214873, 97561214,   4064095256,
            1430796327, 1884066707, 1721732760, 3840122090, 985592757,  535070834,  3873372533,
            770732059,  3856277268, 2159028553, 3436610906, 2950895946, 33753949,   3313441827,
            345462057,  4044727083, 3035532020, 4166506071, 2719759982, 1025532659, 3811323959,
            713457907,  1577198020, 1719946821, 3963262337, 1719605451, 703663722,  1943886497,
            2916371044, 1655862745, 109438187,  195575943,  2572727533, 2421761970, 1796539813,
            2020762515, 1191344316, 2492085516, 2778033179, 4002316684, 1571080685, 1157340389,
            3859584731, 3403766082, 2292873365, 2032258920, 1749575450, 848549431,  1893685820,
            3510068298, 3308906564, 1193936308, 2561670234, 1043148718, 2611815896, 3832995202,
            2436487998, 3377369330, 1174818128, 796514731,  1985886833, 88296218,   3032898657,
            4101301361, 1486994584, 237792475,  1029399834, 1708840018, 2934039708, 1496674948,
            4243234983, 3896751668, 1726119825, 2706068825, 1900013134, 2639641919, 1433377392,
            2962655166, 1870954268, 3873603462, 1778084630, 2393311756, 4135022799, 3669603001,
            811404758,  784379778,  4283689136, 405168660,  3873488622, 486946690,  347427153,
            2139072474, 1143349522, 3780264455, 2938731842, 3864001470, 3497981827, 2703917008,
            3222236962, 2604106616, 1281570367, 175937153,  433252852,  3232065906, 1111895932,
            1027363895, 2435093744, 4232690481, 1940855209, 2844613991, 2095175619, 3479946852,
            393314401,  3625733631, 1073779513, 2884072879, 4089630675, 3614205484, 1379809260,
            3980251795, 3914556410, 3633356126, 3030204458, 1654727861, 3765074811, 959734060,
            842315676,  353688341,  145655006,  1972100601, 1456042517, 3767579955, 4282066379,
            498998655,  4123310742, 1801424182, 777808179,  655425670,  588715641,  2136252742,
            1283378143, 639191135,  3132375783, 276649124,  2036776039, 3352396498, 3893441746,
            3298373918, 1024178230, 2623051553, 1956117442, 2955394456, 2478945776, 3904945720,
            769232312,  2168822980, 3715831945, 453874622,  3351529191, 3256151193, 808042625,
            1700919462, 1008305347, 1518733915, 3194328753, 2228970756, 2604658038, 1376476152,
            2147167203, 2585867511, 445717950,  3595016420, 3673970127, 3640614546, 494944945,
            152508312,  4160926899,
        },
        {
            3225674336, 827428943,  2858523441, 2447266124, 1539223637, 2299756421, 776912458,
            279091824,  1152725492, 3903457284, 3987010398, 3996115574, 839506039,  3052513014,
            28550291,   2597814974, 2328446377, 1961600298, 3695276714, 1334932648, 1141381380,
            3025370440, 997698792,  931473445,  3091440507, 820119215,  3586778616, 1993126242,
            4252838072, 3033829531, 2120026924, 65722921,   746724958,  461423533,  1582298542,
            1564918930, 3710935369, 419349792,  3914061713, 2279209938, 770031171,  2062767935,
            3373230309, 3582372364, 2025682996, 3352859025, 1262632952, 3140021482, 501370035,
            2554730117, 352450195,  1002557127, 2813224858, 2808406559, 290476252,  4216846311,
            1187381982, 3131323304, 1094330039, 2646234280, 655242013,  1152156402, 3658526705,
            3565043535, 693375321,  2120064836, 3726555752, 97387177,   546586686,  1013492636,
            3874404446, 440995849,  1929251266, 95137166,   564969023,  3559119399, 3855477390,
            2439885481, 2492213232, 2611214170, 2054191666, 2778642234, 2267416277, 2194315209,
            1360165075, 1018128176, 2841084399, 3028189871, 3631770575, 541021087,  1091467742,
            2743780329, 3566538467, 1277066122, 279582475,  2712119598, 3296319359, 4187226385,
            1468994750, 2946664285, 2284913307, 740953233,  3351500634, 1791054313, 3355533193,
            610062694,  3089981426, 3469441840, 3225672476, 2223653903, 2593994385, 548784340,
            549871569,  865468702,  1593939385, 645229999,  1412095765, 2814231763, 3619658094,
            877462820,  2198765077, 1845119421, 4144145546, 1356681209, 848707034,  4144513299,
            3231318896, 3382035479, 693621410,  2821661683, 4236142563, 680649431,  3290999942,
            200856634,  617766412,  3194332974, 4102392657, 2776797278, 2932808060, 793967937,
            2149374605, 3736514467, 3547689148, 3744888920, 98278184,   1497045279, 2945126332,
            4285864315, 2791068812, 1939995011, 56752862,   864909862,  625377571,  2266362085,
            1050287398, 925722519,  1008109592, 2819528345, 3573068613, 1915083884, 1536828870,
            3225674336, 827428943,  2858523441, 2447266124, 2186287936, 2299756421, 776912458,
            279091824,  1152725492, 1271286102, 3987010398, 3996115574, 839506039,  3052513014,
            1036957208, 2597814974, 2328446377, 1961600298, 3695276714, 2395157917, 1141381380,
            3025370440, 997698792,  931473445,  2727078785, 820119215,  3586778616, 1993126242,
            4252838072, 1171102868, 2120026924, 65722921,   746724958,  461423533,  2335086228,
            1564918930, 3710935369, 419349792,  3914061713, 1136716661, 770031171,  2062767935,
            3373230309, 3582372364, 4100328450, 3352859025, 1262632952, 3140021482, 501370035,
            2579000299, 352450195,  1002557127, 2813224858, 2808406559, 2642514897, 4216846311,
            1187381982, 3131323304, 1094330039, 3092488663, 655242013,  1152156402, 3658526705,
            3565043535, 3280658482, 2120064836, 3726555752, 97387177,   546586686,  584864345,
            3874404446, 440995849,  1929251266, 95137166,   823950215,  3559119399, 3855477390,
            2439885481, 2492213232, 2297040376, 2054191666, 2778642234, 2267416277, 2194315209,
            573807317,  1018128176, 2841084399, 3028189871, 3631770575, 2747338726, 1091467742,
            2743780329, 3566538467, 1277066122, 1715139924, 2712119598, 3296319359, 4187226385,
            1468994750, 3361368810, 2284913307, 740953233,  3351500634, 1791054313, 4290564545,
            610062694,  3089981426, 3469441840, 3225672476, 1010959310, 2593994385, 548784340,
            549871569,  865468702,  1825306744, 645229999,  1412095765, 2814231763, 3619658094,
            3792219969, 2198765077, 1845119421, 4144145546, 1356681209, 268197516,  4144513299,
            3231318896, 3382035479, 693621410,  2786831464, 4236142563, 680649431,  3290999942,
            200856634,  3822069622, 3194332974, 4102392657, 2776797278, 2932808060, 525501162,
            2149374605, 3736514467, 3547689148, 3744888920, 3219948462, 1497045279, 2945126332,
            4285864315, 2791068812, 2678467476, 56752862,   864909862,  625377571,  2266362085,
            2258093843, 925722519,  1008109592, 2819528345, 3573068613, 2743241289, 1536828870,
            3225674336, 827428943,  2858523441, 992128922,  2186287936, 2299756421, 776912458,
            279091824,  2108721702, 1271286102, 3987010398, 3996115574, 839506039,  1315622698,
            1036957208, 2597814974, 2328446377, 1961600298, 3098343478, 2395157917, 1141381380,
            3025370440, 997698792,  1317753106, 2727078785, 820119215,  3586778616, 1993126242,
            2295599934, 1171102868, 2120026924, 65722921,   746724958,  3999203443, 2335086228,
            1564918930, 3710935369, 419349792,  1662083910, 1136716661, 770031171,  2062767935,
            3373230309, 3271761171, 4100328450, 3352859025, 1262632952, 3140021482, 3981040854,
            2579000299, 352450195,  1002557127, 2813224858, 1064251076, 2642514897, 4216846311,
            1187381982, 3131323304, 2077640887, 3092488663, 655242013,  1152156402, 3658526705,
            548941006,  3280658482, 2120064836, 3726555752, 97387177,   4112878213, 584864345,
            3874404446, 440995849,  1929251266, 227230803,  823950215,  3559119399, 3855477390,
            2439885481, 610498128,  2297040376, 2054191666, 2778642234, 2267416277, 518192832,
            573807317,  1018128176, 2841084399, 3028189871, 2512871059, 2747338726, 1091467742,
            2743780329, 3566538467, 386661563,  1715139924, 2712119598, 3296319359, 4187226385,
            2508754324, 3361368810, 2284913307, 740953233,  3351500634, 1296305541, 4290564545,
            610062694,  3089981426, 3469441840, 148510865,  1010959310, 2593994385, 548784340,
            549871569,  124676809,  1825306744, 645229999,  1412095765, 2814231763, 2540745278,
            3792219969, 2198765077, 1845119421, 4144145546, 3966655401, 268197516,  4144513299,
            3231318896, 3382035479, 1674022032, 2786831464, 4236142563, 680649431,  3290999942,
            4065303704, 3822069622, 3194332974, 4102392657, 2776797278, 3735376922, 525501162,
            2149374605, 3736514467, 3547689148, 2064870756, 3219948462, 1497045279, 2945126332,
            4285864315, 2389978045, 2678467476, 56752862,   864909862,  625377571,  2308006661,
            2258093843, 925722519,  1008109592, 2819528345, 2927186231, 2743241289, 1536828870,
            3225674336, 827428943,  1583633720, 992128922,  2186287936, 2299756421, 776912458,
            298217241,  2108721702, 1271286102, 3987010398, 3996115574, 1041730366, 1315622698,
            1036957208, 2597814974, 2328446377, 1386688725, 3098343478, 2395157917, 1141381380,
            3025370440, 2292273773, 1317753106, 2727078785, 820119215,  3586778616, 206996196,
            2295599934, 1171102868, 2120026924, 65722921,   3271158508, 3999203443, 2335086228,
            1564918930, 3710935369, 3305544914, 1662083910, 1136716661, 770031171,  2062767935,
            4244195826, 3271761171, 4100328450, 3352859025, 1262632952, 3581040310, 3981040854,
            2579000299, 352450195,  1002557127, 1789606594, 1064251076, 2642514897, 4216846311,
            1187381982, 1519386238, 2077640887, 3092488663, 655242013,  1152156402, 3732146227,
            548941006,  3280658482, 2120064836, 3726555752, 2631398817, 4112878213, 584864345,
            3874404446, 440995849,  3541162446, 227230803,  823950215,  3559119399, 3855477390,
            560704260,  610498128,  2297040376, 2054191666, 2778642234, 1614756373, 518192832,
            573807317,  1018128176, 2841084399, 927011949,  2512871059, 2747338726, 1091467742,
            2743780329, 566198434,  386661563,  1715139924, 2712119598, 3296319359, 520529825,
            2508754324, 3361368810, 2284913307, 740953233,  2414584088, 1296305541, 4290564545,
            610062694,  3089981426, 120496553,  148510865,  1010959310, 2593994385, 548784340,
            3206664898, 124676809,  1825306744, 645229999,  1412095765, 821445348,  2540745278,
            3792219969, 2198765077, 1845119421, 3434574619, 3966655401, 268197516,  4144513299,
            3231318896, 3856935910, 1674022032, 2786831464, 4236142563, 680649431,  3331403374,
            4065303704, 3822069622, 3194332974, 4102392657, 2194924932, 3735376922, 525501162,
            2149374605, 3736514467, 2041458481, 2064870756, 3219948462, 1497045279, 2945126332,
            3515890044, 2389978045, 2678467476, 56752862,   864909862,  1009125580, 2308006661,
            2258093843, 925722519,  1008109592, 4166824654, 3399481064, 3848337172, 841675162,
            2388734555, 3373081217, 1627287001, 1958651480, 1771323855, 2126620758, 3879967947,
            1885140905, 806066092,  2168342987, 3778265278, 943582962,  3895768303, 337928214,
            3677576461, 1884088203, 2629440785, 2357038005, 2362450760, 2080907681, 2644383608,
            4153875040, 794977307,  2675637463, 2655426076, 3481699657, 2262369403, 1038608931,
            4210267953, 2376694315, 2661705117, 3994997027, 2994346963, 4074343171, 833108024,
            3562046155, 1113632369, 3087093963, 2115712884, 2778607581, 2702162487, 1347693590,
            4271098334, 2746712394, 1629623802, 1932973152, 3077074108, 1338011180, 848785806,
            1834095770, 4017238,    2661097500, 2935787683, 1214195119, 3099491937, 3868451396,
            1063740008, 2768962809, 2554721244, 695479209,  2634119800, 1379839034, 2653377927,
            921934002,  3586936843, 3035369677, 769283110,  2417935220, 3330084607, 2020519519,
            2546176786, 1523223165, 3654065096, 1835059231, 2776263618, 3837173427, 3236141295,
            1184415634, 157448610,  2474336972, 3313035876, 309195150,  2288837115, 548743307,
            528342914,  1527562212, 554918643,  2739291918, 2630873849, 155419923,  226845272,
            1343735931, 3106346884, 4177975386, 2515480406, 2049734808, 2802879609, 1805234272,
            317920918,  745796250,  3816657414, 4198378080, 3057334192, 503016924,  2027816790,
            579332504,  3037999504, 2857298788, 911046668,  1170775701, 2369720,    3364839261,
            1462383461, 181600856,  1315241696, 2861043792, 3549404088, 3974245218, 4141518566,
            1195336199, 2291064152, 3287203016, 3867432937, 2593766219, 2114273192, 3716228986,
            410286941,  2497285113, 1338500439, 3748757692, 2315519304, 545570554,  1519868916,
            679216320,  3264840479, 4083041163, 261878334,  2370312122, 1408058272, 1287635274,
            3433241543, 3923613754, 2423502603, 3948993135, 1418484161, 230113502,  1766447938,
            3101286974, 917358979,  2836128279, 2859079881, 3162688352, 2158281644, 154509481,
            2409785274, 3096379437,
        },
        {
            2456954827, 2895978734, 1621803157, 230462381,  4046364119, 716597790,  2031510641,
            2208319977, 1107910846, 3379950723, 3628284249, 1393263274, 3842378742, 768116962,
            1782906996, 3022943801, 510040722,  2180373447, 1294989632, 1659724107, 953774117,
            500296619,  2269873184, 3215368465, 3933601613, 2401810535, 3568992417, 617528376,
            2437412983, 2921242388, 2311040363, 3695847323, 1609309841, 3222455492, 1108155620,
            397599239,  3344183623, 1159383441, 81554651,   4223302962, 2812031899, 2613176831,
            2967803832, 3560382993, 670173062,  2361031672, 1745444335, 2067906079, 3019908371,
            2662226130, 2962440272, 3053411095, 92212044,   1041941495, 4116546365, 2094375399,
            3992554702, 216246182,  2271736480, 1006434362, 4104644208, 2543874803, 1310440964,
            1956002873, 1485192936, 3027546418, 448786402,  749040342,  406538664,  2522826782,
            3681979470, 3941253886, 672615054,  3655479714, 392178376,  1619518340, 1639889010,
            666186812,  4094569743, 2947917117, 3308938954, 1572886498, 1065510431, 2158389109,
            1583642689, 1763046973, 3578310229, 4106948216, 58659757,   691952777,  3394715763,
            3333944006, 3020203798, 3598064251, 3151881711, 2071056894, 1263790655, 4188233031,
            4230429856, 3088041549, 3031631424, 3912597408, 1768734847, 1975027092, 3976493733,
            2376551740, 1137628506, 535767974,  3105256806, 15427398,   2472341690, 685997424,
            1374644561, 2446214061, 2844847931, 1058649390, 1581230869, 1725846082, 3062699842,
            1116400547, 1095426642, 2940190462, 4276038488, 2091764667, 4074059985, 98163536,
            4157153745, 32476821,   2354284775, 752663757,  2987293678, 1119786914, 3019442904,
            111185876,  3569592548, 3991775183, 3161418733, 3973354577, 1650454973, 426129509,
            3659038742, 1387393667, 543731583,  781586523,  917315276,  832142534,  3911092159,
            325250500,  2735441676, 163564958,  1002098855, 337936437,  1869530240, 2233969733,
            4108076124, 3255026725, 4072134049, 2083771067, 1559589006, 1845121907, 466036013,
            2456954827, 2895978734, 1621803157, 230462381,  2022150409, 716597790,  2031510641,
            2208319977, 1107910846, 1838834877, 3628284249, 1393263274, 3842378742, 768116962,
            2303040715, 3022943801, 510040722,  2180373447, 1294989632, 3074858415, 953774117,
            500296619,  2269873184, 3215368465, 3531413908, 2401810535, 3568992417, 617528376,
            2437412983, 1730632320, 2311040363, 3695847323, 1609309841, 3222455492, 3189359980,
            397599239,  3344183623, 1159383441, 81554651,   1933731121, 2812031899, 2613176831,
            2967803832, 3560382993, 758113139,  2361031672, 1745444335, 2067906079, 3019908371,
            3537991495, 2962440272, 3053411095, 92212044,   1041941495, 2653519981, 2094375399,
            3992554702, 216246182,  2271736480, 695350220,  4104644208, 2543874803, 1310440964,
            1956002873, 3373048130, 3027546418, 448786402,  749040342,  406538664,  4081844472,
            3681979470, 3941253886, 672615054,  3655479714, 197563239,  1619518340, 1639889010,
            666186812,  4094569743, 2518320719, 3308938954, 1572886498, 1065510431, 2158389109,
            3320483696, 1763046973, 3578310229, 4106948216, 58659757,   3412172826, 3394715763,
            3333944006, 3020203798, 3598064251, 1693717788, 2071056894, 1263790655, 4188233031,
            4230429856, 2564478937, 3031631424, 3912597408, 1768734847, 1975027092, 3546175061,
            2376551740, 1137628506, 535767974,  3105256806, 450760279,  2472341690, 685997424,
            1374644561, 2446214061, 1873063065, 1058649390, 1581230869, 1725846082, 3062699842,
            813496775,  1095426642, 2940190462, 4276038488, 2091764667, 3857233976, 98163536,
            4157153745, 32476821,   2354284775, 3115605568, 2987293678, 1119786914, 3019442904,
            111185876,  996447434,  3991775183, 3161418733, 3973354577, 1650454973, 1089784804,
            3659038742, 1387393667, 543731583,  781586523,  2711412312, 832142534,  3911092159,
            325250500,  2735441676, 3563501139, 1002098855, 337936437,  1869530240, 2233969733,
            1156926454, 3255026725, 4072134049, 2083771067, 1559589006, 3832870112, 466036013,
            2456954827, 2895978734, 1621803157, 2340808859, 2022150409, 716597790,  2031510641,
            2208319977, 1823993818, 1838834877, 3628284249, 1393263274, 3842378742, 2489609764,
            2303040715, 3022943801, 510040722,  2180373447, 4204167795, 3074858415, 953774117,
            500296619,  2269873184, 2320314628, 3531413908, 2401810535, 3568992417, 617528376,
            712451843,  1730632320, 2311040363, 3695847323, 1609309841, 3224192365, 3189359980,
            397599239,  3344183623, 1159383441, 758272390,  1933731121, 2812031899, 2613176831,
            2967803832, 3986798661, 758113139,  2361031672, 1745444335, 2067906079, 3814344052,
            3537991495, 2962440272, 3053411095, 92212044,   817573506,  2653519981, 2094375399,
            3992554702, 216246182,  2456924809, 695350220,  4104644208, 2543874803, 1310440964,
            1151286621, 3373048130, 3027546418, 448786402,  749040342,  637572176,  4081844472,
            3681979470, 3941253886, 672615054,  3038758846, 197563239,  1619518340, 1639889010,
            666186812,  4254608071, 2518320719, 3308938954, 1572886498, 1065510431, 3100620860,
            3320483696, 1763046973, 3578310229, 4106948216, 403923766,  3412172826, 3394715763,
            3333944006, 3020203798, 1859724785, 1693717788, 2071056894, 1263790655, 4188233031,
            2908736862, 2564478937, 3031631424, 3912597408, 1768734847, 966714666,  3546175061,
            2376551740, 1137628506, 535767974,  1561255376, 450760279,  2472341690, 685997424,
            1374644561, 3122124160, 1873063065, 1058649390, 1581230869, 1725846082, 3791666219,
            813496775,  1095426642, 2940190462, 4276038488, 2802023399, 3857233976, 98163536,
            4157153745, 32476821,   1640659450, 3115605568, 2987293678, 1119786914, 3019442904,
            4278091706, 996447434,  3991775183, 3161418733, 3973354577, 3398421232, 1089784804,
            3659038742, 1387393667, 543731583,  1694361696, 2711412312, 832142534,  3911092159,
            325250500,  166035542,  3563501139, 1002098855, 337936437,  1869530240, 1306446339,
            1156926454, 3255026725, 4072134049, 2083771067, 61899937,   3832870112, 466036013,
            2456954827, 2895978734, 767569205,  2340808859, 2022150409, 716597790,  2031510641,
            1690074863, 1823993818, 1838834877, 3628284249, 1393263274, 546011580,  2489609764,
            2303040715, 3022943801, 510040722,  825252468,  4204167795, 3074858415, 953774117,
            500296619,  1952242515, 2320314628, 3531413908, 2401810535, 3568992417, 4254767597,
            712451843,  1730632320, 2311040363, 3695847323, 2393864919, 3224192365, 3189359980,
            397599239,  3344183623, 1759399025, 758272390,  1933731121, 2812031899, 2613176831,
            2809078783, 3986798661, 758113139,  2361031672, 1745444335, 1223235915, 3814344052,
            3537991495, 2962440272, 3053411095, 3711100000, 817573506,  2653519981, 2094375399,
            3992554702, 2987412942, 2456924809, 695350220,  4104644208, 2543874803, 2746231792,
            1151286621, 3373048130, 3027546418, 448786402,  801157439,  637572176,  4081844472,
            3681979470, 3941253886, 975875511,  3038758846, 197563239,  1619518340, 1639889010,
            3137491209, 4254608071, 2518320719, 3308938954, 1572886498, 631178204,  3100620860,
            3320483696, 1763046973, 3578310229, 3338308117, 403923766,  3412172826, 3394715763,
            3333944006, 37220448,   1859724785, 1693717788, 2071056894, 1263790655, 228419012,
            2908736862, 2564478937, 3031631424, 3912597408, 3862306448, 966714666,  3546175061,
            2376551740, 1137628506, 1114919961, 1561255376, 450760279,  2472341690, 685997424,
            2456661198, 3122124160, 1873063065, 1058649390, 1581230869, 2996925693, 3791666219,
            813496775,  1095426642, 2940190462, 1642720015, 2802023399, 3857233976, 98163536,
            4157153745, 1578965959, 1640659450, 3115605568, 2987293678, 1119786914, 1748408698,
            4278091706, 996447434,  3991775183, 3161418733, 4123935663, 3398421232, 1089784804,
            3659038742, 1387393667, 770706529,  1694361696, 2711412312, 832142534,  3911092159,
            335435644,  166035542,  3563501139, 1002098855, 337936437,  2961857543, 1306446339,
            1156926454, 3255026725, 4072134049, 1717290230, 1323146393, 2156340433, 2065716367,
            2597996276, 3402032152, 779574284,  2369501052, 2316224856, 2720986136, 3016786025,
            2916554213, 3476215746, 1132150235, 2619889920, 1279664685, 679206534,  4014394509,
            3624968312, 1480455625, 725015758,  707677352,  3764409715, 1938306480, 2171474419,
            3379664161, 684262379,  2142433069, 43407198,   1398850259, 2059135843, 240266749,
            3788738212, 118513026,  820245055,  1152812311, 1398373423, 3188977726, 872620936,
            2084649448, 807979538,  819501992,  615447916,  3393148006, 1765623964, 2514767257,
            3711360450, 2941886951, 3739102698, 4022385962, 2306039667, 3321267290, 2179238310,
            3192652502, 2118792870, 2571142127, 761776508,  873010906,  1609627751, 4260021041,
            1747852747, 960771906,  2647903291, 77475681,   1282566533, 4022186916, 2681128032,
            1554542462, 3181701944, 1168469070, 74236514,   2806532232, 3981048887, 1888842784,
            2888607878, 1763028723, 701886756,  4124077776, 3738147505, 4066663138, 3816449863,
            921061872,  2956972182, 3159072916, 3337110888, 3552795700, 2281281091, 671098116,
            1282750020, 1008618197, 2363767765, 1812013295, 1854965999, 131027176,  666394000,
            2062217824, 1763334218, 551118598,  1277961175, 3523893635, 1855881150, 2067903393,
            2590963277, 3214508854, 1604911832, 1906690475, 389417851,  2711591984, 427723436,
            1039703630, 639602991,  444779318,  2722002973, 3927985419, 1297446054, 298277450,
            656022205,  134304205,  3847728042, 3339100423, 407022043,  1282443442, 3173884578,
            1417906094, 2364502739, 2158353472, 2402775649, 1807696073, 2837535198, 705887737,
            2129202688, 3853676283, 1388329793, 875153687,  2367465660, 2763058233, 2500632304,
            2196920062, 491306883,  277753357,  3868415380, 324867643,  3654474955, 2569410351,
            1128175417, 1853572398, 1133201743, 662085935,  2263514999, 3077768113, 3309730620,
            3602394176, 3747458070, 188422725,  813812450,  1502276531, 3909138356, 2766044599,
            3760928321, 573108836,
        },
        {
            1240264181, 1624064648, 3039823158, 2013985253, 1473300299, 2762062141, 3273470484,
            1889745445, 2516996174, 3190376531, 996186898,  3893981177, 1268272590, 3226095713,
            153038465,  2184871198, 3224094011, 2526518401, 1738960059, 1187560605, 4194384320,
            2837011297, 3638232350, 367907454,  574009898,  1948901330, 60430044,   1569835584,
            3160561697, 321792583,  3179087993, 1936928378, 412346905,  4020812489, 2603392174,
            3499496781, 1499441233, 1062415256, 1347130973, 1823246794, 3411391800, 4253618056,
            1507733072, 1605629518, 1503312494, 8035741,    4038904206, 2408545792, 969543501,
            954847087,  956553276,  3096241999, 2566194741, 84678421,   3882676079, 2483934330,
            3673546814, 2461422466, 620385599,  898325340,  2145883445, 3653728520, 3744850294,
            2441124935, 904854507,  3216304963, 2373268568, 2354362010, 1245572787, 2894748714,
            2889136188, 3716879184, 1766013949, 1305712667, 1227530310, 4051221847, 925440190,
            1508686692, 1104647879, 1496666754, 3300504219, 127787091,  1528394637, 1739640835,
            2475711496, 3792639955, 1450796299, 1634217367, 3289785095, 2149949989, 811612039,
            1750779366, 1157474938, 514004414,  2264909096, 3730411668, 3308882513, 1834571716,
            378288317,  3800023701, 763396788,  1597708317, 983953861,  94566098,   1548157668,
            3755427117, 1646496505, 3748241449, 3439805936, 2321644449, 3805706235, 4220083901,
            1069923823, 2984004391, 3824885361, 1967477766, 218978249,  348955028,  3188651823,
            1008338679, 2331688720, 1562995454, 1837179689, 3033872688, 3007293665, 1759522678,
            319754369,  2763991927, 1983149629, 1353197132, 1489552694, 2990539062, 3244609108,
            669775440,  886127995,  1636688014, 1251222487, 2351883247, 3261502906, 3139614137,
            3203790139, 2777648095, 3693390579, 3540514982, 3200191735, 750726325,  1014534145,
            2091792357, 3931704474, 1383925867, 2038878506, 2247134268, 2840132188, 61137652,
            1162051299, 399657268,  1682018695, 2640231287, 1733438115, 3611823506, 2077891037,
            1240264181, 1624064648, 3039823158, 2013985253, 4188888201, 2762062141, 3273470484,
            1889745445, 2516996174, 2621448256, 996186898,  3893981177, 1268272590, 3226095713,
            952803645,  2184871198, 3224094011, 2526518401, 1738960059, 738368399,  4194384320,
            2837011297, 3638232350, 367907454,  3772812520, 1948901330, 60430044,   1569835584,
            3160561697, 1655622513, 3179087993, 1936928378, 412346905,  4020812489, 3754224996,
            3499496781, 1499441233, 1062415256, 1347130973, 1167581269, 3411391800, 4253618056,
            1507733072, 1605629518, 1867781671, 8035741,    4038904206, 2408545792, 969543501,
            3189323143, 956553276,  3096241999, 2566194741, 84678421,   996778900,  2483934330,
            3673546814, 2461422466, 620385599,  3129088144, 2145883445, 3653728520, 3744850294,
            2441124935, 4230756652, 3216304963, 2373268568, 2354362010, 1245572787, 1600525238,
            2889136188, 3716879184, 1766013949, 1305712667, 59908073,   4051221847, 925440190,
            1508686692, 1104647879, 2931214731, 3300504219, 127787091,  1528394637, 1739640835,
            62963469,   3792639955, 1450796299, 1634217367, 3289785095, 667987389,  811612039,
            1750779366, 1157474938, 514004414,  2737193098, 3730411668, 3308882513, 1834571716,
            378288317,  3452657469, 763396788,  1597708317, 983953861,  94566098,   2752347916,
            3755427117, 1646496505, 3748241449, 3439805936, 4222757079, 3805706235, 4220083901,
            1069923823, 2984004391, 3887639520, 1967477766, 218978249,  348955028,  3188651823,
            4168456281, 2331688720, 1562995454, 1837179689, 3033872688, 814903833,  1759522678,
            319754369,  2763991927, 1983149629, 3818528075, 1489552694, 2990539062, 3244609108,
            669775440,  1004789460, 1636688014, 1251222487, 2351883247, 3261502906, 4143823654,
            3203790139, 2777648095, 3693390579, 3540514982, 153421222,  750726325,  1014534145,
            2091792357, 3931704474, 4018591985, 2038878506, 2247134268, 2840132188, 61137652,
            1455028838, 399657268,  1682018695, 2640231287, 1733438115, 1853142849, 2077891037,
            1240264181, 1624064648, 3039823158, 2235369076, 4188888201, 2762062141, 3273470484,
            1889745445, 3627876603, 2621448256, 996186898,  3893981177, 1268272590, 2687846008,
            952803645,  2184871198, 3224094011, 2526518401, 861379413,  738368399,  4194384320,
            2837011297, 3638232350, 3753321702, 3772812520, 1948901330, 60430044,   1569835584,
            581506474,  1655622513, 3179087993, 1936928378, 412346905,  2710043900, 3754224996,
            3499496781, 1499441233, 1062415256, 2704745463, 1167581269, 3411391800, 4253618056,
            1507733072, 4215403465, 1867781671, 8035741,    4038904206, 2408545792, 3252742933,
            3189323143, 956553276,  3096241999, 2566194741, 1865159158, 996778900,  2483934330,
            3673546814, 2461422466, 3123557619, 3129088144, 2145883445, 3653728520, 3744850294,
            21840044,   4230756652, 3216304963, 2373268568, 2354362010, 1934462999, 1600525238,
            2889136188, 3716879184, 1766013949, 2822794708, 59908073,   4051221847, 925440190,
            1508686692, 2938291976, 2931214731, 3300504219, 127787091,  1528394637, 1914923136,
            62963469,   3792639955, 1450796299, 1634217367, 257322213,  667987389,  811612039,
            1750779366, 1157474938, 3083649350, 2737193098, 3730411668, 3308882513, 1834571716,
            2778729422, 3452657469, 763396788,  1597708317, 983953861,  1337754195, 2752347916,
            3755427117, 1646496505, 3748241449, 3942745717, 4222757079, 3805706235, 4220083901,
            1069923823, 1314928500, 3887639520, 1967477766, 218978249,  348955028,  3425797638,
            4168456281, 2331688720, 1562995454, 1837179689, 1814071277, 814903833,  1759522678,
            319754369,  2763991927, 1079270448, 3818528075, 1489552694, 2990539062, 3244609108,
            2944573315, 1004789460, 1636688014, 1251222487, 2351883247, 1356892540, 4143823654,
            3203790139, 2777648095, 3693390579, 983917956,  153421222,  750726325,  1014534145,
            2091792357, 296882400,  4018591985, 2038878506, 2247134268, 2840132188, 3508266160,
            1455028838, 399657268,  1682018695, 2640231287, 2480988791, 1853142849, 2077891037,
            1240264181, 1624064648, 1741738969, 2235369076, 4188888201, 2762062141, 3273470484,
            3569498651, 3627876603, 2621448256, 996186898,  3893981177, 4026533880, 2687846008,
            952803645,  2184871198, 3224094011, 1290870737, 861379413,  738368399,  4194384320,
            2837011297, 3833099205, 3753321702, 3772812520, 1948901330, 60430044,   4131290878,
            581506474,  1655622513, 3179087993, 1936928378, 2379952582, 2710043900, 3754224996,
            3499496781, 1499441233, 593780490,  2704745463, 1167581269, 3411391800, 4253618056,
            621889762,  4215403465, 1867781671, 8035741,    4038904206, 2045289976, 3252742933,
            3189323143, 956553276,  3096241999, 2188329018, 1865159158, 996778900,  2483934330,
            3673546814, 2717648418, 3123557619, 3129088144, 2145883445, 3653728520, 1528077261,
            21840044,   4230756652, 3216304963, 2373268568, 803158556,  1934462999, 1600525238,
            2889136188, 3716879184, 161827512,  2822794708, 59908073,   4051221847, 925440190,
            3599942370, 2938291976, 2931214731, 3300504219, 127787091,  4082579845, 1914923136,
            62963469,   3792639955, 1450796299, 2035446714, 257322213,  667987389,  811612039,
            1750779366, 2344204796, 3083649350, 2737193098, 3730411668, 3308882513, 2765191583,
            2778729422, 3452657469, 763396788,  1597708317, 1854746879, 1337754195, 2752347916,
            3755427117, 1646496505, 4020292301, 3942745717, 4222757079, 3805706235, 4220083901,
            1408262601, 1314928500, 3887639520, 1967477766, 218978249,  2173193841, 3425797638,
            4168456281, 2331688720, 1562995454, 2835294077, 1814071277, 814903833,  1759522678,
            319754369,  4048528178, 1079270448, 3818528075, 1489552694, 2990539062, 787253600,
            2944573315, 1004789460, 1636688014, 1251222487, 3584515216, 1356892540, 4143823654,
            3203790139, 2777648095, 1681621541, 983917956,  153421222,  750726325,  1014534145,
            3951869055, 296882400,  4018591985, 2038878506, 2247134268, 1990726826, 3508266160,
            1455028838, 399657268,  1682018695, 3360119279, 3151120565, 3011208718, 3694535943,
            104562665,  2827623271, 249712003,  3413221355, 2347164236, 3227498378, 1805068659,
            2118219686, 1568133029, 902801951,  175637375,  3812819970, 2162769758, 3845613089,
            1795179477, 171494391,  3765826349, 1725798906, 345463508,  2481043227, 226569380,
            3250095421, 1085199388, 3107594542, 4011388155, 1092611190, 3239339214, 4211849464,
            4109911546, 81212018,   3691937144, 2477407396, 3320520455, 3070067913, 3808621884,
            252917069,  3394860294, 1092442235, 2876536384, 1684120191, 431096075,  1701716708,
            639881684,  3066183997, 3660504927, 2047274,    3424756424, 760932520,  2457976057,
            1705265011, 2691137533, 3684307557, 3532744498, 2319162513, 1015534908, 1907173398,
            2820698743, 1264455116, 2323788906, 3062240844, 1878550513, 1717353426, 1805673248,
            62425157,   3662381032, 1964107209, 2559831960, 2117844804, 1228721677, 4240498866,
            3212920337, 2338600301, 931588693,  2379606585, 3643222352, 4154645082, 1115847065,
            2079427925, 2256943798, 2795103368, 2688136486, 1458062143, 1767222217, 635424385,
            284062050,  1547163554, 3380046528, 1145758046, 3935976713, 4017430175, 3863367362,
            3041367424, 303263160,  1465965696, 3757919837, 3083072836, 4024514094, 1381331179,
            2393446325, 3256476469, 4066482738, 3437941107, 1051266504, 921764078,  2933305619,
            1358097211, 4100978724, 2709958834, 574590507,  961767386,  21100886,   753746372,
            4072632446, 733729367,  3060214669, 289165105,  426065754,  2036100240, 2172365757,
            502856627,  84490194,   2630806596, 1206161269, 1009438449, 569581317,  1836947000,
            3125379675, 1756936428, 3772694822, 3670337911, 3020603818, 2376224883, 2539951453,
            2053395002, 3525193914, 1991480838, 3786481083, 873873707,  1693894743, 2450223985,
            754878026,  1943356492, 401524329,  759931885,  611231307,  147950334,  599693701,
            3358729722, 3649058074, 906423787,  1333804225, 875187278,  1115838692, 2476325972,
            3307226674, 3539078918,
        },
};
