/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QNETWORKREPLY
#define QNETWORKREPLY

#include <QBuffer>
#include <QVariant>
#include <QUrl>
#include <QString>
#include <QMetaMethod>

#include "QNetworkRequest"

/**
 * This class is a mock class for
 * http://qt-project.org/doc/qt-5.0/qtnetwork/qnetworkreply.html
 */
class QNetworkReply : public QBuffer
{
    Q_OBJECT

public:
    enum NetworkError {
        NoError,
        ConnectionRefusedError
    };

    QNetworkReply(QObject* parent = 0);

    QVariant attribute(QNetworkRequest::Attribute code) const;

    NetworkError error() const;
    QString errorString() const;
    void setRedirectUrl(QUrl url);

Q_SIGNALS:
    void finished();

protected:
    void connectNotify(const QMetaMethod &signal);

private:
    NetworkError m_error;
    QUrl m_redirectUrl;
};

#endif
