# 19 "calc.mll"
 

  open Lexing
  open Printf
  open Cr

(*s Options and parsing of the command-line. *)

  let precision = ref 10

  let usage = "usage: ecalc [-p prec]

ecalc is a reverse-polish exact calcultator

Copyright (c) 2001- Jean-Christophe Fillitre
This is free software with ABSOLUTELY NO WARRANTY

commands are
  k, prec      pops the top of stack and uses it as precision 

  ;, p, print  displays top of stack
  n, popd      pops top of stack and displays it
  f, show      displays the whole stack
  
  pop          pops top of stack
  c, clear     clears the stack
  d, dup       duplicates top of stack
  r, swap      swaps the two elements on top of stack

constants are
  pi, e

binary operations are
  +, -, *, /, log ('x y log' is log_x(y)), pow (or ^)

unary operations are
  ~ (negation), i (inverse), sqrt (or v), sin, cos, tan, ln, exp, 
  arcsin, arccos, arctan, sinh, cosh, tanh, arcsinh, arccosh, arctanh

options are"

  let speclist = 
    ["-p", Arg.Int (fun n -> precision := n), " set decimal precision"]

  let _ = Arg.parse speclist (fun _ -> ()) usage

(*s The stack. *)

  let stack = ref []

  let push x = stack := x :: !stack

  let error msg = printf "%s\n" msg; flush stdout

  let pop () = match !stack with
    | [] -> invalid_arg "pop"
    | x :: l -> stack := l; x

  let display_stack () =
    List.iter
      (fun x -> printf "   %s\n" (to_string x !precision)) 
      (List.rev !stack);
    flush stdout 

(*s Unary and binary operations on the stack. *)

  let unop f = push (f (pop ()))

  let binop f =
    let x2 = pop () in
    let x1 = pop () in
    push (f x1 x2)


# 77 "calc.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\217\255\216\255\002\000\002\000\253\255\252\255\251\255\
    \250\255\249\255\000\000\245\255\244\255\012\000\028\000\240\255\
    \239\255\238\255\237\255\236\255\235\255\000\000\013\000\225\255\
    \014\000\019\000\001\000\007\000\218\255\028\000\000\000\009\000\
    \012\000\003\000\015\000\018\000\031\000\224\255\024\000\038\000\
    \031\000\020\000\041\000\043\000\038\000\034\000\049\000\038\000\
    \045\000\219\255\035\000\047\000\220\255\042\000\049\000\221\255\
    \044\000\051\000\222\255\055\000\042\000\056\000\223\255\064\000\
    \048\000\247\255\062\000\049\000\242\255\053\000\066\000\064\000\
    \058\000\055\000\055\000\077\000\076\000\069\000\077\000\077\000\
    \067\000\064\000\077\000\081\000\084\000\085\000\075\000\070\000\
    \082\000\073\000\084\000\079\000\081\000\227\255\089\000\226\255\
    \081\000\228\255\146\000\156\000\102\000\246\255\107\000\104\000\
    \254\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\000\000\039\000\255\255\255\255\255\255\
    \255\255\255\255\009\000\255\255\255\255\039\000\012\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\014\000\039\000\255\255\
    \006\000\008\000\039\000\039\000\255\255\039\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\021\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \026\000\255\255\255\255\025\000\255\255\255\255\024\000\255\255\
    \255\255\023\000\255\255\255\255\255\255\022\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\007\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \002\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\012\000\012\000\255\255\255\255\255\255\255\255\
    \255\255";
  Lexing.lex_default = 
   "\002\000\000\000\000\000\255\255\255\255\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\255\255\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\000\000\255\255\255\255\000\000\
    \255\255\255\255\000\000\255\255\255\255\255\255\000\000\255\255\
    \255\255\000\000\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\000\000\
    \255\255\000\000\255\255\255\255\255\255\000\000\255\255\255\255\
    \000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\003\000\003\000\003\000\003\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \003\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\017\000\015\000\000\000\016\000\013\000\018\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\000\000\009\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\000\000\000\000\
    \000\000\000\000\098\000\006\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\023\000\000\000\
    \000\000\027\000\056\000\025\000\010\000\021\000\007\000\102\000\
    \004\000\020\000\039\000\005\000\022\000\038\000\008\000\041\000\
    \024\000\036\000\011\000\029\000\026\000\100\000\028\000\068\000\
    \096\000\042\000\012\000\093\000\094\000\069\000\019\000\059\000\
    \066\000\035\000\060\000\067\000\030\000\033\000\028\000\037\000\
    \011\000\040\000\007\000\007\000\043\000\034\000\045\000\053\000\
    \031\000\050\000\047\000\032\000\048\000\049\000\051\000\052\000\
    \054\000\055\000\057\000\058\000\063\000\061\000\044\000\046\000\
    \062\000\064\000\065\000\085\000\071\000\070\000\008\000\086\000\
    \072\000\083\000\073\000\075\000\023\000\074\000\076\000\077\000\
    \078\000\079\000\080\000\081\000\082\000\012\000\084\000\006\000\
    \088\000\087\000\009\000\089\000\090\000\091\000\092\000\005\000\
    \095\000\097\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\101\000\103\000\
    \104\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\003\000\003\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\003\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\013\000\013\000\013\000\013\000\
    \013\000\013\000\013\000\013\000\013\000\013\000\255\255\255\255\
    \255\255\255\255\014\000\000\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
    \255\255\000\000\026\000\000\000\000\000\000\000\000\000\004\000\
    \000\000\000\000\031\000\000\000\000\000\032\000\000\000\030\000\
    \000\000\033\000\000\000\000\000\000\000\010\000\000\000\024\000\
    \021\000\027\000\000\000\022\000\022\000\024\000\000\000\025\000\
    \024\000\034\000\025\000\024\000\029\000\029\000\035\000\036\000\
    \038\000\039\000\040\000\041\000\042\000\029\000\043\000\044\000\
    \029\000\045\000\046\000\029\000\047\000\048\000\050\000\051\000\
    \053\000\054\000\056\000\057\000\059\000\060\000\043\000\043\000\
    \061\000\063\000\064\000\066\000\067\000\069\000\070\000\066\000\
    \071\000\073\000\072\000\074\000\069\000\072\000\075\000\076\000\
    \077\000\078\000\079\000\080\000\081\000\082\000\083\000\084\000\
    \085\000\086\000\087\000\088\000\089\000\090\000\091\000\092\000\
    \094\000\096\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\100\000\102\000\
    \103\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec loop lexbuf =
    __ocaml_lex_loop_rec lexbuf 0
and __ocaml_lex_loop_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 101 "calc.mll"
    ( loop lexbuf )
# 251 "calc.ml"

  | 1 ->
# 104 "calc.mll"
    ( Arg.usage speclist usage; flush stderr )
# 256 "calc.ml"

  | 2 ->
# 106 "calc.mll"
    ( precision := Gmp.Z.int_from (approx (pop ()) 0) )
# 261 "calc.ml"

  | 3 ->
# 108 "calc.mll"
    ( push (of_int !precision) )
# 266 "calc.ml"

  | 4 ->
# 111 "calc.mll"
    ( display_stack () )
# 271 "calc.ml"

  | 5 ->
# 113 "calc.mll"
    ( let x = pop () in 
      printf "   %s\n" (to_string x !precision); flush stdout )
# 277 "calc.ml"

  | 6 ->
# 116 "calc.mll"
    ( match !stack with
	| [] -> 
	    error "<empty stack>"
	| x :: _ ->
	    printf "   %s\n" (to_string x !precision); flush stdout )
# 286 "calc.ml"

  | 7 ->
# 123 "calc.mll"
    ( ignore (pop ()) )
# 291 "calc.ml"

  | 8 ->
# 125 "calc.mll"
    ( stack := [] )
# 296 "calc.ml"

  | 9 ->
# 127 "calc.mll"
    ( let x = pop () in push x; push x )
# 301 "calc.ml"

  | 10 ->
# 129 "calc.mll"
    ( let x = pop () in let y = pop () in push x; push y )
# 306 "calc.ml"

  | 11 ->
# 131 "calc.mll"
    ( push (of_int (List.length !stack)) )
# 311 "calc.ml"

  | 12 ->
# 134 "calc.mll"
    ( push (of_string (lexeme lexbuf)) )
# 316 "calc.ml"

  | 13 ->
# 135 "calc.mll"
         ( push pi )
# 321 "calc.ml"

  | 14 ->
# 136 "calc.mll"
         ( push e )
# 326 "calc.ml"

  | 15 ->
# 138 "calc.mll"
          ( binop add )
# 331 "calc.ml"

  | 16 ->
# 139 "calc.mll"
          ( binop sub )
# 336 "calc.ml"

  | 17 ->
# 140 "calc.mll"
          ( binop mul )
# 341 "calc.ml"

  | 18 ->
# 141 "calc.mll"
          ( binop div )
# 346 "calc.ml"

  | 19 ->
# 142 "calc.mll"
          ( unop neg )
# 351 "calc.ml"

  | 20 ->
# 143 "calc.mll"
          ( unop inv )
# 356 "calc.ml"

  | 21 ->
# 145 "calc.mll"
           ( unop sin )
# 361 "calc.ml"

  | 22 ->
# 146 "calc.mll"
           ( unop cos )
# 366 "calc.ml"

  | 23 ->
# 147 "calc.mll"
           ( unop tan )
# 371 "calc.ml"

  | 24 ->
# 148 "calc.mll"
              ( unop arcsin )
# 376 "calc.ml"

  | 25 ->
# 149 "calc.mll"
              ( unop arccos )
# 381 "calc.ml"

  | 26 ->
# 150 "calc.mll"
              ( unop arctan )
# 386 "calc.ml"

  | 27 ->
# 152 "calc.mll"
           ( unop exp )
# 391 "calc.ml"

  | 28 ->
# 153 "calc.mll"
           ( unop ln )
# 396 "calc.ml"

  | 29 ->
# 154 "calc.mll"
           ( binop (fun base -> log ~base) )
# 401 "calc.ml"

  | 30 ->
# 155 "calc.mll"
                 ( binop pow )
# 406 "calc.ml"

  | 31 ->
# 157 "calc.mll"
            ( unop sinh )
# 411 "calc.ml"

  | 32 ->
# 158 "calc.mll"
            ( unop cosh )
# 416 "calc.ml"

  | 33 ->
# 159 "calc.mll"
            ( unop tanh )
# 421 "calc.ml"

  | 34 ->
# 160 "calc.mll"
               ( unop arcsinh )
# 426 "calc.ml"

  | 35 ->
# 161 "calc.mll"
               ( unop arccosh )
# 431 "calc.ml"

  | 36 ->
# 162 "calc.mll"
               ( unop arctanh )
# 436 "calc.ml"

  | 37 ->
# 164 "calc.mll"
                 ( unop sqrt )
# 441 "calc.ml"

  | 38 ->
# 166 "calc.mll"
        ( raise End_of_file )
# 446 "calc.ml"

  | 39 ->
# 167 "calc.mll"
        ( raise Parsing.Parse_error )
# 451 "calc.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_loop_rec lexbuf __ocaml_lex_state

;;

# 169 "calc.mll"
 

(*s The main program is an infinite loop exiting on [End_of_file]. *)

  let _ = Sys.catch_break true

  let main () =
    let lb = from_channel stdin in
    try
      while true do 
	try
	  loop lb 
	with 
	  | Sys.Break -> error "<interrupted>"
	  | Parsing.Parse_error -> error "<syntax error>"
	  | Invalid_argument "pop" -> error "<empty stack>"
      done
    with End_of_file ->
      flush stdout; exit 0
      
  let _ = Printexc.catch main ()


# 481 "calc.ml"
