// RUN: %clang_cc1 -triple x86_64-pc-win32 -ast-dump=json %s | FileCheck %s

#define _INLINE_VAR inline
#define _NODISCARD [[nodiscard]]

template <class _Ty, _Ty _Val>
struct integral_constant {
    static constexpr _Ty value = _Val;

    using value_type = _Ty;
    using type       = integral_constant;

    constexpr operator value_type() const noexcept {
        return value;
    }

    _NODISCARD constexpr value_type operator()() const noexcept {
        return value;
    }
};

template <bool _Val>
using bool_constant = integral_constant<bool, _Val>;

template <class>
_INLINE_VAR constexpr bool is_const_v = false; // determine whether type argument is const qualified

template <class _Ty>
_INLINE_VAR constexpr bool is_const_v<const _Ty> = true;

template <class>
_INLINE_VAR constexpr bool is_reference_v = false; // determine whether type argument is a reference

template <class _Ty>
_INLINE_VAR constexpr bool is_reference_v<_Ty&> = true;

template <class _Ty>
_INLINE_VAR constexpr bool is_reference_v<_Ty&&> = true;

template <class _Ty>
struct is_reference : bool_constant<is_reference_v<_Ty>> {};

template <class _Ty>
_INLINE_VAR constexpr bool is_function_v = // only function types and reference types can't be const qualified
    !is_const_v<const _Ty> && !is_reference_v<_Ty>;

template <class _Ty>
struct is_function : bool_constant<is_function_v<_Ty>> {};

template <class>
struct _Is_member_object_pointer {
    static constexpr bool value = false;
};

template <class _Ty1, class _Ty2>
struct _Is_member_object_pointer<_Ty1 _Ty2::*> {
    static constexpr bool value = !is_function_v<_Ty1>;
    using _Class_type           = _Ty2;
};

template <class _Ty>
_INLINE_VAR constexpr bool is_member_object_pointer_v = __is_member_object_pointer(_Ty);

template <class _Ty>
struct is_member_object_pointer : bool_constant<is_member_object_pointer_v<_Ty>> {};

template <class _Ty>
_INLINE_VAR constexpr bool is_member_pointer_v = __is_member_pointer(_Ty);

int main()
{
    return 0;
}
// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "TranslationUnitDecl",
// CHECK-NEXT:  "loc": {},
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {},
// CHECK-NEXT:   "end": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__int128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__uint128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "unsigned __int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "unsigned __int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__NSConstantString",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__NSConstantString_tag"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "RecordType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__NSConstantString_tag"
// CHECK-NEXT:      },
// CHECK-NEXT:      "decl": {
// CHECK-NEXT:       "id": "0x{{.*}}",
// CHECK-NEXT:       "kind": "CXXRecordDecl",
// CHECK-NEXT:       "name": "__NSConstantString_tag"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_ms_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "char *"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "PointerType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "char *"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "BuiltinType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "char"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "char *"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "PointerType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "char *"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "BuiltinType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "char"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 176,
// CHECK-NEXT:     "file": "{{.*}}",
// CHECK-NEXT:     "line": 7,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 17
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 138,
// CHECK-NEXT:      "line": 6,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 483,
// CHECK-NEXT:      "line": 20,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "integral_constant",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 154,
// CHECK-NEXT:       "line": 6,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 148,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 154,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 163,
// CHECK-NEXT:       "col": 26,
// CHECK-NEXT:       "tokLen": 4
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 159,
// CHECK-NEXT:        "col": 22,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 163,
// CHECK-NEXT:        "col": 26,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Val",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "_Ty"
// CHECK-NEXT:      },
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 176,
// CHECK-NEXT:       "line": 7,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 17
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 169,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 483,
// CHECK-NEXT:        "line": 20,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "integral_constant",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 176,
// CHECK-NEXT:         "line": 7,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 17
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 169,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 176,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 17
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "isReferenced": true,
// CHECK-NEXT:        "name": "integral_constant",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "VarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 221,
// CHECK-NEXT:         "line": 8,
// CHECK-NEXT:         "col": 26,
// CHECK-NEXT:         "tokLen": 5
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 200,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 229,
// CHECK-NEXT:          "col": 34,
// CHECK-NEXT:          "tokLen": 4
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isReferenced": true,
// CHECK-NEXT:        "name": "value",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "const _Ty"
// CHECK-NEXT:        },
// CHECK-NEXT:        "storageClass": "static",
// CHECK-NEXT:        "inline": true,
// CHECK-NEXT:        "constexpr": true,
// CHECK-NEXT:        "init": "c",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclRefExpr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 229,
// CHECK-NEXT:            "col": 34,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 229,
// CHECK-NEXT:            "col": 34,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "_Ty"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "referencedDecl": {
// CHECK-NEXT:           "id": "0x{{.*}}",
// CHECK-NEXT:           "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:           "name": "_Val",
// CHECK-NEXT:           "type": {
// CHECK-NEXT:            "qualType": "_Ty"
// CHECK-NEXT:           }
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TypeAliasDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 246,
// CHECK-NEXT:         "line": 10,
// CHECK-NEXT:         "col": 11,
// CHECK-NEXT:         "tokLen": 10
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 240,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 259,
// CHECK-NEXT:          "col": 24,
// CHECK-NEXT:          "tokLen": 3
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isReferenced": true,
// CHECK-NEXT:        "name": "value_type",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "_Ty"
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "_Ty"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x{{.*}}",
// CHECK-NEXT:           "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:           "name": "_Ty"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TypeAliasDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 274,
// CHECK-NEXT:         "line": 11,
// CHECK-NEXT:         "col": 11,
// CHECK-NEXT:         "tokLen": 4
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 268,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 287,
// CHECK-NEXT:          "col": 24,
// CHECK-NEXT:          "tokLen": 17
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "type",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "integral_constant<_Ty, _Val>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "ElaboratedType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "integral_constant<_Ty, _Val>"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "InjectedClassNameType",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "integral_constant<_Ty, _Val>"
// CHECK-NEXT:            },
// CHECK-NEXT:            "isDependent": true,
// CHECK-NEXT:            "isInstantiationDependent": true,
// CHECK-NEXT:            "decl": {
// CHECK-NEXT:             "id": "0x{{.*}}",
// CHECK-NEXT:             "kind": "CXXRecordDecl",
// CHECK-NEXT:             "name": "integral_constant"
// CHECK-NEXT:            }
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXConversionDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 321,
// CHECK-NEXT:         "line": 13,
// CHECK-NEXT:         "col": 15,
// CHECK-NEXT:         "tokLen": 8
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 311,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 9
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 386,
// CHECK-NEXT:          "line": 15,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "operator type-parameter-0-0",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "value_type () const noexcept"
// CHECK-NEXT:        },
// CHECK-NEXT:        "constexpr": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "CompoundStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 358,
// CHECK-NEXT:            "line": 13,
// CHECK-NEXT:            "col": 52,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 386,
// CHECK-NEXT:            "line": 15,
// CHECK-NEXT:            "col": 5,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ReturnStmt",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 368,
// CHECK-NEXT:              "line": 14,
// CHECK-NEXT:              "col": 9,
// CHECK-NEXT:              "tokLen": 6
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 375,
// CHECK-NEXT:              "col": 16,
// CHECK-NEXT:              "tokLen": 5
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "DeclRefExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 375,
// CHECK-NEXT:                "col": 16,
// CHECK-NEXT:                "tokLen": 5
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 375,
// CHECK-NEXT:                "col": 16,
// CHECK-NEXT:                "tokLen": 5
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const _Ty"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "referencedDecl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "VarDecl",
// CHECK-NEXT:               "name": "value",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "const _Ty"
// CHECK-NEXT:               }
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXMethodDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 425,
// CHECK-NEXT:         "line": 17,
// CHECK-NEXT:         "col": 37,
// CHECK-NEXT:         "tokLen": 8
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 404,
// CHECK-NEXT:          "col": 16,
// CHECK-NEXT:          "tokLen": 9
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 481,
// CHECK-NEXT:          "line": 19,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "operator()",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "value_type () const noexcept"
// CHECK-NEXT:        },
// CHECK-NEXT:        "constexpr": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "CompoundStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 453,
// CHECK-NEXT:            "line": 17,
// CHECK-NEXT:            "col": 65,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 481,
// CHECK-NEXT:            "line": 19,
// CHECK-NEXT:            "col": 5,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ReturnStmt",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 463,
// CHECK-NEXT:              "line": 18,
// CHECK-NEXT:              "col": 9,
// CHECK-NEXT:              "tokLen": 6
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 470,
// CHECK-NEXT:              "col": 16,
// CHECK-NEXT:              "tokLen": 5
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "DeclRefExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 470,
// CHECK-NEXT:                "col": 16,
// CHECK-NEXT:                "tokLen": 5
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 470,
// CHECK-NEXT:                "col": 16,
// CHECK-NEXT:                "tokLen": 5
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const _Ty"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "referencedDecl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "VarDecl",
// CHECK-NEXT:               "name": "value",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "const _Ty"
// CHECK-NEXT:               }
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "WarnUnusedResultAttr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "spellingLoc": {
// CHECK-NEXT:             "offset": 125,
// CHECK-NEXT:             "line": 4,
// CHECK-NEXT:             "col": 22,
// CHECK-NEXT:             "tokLen": 9
// CHECK-NEXT:            },
// CHECK-NEXT:            "expansionLoc": {
// CHECK-NEXT:             "offset": 393,
// CHECK-NEXT:             "line": 17,
// CHECK-NEXT:             "col": 5,
// CHECK-NEXT:             "tokLen": 10
// CHECK-NEXT:            }
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "spellingLoc": {
// CHECK-NEXT:             "offset": 125,
// CHECK-NEXT:             "line": 4,
// CHECK-NEXT:             "col": 22,
// CHECK-NEXT:             "tokLen": 9
// CHECK-NEXT:            },
// CHECK-NEXT:            "expansionLoc": {
// CHECK-NEXT:             "offset": 393,
// CHECK-NEXT:             "line": 17,
// CHECK-NEXT:             "col": 5,
// CHECK-NEXT:             "tokLen": 10
// CHECK-NEXT:            }
// CHECK-NEXT:           }
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypeAliasTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 508,
// CHECK-NEXT:     "line": 23,
// CHECK-NEXT:     "col": 1,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 487,
// CHECK-NEXT:      "line": 22,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 558,
// CHECK-NEXT:      "line": 23,
// CHECK-NEXT:      "col": 51,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "bool_constant",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 502,
// CHECK-NEXT:       "line": 22,
// CHECK-NEXT:       "col": 16,
// CHECK-NEXT:       "tokLen": 4
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 497,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 502,
// CHECK-NEXT:        "col": 16,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Val",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TypeAliasDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 514,
// CHECK-NEXT:       "line": 23,
// CHECK-NEXT:       "col": 7,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 508,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 558,
// CHECK-NEXT:        "col": 51,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "bool_constant",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "integral_constant<bool, _Val>"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ElaboratedType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "integral_constant<bool, _Val>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "isDependent": true,
// CHECK-NEXT:        "isInstantiationDependent": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateSpecializationType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "integral_constant<bool, _Val>"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "templateName": "integral_constant",
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "kind": "TemplateArgument",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "bool"
// CHECK-NEXT:            },
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "BuiltinType",
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "bool"
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           },
// CHECK-NEXT:           {
// CHECK-NEXT:            "kind": "TemplateArgument",
// CHECK-NEXT:            "isExpr": true,
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "DeclRefExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 554,
// CHECK-NEXT:                "col": 47,
// CHECK-NEXT:                "tokLen": 4
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 554,
// CHECK-NEXT:                "col": 47,
// CHECK-NEXT:                "tokLen": 4
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "bool"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "prvalue",
// CHECK-NEXT:              "referencedDecl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:               "name": "_Val",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "bool"
// CHECK-NEXT:               }
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 606,
// CHECK-NEXT:     "line": 26,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 562,
// CHECK-NEXT:      "line": 25,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "line": 26,
// CHECK-NEXT:      "col": 41,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_const_v",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 577,
// CHECK-NEXT:       "line": 25,
// CHECK-NEXT:       "col": 16,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 606,
// CHECK-NEXT:       "line": 26,
// CHECK-NEXT:       "col": 28,
// CHECK-NEXT:       "tokLen": 10
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "spellingLoc": {
// CHECK-NEXT:         "offset": 97,
// CHECK-NEXT:         "line": 3,
// CHECK-NEXT:         "col": 21,
// CHECK-NEXT:         "tokLen": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "expansionLoc": {
// CHECK-NEXT:         "offset": 579,
// CHECK-NEXT:         "line": 26,
// CHECK-NEXT:         "col": 1,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 619,
// CHECK-NEXT:        "col": 41,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_const_v",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 619,
// CHECK-NEXT:          "col": 41,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 619,
// CHECK-NEXT:          "col": 41,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "bool"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": false
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplatePartialSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 729,
// CHECK-NEXT:     "line": 29,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 681,
// CHECK-NEXT:      "line": 28,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 753,
// CHECK-NEXT:      "line": 29,
// CHECK-NEXT:      "col": 52,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_const_v",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "const bool"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "init": "c",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 697,
// CHECK-NEXT:       "line": 28,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 691,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 697,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const type-parameter-0-0"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "QualType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "const type-parameter-0-0"
// CHECK-NEXT:        },
// CHECK-NEXT:        "qualifiers": "const",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "type-parameter-0-0"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x0"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 753,
// CHECK-NEXT:        "line": 29,
// CHECK-NEXT:        "col": 52,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 753,
// CHECK-NEXT:        "col": 52,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": true
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 804,
// CHECK-NEXT:     "line": 32,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 14
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 760,
// CHECK-NEXT:      "line": 31,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 821,
// CHECK-NEXT:      "line": 32,
// CHECK-NEXT:      "col": 45,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_reference_v",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 775,
// CHECK-NEXT:       "line": 31,
// CHECK-NEXT:       "col": 16,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 770,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 770,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 804,
// CHECK-NEXT:       "line": 32,
// CHECK-NEXT:       "col": 28,
// CHECK-NEXT:       "tokLen": 14
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "spellingLoc": {
// CHECK-NEXT:         "offset": 97,
// CHECK-NEXT:         "line": 3,
// CHECK-NEXT:         "col": 21,
// CHECK-NEXT:         "tokLen": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "expansionLoc": {
// CHECK-NEXT:         "offset": 777,
// CHECK-NEXT:         "line": 32,
// CHECK-NEXT:         "col": 1,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 821,
// CHECK-NEXT:        "col": 45,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_reference_v",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 821,
// CHECK-NEXT:          "col": 45,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 821,
// CHECK-NEXT:          "col": 45,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "bool"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": false
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplatePartialSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 927,
// CHECK-NEXT:     "line": 35,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 14
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 879,
// CHECK-NEXT:      "line": 34,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 950,
// CHECK-NEXT:      "line": 35,
// CHECK-NEXT:      "col": 51,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_reference_v",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "const bool"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "init": "c",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 895,
// CHECK-NEXT:       "line": 34,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 889,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 895,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "type-parameter-0-0 &"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "LValueReferenceType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "type-parameter-0-0 &"
// CHECK-NEXT:        },
// CHECK-NEXT:        "isDependent": true,
// CHECK-NEXT:        "isInstantiationDependent": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "type-parameter-0-0"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x0"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 950,
// CHECK-NEXT:        "line": 35,
// CHECK-NEXT:        "col": 51,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 950,
// CHECK-NEXT:        "col": 51,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": true
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplatePartialSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1005,
// CHECK-NEXT:     "line": 38,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 14
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 957,
// CHECK-NEXT:      "line": 37,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1029,
// CHECK-NEXT:      "line": 38,
// CHECK-NEXT:      "col": 52,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_reference_v",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "const bool"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "init": "c",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 973,
// CHECK-NEXT:       "line": 37,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 967,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 973,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "type-parameter-0-0 &&"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "RValueReferenceType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "type-parameter-0-0 &&"
// CHECK-NEXT:        },
// CHECK-NEXT:        "isDependent": true,
// CHECK-NEXT:        "isInstantiationDependent": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "type-parameter-0-0"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x0"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1029,
// CHECK-NEXT:        "line": 38,
// CHECK-NEXT:        "col": 52,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1029,
// CHECK-NEXT:        "col": 52,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": true
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1064,
// CHECK-NEXT:     "line": 41,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 12
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1036,
// CHECK-NEXT:      "line": 40,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1115,
// CHECK-NEXT:      "line": 41,
// CHECK-NEXT:      "col": 59,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_reference",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1052,
// CHECK-NEXT:       "line": 40,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1046,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1052,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1064,
// CHECK-NEXT:       "line": 41,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 12
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1057,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1115,
// CHECK-NEXT:        "col": 59,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_reference",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "bases": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "access": "public",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "desugaredQualType": "integral_constant<bool, is_reference_v<_Ty>>",
// CHECK-NEXT:         "qualType": "bool_constant<is_reference_v<_Ty>>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "writtenAccess": "none"
// CHECK-NEXT:       }
// CHECK-NEXT:      ],
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 1064,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 12
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1057,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1064,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 12
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "is_reference",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1167,
// CHECK-NEXT:     "line": 44,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1119,
// CHECK-NEXT:      "line": 43,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1300,
// CHECK-NEXT:      "line": 45,
// CHECK-NEXT:      "col": 50,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_function_v",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1135,
// CHECK-NEXT:       "line": 43,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1129,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1135,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1167,
// CHECK-NEXT:       "line": 44,
// CHECK-NEXT:       "col": 28,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "spellingLoc": {
// CHECK-NEXT:         "offset": 97,
// CHECK-NEXT:         "line": 3,
// CHECK-NEXT:         "col": 21,
// CHECK-NEXT:         "tokLen": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "expansionLoc": {
// CHECK-NEXT:         "offset": 1140,
// CHECK-NEXT:         "line": 44,
// CHECK-NEXT:         "col": 1,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1300,
// CHECK-NEXT:        "line": 45,
// CHECK-NEXT:        "col": 50,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_function_v",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "BinaryOperator",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1255,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1300,
// CHECK-NEXT:          "col": 50,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "<dependent type>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "opcode": "&&",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "UnaryOperator",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 1255,
// CHECK-NEXT:            "col": 5,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 1276,
// CHECK-NEXT:            "col": 26,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "<dependent type>"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "isPostfix": false,
// CHECK-NEXT:          "opcode": "!",
// CHECK-NEXT:          "canOverflow": false,
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "UnresolvedLookupExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 1256,
// CHECK-NEXT:              "col": 6,
// CHECK-NEXT:              "tokLen": 10
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 1276,
// CHECK-NEXT:              "col": 26,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "<dependent type>"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "lvalue",
// CHECK-NEXT:            "usesADL": false,
// CHECK-NEXT:            "name": "is_const_v",
// CHECK-NEXT:            "lookups": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "VarTemplateDecl",
// CHECK-NEXT:              "name": "is_const_v"
// CHECK-NEXT:             }
// CHECK-NEXT:            ],
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "kind": "TemplateArgument",
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const _Ty"
// CHECK-NEXT:              },
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "QualType",
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "const _Ty"
// CHECK-NEXT:                },
// CHECK-NEXT:                "qualifiers": "const",
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "TemplateTypeParmType",
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "_Ty"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "isDependent": true,
// CHECK-NEXT:                  "isInstantiationDependent": true,
// CHECK-NEXT:                  "depth": 0,
// CHECK-NEXT:                  "index": 0,
// CHECK-NEXT:                  "decl": {
// CHECK-NEXT:                   "id": "0x{{.*}}",
// CHECK-NEXT:                   "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:                   "name": "_Ty"
// CHECK-NEXT:                  }
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "UnaryOperator",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 1281,
// CHECK-NEXT:            "col": 31,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 1300,
// CHECK-NEXT:            "col": 50,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "<dependent type>"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "isPostfix": false,
// CHECK-NEXT:          "opcode": "!",
// CHECK-NEXT:          "canOverflow": false,
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "UnresolvedLookupExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 1282,
// CHECK-NEXT:              "col": 32,
// CHECK-NEXT:              "tokLen": 14
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 1300,
// CHECK-NEXT:              "col": 50,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "<dependent type>"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "lvalue",
// CHECK-NEXT:            "usesADL": false,
// CHECK-NEXT:            "name": "is_reference_v",
// CHECK-NEXT:            "lookups": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "VarTemplateDecl",
// CHECK-NEXT:              "name": "is_reference_v"
// CHECK-NEXT:             }
// CHECK-NEXT:            ],
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "kind": "TemplateArgument",
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "_Ty"
// CHECK-NEXT:              },
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "TemplateTypeParmType",
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "_Ty"
// CHECK-NEXT:                },
// CHECK-NEXT:                "isDependent": true,
// CHECK-NEXT:                "isInstantiationDependent": true,
// CHECK-NEXT:                "depth": 0,
// CHECK-NEXT:                "index": 0,
// CHECK-NEXT:                "decl": {
// CHECK-NEXT:                 "id": "0x{{.*}}",
// CHECK-NEXT:                 "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:                 "name": "_Ty"
// CHECK-NEXT:                }
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1332,
// CHECK-NEXT:     "line": 48,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 11
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1304,
// CHECK-NEXT:      "line": 47,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1381,
// CHECK-NEXT:      "line": 48,
// CHECK-NEXT:      "col": 57,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_function",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1320,
// CHECK-NEXT:       "line": 47,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1314,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1320,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1332,
// CHECK-NEXT:       "line": 48,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 11
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1325,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1381,
// CHECK-NEXT:        "col": 57,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_function",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "bases": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "access": "public",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "desugaredQualType": "integral_constant<bool, is_function_v<_Ty>>",
// CHECK-NEXT:         "qualType": "bool_constant<is_function_v<_Ty>>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "writtenAccess": "none"
// CHECK-NEXT:       }
// CHECK-NEXT:      ],
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 1332,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1325,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1332,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 11
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "is_function",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1409,
// CHECK-NEXT:     "line": 51,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 25
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1385,
// CHECK-NEXT:      "line": 50,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1478,
// CHECK-NEXT:      "line": 53,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "_Is_member_object_pointer",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1400,
// CHECK-NEXT:       "line": 50,
// CHECK-NEXT:       "col": 16,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1395,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1395,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1409,
// CHECK-NEXT:       "line": 51,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 25
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1402,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1478,
// CHECK-NEXT:        "line": 53,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "_Is_member_object_pointer",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 1409,
// CHECK-NEXT:         "line": 51,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 25
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1402,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1409,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 25
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "_Is_member_object_pointer",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "VarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 1463,
// CHECK-NEXT:         "line": 52,
// CHECK-NEXT:         "col": 27,
// CHECK-NEXT:         "tokLen": 5
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1441,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1471,
// CHECK-NEXT:          "col": 35,
// CHECK-NEXT:          "tokLen": 5
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "value",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "const bool"
// CHECK-NEXT:        },
// CHECK-NEXT:        "storageClass": "static",
// CHECK-NEXT:        "inline": true,
// CHECK-NEXT:        "constexpr": true,
// CHECK-NEXT:        "init": "c",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "CXXBoolLiteralExpr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 1471,
// CHECK-NEXT:            "col": 35,
// CHECK-NEXT:            "tokLen": 5
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 1471,
// CHECK-NEXT:            "col": 35,
// CHECK-NEXT:            "tokLen": 5
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "bool"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "value": false
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplatePartialSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1523,
// CHECK-NEXT:     "line": 56,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 25
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1482,
// CHECK-NEXT:      "line": 55,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1661,
// CHECK-NEXT:      "line": 59,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "_Is_member_object_pointer",
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canConstDefaultInit": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "defaultedIsConstexpr": true,
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "isConstexpr": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isEmpty": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "type-parameter-0-0 type-parameter-0-1::*"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "MemberPointerType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "type-parameter-0-0 type-parameter-0-1::*"
// CHECK-NEXT:        },
// CHECK-NEXT:        "isDependent": true,
// CHECK-NEXT:        "isInstantiationDependent": true,
// CHECK-NEXT:        "isData": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "type-parameter-0-1"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 1,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x0"
// CHECK-NEXT:          }
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "type-parameter-0-0"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x0"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1498,
// CHECK-NEXT:       "line": 55,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 4
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1492,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1498,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty1",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1510,
// CHECK-NEXT:       "col": 29,
// CHECK-NEXT:       "tokLen": 4
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1504,
// CHECK-NEXT:        "col": 23,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1510,
// CHECK-NEXT:        "col": 29,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty2",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1523,
// CHECK-NEXT:       "line": 56,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 25
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1516,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1523,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 25
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "_Is_member_object_pointer",
// CHECK-NEXT:      "tagUsed": "struct"
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1591,
// CHECK-NEXT:       "line": 57,
// CHECK-NEXT:       "col": 27,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1569,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1618,
// CHECK-NEXT:        "col": 54,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "value",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "storageClass": "static",
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "UnaryOperator",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1599,
// CHECK-NEXT:          "col": 35,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1618,
// CHECK-NEXT:          "col": 54,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "<dependent type>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "isPostfix": false,
// CHECK-NEXT:        "opcode": "!",
// CHECK-NEXT:        "canOverflow": false,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "UnresolvedLookupExpr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 1600,
// CHECK-NEXT:            "col": 36,
// CHECK-NEXT:            "tokLen": 13
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 1618,
// CHECK-NEXT:            "col": 54,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "<dependent type>"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "lvalue",
// CHECK-NEXT:          "usesADL": false,
// CHECK-NEXT:          "name": "is_function_v",
// CHECK-NEXT:          "lookups": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "VarTemplateDecl",
// CHECK-NEXT:            "name": "is_function_v"
// CHECK-NEXT:           }
// CHECK-NEXT:          ],
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "kind": "TemplateArgument",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "_Ty1"
// CHECK-NEXT:            },
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "TemplateTypeParmType",
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "_Ty1"
// CHECK-NEXT:              },
// CHECK-NEXT:              "isDependent": true,
// CHECK-NEXT:              "isInstantiationDependent": true,
// CHECK-NEXT:              "depth": 0,
// CHECK-NEXT:              "index": 0,
// CHECK-NEXT:              "decl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:               "name": "_Ty1"
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TypeAliasDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1631,
// CHECK-NEXT:       "line": 58,
// CHECK-NEXT:       "col": 11,
// CHECK-NEXT:       "tokLen": 11
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1625,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1655,
// CHECK-NEXT:        "col": 35,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "_Class_type",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "_Ty2"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TemplateTypeParmType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "_Ty2"
// CHECK-NEXT:        },
// CHECK-NEXT:        "isDependent": true,
// CHECK-NEXT:        "isInstantiationDependent": true,
// CHECK-NEXT:        "depth": 0,
// CHECK-NEXT:        "index": 1,
// CHECK-NEXT:        "decl": {
// CHECK-NEXT:         "id": "0x{{.*}}",
// CHECK-NEXT:         "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:         "name": "_Ty2"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1713,
// CHECK-NEXT:     "line": 62,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 26
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1665,
// CHECK-NEXT:      "line": 61,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1772,
// CHECK-NEXT:      "line": 62,
// CHECK-NEXT:      "col": 87,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_member_object_pointer_v",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1681,
// CHECK-NEXT:       "line": 61,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1675,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1681,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1713,
// CHECK-NEXT:       "line": 62,
// CHECK-NEXT:       "col": 28,
// CHECK-NEXT:       "tokLen": 26
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "spellingLoc": {
// CHECK-NEXT:         "offset": 97,
// CHECK-NEXT:         "line": 3,
// CHECK-NEXT:         "col": 21,
// CHECK-NEXT:         "tokLen": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "expansionLoc": {
// CHECK-NEXT:         "offset": 1686,
// CHECK-NEXT:         "line": 62,
// CHECK-NEXT:         "col": 1,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1772,
// CHECK-NEXT:        "col": 87,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_member_object_pointer_v",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TypeTraitExpr",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1742,
// CHECK-NEXT:          "col": 57,
// CHECK-NEXT:          "tokLen": 26
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1772,
// CHECK-NEXT:          "col": 87,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "bool"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "_Ty"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x{{.*}}",
// CHECK-NEXT:           "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:           "name": "_Ty"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1804,
// CHECK-NEXT:     "line": 65,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 24
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1776,
// CHECK-NEXT:      "line": 64,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1879,
// CHECK-NEXT:      "line": 65,
// CHECK-NEXT:      "col": 83,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_member_object_pointer",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1792,
// CHECK-NEXT:       "line": 64,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1786,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1792,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1804,
// CHECK-NEXT:       "line": 65,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 24
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1797,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1879,
// CHECK-NEXT:        "col": 83,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_member_object_pointer",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "bases": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "access": "public",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "desugaredQualType": "integral_constant<bool, is_member_object_pointer_v<_Ty>>",
// CHECK-NEXT:         "qualType": "bool_constant<is_member_object_pointer_v<_Ty>>"
// CHECK-NEXT:        },
// CHECK-NEXT:        "writtenAccess": "none"
// CHECK-NEXT:       }
// CHECK-NEXT:      ],
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 1804,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 24
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1797,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1804,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 24
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "is_member_object_pointer",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VarTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1931,
// CHECK-NEXT:     "line": 68,
// CHECK-NEXT:     "col": 28,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1883,
// CHECK-NEXT:      "line": 67,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1976,
// CHECK-NEXT:      "line": 68,
// CHECK-NEXT:      "col": 73,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "is_member_pointer_v",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1899,
// CHECK-NEXT:       "line": 67,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1893,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1899,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "_Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "VarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1931,
// CHECK-NEXT:       "line": 68,
// CHECK-NEXT:       "col": 28,
// CHECK-NEXT:       "tokLen": 19
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "spellingLoc": {
// CHECK-NEXT:         "offset": 97,
// CHECK-NEXT:         "line": 3,
// CHECK-NEXT:         "col": 21,
// CHECK-NEXT:         "tokLen": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "expansionLoc": {
// CHECK-NEXT:         "offset": 1904,
// CHECK-NEXT:         "line": 68,
// CHECK-NEXT:         "col": 1,
// CHECK-NEXT:         "tokLen": 11
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1976,
// CHECK-NEXT:        "col": 73,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "is_member_pointer_v",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const bool"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TypeTraitExpr",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1953,
// CHECK-NEXT:          "col": 50,
// CHECK-NEXT:          "tokLen": 19
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 1976,
// CHECK-NEXT:          "col": 73,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "bool"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmType",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "_Ty"
// CHECK-NEXT:          },
// CHECK-NEXT:          "isDependent": true,
// CHECK-NEXT:          "isInstantiationDependent": true,
// CHECK-NEXT:          "depth": 0,
// CHECK-NEXT:          "index": 0,
// CHECK-NEXT:          "decl": {
// CHECK-NEXT:           "id": "0x{{.*}}",
// CHECK-NEXT:           "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:           "name": "_Ty"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1984,
// CHECK-NEXT:     "line": 70,
// CHECK-NEXT:     "col": 5,
// CHECK-NEXT:     "tokLen": 4
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1980,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 2007,
// CHECK-NEXT:      "line": 73,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "main",
// CHECK-NEXT:    "mangledName": "main",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1991,
// CHECK-NEXT:        "line": 71,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 2007,
// CHECK-NEXT:        "line": 73,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ReturnStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 1997,
// CHECK-NEXT:          "line": 72,
// CHECK-NEXT:          "col": 5,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 2004,
// CHECK-NEXT:          "col": 12,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "IntegerLiteral",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 2004,
// CHECK-NEXT:            "col": 12,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 2004,
// CHECK-NEXT:            "col": 12,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "int"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "value": "0"
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

