CHANGELOG for 6.2.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 6.2 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v6.2.0...v6.2.1

* 6.2.14 (2023-07-31)

 * bug #51178 [Finder] Revert "Fix children condition in ExcludeDirectoryFilterIterator" (derrabus)

* 6.2.13 (2023-07-30)

 * bug #50933 [Serializer] Fix deserializing nested arrays of objects with mixed keys (HypeMC)
 * bug #51071 [VarExporter] Fix calling scope detection inside magic accessors (vtsykun)
 * bug #51078 [FrameworkBundle][Workflow] Throw exception is workflow.xxx.transitions is not an array (lyrixx)
 * bug #51114 [Serializer] Fix denormalizing abstract part headers in MimeMessageNormalizer (fancyweb)
 * bug #50788 [Validator] Fix regression with class metadatada on parent classes (rmikalkenas)
 * bug #51017 [VarExporter] Fix exporting classes with __serialize() but not __unserialize() (fancyweb)
 * bug #51031 Fix deprecations on PHP 8.3 (nicolas-grekas)
 * bug #51000 [WebProfilerBundle] Fix error in case of 'Content-Type' set null in dev environment with no debug (alexbuyanow)
 * bug #50985 [DependencyInjection] Fix fetching lazy non-shared services multiple times (HypeMC)
 * bug #50994 [ErrorHandler][Runtime] Don't mess with ini_set('assert.warning') (nicolas-grekas)
 * bug #50968 [PropertyAccess] Fix access to undefined "file" key when checking stack frames (nicolas-grekas)
 * bug #50552 [Security] Allow custom scheme to be used as redirection URIs (Spomky)
 * bug #50945 [DebugBundle][FrameworkBundle] Fix using the framework without the Console component (HypeMC)
 * bug #50913 [HttpKernel][WebProfilerBundle] Fix search feature (Cyril HERRERA)
 * bug #50937 [Form] fetch all known ChoiceType values at once (xabbuh)
 * bug #50944 [FrameworkBundle] Add missing monolog channel tag to the `messenger:failed:retry` command (HypeMC)
 * bug #49070 [RateLimiter] fix incorrect retryAfter of FixedWindow (RobertMe)
 * bug #50960 [VarDumper] Fix dumping `ArrayObject` with `DumpDataCollector` (lyrixx, HypeMC)
 * bug #50943 [Intl] Taking into account bibliographic + overlong (oleg-andreyev)
 * bug #50954 [PhpUnitBridge] Kill the last concurrent process when it stales for more than 60s (nicolas-grekas)
 * bug #50475 [FrameworkBundle] Prevent `cache:clear` to lose files on subsequent runs (Okhoshi)
 * bug #47252 [PhpUnitBridge] Use triggering class to generate baseline for deprecation messages from DebugClassLoader (leongersen)
 * bug #50582 [Security/Http] Fix false-string handling in `RememberMeAuthenticator` (ossinkine)
 * bug #50595 [DependencyInjection] Don't ignore attributes on the actual decorator (HypeMC)
 * bug #50804 [Serializer] Fix Normalizer not utilizing converted name for index variadic param (DidierLmn)
 * bug #50813 [DoctrineBridge] Load refreshed user proxy (MatTheCat)
 * bug #50905 [DepdencyInjection] Fix costly logic when checking errored definitions (nicolas-grekas)
 * bug #50884 [Finder] Fix initial directory is opened twice (mvorisek)
 * bug #50881 [Messenger] Fix passing options set via tags to handler descriptors (nicolas-grekas)
 * feature #50838 [DoctrineBridge] Remove outdated comment (HeahDude)
 * bug #50837 [DependencyInjection] Fix autocasting null env values to empty string (fancyweb)
 * bug #50819 [SecurityBundle] Do not translate `Bearer` header’s `error_description` (MatTheCat)
 * bug #50793 [DependencyInjection] Fix resource tracking for lazy services (nicolas-grekas)
 * bug #50810 [String] Fix Inflector for 'status' (evertharmeling)

* 6.2.12 (2023-06-26)

 * bug #50763 [DependencyInjection] Skip errored definitions deep-referenced as runtime exceptions (nicolas-grekas)
 * bug #50728 [HttpClient] Explicitly exclude CURLOPT_POSTREDIR (nicolas-grekas)
 * bug #48961 [WebProfilerBundle] right blocks: fix display (jmsche)
 * bug #50671 [HttpClient] Fix encoding some characters in query strings (Daniel Kozák)
 * bug #50655 Revert "Respect isRetryable decision of the retry strategy for re-delivery" (bendavies)
 * bug #50665 [FrameworkBundle] Ignore missing directories in about command (ro0NL)
 * bug #50644 [VarDumper] Dumping DateTime throws error if getTimezone is false (bogdanmoza)
 * bug #50656 Only update autoload_runtime.php when it changed (Seldaek)
 * bug #50698 [HttpClient] Fix int conversion for `GenericRetryStrategy` with floated multiplier  (francisbesset)
 * bug #50611 [Clock] Fix MockClock::modify() on PHP 8.3 (nicolas-grekas)
 * bug #50548 [FrameworkBundle] Show non-bundle extensions in `debug:config` & `config:dump` list view & completion (HypeMC)
 * bug #50585 [Cache] Fix RedisTrait::createConnection for cluster (darkanakin41)
 * bug #50546 [FrameworkBundle] Fix `debug:config` & `config:dump` in debug mode (HypeMC)
 * bug #50560 [DependencyInjection] Support PHP 8.2 `true` and `null` type (ruudk)
 * bug #50562 [Lock] Fix sprintf (fancyweb)
 * bug #50524 Fix Doctrine deprecations (nicolas-grekas)
 * bug #50539 [Validator] Remove internal from methods on non-internal interfaces (wouterj)
 * bug #50534 [PhpUnitBridge] Fix support for the NO_COLOR env var (nicolas-grekas)
 * bug #50517 [DependencyInjection] Fix casting scalar env vars from null (fancyweb)
 * bug #50515 [Mailer] [MailPace] Fix undefined array key in errors response (Florian Heller)
 * bug #50507 [Cache] Fix DBAL deprecations (MatTheCat)
 * bug #50501 [Serializer] Fix discriminator map not working with `AbstractNormalizer::OBJECT_TO_POPULATE` (HypeMC)
 * bug #50480 [Serializer] Fix discriminator map not working with `AbstractNormalizer::OBJECT_TO_POPULATE` (HypeMC)
 * bug #50437 [Filesystem] Follow symlinks when dumping files (ausi)
 * bug #50478 [DependencyInjection] Escape `` from parameter-like default values (MatTheCat)
 * bug #50452 Hide definitions bearing the `container.excluded` tag (Myks92)

* 6.2.11 (2023-05-27)

 * bug #50442 [SecurityBundle] Update security-1.0.xsd to include missing access-token definition (aegypius)
 * bug #50429 [Console] block input stream if needed (joelwurtz)
 * bug #50312 [Security] Skip clearing CSRF Token on stateless logout (chalasr)
 * bug #50315 [Translation] Fix handling of null messages in `ArrayLoader` (rob006)
 * bug #50338 [Console] Remove ``exec`` and replace it by ``shell_exec`` (maxbeckers)
 * bug #50193 [Serializer] Fix `SerializedPath` not working with constructor arguments (HypeMC)
 * bug #50280 [PropertyAccess] Fix nullsafe operator on array index (HypeMC)
 * bug #50362 [FrameworkBundle] Fix Workflow without a marking store definition uses marking store definition of previously defined workflow (krciga22)
 * bug #50309 [HttpFoundation] UrlHelper is now aware of RequestContext changes (giosh94mhz)
 * bug #50309 [HttpFoundation] UrlHelper is now aware of RequestContext changes (giosh94mhz)
 * bug #50352 [Notifier][TurboSMS] Fix get sender name (ZhukV)
 * bug #50354 [Process] Stop the process correctly even if underlying input stream is not closed (joelwurtz)
 * bug #50332 [PropertyInfo] Fix `PhpStanExtractor` when constructor has no docblock (HypeMC)
 * bug #50253 [FrameworkBundle] Generate caches consistently on successive run of `cache:clear` command (Okhoshi)
 * bug #49063 [Messenger] Respect `isRetryable` decision of the retry strategy for re-delivery (FlyingDR)
 * bug #50251 [Serializer] Handle datetime deserialization in U format (tugmaks)
 * bug #50266 [HttpFoundation] Fix file streaming after connection aborted (rlshukhov)
 * bug #50277 [Messenger] Add `IS_REPEATABLE` flag to `AsMessageHandler` attribute (adrianguenter)
 * bug #50269 Fix param type annotation (l-vo)
 * bug #50268 Allow resources in Query::setParam (l-vo)
 * bug #50256 [HttpClient] Fix setting duplicate-name headers when redirecting with AmpHttpClient (nicolas-grekas)
 * bug #50214 [WebProfilerBundle] Remove legacy filters remnants (MatTheCat)
 * bug #50235 [HttpClient] Fix getting through proxies via CONNECT (nicolas-grekas)
 * bug #50241 [HttpKernel] Prevent initialising lazy services during services reset (tucksaun)
 * bug #50244 [HttpKernel] Fix restoring surrogate content from cache (nicolas-grekas)
 * bug #50246 [DependencyInjection] Do not check errored definitions’ type (MatTheCat)
 * bug #49557 [PropertyInfo] Fix phpDocExtractor nullable array value type (fabpot)
 * bug #50213 [ErrorHandler] Prevent conflicts with WebProfilerBundle’s JavaScript (MatTheCat)
 * bug #50192 [Serializer] backed enum throw notNormalizableValueException outside construct method (alli83)
 * bug #50238 [HttpKernel] Don't use eval() to render ESI/SSI (nicolas-grekas)
 * bug #50226 [HttpClient] Ensure HttplugClient ignores invalid HTTP headers (nicolas-grekas)
 * bug #50203 [Messenger] Fix registering message handlers (nicolas-grekas)
 * bug #50204 [ErrorHandler] Skip Httplug deprecations for HttplugClient (nicolas-grekas)

* 6.2.10 (2023-04-28)

 * bug #50143 [Console] trim(): Argument #1 () must be of type string, bool given (danepowell)
 * bug #50139 Check if trace.curlCommand is defined in profiler (Toflar)
 * bug #50066 [Dumper] Trim leading newlines when checking if value begins with a space (bradtreloar)
 * bug #50115 [FrameworkBundle] Make service edges unique (rmikalkenas)
 * bug #50111 Fix the list of supported shells for completions in a phar (stof)
 * bug #50110 [Console] Fix the usage of the zsh completion through the fpath discovery (stof)
 * bug #50074 [Cache] Send Predis SSL options in the $hosts parameter (magnusnordlander)
 * bug #50088 [DependencyInjection] Do not ignore tags `name` attribute when it does not define their name (MatTheCat)
 * bug #50099 [Cache] Fix success interpretation when pruning cache (staabm)
 * bug #50092 [Security] Fix return type of AuthenticationSuccessHandlerInterface::onAuthenticationSuccess() (nicolas-grekas)
 * bug #48288 [Security] Make onAuthenticationSuccess Response optional (db306)
 * bug #50086 [VarExporter] Fix forwarding references to proxied classes (nicolas-grekas)
 * bug #50072 [HttpClient] Fix global state preventing two CurlHttpClient instances from working together (nicolas-grekas)
 * bug #50040 [Translation] Crowdin Bridge: Fix locale vs LanguageId (Peter Culka)
 * bug #50061 [DependencyInjection] Fix support for inner collections when using `<bind>` (zerustech)
 * bug #50022 [DependencyInjection] Fallback to default value when autowiring undefined parameters for optional arguments (radar3301)
 * bug #50056 [Form] Fix "prototype_data" option creating duplicates instead of new lines (Thorry84)
 * bug #50017 [Validator] Fix support of Enum to `ConstraintValidator::formatValue` (PhoneixS)
 * bug #49356 [Process] Path resolution changes for PHP in the cgi-fcgi mode (isdn)
 * bug #48886 [Console] Fix computing column width containing multibyte chars (cay89)
 * bug #50049 [Messenger] Fix deprecation layer of RedeliveryStamp (nicolas-grekas)
 * bug #47505 [Mime] Form field values with integer keys not resolved correctly  (claudiu-cristea)
 * bug #50048 [PhpUnitBridge] Fix PHPUnit 10.1 compatibility (enumag)
 * bug #50047 [VarDumper] Make the server TCP connection sync (ogizanagi)
 * bug #48837 [Messenger] [Redis] Fixed problem where worker stops handling messages on first empty message (jvmanji)
 * bug #49317 [Messenger] Fix warning message on failed messenger show command (gstapinato)
 * bug #49992 [Mailer] [Mailjet] Use body MessageID instead of X-MJ-Request-GUID (Starfox64)
 * bug #48972 [HttpFoundation] Fix memory limit problems in BinaryFileResponse (glady)
 * bug #48108 [PropertyAccess] Readonly properties must have no PropertyWriteInfo (CasvanDongen)
 * bug #49009 [Form] Cast choices value callback result to string (Matth--)
 * bug #49537 [Serializer] Unexpected value should throw UnexpectedValueException (ThomasTr)
 * bug #49581 Avoid leading .. for temporary files from Filesystem recursive remove (giosh94mhz)
 * bug #50036 [ErrorHandler] Don't throw deprecations for HttplugClient (nicolas-grekas)
 * bug #50024 [Serializer] Fix denormalization of object with typed constructor arg (not castable) and with COLLECT_DENORMALIZATION_ERRORS (lyrixx)
 * bug #50004 [HttpClient] fix proxied redirects in curl client (matthi4s)
 * bug #50008 [Intl] Update the ICU data to 73.1 (jderusse)
 * bug #50015 [Serializer] Fix serializer normalize attribute context (akalineskou)
 * bug #49987 [Console] Restoring the ability to output unicode text to the Win10 console (aleksandr-shevchenko)

* 6.2.9 (2023-04-13)

 * bug #49957 [ErrorHandler] Fix sending `Vary` header with `SerializerErrorRenderer` (nicolas-grekas)
 * bug #49983 [DomCrawler] Avoid passing null to substr/strrpos methods (VincentLanglet)
 * bug #49079 [DoctrineBridge] fix issue with missing stopwatch events (dmaicher)
 * bug #49926 [HttpClient] Fix canceling MockResponse (fancyweb)
 * bug #49889 [FrameworkBundle] Fix registering ExpressionValidator (nicolas-grekas)

* 6.2.8 (2023-03-31)

 * bug #49835 [Form] CollectionType apply prototypeOptions to ResizeFormListener new fields (Thorry84)
 * bug #49849 [FrameworkBundle] Fix services usages output for text descriptor (rmikalkenas)
 * bug #49525 [Serializer] Fix serialized path for non-scalar values (boenner)
 * bug #49618 [Serializer] Preserve array keys while denormalize variadic parameters (melya)
 * bug #49401 [TwigBridge] Fix raw content rendering in HTML notification emails (1ed)
 * bug #49679 [FrameworkBundle] enable metadata cache when annotation is disabled (bastnic)
 * bug #49796 [HttpClient] Fix not calling the on progress callback when canceling a MockResponse (fancyweb)
 * bug #49850 [FrameworkBundle] Fix auto-discovering validator constraints (nicolas-grekas)
 * bug #49867 [DependencyInjection] Filter "container.excluded" services when using `findTaggedServiceIds()` (nicolas-grekas)
 * bug #49833 [Translation] TranslatorBag::diff now iterates over catalogue domains instead of operation domains (welcoMattic)
 * bug #49848 [Cache] Fix storing binary keys when using pgsql (nicolas-grekas)
 * bug #49765 [Console] Add missing ZSH mention in DumpCompletionCommand help (lyrixx)
 * bug #49843 [FrameworkBundle] Add missing monolog channel tag for messenger services (rmikalkenas)
 * bug #49745 [FrameworkBundle] Fix wiring session.handler when handler_id is null (nicolas-grekas)
 * bug #49189 [FrameworkBundle] Improve documentation about translation:extract --sort option (marien-probesys)
 * bug #49274 [VarDumper] Disable links for IntelliJ platform (SerafimArts)
 * bug #49682 [FrameworkBundle] Workflow - Fix LogicException about a wrong configuration of "enabled" node (adpauly)
 * bug #49758 [HttpFoundation] Use separate caches for IpUtils checkIp4 and checkIp6 (danielburger1337)
 * bug #49722 [HttpClient] Encode and decode curly brackets {} (pbowyer)
 * bug #49720 [Serializer] GetSetMethodNormalizer::supportss should not check ignored methods (nikophil)
 * bug #49681 [String] Correct inflection of 'codes' and 'names' (GwendolenLynch)
 * bug #49697 [Validator] Update BIC validator IBAN mappings (maxbeckers)
 * bug #49706 Stop stopwatch events in case of exception (MatTheCat)
 * bug #49657 [HttpKernel] Change limit argument from string to integer for Profiler (Aliance)
 * bug #49674 [FrameworkBundle] Rename limiter’s `strategy` to `policy` in XSD (MatTheCat)
 * bug #49673 [VarDumper] Fixed dumping of CutStub (lyrixx)
 * bug #49604 [Mailer] STDOUT blocks infinitely under Windows when STDERR is filled (TemaYud)
 * bug #49651 [DependencyInjection] Fix support binary values in parameters. (vtsykun)
 * bug #49548 [Messenger] Fix `TransportNamesStamp` deserialization (tucksaun)
 * bug #49580 [HttpClient] Fix encoding "+" in URLs (nicolas-grekas)
 * bug #49541 [Security] Remove ``@internal`` tag on `TraceableAuthenticator::getAuthenticator()` (florentdestremau)
 * bug #49578 [DependencyInjection] Fix dumping array of enums parameters (fancyweb)

* 6.2.7 (2023-02-28)

 * bug #49526 [Security] Migrate the session on login only when the user changes (nicolas-grekas)
 * bug #49528 [Console] Fix fatal error when accessing Application::signalRegistry without pcntl (lyrixx)
 * bug #49516 [Workflow] display label with new lines + colours properly when rendering a PUML dump (alexislefebvre)
 * bug #48965 [TwigBridge] Allow floats in html5 input type number field (wimhendrikx)
 * bug #48833 [Translation] Handle the translation of empty strings (javiereguiluz)
 * bug #49292 [VarDumper] Fix error when reflected class has default Enum parameter in constructor (kapiwko)
 * bug #49493 [FrameworkBundle] Fix denyAccessUnlessGranted for mixed attributes (delbertooo)
 * bug #49484 [Validator] Fix translation of AtLeastOneOf constraint message (alexandre-daubois)
 * bug #48998 [Validator] Sync IBAN formats with Swift IBAN registry (smelesh)
 * bug #49488 [Mailer] Update Infobip API transport (ndousson)
 * bug #49477 [WebProfilerBundle] Fix the rendering of query explanation with Postgresql (stof)
 * bug #49446 [SecurityBundle] Fix `Security::login()` on specific firewall (chalasr)
 * bug #49405 [MonologBridge] FirePHPHandler::onKernelResponse throws PHP 8.1 deprecation when no user agent is set (juagarc4)
 * bug #49421 [TwigBridge] do not drop embed label classes (xabbuh)
 * bug #49459 [Form] Skip password hashing on empty password (Seb33300)
 * bug #49422 [Cache][Messenger] fixed CallbackInterface support in async expiration handler (AdamKatzDev)
 * bug #49441 [Contracts] Fix setting $container before calling parent::setContainer in ServiceSubscriberTrait (edsrzf)
 * bug #49272 [Workflow] remove new lines from workflow metadata (alexislefebvre)
 * bug #49427 [WebProfilerBundle] Render original (not encoded) email headers (1ed)
 * bug #48897 [Console] fix clear of section with question (maxbeckers)
 * bug #49400 [WebProfilerBundle] Tweak Mailer panel rendering (1ed)
 * bug #49368 [BC Break] Make data providers for abstract test cases static (OskarStark, alexandre-daubois)
 * bug #49379 [DependencyInjection] Fix autowire attribute with nullable parameters (alamirault)
 * bug #49385 [Notifier] Make `TransportTestCase` data providers static (alexandre-daubois)
 * bug #49395 fix trying to load Memcached before checking we can (nicolas-grekas)
 * bug #49326 [Notifier] Fix notifier profiler when transport name is null (fabpot)
 * bug #49265 [HttpKernel] Fix setting the session on the main request when it's started by a subrequest (nicolas-grekas)
 * bug #49353 [Cache] Only validate dbindex parameter when applicable (loevgaard)
 * bug #49346 [ErrorHandler] Do not patch return statements in closures (wouterj)
 * bug #49334 [DependencyInjection] keep `proxy` tag on original definition when decorating (kbond)
 * bug #47946 [FrameworkBundle] Fix checkboxes check assertions (MatTheCat)
 * bug #49301 [HttpClient] Fix data collector (fancyweb)
 * bug #49310 [Notifier][WebProfilerBundle] Ignore messages whose `getNotification` returns `null` (MatTheCat)
 * bug #49267 [Form] Check for `RepeatedType` child in `PasswordHasherListener` (MatTheCat)
 * bug #49299 [HttpClient] Fix over-encoding of URL parts to match browser's behavior (nicolas-grekas)
 * bug #49314 [HttpClient] Revert support for "friendsofphp/well-known-implementations" (nicolas-grekas)
 * bug #49214 [Mailer] add Sender to the list of bypassed headers (xabbuh)
 * bug #49282 [VarExporter] Fix lazy-proxying readonly classes on PHP 8.3 (nicolas-grekas)
 * bug #49147 [Intl] Generate all emoji short name returned by slack api (adnen-chouibi)
 * bug #49245 [Serializer] Fix CsvEncoder decode on empty data (cazak)
 * bug #49255 [Cache] Fix Redis proxies (nicolas-grekas)
 * bug #49249 [Dotenv] Fix phpdoc Dotenv (alamirault)
 * bug #49247 [Translator] Replace deprecated/removed way to configure enabled_locales (chr-hertel)
 * bug #49248 [Config] Fix phpdoc nullable (alamirault)
 * bug #48880 [Response] `getMaxAge()` returns non-negative integer (pkruithof, fabpot)
 * bug #49207 [PropertyInfo] Add meaningful message when `phpstan/phpdoc-parser` is not installed when using `PhpStanExtractor` (alexandre-daubois)
 * bug #49208 [Form] Fix `PasswordHasherListener` to work with empty data (1ed)
 * bug #49210 [Mailer] [MailPace] Fix undefined key in error response (OskarStark)
 * bug #49220 [Validator] Make ConstraintValidatorTestCase compatible with PHPUnit 10 (gjuric)
 * bug #49224 [WebProfilerBundle] Fix an accessibility issue in the search form of the header (javiereguiluz)
 * bug #49226 [WebProfilerBundle] Disable Turbo for debug toolbar links (javiereguiluz)
 * bug #49223 [WebProfilerBundle] Fix some minor HTML issues (javiereguiluz)
 * bug #49146 [PropertyInfo] fail with a meaningful error when a needed package is missing (xabbuh)
 * bug #49187 [Ldap] Allow multiple values on `extra_fields` (mvhirsch)
 * bug #49128 [DependencyInjection] Fix combinatory explosion when autowiring union and intersection types (nicolas-grekas)

* 6.2.6 (2023-02-01)

 * bug #49141 [HttpFoundation] Fix bad return type in IpUtils::checkIp4() (tristankretzer)
 * bug #49126 [DependencyInjection] Fix order of arguments when mixing positional and named ones (nicolas-grekas)
 * bug #49104 [HttpClient] Fix collecting data non-late for the profiler (nicolas-grekas)
 * bug #49103 [Security/Http] Fix compat of persistent remember-me with legacy tokens (nicolas-grekas)
 * security #cve-2022-24895 [Security/Http] Remove CSRF tokens from storage on successful login (nicolas-grekas)
 * security #cve-2022-24894 [HttpKernel] Remove private headers before storing responses with HttpCache (nicolas-grekas)

* 6.2.5 (2023-01-24)

 * bug #49078 [Security/Http] Check tokens before loading users from providers (nicolas-grekas)
 * bug #49077 [DependencyInjection] Fix named arguments when using ContainerBuilder before compilation (nicolas-grekas)
 * bug #49031 [Cache] fix collecting cache stats when nesting computations (nicolas-grekas)
 * bug #49046 Fix for Windows when projects are deployed on junctions/symlinks (nerdgod)
 * bug #49025 [Notifier] [OvhCloud] handle invalid receiver (seferov)
 * bug #49034 [Security] Return default value instead of deferring to lower prio resolvers when using #[CurrentUser] and no user is found (Seldaek)
 * bug #48993 [VarDumper] Fix JS to expand / collapse (nicolas-grekas)
 * bug #48983 Fix BC user_identifier support after deprecation username (vtsykun)
 * bug #48986 [Validator] Fix Email validator logic (fabpot)
 * bug #48969 [PropertyInfo] Fixes constructor extractor for mixed type (michael.kubovic)
 * bug #48978 [Serializer] use method_exists() instead of catching reflection exceptions (xabbuh)
 * bug #48958 [DependencyInjection] fixes validation of non-scalar attribute values (ju1ius)
 * bug #48937 [SecurityBundle] Fix using same handler for multiple authenticators (RobertMe)
 * bug #48971 [DependencyInjection] Fix dump order of inlined deps (nicolas-grekas)
 * bug #48966 [HttpClient] Let curl handle content-length headers (nicolas-grekas)
 * bug #48968 [VarExporter] Fix exporting enums (nicolas-grekas)
 * bug #48933 [Validator] Fix bad handling of nulls when the 'fields' option of the Unique constraint is set (plfort)
 * bug #48926 [DependencyInjection] Fix support for named arguments on non-autowired services (nicolas-grekas)
 * bug #48943 [FrameworkBundle] Fix deprecation when accessing a "container.private" service from the test container (nicolas-grekas)
 * bug #48939 [VarExporter] Fix signature of `Lazy*Trait::createLazy*()` (nicolas-grekas)
 * bug #48931 [DependencyInjection] Fix dumping inlined withers (nicolas-grekas)
 * bug #48898 [HttpClient] Move Http clients data collecting at a late level (pforesi)
 * bug #48896 [DoctrineBridge] Fix detecting mapping with one line annotations (franmomu)
 * bug #48916 [FrameworkBundle] restore call to addGlobalIgnoredName (alexislefebvre)
 * bug #48917 [Config] Fix XML dump when node example is an array (alexandre-daubois)
 * bug #48904 [Validator] Allow egulias/email-validator v4 (chalasr)
 * bug #48830 [Translation] fix PhpAstExtractor also extracts messages if t() contains both unnamed and named arguments (gassan)
 * bug #48846 [Translation] Fix for resolving Constraint Validator FQCN defined as foo.bar.class parameters (gassan)
 * bug #48866 [Validator] fix: Case-insensitive extensions in File-Constraint (spackmat)
 * bug #48831 [Uid] Fix validating nil and max uuid (fancyweb)

* 6.2.4 (2022-12-29)

 * bug #48822 [WebProfilerBundle] Fix the usage of web fonts (javiereguiluz)
 * bug #48823 [Cache] Fix possibly null value passed to preg_match() in RedisTrait (chalasr)
 * bug #48816 [Cache] Fix for RedisAdapter without auth parameter (rikvdh)

* 6.2.3 (2022-12-28)

 * bug #48805 [DependencyInjection] Fix resolving parameters when dumping lazy proxies (nicolas-grekas)
 * bug #48787 [PhpUnitBridge] Use verbose deprecation output for quiet types only when it reaches the threshold (ogizanagi)
 * bug #48784 [Console] Correctly overwrite progressbars with different line count per step (ncharalampidis)
 * bug #48801 [Form] Make `ButtonType` handle `form_attr` option (MatTheCat)
 * bug #48791 [DependencyInjection] Fix deduplicating service instances in circular graphs (nicolas-grekas)
 * bug #48790 [WebProfilerBundle] fix Mailer detail on click (Jean-Beru)
 * bug #48771 [CssSelector] Fix escape patterns (fancyweb)
 * bug #48774 [Translation] Fix undefined variable messages in ConstraintVisitor (alamirault)
 * bug #48727 [PropertyAccess] Fix nullsafe chain like x?.y (Vincz)
 * bug #48711 [Cache] RedisTrait::createConnection does not pass auth value from redis sentinel cluster DSN (evgkord)
 * bug #48724 [VarExporter] Fix exporting classes with __unserialize() but not __serialize() (fancyweb)
 * bug #48746 [Validator] Fix IBAN format for Tunisia and Mauritania (smelesh)
 * bug #48738 [Workflow] Allow spaces in place names so the PUML dump doesn't break (Kamil Musial)
 * bug #48742 [VarExporter] Generate proxies for static abstract methods (nicolas-grekas)
 * bug #48735 [SecurityBundle] Prevent RuntimeException on profiler (marphi)
 * bug #48718 Compatibility with doctrine/annotations 2 (derrabus)
 * bug #48688 [FrameworkBundle] Add MailPace definition (skmedix)

* 6.2.2 (2022-12-16)

 * bug #48661 [Serializer] fix context attribute with serializedName (nikophil)
 * bug #48681 [Console] Revert "bug #48089  Fix clear line with question in section (maxbeckers) (chalasr)
 * bug #48680 [Cache] fix lazyness of redis when using RedisTagAwareAdapter (nicolas-grekas)
 * bug #48651 [HttpKernel] AbstractSessionListener should not override the cache lifetime for private responses (rodmen)
 * bug #48591 [DependencyInjection] Shared private services becomes public after a public service is accessed (alexpott)
 * bug #48126 [Mailer] Include all transports' debug messages in RoundRobin transport exception  (mixdf)
 * bug #48644 [Validator] Allow opt-out of EmailValidator deprecation when using Validation::createValidatorBuilder() (nicolas-grekas)
 * bug #48606 [FrameworkBundle] container:debug CLI output improvements for excluded services (apfelbox)
 * bug #48089 [Console] Fix clear line with question in section (maxbeckers)
 * bug #48602 [HtmlSanitizer] Fix HtmlSanitizer default configuration behavior for allowed schemes (Titouan Galopin)
 * bug #48635 [HttpFoundation] Use relative timestamps with MemcachedSessionHandler (tvlooy)
 * bug #47979 [Cache] Fix dealing with ext-redis' multi/exec returning a bool (João Nogueira)
 * bug #48612 [Messenger] [Amqp] Added missing rpc_timeout option (lyrixx)
 * bug #48233 [Serializer] Prevent `GetSetMethodNormalizer` from creating invalid magic method call (klaussilveira)
 * bug #48628 [HttpFoundation] Fix dumping array cookies (nicolas-grekas)
 * bug #48559 [ExpressionLanguage] Fix BC of cached SerializedParsedExpression containing GetAttrNode (fancyweb)
 * bug #48524 [HttpKernel] Fix `CacheAttributeListener` priority (HypeMC)
 * bug #48451 [Translation] Fix extraction when dealing with VariadicPlaceholder parameters (Kocal)
 * bug #48601 [SecurityBundle] Fix authenticator existence check in `Security::login()` (chalasr)
 * bug #48587 [TwigBundle] Alias BodyRendererInterface (n3o77)
 * bug #48580 [Console] Fix missing command not matching namespace error message (Titouan Galopin)
 * bug #48449 [DependencyInjection] Fix bug when tag name is a text node (BrandonlinU)
 * bug #48048 [WebProfilerBundle] Fix dump header not being displayed (HypeMC)
 * bug #47836 [HttpClient] TraceableHttpClient: increase decorator's priority (adpeyre)
 * bug #48259 [FrameworkBundle] Allow configuring `framework.exceptions` with a config builder (MatTheCat)
 * bug #48314 [Mime] Fix MessagePart serialization (Amunak)
 * bug #48331 [Yaml] fix dumping top-level tagged values (xabbuh)
 * bug #48615 Fix getting the name of closures on PHP 8.1.11+ (nicolas-grekas)
 * bug #48624 [ErrorHandler][HttpKernel] Fix reading the SYMFONY_IDE env var (nicolas-grekas)
 * bug #48618 [ErrorHandler] [DebugClassLoader] Fix some new return types support (fancyweb)
 * bug #48605 [VarExporter] Fix adding a key to an uninitialized array (nicolas-grekas)
 * bug #48554 [Security] Fix invalid deprecation messages in Security constants (IonBazan)
 * bug #48538 [Clock] Fix `usleep` deprecation warning (victor-prdh)
 * bug #48421 [HttpFoundation] IPv4-mapped IPv6 addresses incorrectly rejected (bonroyage)
 * bug #48501 [RateLimiter] Add `int` to `Reservation::wait()` (DaRealFreak)
 * bug #48359 [VarDumper] Ignore \Error in __debugInfo() (fancyweb)
 * bug #48553 [VarExporter] Fix calling `parent::__wakeup()` when unserializing with LazyProxyTrait (azjezz)
 * bug #48489 [DoctrineBridge] Skip resolving entities when the corresponding request attribute is already an object (nicolas-grekas)
 * bug #48534 [FrameworkBundle] add `kernel.locale_aware` tag to `LocaleSwitcher` (kbond)
 * bug #48521 [FrameworkBundle] fix removing commands if console not available (kbond)
 * bug #48522 [DependencyInjection] Generate different classes for ghost objects and virtual proxies (nicolas-grekas)
 * bug #48482 [DependencyInjection] Revert "bug #48027 Don't autoconfigure tag when it's already set with attributes" (nicolas-grekas)

* 6.2.1 (2022-12-06)

 * bug #48502 [DependencyInjection] Fix `ContainerBuilder` stats env usage with enum (alamirault)
 * bug #48509 [HttpKernel] Fix using entities with the `#[Cache()]` attribute (HypeMC)
 * bug #48505 [Mailer] Fix rendered templates for notifications (fabpot)
 * bug #48476 [WebProfilerBundle] Use same color as other icons for the close toolbar btn (ogizanagi)
 * bug #48483 [DependencyInjection] Remove refs that point to container.excluded services when allowed (nicolas-grekas)
 * bug #48346 [HttpKernel] In DateTimeValueResolver, convert previously defined date attribute to the expected class (GromNaN)
 * bug #48450 [WebProfilerBundle] Fix form panel expanders (MatTheCat)
 * bug #48459 [FrameworkBundle] [Framework] Fix Infobip Mailer transport factory import (gnito-org)
 * bug #48461 [VarExporter] Fix possible memory-leak when using lazy-objects (nicolas-grekas)
 * bug #48335 [TwigBridge] Amend `MoneyType` twig to include a space (mogilvie)
 * bug #48046 [WebProfilerBundle] Remove redundant code from logger template (HypeMC)
 * bug #48428 Fixed undefined variable error (Kevin Meijer)
 * bug #48416 [FrameworkBundle] don't register the MailerTestCommand symfony/console is not installed (xabbuh)

* 6.2.0 (2022-11-30)

 * bug #48395 [String] Fix AsciiSlugger with emojis (fancyweb)
 * bug #48385 [Security] Reuse `AbstractFactory`'s config tree in `AccessTokenFactory` (chalasr)
 * bug #48292 [Security] [LoginLink] Throw InvalidLoginLinkException on missing parameter (MatTheCat)

* 6.2.0-RC2 (2022-11-28)

 * bug #48366 [Mailer] Fix body renderer check (fabpot)
 * bug #48347 [Clock] Autowire PSR interface (wouterj)
 * bug #48341 [SecurityBundle] Fix `logout.csrf_token_generator` default value (MatTheCat)
 * bug #48333 [Yaml] parse unquoted digits in tag values as integers (xabbuh)
 * bug #48330 [FrameworkBundle] do not wire the MercureTransportFactory if the MercureBundle is not enabled (xabbuh)
 * bug #48320 [Clock] Implement PSR-20 (nicolas-grekas)

* 6.2.0-RC1 (2022-11-25)

 * bug #48312 [VarExporter] Improve partial-initialization API for ghost objects (nicolas-grekas)
 * bug #48285 [Security] Support loading UserBadge directly from accessToken (Jeroeny)
 * bug #48262 [Notifier] [SMSBiuras] `true`/`false` mismatch for `test_mode` option (StaffNowa)
 * bug #48273 [HttpKernel] Fix message for unresovable arguments of invokable controllers (fancyweb)
 * bug #48251 [PropertyInfo] ignore const expressions read by phpdocumentor (xabbuh)
 * bug #48224 [DependencyInjection] Process bindings in `ServiceLocatorTagPass` (MatTheCat)
 * bug #48271 [WebProfilerBundle] Fix form panel when there are no view vars (nicolas-grekas)
 * bug #48274 Add more #[\SensitiveParameter] (fancyweb)
 * bug #48179 [Console] Support completion for bash functions (Chi-teck)

* 6.2.0-BETA3 (2022-11-19)

 * bug #48217 [Console] Improve error message when shell is not detected in completion command (GromNaN)
 * bug #48222 [Translation] [Lokalize] Configure `replace_breaks` to prevent issues with multilines translations (Kocal)
 * bug #48210 [Console]  Fix signal handlers called after event listeners and skip exit (GromNaN)
 * bug #48198 [Messenger] Fix time-limit check exception (alamirault)
 * feature #48189 [Clock] Provide `modify()` in MockClock (dbrumann)
 * bug #48207 [Yaml] Restore deprecated php/const: syntax in YAML key (GromNaN)
 * bug #48209 [VarExporter] Use `array<property-name,Closure>` for partial initialization of lazy ghost objects (nicolas-grekas)
 * bug #48186 [WebProfilerBundle] Minor tweaks in profiler redesign (javiereguiluz)
 * bug #48122 [PhpUnitBridge] Fix language deprecations incorrectly marked as direct (wouterj)
 * bug #47998 [Console] Fix console `ProgressBar::override()` after manual `ProgressBar::cleanup()` (maxbeckers)
 * bug #48041 [FrameworkBundle] Split loggers debug compiler pass (MatTheCat)
 * bug #48032 [SecurityBundle] Set `UserValueResolver`'s priority higher than `EntityValueResolver` (kbond)
 * bug #48156 [Mime] When serializing File parts convert to string to allow proper unserialization (ovrflo)
 * bug #48170 [Routing] Fix PSR-4 directory loader for abstract classes (derrabus)
 * bug #48173 [HttpClient] Handle Amp HTTP client v5 incompatibility gracefully (fancyweb)
 * bug #48172 [HttpKernel] Don’t try to wire Response argument with controller.service_arguments (MatTheCat)
 * bug #48160 Adding missing argument to sprintf (weaverryan)
 * bug #48085 [Messenger] Tell about messenger:consume invalid limit options (MatTheCat)
 * bug #48120 [Messenger] Do not throw 'no handlers' exception when skipping handlers due to duplicate handling (wouterj)
 * bug #48112 [HttpFoundation] Compare cookie with null value as empty string in ResponseCookieValueSame (fancyweb)
 * bug #48119 [FrameworkBundle][Lock] Allow to disable lock without defining a resource (MatTheCat)
 * bug #48110 [HttpKernel] Fix deprecation for DateTimeValueResolver with null on non-nullable argument (GromNaN)
 * bug #48093 [DependencyInjection] don't move locator tag for service subscriber (RobertMe)
 * bug #48075 [Mailer] Stream timeout not detected fgets returns false (Sezil)
 * bug #48092 Fix the notification email theme for asynchronously dispatched emails (krisbuist)
 * bug #48097 Fix search scope when performing fallback mapping driver detection (spideyfusion)
 * bug #48103 [HttpClient] Do not set http_version instead of setting it to null (Tetragramat)
 * bug #48077 [FrameworkBundle] Allow UUID v7 in uid configuration (achterin)
 * bug #48027 [DependencyInjection] Don't autoconfigure tag when it's already set with attributes (nicolas-grekas)
 * feature #48045 [DependencyInjection] Allow enum as service parameter in php config files (alexndlm)
 * bug #48062 [Notifier] Mark tokens with #[SensitiveParameter] (nicolas-grekas)
 * bug #48050 [HttpFoundation] Check IPv6 is valid before comparing it (PhilETaylor)

* 6.2.0-BETA2 (2022-10-28)

 * bug #48020 [FrameworkBundle] add router cache directory option to XML schema (xabbuh)
 * feature #47976 Add padding to HIBP check (rullzer)
 * bug #47990 [HttpClient] Fix retrying requests when the content is used by the strategy (nicolas-grekas)
 * bug #48005 [ErrorHandler] s/\</br\>/\<br\> (PhilETaylor)
 * bug #47907 [Console] Update Application.php (aleksandr-shevchenko)
 * bug #47992 [Mailer] Fix BC breaking event name change (chalasr)

* 6.2.0-BETA1 (2022-10-24)

 * feature #47364 [DependencyInjection] Allow array attributes for service tags (aschempp)
 * feature #44166 [Config] Use better typehint in PHP Configuration (jderusse)
 * feature #47956 [Notifier] Add support for editing Telegram messages (chr-hertel)
 * feature #43534 [Serializer] Add `SerializedPath` annotation to flatten nested attributes (boenner)
 * feature #47943 [Config][Routing] Nicer config syntax for PSR-4 route loading (derrabus)
 * feature #46224 [Form] Add `hash_property_path` option to `PasswordType` (Seb33300)
 * feature #47950 [HttpClient] Add support for "friendsofphp/well-known-implementations" (nicolas-grekas)
 * feature #47936 [HttpClient] Add `withOptions()` to `HttplugClient` and `Psr18Client` (nicolas-grekas)
 * feature #46053 [Messenger] Add option `allow_no_senders` to enable throwing when a message doesn't have a sender (babeuloula)
 * feature #45907 [SecurityBundle] Allow specifying attributes for `RequestMatcher` (freiondrej-lmc)
 * feature #47483 [HttpKernel] Make Logger implement DebugLoggerInterface (MatTheCat)
 * feature #46161 [Translation] Add `PhpAstExtractor` (welcoMattic)
 * feature #47872 [Validator] new email validation option to match with w3c official specification (guillemfondin)
 * feature #47916 [Routing] PSR-4 directory loader (derrabus)
 * feature #47890 [SecurityBundle] Deprecate the `enable_authenticator_manager` option (chalasr)
 * feature #47906 [DependencyInjection] Allow injecting the current env into php config closures (HypeMC)
 * feature #47902 [DependencyInjection] Add support for tagged iterators/locators exclude option to xml and yaml (HypeMC)
 * feature #47801 [DependencyInjection] Allow array for the value of Autowire attribute (willemverspyck)
 * feature #47864 [DoctrineBridge] Deprecate calling `ContainerAwareEventManager::getListeners()` without event name (derrabus)
 * feature #47711 [Mime] deprecate attach/embed methods in favor of Email::addPart() (fabpot)
 * feature #47832 [HttpClient] Make HttplugClient implement PSR-17 factories instead of Httplug's (nicolas-grekas)
 * feature #47817 [Security] TraceableAccessDecisionManager: fix inspecting voters of custom access decision managers (sarbanha)
 * feature #47750 [Console] Show available commands in namespace when running namespace as command (wouterj)
 * feature #47730 Ban DateTime from the codebase (WebMamba)
 * feature #47496 [FrameworkBundle] Make the Router `cache_dir` configurable (mpdude)
 * feature #47511 [Form][PropertyAccess] Allow optional property accesses (fsoedjede)
 * feature #47068 [Messenger] Deprecate MessageHandlerInterface and MessageSubscriberInterface (alamirault)
 * feature #47460 [Messenger] add dedicated method for disabling instead of passing boolean flags (xabbuh)
 * feature #47643 [WebProfilerBundle] Update the mailer panel (javiereguiluz)
 * feature #47710 [Validator] File: add option to check extension (dunglas)
 * feature #47734 [Validator] add the getCause() to the ConstraintViolationInterface (xabbuh)
 * feature #47308 [Console] Allow limiting the height of a console section (wouterj)
 * feature #47243 Add context option to configure the indentation of nested nodes for `YamlEncoder` (dbu)
 * feature #47462 [Mime] Simplify adding Parts to an Email (fabpot)
 * feature #47683 [DependencyInjection] Deprecate numeric parameter names (HeahDude)
 * feature #47377 [HttpKernel] Use Accept-Language header even if there are no enabled locales (MatTheCat)
 * feature #47588 Add warning for possibly truncated inputs in QuestionHelper (#47586) (pbek)
 * feature #47665 [WebProfilerBundle] [WebProfilerPanel] Update the configuration panel (javiereguiluz)
 * feature #47630 [FrameworkBundle] Add semantic config for new terminate_on_cache_hit HttpCache option (wouterj)
 * feature #47595 [HttpFoundation] Extract request matchers for better reusability (fabpot)
 * feature #47535 [TwigBridge] Expose current route in `AppVariable` (HeahDude)
 * feature #47536 [TwigBundle] add option for configuring custom HTML to text converter services (xabbuh)
 * feature #46064 [Security] Add a `ChainUserChecker` to allow calling multiple user checkers for a firewall (mbabker)
 * feature #47445 [FrameworkBundle] Allow secrets vaults to be used directly outside Symfony (AndreasA)
 * feature #47148 [WebProfilerBundle] Profiler redesign (javiereguiluz)
 * feature #38996 Remove the default values from setters with a nullable parameter (derrabus, nicolas-grekas)
 * feature #42593 [Validator] Add the `When` constraint and validator (wuchen90)
 * feature #47525 [Uid] Add UuidV7 and UuidV8 (nicolas-grekas)
 * feature #47515 [Uid] Add MaxUuid and MaxUlid (nicolas-grekas)
 * feature #47407 [Console] Terminal Color Mode refactoring and force Color Mode (julien-boudry)
 * feature #47507 [Uid] Add interface for `getDateTime()` and apply to relevant UIDs (shrikeh)
 * feature #47236 [DependencyInjection][VarExporter] Generate lazy-loading virtual proxies for non-ghostable lazy services (nicolas-grekas)
 * feature #39622 [Messenger] Be able to get raw data when a message in not decodable by the PHP Serializer (lyrixx)
 * feature #47311 [FrameworkBundle] Update ContainerDebugCommand to add parial search for tags (vshevelev, BOB41K1987)
 * feature #47367 [DependencyInjection] Handle INI arrays (MatTheCat)
 * feature #47373 [Notifier] Add Chatwork Notifier Bridge (Ippey)
 * feature #47363 [HttpKernel] Replace ArgumentValueResolverInterface by ValueResolverInterface (nicolas-grekas)
 * feature #47101 [DependencyInjection] Allow service subscribers to return `SubscribedService[]` (kbond)
 * feature #40152 [Messenger] Pass sender details to SendMessageToTransportsEvent (Jeroeny)
 * feature #41171 [Messenger] Add simple transport based rate limiter to Messenger (bobvandevijver)
 * feature #47295 [PhpUnitBridge] add ability to mock the hrtime() function (xabbuh)
 * feature #47264 [String] Add support for emoji in AsciiSlugger (lyrixx)
 * feature #47263 [Intl] Update EmojiTransliterator to translate emoji to github and slack short code (lyrixx)
 * feature #45418 [Messenger] Add HandlerArgumentsStamp (enumag)
 * feature #47094 [HttpKernel] Use xxh128 algorithm instead of sha256 for http cache store key (Pascal Woerde)
 * feature #46000 [Workflow] Mark registry as internal and deprecate the service (lyrixx)
 * feature #46428 [Security] Access Token Authenticator (Spomky)
 * feature #47225 [Mime] Re-allow addIdHeader to be used for 'In-Reply-To' and 'References' headers (AlbinoDrought)
 * feature #47190 [Mailer] Add a way to change the Bus transport dynamically (fabpot)
 * feature #47201 [Mime] Add a way to control the HTML to text conversion (fabpot)
 * feature #47202 [Serializer] enable JSON_PRESERVE_ZERO_FRACTION by default (dbu)
 * feature #39306 [Messenger] Add `TransportNamesStamp` to change the transport while dispatching a message (asilelik, fabpot)
 * feature #47196 Allow extending `#[When]` attribute (ruudk)
 * feature #47191 [Mailer] Add a way to inject Stamps when sending an email via Messenger (fabpot)
 * feature #47170 [Mailer] Use better error code when auth fails (fabpot)
 * feature #46978 [Security] Allow using expressions with the #[IsGranted] attribute (HypeMC)
 * feature #46571 [Messenger] Add new `messenger:count` command that return a list of transports with their "to be processed" message count. (ktherage, ogizanagi, EXT - THERAGE Kevin)
 * feature #43865 [TwigBridge] Add support for toggle buttons in Bootstrap 5 form theme (ker0x)
 * feature #46683 [Ldap] Deprecate '{username}' parameter use in favour of '{user_identifier}' in LDAP configuration (EXT - THERAGE Kevin)
 * feature #46514 [HttpKernel] Add option to render Surrogate fragment with absolute URIs (Kern046)
 * feature #46715 [Clock] A new component to decouple applications from the system clock (nicolas-grekas)
 * feature #42355 [HttpKernel] Bugfix/last modified response strategy (aschempp)
 * feature #47080 [Mailer] Add new events (fabpot)
 * feature #47075 [Mime] Change the way we avoid rendering an email twice (fabpot)
 * feature #46755 [Intl] Add `EmojiTransliterator` to translate emoji to many locales (lyrixx, nicolas-grekas)
 * feature #47062 [Console] Don't cut Urls wrapped in SymfonyStyle block (fchris82, GromNaN)
 * feature #45987 [Notifier] Add `from` in `SmsMessage` (alamirault)
 * feature #46142 [ExpressionLanguage] Add support for null coalescing syntax (mytuny)
 * feature #47050 [Form] Allow TranslatableInterface to the FormType help option (alamirault)
 * feature #46110 [RateLimiter][Security] Improve performance of login/request rate limiter (Seldaek, wouterj)
 * feature #46895 [Notifier] Introduce PHPUnit constraints and assertions for the Notifier (ismail1432)
 * feature #47049 [Mailer] Throw a more specific exception when a BodyRendererInterface is needed but not configured (fabpot)
 * feature #47040 Add a mailer:test command (fabpot)
 * feature #46242 [Console] Add support for resuming a ProgressBar (yivi)
 * feature #46962 [Mime] Add DataPart::setContentId() (fabpot)
 * feature #47038 [Notifier] Add Notification::exception() (fabpot)
 * feature #46944 [Console] Add Ansi8 (256 color) support, improve true color (Ansi24) support detection (julien-boudry)
 * feature #47034 [Mime] Simplify code (fabpot)
 * feature #47018 [Console] Zsh shell autocompletion (adhocore, GromNaN)
 * feature #46591 [Finder] Add methods to sort by extension & size  (sandoba)
 * feature #46126 [Finder] Case insensitive file sort (hmoreau)
 * feature #45034 [HttpFoundation] Rename Request::getContentType to getContentTypeFormat (MarkPedron)
 * feature #46806 [Cache][WebProfilerBundle] Add adapter class to Cache `DataCollector` (Jean-Beru)
 * feature #44902 Add visibility context option in PropertyNormalizer (alamirault)
 * feature #46567 [Security] [LoginLink] Set custom lifetime for login link (mbrodala, fabpot)
 * feature #46599 Add "negate" option to Expression constraint (fmata)
 * feature #46821 [FrameworkBundle] Add `resolve-env` option to debug:config command (alexandre-daubois)
 * feature #46580 [SecurityBundle] Add shortcut option to enable logout CSRF protection (wouterj)
 * feature #46814 [FrameworkBundle] Add service and alias deprecation message to debug:container <name> output (94noni)
 * feature #47008 [Messenger] Add options to `FailedMessagesShowCommand` (Florian Guimier, fabpot)
 * feature #45977 [Validator] Add the match option to the Choice constraint (fancyweb)
 * feature #46338 [Security] Allow configuring a target url when switching user (94noni)
 * feature #46326 SMTP Transport to provide the (final) Message-ID if available (Raphaël Droz)
 * feature #43854 [DoctrineBridge] Add an Entity Argument Resolver (jderusse, nicolas-grekas)
 * feature #46315 [Mailer] `max_per_second` option configurable via DSN (gassan)
 * feature #46118 [Security] Don't allow empty username or empty password (bikalbasnet)
 * feature #46229 [Messenger] Make Redis messages countable (Jean-Beru)
 * feature #41406 [Security] Add a method in the security helper to ease programmatic logout (johnkrovitch, chalasr)
 * feature #45404 [Mailer] allow custom hosts for ses+smtp with amazon mailer (jrushlow)
 * feature #45945 [Uid] Added toHexString method to AbstractUid class (aurimasniekis)
 * feature #46642 [DoctrineBridge] Add `NAME` const for UID types (marcelsiegert)
 * feature #46502 [Dotenv] Variable filter added to debug command (rmikalkenas)
 * feature #46211 [Mailer] Add Infobip bridge (B-Galati)
 * feature #46773 [VarDumper] Add `FFI\CData` and `FFI\CType` types (SerafimArts)
 * feature #46946 [Form] ChoiceType choices must support TranslatableInterface (alamirault)
 * feature #38903 [FrameworkBundle] Add "Usages" to debug:container output (Bert ter Heide, bertterheide)
 * feature #46901 [Console] Be explicit about the completion API version (wouterj)
 * feature #46752 [DependencyInjection] Use lazy-loading ghost object proxies out of the box (nicolas-grekas)
 * feature #46880 [HttpKernel] Add `#[Cache()]` to describe the default HTTP cache headers on controllers (nicolas-grekas)
 * feature #46751 [VarExporter] Add trait to help implement lazy loading ghost objects (nicolas-grekas)
 * feature #46906 [TwigBridge] Add `#[Template()]` to describe how to render arrays returned by controllers (nicolas-grekas)
 * feature #46907 [Security] Add `#[IsGranted()]` (nicolas-grekas)
 * feature #46183 Hide sensitive information with `SensitiveParameter` attribute (GromNaN)
 * feature #46896 Console/SymfonyStyle: Add Multiselect to choice() (julien-boudry)
 * feature #46883 [DependencyInjection] Add `shuffle` env processor (ostrolucky)
 * feature #46846 [Notifier] Add Zendesk Notifier Bridge (stloyd)
 * feature #46001 [HttpKernel] Add `ControllerEvent::getAttributes()` to handle attributes on controllers (nicolas-grekas)
 * feature #46854 [FrameworkBundle] Make `AbstractController::render()` able to deal with forms and deprecate `renderForm()` (nicolas-grekas)
 * feature #41274 [Security] Add a method in the security helper to ease programmatic login (#40662) (johnkrovitch, chalasr)
 * feature #46831 Add deprecation when the session is not FlashBagAware (VincentLanglet)
 * feature #46491 Introduce FlashBagAwareSessionInterface (VincentLanglet)
 * feature #46813 [Form] Provide string keys when iterating on a form (VincentLanglet)
 * feature #46680 [Serializer] Provide context information from attribute for promoted properties (DanielBadura)
 * feature #46564 [DependencyInjection] Add Enum Env Var Processor (jack-worman)
 * feature #46763 [HttpCache] Do not call terminate() on cache hit (Toflar)
 * feature #45997 [FrameworkBundle][HttpKernel] Add deprecation warning to show `HttpKernel::handle()` will catch throwables (Nyholm)
 * feature #46714 [Mailer] Deprecate OhMySmtp Transport, Create MailPace transport (Holicz)
 * feature #46771 [Yaml] Add support for `!php/enum *->value` syntax (nicolas-grekas)
 * feature #46395 [Notifier] Add Contact Everyone Bridge (franckranaivo)
 * feature #46724 [Notifier] Add SMSFactor bridge (Gwemox)
 * feature #46741 [DependencyInjection] Allow using ghost objects for lazy loading services (nicolas-grekas)
 * feature #46675 [Serializer] Add support of true built-in type (from PHP 8.2) (bobahvas, alexandre-daubois)
 * feature #46663 [Serializer] Deprecate autowiring aliases pointing to concrete normalizers (chalasr)
 * feature #46584 [Security] Enforce maximum username length in UserBadge (wouterj)
 * feature #46066 [Security] Add an easier way to get the current firewall configuration (Kocal)
 * feature #46614 Remove Debug component leftovers (chalasr)
 * feature #46566 [Serializer][WebProfilerBundle] Show serializer collector info in toolbar (ogizanagi)
 * feature #46569 [Serializer][WebProfilerBundle] Collect & show caller source code (ogizanagi)
 * feature #46094 [Security][SecurityBundle] Move the `Security` helper to SecurityBundle (chalasr)
 * feature #46518 [Validator] deprecate the loose e-mail validation mode (xabbuh)
 * feature #45985 [TwigBridge] Add form_label_content and form_help_content block to form_div_layout (alexander-schranz)
 * feature #46430 [Routing] Add `Requirement::POSITIVE_INT` for common ids and pagination (HeahDude)
 * feature #46279 [DependencyInjection] Optimize autowiring logic by telling it about excluded symbols (nicolas-grekas)
 * feature #46452 [DependencyInjection] Add Hydrator::hydrate() and preserve PHP references when using it (nicolas-grekas)

